<div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">

        {!! Form::open(['url' => action([\App\Http\Controllers\WarehouseController::class, 'store']), 'method' => 'post', 'id' => 'warehouse_add_form' ]) !!}

        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('lang_v1.add_warehouse')</h4>
        </div>

        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('name', __( 'invoice.name' ) . ':*') !!}
                        {!! Form::text('name', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'invoice.name' ) ]); !!}
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('code', __( 'lang_v1.code' ) . ':') !!}
                        {!! Form::text('code', null, ['class' => 'form-control', 'placeholder' => __( 'lang_v1.code' ) ]); !!}
                        <small class="help-block">@lang('lang_v1.warehouse_code_help')</small>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('is_active', __( 'lang_v1.status' ) . ':') !!}
                        <br>
                        {!! Form::checkbox('is_active', 1, true); !!} @lang('lang_v1.active')
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('address', __( 'business.address' ) . ':') !!}
                        {!! Form::textarea('address', null, ['class' => 'form-control', 'rows' => 2, 'placeholder' => __( 'business.address' ) ]); !!}
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('city', __( 'business.city' ) . ':') !!}
                        {!! Form::text('city', null, ['class' => 'form-control', 'placeholder' => __( 'business.city')]); !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('state', __( 'business.state' ) . ':') !!}
                        {!! Form::text('state', null, ['class' => 'form-control', 'placeholder' => __( 'business.state')]); !!}
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('country', __( 'business.country' ) . ':') !!}
                        {!! Form::text('country', null, ['class' => 'form-control', 'placeholder' => __( 'business.country')]); !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('zip_code', __( 'business.zip_code' ) . ':') !!}
                        {!! Form::text('zip_code', null, ['class' => 'form-control', 'placeholder' => __( 'business.zip_code')]); !!}
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('phone', __( 'business.mobile' ) . ':') !!}
                        {!! Form::text('phone', null, ['class' => 'form-control', 'placeholder' => __( 'business.mobile')]); !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('email', __( 'business.email' ) . ':') !!}
                        {!! Form::email('email', null, ['class' => 'form-control', 'placeholder' => __( 'business.email')]); !!}
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __( 'lang_v1.notes' ) . ':') !!}
                        {!! Form::textarea('notes', null, ['class' => 'form-control', 'rows' => 3, 'placeholder' => __( 'lang_v1.notes' ) ]); !!}
                    </div>
                </div>
            </div>
        </div>

        <div class="modal-footer">
            <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white">@lang( 'messages.save' )</button>
            <button type="button" class="tw-dw-btn tw-dw-btn-neutral tw-text-white" data-dismiss="modal">@lang( 'messages.close' )</button>
        </div>

        {!! Form::close() !!}

    </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->

