@extends('layouts.app')
    @php
        $title = __('purchase.all_payment');
    @endphp
@section('title', $title)

@section('content')

    <section class="content-header">
        <h1>{{$title}}</h1>
    </section>
    <!-- Main content -->

    <section class="content no-print">

          <!-- Sub Menu -->
       <div class="horizontal-scroll mb-10">
        @include('layouts.sub_menu.transaction')
    </div>
    <!---submenu end--->

        <div class="row">
            <div class="col-md-12 col-sm-12">

                @component('components.widget', ['class' => 'box-solid'])

                    <div class="row">

                        <div class="col-sm-4">
                            <div class="form-group">
                                {!! Form::label('select_location_id', __('Location Name') . ':*') !!}
                                <div class="input-group" style="width: 100%;margin-bottom: 4px">
                                    {!! Form::hidden('location_id', null, ['id' => 'location_id', 'data-receipt_printer_type' => !empty($default_location->receipt_printer_type) ? $default_location->receipt_printer_type : 'browser', 'data-default_payment_accounts' => $default_location->default_payment_accounts ?? '']); !!}
                                    
                                    @if(count($business_locations) > 1)
                                        <div style="margin-bottom: 5px;">
                                            {!! Form::select('select_location_id', $business_locations, null, ['placeholder' => __('messages.please_select'), 'class' => 'form-control input-sm', 'id' => 'select_location_id', 'required', 'autofocus'], $bl_attributes); !!}
                                        </div>
                                    @else
                                        {{$default_location->name}}
                                    @endif

                                </div>
                            </div>
                        </div>

                        <div class="col-sm-4">
                            <div class="form-group">
                                {!! Form::label('contact_id', __('Contact Name') . ':*') !!}
                                <div class="input-group" style="margin-bottom: 4px">
                                    <span class="input-group-addon">
                                        <i class="fa fa-user"></i>
                                    </span>
                                    {!! Form::select('contact_id', ['' => 'Please Select'] + $all_contact, null, ['class' => 'form-control select2', 'id'=>'select_contact_id', 'required']) !!}
                                </div>
                            </div>
                        </div>


                        <div class="col-md-4">
                            <div class="form-group">
                                {!! Form::label('all_payment_date_range', __('report.date_range') . ':') !!}
                                <div class="input-group" style="margin-bottom: 4px;width: 100%;">
                                    {!! Form::text('all_payment_date_range', now(), ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'all_payment_date_range', 'required', 'readonly']); !!}
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-4">
                            <div class="form-group">
                                {!! Form::label('due_payment_type', __('Type') . ':*') !!}
                                <div class="input-group" style="margin-bottom: 4px">
                                    <span class="input-group-addon">
                                        <i class="fa fa-user"></i>
                                    </span>
                                    {!! Form::select('due_payment_type', ['' => 'Please Select', 'purchase' => 'Purchase','purchase_return' => 'Purchase eturn','sell' => 'Sell','sell_return'=>'Sell Return'], null, ['class' => 'due_payment_type form-control select2', 'id'=>'due_payment_type', 'required']) !!}
                                </div>
                            </div>
                        </div>

     
                        <div class="col-md-4">
                            <div class="form-group">
                                {!! Form::label("method" , __('purchase.payment_method') . ':*') !!}
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fas fa-money-bill-alt"></i>
                                    </span>
                                    {!! Form::select("method", ['' => 'Please Select'] + $payment_types, null, ['class' => 'form-control select2', 'id' => 'payment_method', 'required', 'style' => 'width:100%;']); !!}
                                </div>
                            </div>
                        </div>
                        
                    </div>

                    @component('components.widget', ['class' => 'box-primary', 'title' => __('Payment List')])

                        <table class="table table-bordered table-striped" id="contact_payments_table" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th>@lang('lang_v1.action')</th>
                                    <th>@lang('contact.name')</th>
                                    <th>@lang('messages.date')</th>
                                    <th>@lang('lang_v1.contact_id')</th>
                                    <th>@lang('sale.location')</th>
                                    <th>@lang('Old Due')</th>
                                    <th>@lang('Today Pay')</th>
                                    <th>@lang('Balance')</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                            <tfoot>
                                <tr class="bg-gray font-17 text-center footer-total">
                            
                                    <td colspan="4">
                                        <strong>
                                            @lang('sale.total'):
                                        </strong>
                                    </td>
                                    <td class="footer_contact_old_due"></td>
                                    <td class="footer_contact_pay"></td>
                                    <td class="footer_contact_balance"></td>
                                </tr>
                            </tfoot>
                        </table>
                
                    @endcomponent


                @endcomponent

            </div>
        </div>

    </section>

    <!-- This will be printed -->
    <section class="invoice print_section" id="receipt_section"></section>


    <div class="modal fade payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    
    
@stop

@section('javascript')

	<script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/payment.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>

	<!-- Call restaurant module if defined -->
    @if(in_array('tables' ,$enabled_modules) || in_array('modifiers' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules))
    	<script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
    @endif
    <script type="text/javascript">


    	$(document).ready( function() {

    		$('.paid_on').datetimepicker({
                format: moment_date_format + ' ' + moment_time_format,
                ignoreReadonly: true,
            });


            if ($('#all_payment_date_range').length == 1) {
                $('#all_payment_date_range').daterangepicker({
                    ranges: ranges,
                    autoUpdateInput: false,
                    locale: {
                        format: moment_date_format,
                        cancelLabel: LANG.clear,
                        applyLabel: LANG.apply,
                        customRangeLabel: LANG.custom_range,
                    },
                    function(start, end) {
                        $('#expense_date_range').val(
                            start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                        );
                        contact_payments_table.ajax.reload();
                    }
                });
                $('#all_payment_date_range').on('apply.daterangepicker', function(ev, picker) {
                    $(this).val(
                        picker.startDate.format(moment_date_format) +' ~ ' + picker.endDate.format(moment_date_format)
                    );
                    contact_payments_table.ajax.reload();
                });
                
                $('#all_payment_date_range').on('cancel.daterangepicker', function(ev, picker) {
                    $(this).val('');
                    contact_payments_table.ajax.reload();
                });
            }


            var columns = [
                { data: 'action'},
                { data: 'conatct_name', name: 'conatct_name'},
                { data: 'paid_on', name: 'transaction_payments.paid_on'},
                { data: 'contact_id', name: 'contact_id'},
                { data: 'business_location', name: 'bl.name'},
                { data: 'due', searchable: false, orderable: false },
                { data: 'today_pay', searchable: false, orderable: false },
                { data: 'balance', searchable: false, orderable: false }
            ];

        
            contact_payments_table = $('#contact_payments_table').DataTable({
                processing: true,
                serverSide: true,
                scrollY:        "75vh",
                scrollX:        true,
                scrollCollapse: true,
                "ajax": {
                    "url": "/payments",
                    "data": function (d) {
                        d.start_date = $('#all_payment_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD HH:mm:ss') ;
                        d.end_date = $('#all_payment_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD HH:mm:ss') ;
                        d.contact_id = $('#select_contact_id').val();
                        d.location_id = $('#select_location_id').val();
                        d.payment_method = $('#payment_method').val();
                        d.due_payment_type = $('#due_payment_type').val();
                    }
                },
                aaSorting: [[1, 'desc']],
                columns: columns,
                fnDrawCallback: function(oSettings) {
                    __currency_convert_recursively($('#contact_payments_table'));
                },
                "footerCallback": function (row, data) {

                    var total_old_due = 0;
                    var total_pay = 0;
                    var total_balance = 0;

                    for (var r in data){
                        total_old_due += $(data[r].due).data('orig-value') ? 
                        parseFloat($(data[r].due).data('orig-value')) : 0;    
                        
                        total_pay += $(data[r].today_pay).data('orig-value') ? 
                        parseFloat($(data[r].today_pay).data('orig-value')) : 0;

                        total_balance += $(data[r].balance).data('orig-value') ? 
                        parseFloat($(data[r].balance).data('orig-value')) : 0;
                    }
                    $('.footer_contact_old_due').html(__currency_trans_from_en(total_old_due));
                    $('.footer_contact_pay').html(__currency_trans_from_en(total_pay));
                    $('.footer_contact_balance').html(__currency_trans_from_en(total_balance));
                }
               
            });

        

            $('select#select_contact_id, select#due_payment_type, select#payment_method, #all_payment_date_range, select#select_location_id').on('change', function(e) {
                contact_payments_table.ajax.reload();

            });


    	});
    </script>
@endsection
