<tr class="product_row">
	<td>
		{{$product->product_name}}
		<br/>
		{{$product->sub_sku}}@if(!empty($product->brand)), {{$product->brand}} @endif
		&nbsp;
		<input type="hidden" class="enable_sr_no" value="{{$product->enable_sr_no}}">
		<i class="fa fa-commenting cursor-pointer text-primary add-pos-row-description" title="@lang('lang_v1.add_description')" data-toggle="modal" data-target="#row_description_modal_{{$row_count}}"></i>
	</td>
	<td>
		
		<input type="hidden" name="products[{{$row_count}}][product_id]" class="form-control product_id" value="{{$product->product_id}}">
		<input type="hidden" name="products[{{$row_count}}][transaction_id]" class="form-control transaction_id" value="{{$product->transaction_id}}">
		<input type="hidden" name="products[{{$row_count}}][location_id]" class="form-control location_id" value="{{$product->location_id}}">
		<input type="hidden" name="products[{{$row_count}}][sell_line_id]"  value="{{$product->sell_line_id}}">
		<input type="hidden" name="products[{{$row_count}}][product_unit_id]"  value="{{$product->unit_id}}">


		
		<input type="hidden" value="{{$product->variation_id}}" name="products[{{$row_count}}][variation_id]" class="row_variation_id">
		<input type="hidden" value="{{$product->enable_stock}}" name="products[{{$row_count}}][enable_stock]">
		
		@if(empty($product->quantity_ordered))
			@php
				$product->quantity_ordered = 1;
			@endphp
		@endif


		@php
			$common_settings = session()->get('business.common_settings');
			$multiplier = 1;
		@endphp
		@foreach($sub_units as $key => $value)
			@if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key)
				@php
					$multiplier = $value['multiplier'];
				@endphp
			@endif
		@endforeach


		@php
			$max_quantity = $product->qty_available;
			$formatted_max_quantity = $product->formatted_qty_available;

			$max_qty_rule = $max_quantity;
			$max_qty_msg = __('validation.custom-messages.quantity_not_available', ['qty'=> $formatted_max_quantity, 'unit' => $product->unit  ]);
		@endphp


		@foreach($sub_units as $key => $value)
        	@if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key)
        		@php
        			$max_qty_rule = $max_qty_rule / $multiplier;
        			$unit_name = $value['name'];
        			$max_qty_msg = __('validation.custom-messages.quantity_not_available', ['qty'=> $max_qty_rule, 'unit' => $unit_name  ]);

        			if(!empty($product->lot_no_line_id)){
        				$max_qty_msg = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $max_qty_rule, 'unit' => $unit_name  ]);
        			}
        		@endphp
        	@endif
        @endforeach


		<input type="hidden" class="base_unit_multiplier" name="products[{{$row_count}}][base_unit_multiplier]" value="{{$multiplier}}">

		<div class="input-group input-number">
			<span class="input-group-btn">
				<button type="button" class="btn btn-default btn-flat quantity-down">
					<i class="fa fa-minus text-danger"></i>
				</button>
			</span>
				<input type="text" data-min="1" 
						class="form-control pos_quantity input_number mousetrap input_quantity" 
						value="{{@format_quantity($product->quantity_ordered)}}" 
						name="products[{{$row_count}}][quantity]" 
						
						data-allow-overselling="@if(empty($pos_settings['allow_overselling'])){{'false'}}@else{{'true'}}@endif" 
						@if($product->unit_allow_decimal == 1) 
							data-decimal=1 
						@else 
							data-decimal=0 
							data-rule-abs_digit="true" 
							data-msg-abs_digit="@lang('lang_v1.decimal_value_not_allowed')" 
						@endif
						data-rule-required="true" 
						data-msg-required="@lang('validation.custom-messages.this_field_is_required')" 

						@if($product->enable_stock)

							data-rule-max-value="{{$max_qty_rule}}" 
							data-qty_available="{{$product->qty_available}}" 
							data-msg-max-value="{{$max_qty_msg}}" 

							data-msg_max_default="@lang('validation.custom-messages.quantity_not_available', ['qty'=> $product->formatted_qty_available, 'unit' => $product->unit  ])" 
						@endif 
					>

			<span class="input-group-btn">
				<button type="button" class="btn btn-default btn-flat quantity-up">
					<i class="fa fa-plus text-success"></i>
				</button>
			</span>
		</div>
		{{$product->unit}}
		
	</td>

	<td>
		<input type="text" name="products[{{$row_count}}][unit_price]" class="form-control pos_unit_price input_number mousetrap" value="{{@num_format($product->default_sell_price)}}">
	</td>

	@php
		$hide_tax = 'hide';
 
        
		$tax_id = $product->tax_id;
		$unit_price_inc_tax = $product->sell_price_inc_tax;
		if($hide_tax == 'hide'){
			$tax_id = null;
			$unit_price_inc_tax = $product->default_sell_price;
		}
	@endphp

	<td class="{{$hide_tax}}">
		<input type="hidden" name="products[{{$row_count}}][item_tax]" class="form-control item_tax">
		{!! Form::select("products[$row_count][tax_id]", $tax_dropdown['tax_rates'], $tax_id, ['placeholder' => 'Select', 'class' => 'form-control tax_id'], $tax_dropdown['attributes']); !!}
	</td>

	<td class="{{$hide_tax}}">
		<input type="text" name="products[{{$row_count}}][unit_price_inc_tax]" class="form-control pos_unit_price_inc_tax input_number" value="{{@num_format($unit_price_inc_tax)}}">
	</td>

	<td>
		<input type="text" readonly name="products[{{$row_count}}][price]" class="form-control pos_line_total" value="{{@num_format($product->quantity_ordered*$unit_price_inc_tax )}}">
	</td>

	<td class="text-center">
		<i class="fa fa-trash pos_remove_row cursor-pointer" aria-hidden="true"></i>
	</td>
	
</tr>

<script type="text/javascript">
	$(document).ready(function(){
		$('input.expiry_datepicker').datepicker({
        	autoclose: true,
        	format:datepicker_date_format
    	});
	});
</script>