@extends('layouts.app')

@php
	$title = __('lang_v1.add_sell_return');
@endphp

@section('title', $title)

@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}}</h1>
    </section>


    <!-- Main content -->
    <section class="content no-print">

        {!! Form::open(['url' => action([\App\Http\Controllers\SellReturnController::class, 'store']), 'method' => 'post', 'id' => 'add_sell_return_form', 'files' => true ]) !!}

            <input type="hidden" id="amount_rounding_method" value="{{$pos_settings['amount_rounding_method'] ?? ''}}">

            @component('components.widget', ['class' => 'box-solid'])
             
                <div class="row">

                    {{-- <div class="col-sm-4 hide">
                        <div class="form-group">
                            {!! Form::label('contact_id', __('sale.return_from') . ':*') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-map-marker"></i>
                                </span>
                                {!! Form::select('location_id', $business_locations, $default_location->id ?? null, ['class' => 'form-control input-sm', 'id' => 'location_id', 'required', 'autofocus'], $bl_attributes); !!}
                                <span class="input-group-addon">
                                    @show_tooltip(__('tooltip.sale_location'))
                                </span> 
                            </div>
                        </div>
                    </div> --}}


                    <div class="col-sm-4">
                        <div class="form-group">
                            {!! Form::label('contact_id', __('sale.return_store') . ':*') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-map-marker"></i>
                                </span>
                                {!! Form::select('select_location_id', $business_locations, $default_location->id ?? null, ['class' => 'form-control input-sm', 'id' => 'select_location_id', 'required', 'autofocus'], $bl_attributes); !!}
                                <span class="input-group-addon">
                                    @show_tooltip(__('tooltip.sale_location'))
                                </span> 
                            </div>
                        </div>
                    </div>


                    <div class="col-sm-4">
                        <div class="form-group">
                            {!! Form::label('contact_id', __('contact.customer') . ':*') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-user"></i>
                                </span>
                                <input type="hidden" id="default_customer_id" value="{{ $walk_in_customer['id']}}" >
                                <input type="hidden" id="default_customer_name" value="{{ $walk_in_customer['name']}}" >
                                <input type="hidden" id="default_customer_balance" value="{{ $walk_in_customer['balance'] ?? ''}}" >
                                <input type="hidden" id="default_customer_address" value="{{ $walk_in_customer['shipping_address'] ?? ''}}" >
                                @if(!empty($walk_in_customer['price_calculation_type']) && $walk_in_customer['price_calculation_type'] == 'selling_price_group')
                                    <input type="hidden" id="default_selling_price_group" value="{{ $walk_in_customer['selling_price_group_id'] ?? ''}}" >
                                @endif
                                {!! Form::select('contact_id', [], null, ['class' => 'form-control mousetrap', 'id' => 'customer_id', 'placeholder' => 'Enter Customer name / phone', 'required']); !!}
                                <span class="input-group-btn">
                                    <button type="button" class="btn btn-default bg-white btn-flat add_new_customer" data-name=""><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
                                </span>
                            </div>
                            <small class="text-danger hide contact_due_text">
                                <strong>@lang('account.customer_due'):</strong> <span></span>
                            </small>
                        </div>
                        <small>
                            <strong>
                                @lang('lang_v1.billing_address'):
                            </strong>
                            <div id="billing_address_div">
                                {!! $walk_in_customer['contact_address'] ?? '' !!}
                            </div>
                            <br>
                            <strong>
                                @lang('lang_v1.shipping_address'):
                            </strong>
                            <div id="shipping_address_div">
                                {{$walk_in_customer['supplier_business_name'] ?? ''}},<br>
                                {{$walk_in_customer['name'] ?? ''}},<br>
                                {{$walk_in_customer['shipping_address'] ?? ''}}
                            </div>					
                        </small>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            {!! Form::label('transaction_date', __('Return date') . ':*') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </span>
                                {!! Form::text('transaction_date', $default_datetime, ['class' => 'form-control', 'readonly', 'required']); !!}
                            </div>
                        </div>
                    </div>

                    @can('edit_invoice_number')
                        <div class="col-sm-4 hide">
                            <div class="form-group">
                                {!! Form::label('invoice_no', 'Return '.__('sale.invoice_no') . ':') !!}
                                {!! Form::text('invoice_no', null, ['class' => 'form-control', 'placeholder' => __('sale.invoice_no')]); !!}
                                <p class="help-block">@lang('lang_v1.keep_blank_to_autogenerate')</p>
                            </div>
                        </div>
                    @endcan


                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            {!! Form::label('return_note',__('sale.return_note')) !!}
                            {!! Form::textarea('sale_note', null, ['class' => 'form-control', 'id' => 'return_note', 'rows' => 3]); !!}
                        </div>
                    </div>
                </div>

            @endcomponent

            

            @component('components.widget', ['class' => 'box-solid'])

                <div class="col-sm-10 col-sm-offset-1">
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-btn">
                                <button type="button" class="btn btn-default bg-white btn-flat" data-toggle="modal" data-target="#configure_search_modal" title="{{__('lang_v1.configure_product_search')}}"><i class="fas fa-search-plus"></i></button>
                            </div>
                            <input type="hidden" id="search_type" value="sell_return">
                            {!! Form::text('search_sell_product', null, ['class' => 'form-control mousetrap', 'id' => 'search_sell_product', 'placeholder' => __('lang_v1.search_product_placeholder'),'disabled' => is_null($default_location)? true : false, 'autofocus' => is_null($default_location)? false : true,]); !!}
                        </div>
                    </div>
                </div>

                <div class="row col-sm-12 pos_product_div" style="min-height: 0">

                    <input type="hidden" name="sell_price_tax" id="sell_price_tax" value="{{$business_details->sell_price_tax}}">

                    <!-- Keeps count of product rows -->
                    <input type="hidden" id="product_row_count" value="0">

                    @php
                        $hide_tax = 'hide';
                    @endphp


                    <div class="table-responsive">
                        <table class="table table-condensed table-bordered table-striped table-responsive" id="sell_return_add_table">
                            <thead>
                                <tr>
                                    <th class="text-center">	
                                        @lang('sale.product')
                                    </th>

                                    <th class="text-center">
                                        @lang('sale.qty')
                                    </th>
                   
                                    <th class="@if(!auth()->user()->can('edit_product_price_from_sale_screen')) hide @endif">
                                        @lang('sale.unit_price')
                                    </th>
                     
                                    <th class="text-center {{$hide_tax}}">
                                        @lang('sale.tax')
                                    </th>
                                    <th class="text-center {{$hide_tax}}">
                                        @lang('sale.price_inc_tax')
                                    </th>
                                    @if(!empty($common_settings['enable_product_warranty']))
                                        <th>@lang('lang_v1.warranty')</th>
                                    @endif

                                    <th class="text-center">
                                        @lang('sale.subtotal')
                                    </th>

                                    <th class="text-center">
                                        <i class="fas fa-times" aria-hidden="true"></i>
                                    </th>

                                </tr>
                            </thead>

                            <tbody></tbody>

                        </table>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-condensed table-bordered table-striped">
                            <tr>
                                <td>
                                    <div class="pull-right">
                                    <b>@lang('sale.item'):</b> 
                                    <span class="total_quantity">0</span>
                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                    <b>@lang('sale.total'): </b>
                                        <span class="price_total">0</span>
                                        <input type="hidden" name="price_total" id="price_total">
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>

                </div>
            @endcomponent


            @component('components.widget', ['class' => 'box-solid hide'])
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('discount_type', __( 'purchase.discount_type' ) . ':') !!}
                        {!! Form::select('discount_type', [ '' => __('lang_v1.none'), 'fixed' => __( 'lang_v1.fixed' ), 'percentage' => __( 'lang_v1.percentage' )], '', ['class' => 'form-control']); !!}
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('discount_amount', __( 'purchase.discount_amount' ) . ':') !!}
                        {!! Form::text('discount_amount', 0, ['class' => 'form-control input_number']); !!}
                    </div>
                </div>
            @endcomponent
            

            @php
                $payment_body_id = 'payment_rows_div';
            @endphp


            @can('sell.payments')
                @component('components.widget', ['class' => 'box-solid', 'id' => $payment_body_id, 'title' => __('Add Return payment')])
        
                    <div class="payment_row">
                        <div class="row hide">
                            <div class="col-md-12 mb-12">
                                <strong>@lang('lang_v1.advance_balance'):</strong> <span id="advance_balance_text"></span>
                                {!! Form::hidden('advance_balance', null, ['id' => 'advance_balance', 'data-error-msg' => __('lang_v1.required_advance_balance_not_available')]); !!}
                            </div>
                        </div>

                        @include('sell_return.partials.payment_row_form', ['row_index' => 0, 'show_date' => true, 'show_denomination' => true])
                    </div>
                    <div class="payment_row">


                        {{-- <div class="row">
                            <div class="col-md-12">
                                <hr>
                                <strong>
                                    @lang('lang_v1.change_return'):
                                </strong>
                                <br/>
                                <span class="lead text-bold change_return_span">0</span>
                                {!! Form::hidden("change_return", $change_return['amount'], ['class' => 'form-control change_return input_number', 'required', 'id' => "change_return"]); !!}
                                <!-- <span class="lead text-bold total_quantity">0</span> -->
                                @if(!empty($change_return['id']))
                                    <input type="hidden" name="change_return_id" 
                                    value="{{$change_return['id']}}">
                                @endif
                            </div>
                        </div>
                        <div class="row hide payment_row" id="change_return_payment_data">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {!! Form::label("change_return_method" , __('lang_v1.change_return_payment_method') . ':*') !!}
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fas fa-money-bill-alt"></i>
                                        </span>
                                        @php
                                            $_payment_method = empty($change_return['method']) && array_key_exists('cash', $payment_types) ? 'cash' : $change_return['method'];

                                            $_payment_types = $payment_types;
                                            if(isset($_payment_types['advance'])) {
                                                unset($_payment_types['advance']);
                                            }
                                        @endphp
                                        {!! Form::select("payment[change_return][method]", $_payment_types, $_payment_method, ['class' => 'form-control col-md-12 payment_types_dropdown', 'id' => 'change_return_method', 'style' => 'width:100%;']); !!}
                                    </div>
                                </div>
                            </div>
                            @if(!empty($accounts))
                            <div class="col-md-4">
                                <div class="form-group">
                                    {!! Form::label("change_return_account" , __('lang_v1.change_return_payment_account') . ':') !!}
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fas fa-money-bill-alt"></i>
                                        </span>
                                        {!! Form::select("payment[change_return][account_id]", $accounts, !empty($change_return['account_id']) ? $change_return['account_id'] : '' , ['class' => 'form-control select2', 'id' => 'change_return_account', 'style' => 'width:100%;']); !!}
                                    </div>
                                </div>
                            </div>
                            @endif
                            @include('sale_pos.partials.payment_type_details', ['payment_line' => $change_return, 'row_index' => 'change_return'])
                        </div> --}}


                        <hr>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="pull-right"><strong>@lang('lang_v1.balance'):</strong> <span class="balance_due">0.00</span></div>
                            </div>
                        </div>
                    </div>

                @endcomponent
            @endcan
        

            <div class="row">
                {!! Form::hidden('is_save_and_print', 0, ['id' => 'is_save_and_print']); !!}
                <div class="col-sm-12 text-center">
                    <button type="button" id="save-and-print" class="btn btn-success btn-big">@lang('lang_v1.save_and_print')</button>
                </div>
            </div>


        {!! Form::close() !!}


    </section>

    <div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        @include('contact.create', ['quick_add' => true])
    </div>

    <!-- /.content -->
    <div class="modal fade register_details_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade close_register_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

    <!-- quick product modal -->
    @include('sale_pos.partials.configure_search_modal')

@stop

@section('javascript')


	<script src="{{ asset('js/sell_return.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>

	<!-- Call restaurant module if defined -->
    @if(in_array('tables' ,$enabled_modules) || in_array('modifiers' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules))
    	<script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
    @endif

    <script type="text/javascript">
    	$(document).ready( function() {

    		$('#status').change(function(){
    			if ($(this).val() == 'final') {
    				$('#payment_rows_div').removeClass('hide');
    			} else {
    				$('#payment_rows_div').addClass('hide');
    			}
    		});

    		$('.paid_on').datetimepicker({
                format: moment_date_format + ' ' + moment_time_format,
                ignoreReadonly: true,
            });

            $('#shipping_documents').fileinput({
		        showUpload: false,
		        showPreview: false,
		        browseLabel: LANG.file_browse_label,
		        removeLabel: LANG.remove,
		    });

		    $(document).on('change', '#prefer_payment_method', function(e) {
			    var default_accounts = $('select#select_location_id').length ? $('select#select_location_id').find(':selected').data('default_payment_accounts') : $('#location_id').data('default_payment_accounts');
			    var payment_type = $(this).val();
			    if (payment_type) {
			        var default_account = default_accounts && default_accounts[payment_type]['account'] ? default_accounts[payment_type]['account'] : '';
			        var account_dropdown = $('select#prefer_payment_account');
			        if (account_dropdown.length && default_accounts) {
			            account_dropdown.val(default_account);
			            account_dropdown.change();
			        }
			    }
			});

		    function setPreferredPaymentMethodDropdown() {
			    var payment_settings = $('#location_id').data('default_payment_accounts');
			    payment_settings = payment_settings ? payment_settings : [];
			    enabled_payment_types = [];
			    for (var key in payment_settings) {
			        if (payment_settings[key] && payment_settings[key]['is_enabled']) {
			            enabled_payment_types.push(key);
			        }
			    }
			    if (enabled_payment_types.length) {
			        $("#prefer_payment_method > option").each(function() {
		                if (enabled_payment_types.indexOf($(this).val()) != -1) {
		                    $(this).removeClass('hide');
		                } else {
		                    $(this).addClass('hide');
		                }
			        });
			    }
			}
			
			setPreferredPaymentMethodDropdown();

			$('#is_export').on('change', function () {
	            if ($(this).is(':checked')) {
	                $('div.export_div').show();
	            } else {
	                $('div.export_div').hide();
	            }
	        });

			if($('.payment_types_dropdown').length){
				$('.payment_types_dropdown').change();
			}

    	});
    </script>

@endsection
