@extends('layouts.app')

@section('title', __('lang_v1.sell_exchange'))

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>@lang('lang_v1.sell_exchange')</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="box box-solid">
        <div class="box-header">
            <h3 class="box-title">@lang('lang_v1.exchange_details')</h3>
        </div>
        <div class="box-body">
            <div class="row">
                 <div class="col-sm-4">
                    <strong>@lang('sale.invoice_no'):</strong> {{ $sell_exchange->transaction->invoice_no ?? '-' }}<br>
                    <strong>@lang('messages.date'):</strong> {{ @format_date($sell_exchange->created_at) }}
                </div>
                <div class="col-sm-4">
                    <strong>@lang('contact.customer'):</strong> {{ $sell_exchange->transaction->contact->name ?? '-' }}<br>
                    <strong>@lang('purchase.business_location'):</strong> {{ $sell_exchange->businessLocation->name ?? '-' }}
                </div>
            </div>
        </div>
    </div>

    @foreach ($exchangeDetails as $detail)
        <div class="box box-solid">
            <div class="box-header">
                <h3 class="box-title">@lang('lang_v1.exchanged_products')</h3>
            </div>
            <div class="box-body">
                <table class="table table-bordered">
                    <thead>
                        <tr class="bg-gray">
                            <th>#</th>
                            <th>@lang('product.product_name')</th>
                            <th>@lang('product.variation')</th>
                            <th>@lang('sale.quantity')</th>
                            <th>@lang('sale.unit_price')</th>
                            <th>@lang('sale.total_price')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($detail['exchange_products'] as $index => $product)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $product->name }}</td>
                                <td>
                                    {{
                                        optional($product->variations->firstWhere('id', $detail['exchange_variation_ids'][$index]))->name ?? 'N/A'
                                    }}
                                </td>
                                <td>{{ $detail['exchange_quantities'][$index] ?? '-' }}</td>
                                <td>{{ $detail['exchange_unit_price'][$index] ?? '-' }}</td>
                                <td>{{ $detail['exchange_total_price'][$index] ?? '-' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <div class="box box-solid">
            <div class="box-header">
                <h3 class="box-title">@lang('lang_v1.new_products_given')</h3>
            </div>
            <div class="box-body">
                <table class="table table-bordered">
                    <thead>
                        <tr class="bg-gray">
                            <th>#</th>
                            <th>@lang('product.product_name')</th>
                            <th>@lang('product.variation')</th>
                            <th>@lang('sale.quantity')</th>
                            <th>@lang('sale.unit_price')</th>
                            <th>@lang('sale.total_price')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($detail['new_products'] as $index => $product)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $product->name }}</td>
                                <td>
                                    {{
                                        optional($product->variations->firstWhere('id', $detail['new_variation_ids'][$index]))->name ?? 'N/A'
                                    }}
                                </td>
                                <td>{{ $detail['new_quantities'][$index] ?? '-' }}</td>
                                <td>{{ $detail['new_unit_price'][$index] ?? '-' }}</td>
                                <td>{{ $detail['new_total_price'][$index] ?? '-' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endforeach
</section>
@endsection
