@extends('layouts.app')
@section('title', __('lang_v1.sell_exchange'))

@section('content')

<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('lang_v1.sell_exchange')
    </h1>
</section>
<!-- Main content -->
<section class="content no-print">
    @component('components.filters', ['title' => __('report.filters')])
    <div class="col-md-3">
        <div class="form-group">
            {!! Form::label('sell_exchange_filter_location_id',  __('purchase.business_location') . ':') !!}
            {!! Form::select('sell_exchange_filter_location_id', $business_locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all') ]); !!}
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group">
            {!! Form::label('sell_exchange_filter_customer_id',  __('contact.customer') . ':') !!}
            {!! Form::select('sell_exchange_filter_customer_id', $customers, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all')]); !!}
        </div>
    </div>

    <div class="col-md-3">
        <div class="form-group">
            {!! Form::label('sell_exchange_filter_date_range', __('report.date_range') . ':') !!}
            {!! Form::text('sell_exchange_filter_date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly']); !!}
        </div>
    </div>
    @can('access_sell_exchange')
    <div class="col-md-3">
        <div class="form-group">
            {!! Form::label('created_by',  __('report.user') . ':') !!}
            {!! Form::select('created_by', $sales_representative, null, ['class' => 'form-control select2', 'style' => 'width:100%']); !!}
        </div>
    </div>
    @endcan
@endcomponent

<!-- Sub Menu -->
<div class="horizontal-scroll mb-10">
    @include('layouts.sub_menu.sale')
</div>
<!---submenu end--->

@component('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.sell_exchange')])
@include('sell_exchange.partials.sell_exchange_list')
@endcomponent

<!-- Payment Modals -->
<div class="modal fade payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
<div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
<div class="modal fade pay_contact_due_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

</section>

@stop

@section('javascript')
<script src="{{ asset('js/payment.js?v=' . $asset_v) }}"></script>
<script>
    $(document).ready(function(){
        // Date range picker
        $('#sell_exchange_filter_date_range').daterangepicker(
            dateRangeSettings,
            function (start, end) {
                $('#sell_exchange_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
                sell_exchange_table.ajax.reload();
            }
        );
        $('#sell_exchange_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $('#sell_exchange_filter_date_range').val('');
            sell_exchange_table.ajax.reload();
        });

        // Initialize DataTable
        sell_exchange_table = $('#sell_exchange_table').DataTable({
            processing: true,
            serverSide: true,
            aaSorting: [[0, 'desc']],
            ajax: {
                url: "/sell-exchange",
                data: function (d) {
                    console.log("data",d)
                    if($('#sell_exchange_filter_date_range').val()) {
                        var start = $('#sell_exchange_filter_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#sell_exchange_filter_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }

                    d.location_id = $('#sell_exchange_filter_location_id').val();
                    d.customer_id = $('#sell_exchange_filter_customer_id').val();
                    
                    if($('#created_by').length) {
                        d.created_by = $('#created_by').val();
                    }
                }
            },
            columnDefs: [{
                targets: [5, 6],
                orderable: false,
                searchable: false
            }],
            columns: [
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'customer_name', name: 'contacts.name' },
                { data: 'business_location', name: 'bl.name' },
                // { data: 'status', name: 'status' },
                { data: 'amount_before_exchange', name: 'amount_before_exchange' },
                { data: 'amount_after_exchange', name: 'amount_after_exchange' },
                // { data: 'payment_due', name: 'payment_due' },
                { data: 'action', name: 'action' }
            ],
            fnDrawCallback: function (oSettings) {
                var total_before_exchange = sum_table_col($('#sell_exchange_table'), 'amount_before_exchange');
                console.log('total_before_exchange', total_before_exchange);
                $('#footer_before_exchange_amount').text(total_before_exchange);
                
                var total_after_exchange = sum_table_col($('#sell_exchange_table'), 'amount_after_exchange');
                $('#footer_after_exchange_amount').text(total_after_exchange);

                __currency_convert_recursively($('#sell_exchange_table'));
            },
            createdRow: function(row, data, dataIndex) {
                $(row).find('td:eq(2)').attr('class', 'clickable_td');
            }
        });

        // Filter change events
        $(document).on('change', '#sell_exchange_filter_location_id, #sell_exchange_filter_customer_id, #created_by', function() {
            sell_exchange_table.ajax.reload();
        });

        // Delete sell exchange
        $(document).on('click', 'a.delete_sell_exchange', function(e) {
            e.preventDefault();
            swal({
                title: LANG.sure,
                icon: 'warning',
                buttons: true,
                dangerMode: true,
            }).then(willDelete => {
                if (willDelete) {
                    var href = $(this).attr('href');
                    var data = $(this).serialize();

                    $.ajax({
                        method: 'DELETE',
                        url: href,
                        dataType: 'json',
                        data: data,
                        success: function(result) {
                            if (result.success == true) {
                                toastr.success(result.msg);
                                sell_exchange_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        },
                    });
                }
            });
        });
    });
</script>
@endsection