@extends('layouts.app')

@section('content')
    <section class="content-header">
        <h1>
            {{ __('Sell Exchange') }}
        </h1>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box">

                    <div class="box-body">
                        <form action="{{ action([\App\Http\Controllers\SellExchangeController::class, 'store']) }}"
                            method="post" id="sell_exchange_form">
                            @if (count($business_locations) > 0)
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <i class="fa fa-map-marker"></i>
                                                </span>
                                                {!! Form::select(
                                                    'select_location_id',
                                                    $business_locations,
                                                    $default_location->id ?? null,
                                                    ['class' => 'form-control input-sm', 'id' => 'select_location_id', 'required', 'autofocus'],
                                                    $bl_attributes,
                                                ) !!}
                                                <span class="input-group-addon">
                                                    @show_tooltip(__('tooltip.sale_location'))
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            @csrf
                            <input type="hidden" name="sell_id" value="{{ $sell->id }}">
                            @php
                                $total_paid = 0;
                            @endphp
                            <div class="row">
                                <div class="col-md-8">
                                    <h3>Current Sell Details (Invoice:{{ $sell->invoice_no }})</h3>

                                    <p>
                                        <strong>{{ __('sale.products') }}: </strong>

                                    </p>
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr class="bg-gray">
                                                <th><input type="checkbox" id="select_all"> #</th>
                                                <th>Product</th>
                                                <th>Product Serial</th>
                                                <th>Quantity</th>
                                                <th>Unit Price</th>
                                                <th>Discount</th>
                                                <th>Tax</th>
                                                <th>Price inc. Tax</th>
                                                <th>Subtotal</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {{-- @dd($sell, $sell->sell_lines) --}}
                                            <input type="hidden" name="transaction_id" value="{{ $sell->id }}">
                                            <input type="hidden" name="location_id" value="{{ $sell->location_id }}">


                                            @foreach ($sell->sell_lines as $sell_line)
                                                @php
                                                    $lineId = $sell_line->id;
                                                @endphp
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="exchange_checkbox" name="line_id[]"
                                                            value="{{ $sell_line->id }}" data-line="{{ $lineId }}"
                                                            data-subtotal="{{ $sell_line->quantity * $sell_line->unit_price_inc_tax }}">

                                                        {{ $loop->iteration }}
                                                    </td>
                                                    <input type="hidden" name="product_id[{{ $lineId }}]"
                                                        value="{{ $sell_line->product_id }}">
                                                    <input type="hidden" name="product_variation_id[{{ $lineId }}]"
                                                        value="{{ $sell_line->variation_id }}">
                                                    <input type="hidden" name="quantity[{{ $lineId }}]"
                                                        value="{{ $sell_line->quantity }}">
                                                    <input type="hidden"
                                                        name="unit_price_before_discount[{{ $lineId }}]"
                                                        value="{{ $sell_line->unit_price_before_discount }}">


                                                    <td>{{ $sell_line->product->name }}<br>{{ $sell_line->variations->sub_sku }}
                                                    </td>
                                                    <td>{{ $sell_line->product_serial ?? '-' }}</td>
                                                    <!--product quantity start--->
                                                    @if ($sell->type == 'sales_order')
                                                        <td>
                                                            <span class="display_currency" data-currency_symbol="false"
                                                                data-is_quantity="true">
                                                                {{ $sell_line->quantity - $sell_line->so_quantity_invoiced }}
                                                            </span>
                                                            @if (!empty($sell_line->sub_unit))
                                                                {{ $sell_line->sub_unit->short_name }}
                                                            @else
                                                                {{ $sell_line->product->unit->short_name }}
                                                            @endif

                                                            @if ($sell_line->product->use_multi_unit == 1)
                                                                @php
                                                                    $first_quantity =
                                                                        $sell_line->quantity /
                                                                        $sell_line->product->first_conversion_unit_rate;
                                                                    $first_unit = App\Unit::where(
                                                                        'id',
                                                                        $line['first_conversion_unit_id'],
                                                                    )->first();
                                                                @endphp
                                                                {{ $first_quantity }}
                                                                {{ $first_unit->actual_name }}({{ $first_unit->short_name }})
                                                            @endif
                                                        </td>
                                                    @endif
                                                    <td>
                                                        @if (!empty($for_ledger))
                                                            {{ @format_quantity($sell_line->quantity) }}
                                                        @else
                                                            <span class="display_currency" data-currency_symbol="false"
                                                                data-is_quantity="true">{{ $sell_line->quantity }}</span>
                                                        @endif
                                                        @if (!empty($sell_line->sub_unit))
                                                            {{ $sell_line->sub_unit->short_name }}
                                                        @else
                                                            {{ $sell_line->product->unit->short_name }}
                                                        @endif

                                                        @if (!empty($sell_line->product->second_unit) && $sell_line->secondary_unit_quantity != 0)
                                                            <br>
                                                            @if (!empty($for_ledger))
                                                                {{ @format_quantity($sell_line->secondary_unit_quantity) }}
                                                            @else
                                                                <span class="display_currency" data-is_quantity="true"
                                                                    data-currency_symbol="false">{{ $sell_line->secondary_unit_quantity }}</span>
                                                            @endif
                                                            {{ $sell_line->product->second_unit->short_name }}
                                                        @endif


                                                        @if ($sell_line->product->use_multi_unit == 1)
                                                            @if (!empty($sell_line->product->first_conversion_unit_id))
                                                                <br>
                                                                @php
                                                                    $first_quantity =
                                                                        $sell_line->quantity /
                                                                        $sell_line->product->first_conversion_unit_rate;
                                                                    $first_unit = App\Unit::where(
                                                                        'id',
                                                                        $sell_line->product->first_conversion_unit_id,
                                                                    )->first();
                                                                @endphp
                                                                {{ $first_quantity }}
                                                                {{ $first_unit->actual_name }}({{ $first_unit->short_name }})
                                                            @endif

                                                            @if (!empty($sell_line->product->second_conversion_unit_id))
                                                                <br>
                                                                @php
                                                                    $second_quantity =
                                                                        $sell_line->quantity /
                                                                        ($sell_line->product
                                                                            ->first_conversion_unit_rate *
                                                                            $sell_line->product
                                                                                ->second_conversion_unit_rate);
                                                                    $second_unit = App\Unit::where(
                                                                        'id',
                                                                        $sell_line->product->second_conversion_unit_id,
                                                                    )->first();
                                                                @endphp
                                                                {{ $second_quantity }}
                                                                {{ $second_unit->actual_name }}({{ $second_unit->short_name }})
                                                            @endif
                                                        @endif




                                                    </td>

                                                    <!--product quantity end--->

                                                    <!-----product unit price start--->
                                                    <td>
                                                        @if (!empty($for_ledger))
                                                            @format_currency($sell_line->unit_price_before_discount)
                                                        @else
                                                            <span class="display_currency"
                                                                data-currency_symbol="true">{{ $sell_line->unit_price_before_discount }}</span>
                                                        @endif
                                                    </td>
                                                    <!-----product unit price end--->

                                                    <!-----product discount start--->
                                                    <td>
                                                        @if (!empty($for_ledger))
                                                            @format_currency($sell_line->get_discount_amount())
                                                        @else
                                                            <span class="display_currency"
                                                                data-currency_symbol="true">{{ $sell_line->get_discount_amount() }}</span>
                                                        @endif
                                                        @if ($sell_line->line_discount_type == 'percentage')
                                                            ({{ $sell_line->line_discount_amount }}%)
                                                        @endif
                                                    </td>
                                                    <!-----product discount end--->

                                                    <!-----product tax start--->
                                                    <td>
                                                        @if (!empty($for_ledger))
                                                            @format_currency($sell_line->item_tax)
                                                        @else
                                                            <span class="display_currency"
                                                                data-currency_symbol="true">{{ $sell_line->item_tax }}</span>
                                                        @endif
                                                    </td>
                                                    <!-----product tax end--->

                                                    <!-----product price inc tax start--->
                                                    <td>
                                                        @if (!empty($for_ledger))
                                                            @format_currency($sell_line->unit_price_inc_tax)
                                                        @else
                                                            <span class="display_currency"
                                                                data-currency_symbol="true">{{ $sell_line->unit_price_inc_tax }}</span>
                                                        @endif
                                                    </td>
                                                    <!-----product price inc tax end--->

                                                    <!-----product subtotal start--->
                                                    <td>
                                                        @if (!empty($for_ledger))
                                                            @format_currency($sell_line->quantity * $sell_line->unit_price_inc_tax)
                                                        @else
                                                            <span class="display_currency"
                                                                data-currency_symbol="true">{{ $sell_line->quantity * $sell_line->unit_price_inc_tax }}</span>
                                                        @endif
                                                    </td>
                                                    <!-----product subtotal end--->
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <h4>Total Exchange Amount: <span id="total_exchange_amount" class="display_currency"
                                            data-currency_symbol="true">0</span></h4>


                                    <!--payment info existing-->
                                    <div class="col-sm-12 col-xs-12">
                                        <h4>{{ __('sale.payment_info') }}:</h4>
                                    </div>

                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                        <div class="table-responsive">
                                            <table class="table">
                                                <tr class="bg-gray">
                                                    <th>#</th>
                                                    <th>{{ __('messages.date') }}</th>
                                                    <th>{{ __('purchase.ref_no') }}</th>
                                                    <th>{{ __('sale.amount') }}</th>
                                                    <th>{{ __('sale.payment_mode') }}</th>
                                                    <th>{{ __('sale.payment_note') }}</th>
                                                </tr>
                                                @foreach ($sell->payment_lines as $payment_line)
                                                    <input type="hidden" name="payment_line_id[]"
                                                        value="{{ $payment_line->id }}">
                                                    <input type="hidden" name="payment_transaction_id[]"
                                                        value="{{ $payment_line->transaction_id }}">
                                                    <input type="hidden" name='payment_business_id[]'
                                                        value='{{ $payment_line->business_id }}'>
                                                    <input type="hidden" name="payment_amount[]"
                                                        value="{{ $payment_line->amount }}">
                                                    <input type="hidden" name="payment_method[]"
                                                        value="{{ $payment_line->method }}">
                                                    {{-- @dd($payment_line); --}}
                                                    @php
                                                        if ($payment_line->is_return == 1) {
                                                            $total_paid -= $payment_line->amount;
                                                        } else {
                                                            $total_paid += $payment_line->amount;
                                                        }
                                                    @endphp
                                                    <tr>
                                                        <td>{{ $loop->iteration }}</td>
                                                        <td>{{ @format_date($payment_line->paid_on) }}</td>
                                                        <td>{{ $payment_line->payment_ref_no }}</td>
                                                        <td><span class="display_currency"
                                                                data-currency_symbol="true">{{ $payment_line->amount }}</span>
                                                        </td>
                                                        <td>
                                                            {{ $payment_types[$payment_line->method] ?? $payment_line->method }}
                                                            @if ($payment_line->is_return == 1)
                                                                <br />
                                                                ({{ __('lang_v1.change_return') }})
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if ($payment_line->note)
                                                                {{ ucfirst($payment_line->note) }}
                                                            @else
                                                                --
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </table>
                                        </div>
                                    </div>


                                    <h3>Exchange Product</h3>
                                    @php
                                        $hide_tax = '';
                                        if (session()->get('business.enable_inline_tax') == 0) {
                                            $hide_tax = 'hide';
                                        }
                                    @endphp
                                    <input type="hidden" id="item_addition_method"
                                        value="{{ $business_details->item_addition_method }}">
                                    <input type="hidden" id="location_id" value="{{ $sell->location_id }}">
                                    <input type="hidden" id="customer_id" value="{{ $sell->contact_id }}">


                                    @component('components.widget', ['class' => 'box-solid'])
                                        <div class="col-sm-10 col-sm-offset-1">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-btn">
                                                        <button type="button" class="btn btn-default bg-white btn-flat"
                                                            data-toggle="modal" data-target="#configure_search_modal"
                                                            title="{{ __('lang_v1.configure_product_search') }}"><i
                                                                class="fas fa-search-plus"></i></button>
                                                    </div>
                                                    {!! Form::text('search_product', null, [
                                                        'class' => 'form-control mousetrap',
                                                        'id' => 'search_product',
                                                        'placeholder' => __('lang_v1.search_product_placeholder'),
                                                        'disabled' => is_null($default_location) ? true : false,
                                                        'autofocus' => is_null($default_location) ? false : true,
                                                    ]) !!}
                                                    <span class="input-group-btn">
                                                        <button type="button"
                                                            class="btn btn-default bg-white btn-flat pos_add_quick_product"
                                                            data-href="{{ action([\App\Http\Controllers\ProductController::class, 'quickAdd']) }}"
                                                            data-container=".quick_add_product_modal"><i
                                                                class="fa fa-plus-circle text-primary fa-lg"></i></button>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row col-sm-12 pos_product_div" style="min-height: 0">

                                            <input type="hidden" name="sell_price_tax" id="sell_price_tax"
                                                value="{{ $business_details->sell_price_tax }}">

                                            <!-- Keeps count of product rows -->
                                            <input type="hidden" id="product_row_count" value="0">
                                            @php
                                                $hide_tax = '';
                                                if (session()->get('business.enable_inline_tax') == 0) {
                                                    $hide_tax = 'hide';
                                                }
                                            @endphp
                                            <div class="table-responsive">

                                                <table
                                                    class="table table-condensed table-bordered table-striped table-responsive"
                                                    id="pos_table">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center">
                                                                @lang('sale.product')
                                                            </th>


                                                            @if (!empty($common_settings['enable_serial_number']))
                                                                <th>Product Serial</th>
                                                            @endif


                                                            <th class="text-center">
                                                                @lang('sale.qty')
                                                            </th>


                                                            @if (!empty($pos_settings['show_multi_unit']))
                                                                <th class="text-center fs-12 col-md-2">Other Unit </th>
                                                            @endif

                                                            @if (!empty($pos_settings['inline_service_staff']))
                                                                <th class="text-center">
                                                                    @lang('restaurant.service_staff')
                                                                </th>
                                                            @endif
                                                            <th class="@if (!auth()->user()->can('edit_product_price_from_sale_screen')) hide @endif">
                                                                @lang('sale.unit_price')
                                                            </th>
                                                            <th class="@if (!auth()->user()->can('edit_product_discount_from_sale_screen')) hide @endif">
                                                                @lang('receipt.discount')
                                                            </th>
                                                            <th class="text-center {{ $hide_tax }}">
                                                                @lang('sale.tax')
                                                            </th>
                                                            <th class="text-center {{ $hide_tax }}">
                                                                @lang('sale.price_inc_tax')
                                                            </th>
                                                            @if (!empty($common_settings['enable_product_warranty']))
                                                                <th>@lang('lang_v1.warranty')</th>
                                                            @endif
                                                            <th class="text-center">
                                                                @lang('sale.subtotal')
                                                            </th>
                                                            <th class="text-center"><i class="fas fa-times"
                                                                    aria-hidden="true"></i></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody></tbody>
                                                </table>




                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-condensed table-bordered table-striped">
                                                    <tr>
                                                        <td>
                                                            <div class="pull-right">
                                                                <b>@lang('sale.item'):</b>
                                                                <span class="total_quantity">0</span>
                                                                &nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>@lang('sale.total'): </b>
                                                                <span class="price_total">0</span>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    @endcomponent

                                    <!---details--->
                                    @component('components.widget', ['class' => 'box-solid'])
                                        {{-- <div class="col-md-4">
                                            <div class="form-group">
                                                {!! Form::label('discount_type', __('sale.discount_type') . ':*') !!}
                                                <div class="input-group">
                                                    <span class="input-group-addon">
                                                        <i class="fa fa-info"></i>
                                                    </span>
                                                    {!! Form::select(
                                                        'discount_type',
                                                        ['fixed' => __('lang_v1.fixed'), 'percentage' => __('lang_v1.percentage')],
                                                        'percentage',
                                                        [
                                                            'class' => 'form-control',
                                                            'placeholder' => __('messages.please_select'),
                                                            'required',
                                                            'data-default' => 'percentage',
                                                        ],
                                                    ) !!}
                                                </div>
                                            </div>
                                        </div> --}}
                                        @php
                                            $max_discount = !is_null(auth()->user()->max_sales_discount_percent)
                                                ? auth()->user()->max_sales_discount_percent
                                                : '';

                                            //if sale discount is more than user max discount change it to max discount
                                            $sales_discount = $business_details->default_sales_discount;
                                            if ($max_discount != '' && $sales_discount > $max_discount) {
                                                $sales_discount = $max_discount;
                                            }

                                            $default_sales_tax = $business_details->default_sales_tax;

                                        @endphp
                                        {{-- <div class="col-md-4">
                                            <div class="form-group">
                                                {!! Form::label('discount_amount', __('sale.discount_amount') . ':*') !!}
                                                <div class="input-group">
                                                    <span class="input-group-addon">
                                                        <i class="fa fa-info"></i>
                                                    </span>
                                                    {!! Form::text('discount_amount', @num_format($sales_discount), [
                                                        'class' => 'form-control input_number',
                                                        'data-default' => $sales_discount,
                                                        'data-max-discount' => $max_discount,
                                                        'data-max-discount-error_msg' => __('lang_v1.max_discount_error_msg', [
                                                            'discount' => $max_discount != '' ? @num_format($max_discount) : '',
                                                        ]),
                                                    ]) !!}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4"><br>
                                            <b>@lang('sale.discount_amount'):</b>(-)
                                            <span class="display_currency" id="total_discount">0</span>
                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="col-md-12 well well-sm bg-light-gray">
                                            <input type="hidden" name="rp_redeemed" id="rp_redeemed" value="0">
                                            <input type="hidden" name="rp_redeemed_amount" id="rp_redeemed_amount"
                                                value="0">
                                            <div class="col-md-12">
                                                <h4>{{ session('business.rp_name') }}</h4>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {!! Form::label('rp_redeemed_modal', __('lang_v1.redeemed') . ':') !!}
                                                    <div class="input-group">
                                                        <span class="input-group-addon">
                                                            <i class="fa fa-gift"></i>
                                                        </span>
                                                        {!! Form::number('rp_redeemed_modal', 0, [
                                                            'class' => 'form-control direct_sell_rp_input',
                                                            'data-amount_per_unit_point' => session('business.redeem_amount_per_unit_rp'),
                                                            'min' => 0,
                                                            'data-max_points' => 0,
                                                            'data-min_order_total' => session('business.min_order_total_for_redeem'),
                                                        ]) !!}
                                                        <input type="hidden" id="rp_name"
                                                            value="{{ session('business.rp_name') }}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <p><strong>@lang('lang_v1.available'):</strong> <span id="available_rp">0</span></p>
                                            </div>
                                            <div class="col-md-4">
                                                <p><strong>@lang('lang_v1.redeemed_amount'):</strong> (-)<span
                                                        id="rp_redeemed_amount_text">0</span></p>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                {!! Form::label('tax_rate_id', __('sale.order_tax') . ':*') !!}
                                                <div class="input-group">
                                                    <span class="input-group-addon">
                                                        <i class="fa fa-info"></i>
                                                    </span>
                                                    {!! Form::select(
                                                        'tax_rate_id',
                                                        $taxesDropdown['tax_rates'],
                                                        $default_sales_tax,
                                                        ['placeholder' => __('messages.please_select'), 'class' => 'form-control', 'data-default' => $default_sales_tax],
                                                        $taxesDropdown['attributes'],
                                                    ) !!}

                                                    <input type="hidden" name="tax_calculation_amount"
                                                        id="tax_calculation_amount"
                                                        value="@if (empty($edit)) {{ @num_format($business_details->tax_calculation_amount) }} @else {{ @num_format($transaction->tax?->amount) }} @endif"
                                                        data-default="{{ $business_details->tax_calculation_amount }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-md-offset-4">
                                            <b>@lang('sale.order_tax'):</b>(+)
                                            <span class="display_currency" id="order_tax">0</span>
                                        </div> --}}

                                        {{-- <div class="col-md-12">
                                            <div class="form-group">
                                                {!! Form::label('sell_note', __('sale.sell_note')) !!}
                                                {!! Form::textarea('sale_note', null, ['class' => 'form-control', 'rows' => 3]) !!}
                                            </div>
                                        </div> --}}
                                        <input type="hidden" name="is_direct_sale" value="1">
                                    @endcomponent

                                    @php
                                        $is_enabled_download_pdf = config('constants.enable_download_pdf');
                                        $payment_body_id = 'payment_rows_div';
                                        if ($is_enabled_download_pdf) {
                                            $payment_body_id = '';
                                        }
                                    @endphp
                                    @can('sell.payments')
                                        @component('components.widget', [
                                            'class' => 'box-solid',
                                            'id' => $payment_body_id,
                                            'title' => __('purchase.add_payment'),
                                        ])
                                            @if ($is_enabled_download_pdf)
                                                <div class="well row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            {!! Form::label('prefer_payment_method', __('lang_v1.prefer_payment_method') . ':') !!}
                                                            @show_tooltip(__('lang_v1.this_will_be_shown_in_pdf'))
                                                            <div class="input-group">
                                                                <span class="input-group-addon">
                                                                    <i class="fas fa-money-bill-alt"></i>
                                                                </span>
                                                                {!! Form::select('prefer_payment_method', $payment_types, 'cash', [
                                                                    'class' => 'form-control',
                                                                    'style' => 'width:100%;',
                                                                ]) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            {!! Form::label('prefer_payment_account', __('lang_v1.prefer_payment_account') . ':') !!}
                                                            @show_tooltip(__('lang_v1.this_will_be_shown_in_pdf'))
                                                            <div class="input-group">
                                                                <span class="input-group-addon">
                                                                    <i class="fas fa-money-bill-alt"></i>
                                                                </span>
                                                                {!! Form::select('prefer_payment_account', $accounts, null, [
                                                                    'class' => 'form-control',
                                                                    'style' => 'width:100%;',
                                                                ]) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            @if (empty($status) || !in_array($status, ['quotation', 'draft']))
                                                <div class="payment_row"
                                                    @if ($is_enabled_download_pdf) id="payment_rows_div" @endif>
                                                    <div class="row">
                                                        <div class="col-md-12 mb-12">
                                                            <strong>@lang('lang_v1.advance_balance'):</strong> <span
                                                                id="advance_balance_text"></span>
                                                            {!! Form::hidden('advance_balance', null, [
                                                                'id' => 'advance_balance',
                                                                'data-error-msg' => __('lang_v1.required_advance_balance_not_available'),
                                                            ]) !!}
                                                        </div>
                                                    </div>
                                                    @include('sell_exchange.partials.payment_row', [
                                                        'row_index' => 0,
                                                        'show_date' => true,
                                                        'show_denomination' => true,
                                                    ])
                                                </div>
                                                <div class="payment_row">


                                                    <hr>
                                                    <div class="row">
                                                        <div class="col-sm-12">
                                                            <div class="pull-right"><strong>@lang('lang_v1.balance'):</strong> <span
                                                                    id="total_payable"
                                                                    class="display_currency pull-right total_payable"
                                                                    data-currency_symbol="true"></span></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @endcomponent
                                    @endcan




                                </div>

                                <div class="col-md-4">
                                    <h3>Current Sell Details</h3>

                                    <div class="table-responsive">
                                        <table class="table bg-gray">
                                            <tr>
                                                <th>{{ __('sale.total') }}: </th>
                                                <td></td>
                                                <td><span class="display_currency pull-right "
                                                        data-currency_symbol="true">{{ $sell->total_before_tax }}</span>
                                                        <input type="hidden" name="" class="beforeTaxTotal" value="{{ $sell->total_before_tax }}">
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>{{ __('sale.discount') }}:</th>
                                                <td><b>(-)</b></td>
                                                <td>
                                                    <div class="pull-right"><span class="display_currency"
                                                            @if ($sell->discount_type == 'fixed') data-currency_symbol="true" @endif>{{ $sell->discount_amount }}</span>
                                                        @if ($sell->discount_type == 'percentage')
                                                            {{ '%' }}
                                                        @endif
                                                        </span>
                                                        <input type="hidden" name="" class="beforeTaxDiscountType" value="{{ $sell->discount_type }}">
                                                        <input type="hidden" name="" class="beforeTaxDiscountAmount" value="{{ $sell->discount_amount }}">
                                                    </div>
                                                </td>
                                            </tr>
                                            @if (in_array('types_of_service', $enabled_modules) && !empty($sell->packing_charge))
                                                <tr>
                                                    <th>{{ __('lang_v1.packing_charge') }}:</th>
                                                    <td><b>(+)</b></td>
                                                    <td>
                                                        <div class="pull-right"><span class="display_currency"
                                                                @if ($sell->packing_charge_type == 'fixed') data-currency_symbol="true" @endif>{{ $sell->packing_charge }}</span>
                                                            @if ($sell->packing_charge_type == 'percent')
                                                                {{ '%' }}
                                                            @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endif
                                            @if (session('business.enable_rp') == 1 && !empty($sell->rp_redeemed))
                                                <tr>
                                                    <th>{{ session('business.rp_name') }}:</th>
                                                    <td><b>(-)</b></td>
                                                    <td> <span class="display_currency pull-right"
                                                            data-currency_symbol="true">{{ $sell->rp_redeemed_amount }}</span>
                                                    </td>
                                                </tr>
                                            @endif
                                            <tr>
                                                <th>{{ __('sale.order_tax') }}:</th>
                                                <td><b>(+)</b></td>
                                                <td class="text-right">
                                                    @if (!empty($order_taxes))
                                                        @foreach ($order_taxes as $k => $v)
                                                            <strong><small>{{ $k }}</small></strong> - <span
                                                                class="display_currency pull-right"
                                                                data-currency_symbol="true">{{ $v }}</span><br>
                                                        @endforeach
                                                    @else
                                                        0.00
                                                    @endif
                                                </td>
                                            </tr>
                                            @if (!empty($line_taxes))
                                                <tr>
                                                    <th>{{ __('lang_v1.line_taxes') }}:</th>
                                                    <td></td>
                                                    <td class="text-right">
                                                        @if (!empty($line_taxes))
                                                            @foreach ($line_taxes as $k => $v)
                                                                <strong><small>{{ $k }}</small></strong> - <span
                                                                    class="display_currency pull-right"
                                                                    data-currency_symbol="true">{{ $v }}</span><br>
                                                            @endforeach
                                                        @else
                                                            0.00
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endif
                                            <tr>
                                                <th>{{ __('sale.shipping') }}: @if ($sell->shipping_details)
                                                        ({{ $sell->shipping_details }})
                                                    @endif
                                                </th>
                                                <td><b>(+)</b></td>
                                                <td><span class="display_currency pull-right"
                                                        data-currency_symbol="true">{{ $sell->shipping_charges }}</span>
                                                </td>
                                            </tr>

                                            @if (!empty($sell->additional_expense_value_1) && !empty($sell->additional_expense_key_1))
                                                <tr>
                                                    <th>{{ $sell->additional_expense_key_1 }}:</th>
                                                    <td><b>(+)</b></td>
                                                    <td><span
                                                            class="display_currency pull-right">{{ $sell->additional_expense_value_1 }}</span>
                                                    </td>
                                                </tr>
                                            @endif
                                            @if (!empty($sell->additional_expense_value_2) && !empty($sell->additional_expense_key_2))
                                                <tr>
                                                    <th>{{ $sell->additional_expense_key_2 }}:</th>
                                                    <td><b>(+)</b></td>
                                                    <td><span
                                                            class="display_currency pull-right">{{ $sell->additional_expense_value_2 }}</span>
                                                    </td>
                                                </tr>
                                            @endif
                                            @if (!empty($sell->additional_expense_value_3) && !empty($sell->additional_expense_key_3))
                                                <tr>
                                                    <th>{{ $sell->additional_expense_key_3 }}:</th>
                                                    <td><b>(+)</b></td>
                                                    <td><span
                                                            class="display_currency pull-right">{{ $sell->additional_expense_value_3 }}</span>
                                                    </td>
                                                </tr>
                                            @endif
                                            @if (!empty($sell->additional_expense_value_4) && !empty($sell->additional_expense_key_4))
                                                <tr>
                                                    <th>{{ $sell->additional_expense_key_4 }}:</th>
                                                    <td><b>(+)</b></td>
                                                    <td><span
                                                            class="display_currency pull-right">{{ $sell->additional_expense_value_4 }}</span>
                                                    </td>
                                                </tr>
                                            @endif
                                            <tr>
                                                <th>{{ __('lang_v1.round_off') }}: </th>
                                                <td></td>
                                                <td><span class="display_currency pull-right"
                                                        data-currency_symbol="true">{{ $sell->round_off_amount }}</span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>{{ __('sale.total_payable') }}: </th>
                                                <td></td>
                                                <td><span class="display_currency pull-right "
                                                        data-currency_symbol="true">{{ $sell->final_total }}</span></td>
                                                        <input type="hidden" name="" class="afterTaxTotal" value="{{ $sell->final_total }}">
                                            </tr>
                                            @if ($sell->type != 'sales_order')
                                                <tr>
                                                    <th>{{ __('sale.total_paid') }}:</th>
                                                    <td></td>
                                                    <td>
                                                        <span class="display_currency pull-right"
                                                            data-currency_symbol="true">{{ $total_paid }}</span>
                                                        <input type="hidden" name="total_current_paid"
                                                            class="totalCurrentAmountForExchange"
                                                            value="{{ $total_paid }}">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>{{ __('sale.total_remaining') }}:</th>
                                                    <td></td>
                                                    <td>
                                                        <!-- Converting total paid to string for floating point substraction issue -->
                                                        @php
                                                            $total_paid = (string) $total_paid;
                                                        @endphp
                                                        <span class="display_currency pull-right"
                                                            data-currency_symbol="true">{{ $sell->final_total - $total_paid }}</span>
                                                    </td>
                                                </tr>
                                            @endif
                                        </table>
                                    </div>

                                    <!---exchange details---->
                                    <h3>Exchange Sell Details</h3>
                                    <div class="table-responsive">
                                        <table class="table bg-gray">
                                            <tr>
                                                <th>{{ __('sale.total') }}: </th>
                                                <td></td>
                                                <td><span id="price_total" class="display_currency pull-right price_total"
                                                        data-currency_symbol="true"></span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>{{ __('sale.discount') }}:</th>
                                                <td><b>(-)</b></td>
                                                <td>
                                                    <div class="pull-right"><span class="display_currency"
                                                            id="total_discount" data-currency_symbol="true"></span>
                                                    </div>
                                                </td>
                                            </tr>

                                            <tr>
                                                <th>{{ __('sale.order_tax') }}:</th>
                                                <td><b>(+)</b></td>
                                                <td class="text-right">
                                                    @if (!empty($order_taxes))
                                                        @foreach ($order_taxes as $k => $v)
                                                            <strong><small>{{ $k }}</small></strong> - <span
                                                                class="display_currency pull-right"
                                                                data-currency_symbol="true"></span><br>
                                                        @endforeach
                                                    @else
                                                        0.00
                                                    @endif
                                                </td>
                                            </tr>

                                            <tr>

                                            <tr>
                                                <th>{{ __('sale.total_payable') }}: </th>
                                                <td></td>
                                                <td>
                                                    <input type="hidden" name="final_total" id="final_total_input">
                                                    <span id="total_payable"
                                                        class="display_currency pull-right total_payable totalNewPayable"
                                                        data-currency_symbol="true"></span>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>

                            </div>



                            <div class="row">
                                {!! Form::hidden('is_save_and_print', 0, ['id' => 'is_save_and_print']) !!}
                                <div class="col-sm-12 text-center tw-mt-4">
                                    <button type="button" id="submit-exchange"
                                        class="tw-dw-btn tw-dw-btn-primary tw-dw-btn-lg tw-text-white">@lang('messages.save')</button>

                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection




@section('javascript')
    <script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>

    <script type="text/javascript">
        $('button#submit-exchange').click(function(e) {
            e.preventDefault();
            window.onbeforeunload = null;
            console.log('form submit', e);
            var totalPayableAmount = parseFloat($('.totalNewPayable').text().replace(/[^\d.-]/g, '')) || 0;
            var currentTotalExchange = parseFloat($('#total_exchange_amount').text()) || 0;
            var paymentAmountForExchange = parseFloat($('.paymentAmountForExchange').val()) || 0;
            if (paymentAmountForExchange < 0) {
                toastr.error('Payment amount cannot be negative.');
                return false;
            }

            console.log('totalPayableAmount', totalPayableAmount, 'currentTotalExchange', currentTotalExchange,
                'paymentAmountForExchange', paymentAmountForExchange);


            console.log('totalPayableAMount', totalPayableAmount, 'currentTotalExchange', currentTotalExchange);
            if (currentTotalExchange == 0) {
                toastr.error('Current exchange amount cannot be zero');
                return false;
            } else if (totalPayableAmount < currentTotalExchange) {
                toastr.error(
                    'Previous paid amount should be greater than or equal to current total exchange amount');
                return false;
            }
            if ($('table#pos_table tbody').find('.product_row').length <= 0) {
                toastr.warning(LANG.no_products_added);
                return false;
            }



            var is_msp_valid = true;
            //Validate minimum selling price if hidden
            $('.pos_unit_price_inc_tax').each(function() {
                if (!$(this).is(":visible") && $(this).data('rule-min-value')) {
                    var val = __read_number($(this));
                    console.log("val", val);
                    var error_msg_td = $(this).closest('tr').find('.pos_line_total_text').closest('td');
                    if (val > $(this).data('rule-min-value')) {
                        is_msp_valid = false;
                        error_msg_td.append('<label class="error">' + $(this).data('msg-min-value') +
                            '</label>');
                    } else {
                        error_msg_td.find('label.error').remove();
                    }
                }
            });

            if (!is_msp_valid) {
                return false;
            }

            var form = $(this).closest('form');
            var formData = form.serialize();
            var url = form.attr('action');
            var method = form.attr('method');

            $.ajax({
                method: method,
                url: url,
                data: formData,
                dataType: 'json',
                success: function(result) {
                    console.log(result);
                    if (result.success) {
                        toastr.success(result.msg);
                        location.reload();
                    } else {
                        toastr.error(result.msg || 'Something went wrong!');
                    }
                },
                error: function(xhr) {
                    console.error(xhr);
                    let errorMsg = 'Something went wrong!';
                    if (xhr.responseJSON && xhr.responseJSON.msg) {
                        errorMsg = xhr.responseJSON.msg;
                    }
                    toastr.error(errorMsg);
                }

            });


        });
    </script>

    <!-- Call restaurant module if defined -->
    @if (in_array('tables', $enabled_modules) ||
            in_array('modifiers', $enabled_modules) ||
            in_array('service_staff', $enabled_modules))
        <script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
    @endif
    <script type="text/javascript">
        $(document).ready(function() {
            $('#status').change(function() {
                if ($(this).val() == 'final') {
                    $('#payment_rows_div').removeClass('hide');
                } else {
                    $('#payment_rows_div').addClass('hide');
                }
            });
            $('.paid_on').datetimepicker({
                format: moment_date_format + ' ' + moment_time_format,
                ignoreReadonly: true,
            });

            $('#shipping_documents').fileinput({
                showUpload: false,
                showPreview: false,
                browseLabel: LANG.file_browse_label,
                removeLabel: LANG.remove,
            });

            $(document).on('change', '#prefer_payment_method', function(e) {
                var default_accounts = $('select#select_location_id').length ?
                    $('select#select_location_id')
                    .find(':selected')
                    .data('default_payment_accounts') : $('#location_id').data('default_payment_accounts');
                var payment_type = $(this).val();
                if (payment_type) {
                    var default_account = default_accounts && default_accounts[payment_type]['account'] ?
                        default_accounts[payment_type]['account'] : '';
                    var account_dropdown = $('select#prefer_payment_account');
                    if (account_dropdown.length && default_accounts) {
                        account_dropdown.val(default_account);
                        account_dropdown.change();
                    }
                }
            });

            function setPreferredPaymentMethodDropdown() {
                var payment_settings = $('#location_id').data('default_payment_accounts');
                payment_settings = payment_settings ? payment_settings : [];
                enabled_payment_types = [];
                for (var key in payment_settings) {
                    if (payment_settings[key] && payment_settings[key]['is_enabled']) {
                        enabled_payment_types.push(key);
                    }
                }
                if (enabled_payment_types.length) {
                    $("#prefer_payment_method > option").each(function() {
                        if (enabled_payment_types.indexOf($(this).val()) != -1) {
                            $(this).removeClass('hide');
                        } else {
                            $(this).addClass('hide');
                        }
                    });
                }
            }

            setPreferredPaymentMethodDropdown();

            $('#is_export').on('change', function() {
                if ($(this).is(':checked')) {
                    $('div.export_div').show();
                } else {
                    $('div.export_div').hide();
                }
            });

            if ($('.payment_types_dropdown').length) {
                $('.payment_types_dropdown').change();
            }


            $('.direct_sell_serial_btn').on('click', function() {
                // serial_div_modal

                console.log("dfghjkl;");

                // $('.serial_div_modal').html('');
                // $('.serial_div_modal').modal('show');
                // $('.serial_div_modal').html('');
            })




        });

        $('#select_all').on('click', function() {
            $('.exchange_checkbox').prop('checked', this.checked);
        });



        function calculateExchangeTotal() {
            let total = 0;
            $('.exchange_checkbox:checked').each(function() {
                let subtotal = parseFloat($(this).data('subtotal'));
                if (!isNaN(subtotal)) {
                    total += subtotal;
                }
            });

            // Format with currency if needed
            $('#total_exchange_amount').text(__currency_trans_from_en(total, false));
        }

        $(document).on('change', '.exchange_checkbox, #select_all', function() {
            calculateExchangeTotal();
            pos_total_row();
        });

        // Recalculate on load in case checkboxes are pre-checked
        $(document).ready(function() {
            calculateExchangeTotal();
        });




        $(document).on('change', '.payment_types_dropdown', function() {
            console.log('payment_types_dropdown');
            var payment_type = $(this).val();
            var to_show = null;
            $(this)
                .closest('.payment_row')
                .find('.payment_details_div')
                .each(function() {
                    if ($(this).attr('data-type') == payment_type) {
                        to_show = $(this);
                    } else {
                        if (!$(this).hasClass('hide')) {
                            $(this).addClass('hide');
                        }
                    }
                });

            if (to_show && to_show.hasClass('hide')) {
                to_show.removeClass('hide');
                to_show
                    .find('input')
                    .filter(':visible:first')
                    .focus();
            }

            if ($(this).closest('.payment_row').find('.enable_cash_denomination_for_payment_methods').length) {
                var payment_methods = JSON.parse($(this).closest('.payment_row').find(
                    '.enable_cash_denomination_for_payment_methods').val());
                if (payment_methods.indexOf(payment_type) >= 0) {
                    $(this).closest('.payment_row').find('.cash_denomination_div').removeClass('hide');
                } else {
                    $(this).closest('.payment_row').find('.cash_denomination_div').addClass('hide');
                }
            }
        });
    </script>
@endsection
