<!-- business information here -->

<div class="row" style="color: #000000 !important;">
		@if(empty($receipt_details->letter_head))
			<!-- Header text -->
			@if(!empty($receipt_details->header_text))
				<div class="col-xs-12">
					{!! $receipt_details->header_text !!}
				</div>
			@endif

					<!-- Logo and Business Info Layout -->
		<div class="col-xs-12" style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 20px;">
			<!-- Left side - Logo -->
			<div style="flex: 0 0 auto;">
				@if(!empty($receipt_details->logo))
					<img style="max-height: 120px; width: auto;" src="{{$receipt_details->logo}}" class="img img-responsive">
				@endif
			</div>


			<!-- Right side - Business Information -->
			<div style="flex: 1; text-align: right; margin-left: 20px;">
				<!-- Shop & Location Name  -->
				@if(!empty($receipt_details->display_name))
					<h2 style="margin: 0; font-size: 24px; font-weight: bold;">
						{{$receipt_details->display_name}}
					</h2>
				@endif

				<!-- Address and Contact Info -->
				<div style="margin-top: 10px;">
					@if(!empty($receipt_details->address))
						<div style="font-size: 14px; line-height: 1.4;">
							{!! $receipt_details->address !!}
						</div>
					@endif
					@if(!empty($receipt_details->contact))
						<div style="font-size: 14px; margin-top: 5px;">
							{!! $receipt_details->contact !!}
						</div>
					@endif
					@if(!empty($receipt_details->website))
						<div style="font-size: 14px; margin-top: 5px;">
							{{ $receipt_details->website }}
						</div>
					@endif
					@if(!empty($receipt_details->location_custom_fields))
						<div style="font-size: 14px; margin-top: 5px;">
							{{ $receipt_details->location_custom_fields }}
						</div>
					@endif
				</div>

				<!-- Sub headings -->
				@if(!empty($receipt_details->sub_heading_line1) || !empty($receipt_details->sub_heading_line2) || !empty($receipt_details->sub_heading_line3) || !empty($receipt_details->sub_heading_line4) || !empty($receipt_details->sub_heading_line5))
					<div style="margin-top: 10px; font-size: 14px;">
						@if(!empty($receipt_details->sub_heading_line1))
							{{ $receipt_details->sub_heading_line1 }}
						@endif
						@if(!empty($receipt_details->sub_heading_line2))
							<br>{{ $receipt_details->sub_heading_line2 }}
						@endif
						@if(!empty($receipt_details->sub_heading_line3))
							<br>{{ $receipt_details->sub_heading_line3 }}
						@endif
						@if(!empty($receipt_details->sub_heading_line4))
							<br>{{ $receipt_details->sub_heading_line4 }}
						@endif		
						@if(!empty($receipt_details->sub_heading_line5))
							<br>{{ $receipt_details->sub_heading_line5 }}
						@endif
					</div>
				@endif

				<!-- Tax Info -->
				@if(!empty($receipt_details->tax_info1) || !empty($receipt_details->tax_info2))
					<div style="margin-top: 10px; font-size: 14px;">
						@if(!empty($receipt_details->tax_info1))
							<b>{{ $receipt_details->tax_label1 }}</b> {{ $receipt_details->tax_info1 }}
						@endif
						@if(!empty($receipt_details->tax_info2))
							<br><b>{{ $receipt_details->tax_label2 }}</b> {{ $receipt_details->tax_info2 }}
						@endif
					</div>
				@endif
			</div>
		</div>

		<!-- Title of receipt -->
		@if(!empty($receipt_details->invoice_heading))
			<div class="col-xs-12 text-center">
				<h3 class="text-center">
					{!! $receipt_details->invoice_heading !!}
				</h3>
			</div>
		@endif
	@endif
	@if(!empty($receipt_details->letter_head))
			<div class="col-xs-12 text-center">
				<img style="width: 100%;margin-bottom: 10px;" src="{{$receipt_details->letter_head}}">
			</div>
		@endif
	<div class="col-xs-12 text-center">
		<!-- Invoice  number, Date  -->
		<p style="width: 100% !important" class="word-wrap">
			<span class="pull-left text-left word-wrap">
				@if(!empty($receipt_details->invoice_no_prefix))
					<b>{!! $receipt_details->invoice_no_prefix !!}</b>
				@endif
				{{$receipt_details->invoice_no}}
				<br/>
				{{$receipt_details->additional_notes ?? ''}}

				@if(!empty($receipt_details->types_of_service))
					<br/>
					<span class="pull-left text-left">
						<strong>{!! $receipt_details->types_of_service_label !!}:</strong>
						{{$receipt_details->types_of_service}}
						<!-- Waiter info -->
						@if(!empty($receipt_details->types_of_service_custom_fields))
							@foreach($receipt_details->types_of_service_custom_fields as $key => $value)
								<br><strong>{{$key}}: </strong> {{$value}}
							@endforeach
						@endif
					</span>
				@endif

				<!-- Table information-->
		        @if(!empty($receipt_details->table_label) || !empty($receipt_details->table))
		        	<br/>
					<span class="pull-left text-left">
						@if(!empty($receipt_details->table_label))
							<b>{!! $receipt_details->table_label !!}</b>
						@endif
						{{$receipt_details->table}}

						<!-- Waiter info -->
					</span>
		        @endif

				<!-- customer info -->
				@if(!empty($receipt_details->customer_info))
					<br/>
					<b>{{ $receipt_details->customer_label }}</b> <br> {!! $receipt_details->customer_info !!} <br>
				@endif
				@if(!empty($receipt_details->client_id_label))
					<br/>
					<b>{{ $receipt_details->client_id_label }}</b> {{ $receipt_details->client_id }}
				@endif
				@if(!empty($receipt_details->customer_tax_label))
					<br/>
					<b>{{ $receipt_details->customer_tax_label }}</b> {{ $receipt_details->customer_tax_number }}
				@endif
				@if(!empty($receipt_details->customer_custom_fields))
					<br/>{!! $receipt_details->customer_custom_fields !!}
				@endif
				@if(!empty($receipt_details->sales_person_label))
					<br/>
					<b>{{ $receipt_details->sales_person_label }}</b> {{ $receipt_details->sales_person }}
				@endif
				@if(!empty($receipt_details->commission_agent_label))
					<br/>
					<strong>{{ $receipt_details->commission_agent_label }}</strong> {{ $receipt_details->commission_agent }}
				@endif
				@if(!empty($receipt_details->customer_rp_label))
					<br/>
					<strong>{{ $receipt_details->customer_rp_label }}</strong> {{ $receipt_details->customer_total_rp }}
				@endif
			</span>

			<span class="pull-right text-left">
				<b>{{$receipt_details->date_label}}</b> {{$receipt_details->invoice_date}}

				@if(!empty($receipt_details->due_date_label))
				<br><b>{{$receipt_details->due_date_label}}</b> {{$receipt_details->due_date ?? ''}}
				@endif

				@if(!empty($receipt_details->brand_label) || !empty($receipt_details->repair_brand))
					<br>
					@if(!empty($receipt_details->brand_label))
						<b>{!! $receipt_details->brand_label !!}</b>
					@endif
					{{$receipt_details->repair_brand}}
		        @endif


		        @if(!empty($receipt_details->device_label) || !empty($receipt_details->repair_device))
					<br>
					@if(!empty($receipt_details->device_label))
						<b>{!! $receipt_details->device_label !!}</b>
					@endif
					{{$receipt_details->repair_device}}
		        @endif

				@if(!empty($receipt_details->model_no_label) || !empty($receipt_details->repair_model_no))
					<br>
					@if(!empty($receipt_details->model_no_label))
						<b>{!! $receipt_details->model_no_label !!}</b>
					@endif
					{{$receipt_details->repair_model_no}}
		        @endif

				@if(!empty($receipt_details->serial_no_label) || !empty($receipt_details->repair_serial_no))
					<br>
					@if(!empty($receipt_details->serial_no_label))
						<b>{!! $receipt_details->serial_no_label !!}</b>
					@endif
					{{$receipt_details->repair_serial_no}}<br>
		        @endif
				@if(!empty($receipt_details->repair_status_label) || !empty($receipt_details->repair_status))
					@if(!empty($receipt_details->repair_status_label))
						<b>{!! $receipt_details->repair_status_label !!}</b>
					@endif
					{{$receipt_details->repair_status}}<br>
		        @endif
		        
		        @if(!empty($receipt_details->repair_warranty_label) || !empty($receipt_details->repair_warranty))
					@if(!empty($receipt_details->repair_warranty_label))
						<b>{!! $receipt_details->repair_warranty_label !!}</b>
					@endif
					{{$receipt_details->repair_warranty}}
					<br>
		        @endif
		        
				<!-- Waiter info -->
				@if(!empty($receipt_details->service_staff_label) || !empty($receipt_details->service_staff))
		        	<br/>
					@if(!empty($receipt_details->service_staff_label))
						<b>{!! $receipt_details->service_staff_label !!}</b>
					@endif
					{{$receipt_details->service_staff}}
		        @endif
		        @if(!empty($receipt_details->shipping_custom_field_1_label))
					<br><strong>{!!$receipt_details->shipping_custom_field_1_label!!} :</strong> {!!$receipt_details->shipping_custom_field_1_value ?? ''!!}
				@endif

				@if(!empty($receipt_details->shipping_custom_field_2_label))
					<br><strong>{!!$receipt_details->shipping_custom_field_2_label!!}:</strong> {!!$receipt_details->shipping_custom_field_2_value ?? ''!!}
				@endif

				@if(!empty($receipt_details->shipping_custom_field_3_label))
					<br><strong>{!!$receipt_details->shipping_custom_field_3_label!!}:</strong> {!!$receipt_details->shipping_custom_field_3_value ?? ''!!}
				@endif

				@if(!empty($receipt_details->shipping_custom_field_4_label))
					<br><strong>{!!$receipt_details->shipping_custom_field_4_label!!}:</strong> {!!$receipt_details->shipping_custom_field_4_value ?? ''!!}
				@endif

				@if(!empty($receipt_details->shipping_custom_field_5_label))
					<br><strong>{!!$receipt_details->shipping_custom_field_2_label!!}:</strong> {!!$receipt_details->shipping_custom_field_5_value ?? ''!!}
				@endif
				{{-- sale order --}}
				@if(!empty($receipt_details->sale_orders_invoice_no))
					<br>
					<strong>@lang('restaurant.order_no'):</strong> {!!$receipt_details->sale_orders_invoice_no ?? ''!!}
				@endif

				@if(!empty($receipt_details->sale_orders_invoice_date))
					<br>
					<strong>@lang('lang_v1.order_dates'):</strong> {!!$receipt_details->sale_orders_invoice_date ?? ''!!}
				@endif

				@if(!empty($receipt_details->sell_custom_field_1_value))
					<br>
					<strong>{{ $receipt_details->sell_custom_field_1_label }}:</strong> {!!$receipt_details->sell_custom_field_1_value ?? ''!!}
				@endif

				@if(!empty($receipt_details->sell_custom_field_2_value))
					<br>
					<strong>{{ $receipt_details->sell_custom_field_2_label }}:</strong> {!!$receipt_details->sell_custom_field_2_value ?? ''!!}
				@endif

				@if(!empty($receipt_details->sell_custom_field_3_value))
					<br>
					<strong>{{ $receipt_details->sell_custom_field_3_label }}:</strong> {!!$receipt_details->sell_custom_field_3_value ?? ''!!}
				@endif

				@if(!empty($receipt_details->sell_custom_field_4_value))
					<br>
					<strong>{{ $receipt_details->sell_custom_field_4_label }}:</strong> {!!$receipt_details->sell_custom_field_4_value ?? ''!!}
				@endif

			</span>
		</p>
	</div>
</div>

<div class="row" style="color: #000000 !important;">
	@includeIf('sale_pos.receipts.partial.common_repair_invoice')
</div>

<div class="row" style="color: #000000 !important;">
	<div class="col-xs-12">
		<br/>
		@php
			$p_width = 45;
		@endphp
		@if(!empty($receipt_details->item_discount_label))
			@php
				$p_width -= 10;
			@endphp
		@endif
		@if(!empty($receipt_details->discounted_unit_price_label))
			@php
				$p_width -= 10;
			@endphp
		@endif
		<table class="table table-responsive" style="border-collapse: collapse; width: 100%; margin-bottom: 20px; border: 1px solid #ddd;">
			<thead>
				<tr style="background-color: #f8f9fa; border-bottom: 2px solid #dee2e6;">
					<th width="{{$p_width}}%" style="padding: 12px 8px; text-align: left; font-weight: bold; color: #495057; border-right: 1px solid #dee2e6;">{{$receipt_details->table_product_label}}</th>
					<th class="text-right" width="15%" style="padding: 12px 8px; text-align: right; font-weight: bold; color: #495057; border-right: 1px solid #dee2e6;">{{$receipt_details->table_qty_label}}</th>
					<th class="text-right" width="15%" style="padding: 12px 8px; text-align: right; font-weight: bold; color: #495057; border-right: 1px solid #dee2e6;">{{$receipt_details->table_unit_price_label}}</th>
					@if(!empty($receipt_details->discounted_unit_price_label))
						<th class="text-right" width="10%" style="padding: 12px 8px; text-align: right; font-weight: bold; color: #495057; border-right: 1px solid #dee2e6;">{{$receipt_details->discounted_unit_price_label}}</th>
					@endif
					@if(!empty($receipt_details->item_discount_label))
						<th class="text-right" width="10%" style="padding: 12px 8px; text-align: right; font-weight: bold; color: #495057; border-right: 1px solid #dee2e6;">{{$receipt_details->item_discount_label}}</th>
					@endif
					<th class="text-right" width="15%" style="padding: 12px 8px; text-align: right; font-weight: bold; color: #495057;">{{$receipt_details->table_subtotal_label}}</th>
				</tr>
			</thead>
			<tbody>

				@if(!empty($receipt_details->purchase_lines))
					@foreach ($receipt_details->purchase_lines as $loop_key => $purchase)
						<tr style="border-bottom: 1px solid #dee2e6;">
							<td style="padding: 12px 8px; border-right: 1px solid #dee2e6; vertical-align: top;">
								@if(!empty($purchase['image']))
									<img src="{{$purchase['image']}}" alt="Image" width="50" style="float: left; margin-right: 8px;">
								@endif
								{{$purchase['name']}} {{$purchase['product_variation']}} {{$purchase['variation']}} 
								@if(!empty($purchase['sub_sku'])), {{$purchase['sub_sku']}} @endif @if(!empty($purchase['brand'])), {{$purchase['brand']}} @endif @if(!empty($line['cat_code'])), {{$line['cat_code']}}@endif
								@if(!empty($purchase['product_custom_fields'])), {{$purchase['product_custom_fields']}} @endif
								@if(!empty($purchase['product_description']))
									<small>
										{!!$purchase['product_description']!!}
									</small>
								@endif 

								@if(!empty($purchase['lot_number']))<br> {{$purchase['lot_number_label']}}:  {{$purchase['lot_number']}} @endif 
								@if(!empty($purchase['product_expiry'])), {{$purchase['product_expiry_label']}}:  {{$purchase['product_expiry']}} @endif

								@if(!empty($purchase['warranty_name'])) <br><small>{{$purchase['warranty_name']}} </small>@endif @if(!empty($purchase['warranty_exp_date'])) <small>- {{@format_date($purchase['warranty_exp_date'])}} </small>@endif
								@if(!empty($purchase['warranty_description'])) <small> {{$purchase['warranty_description'] ?? ''}}</small>@endif

								@if($receipt_details->show_base_unit_details && $purchase['quantity'] && $purchase['base_unit_multiplier'] !== 1)
									<br>
									<small>
										1 {{$purchase['units']}} = {{$purchase['base_unit_multiplier']}} {{$purchase['base_unit_name']}} <br>
										{{$purchase['base_unit_price']}} x {{$purchase['orig_quantity']}} = {{$purchase['line_total']}}
									</small>
								@endif

								@if($receipt_details->show_serial_number)
									@if(!empty(getPurchaseProductSerial($purchase['product_id'], $purchase['serial_purchase_code'])))
										@if(!empty(getPurchaseProductSerial($purchase['product_id'], $purchase['serial_purchase_code'])))
											
											@php
												$num_of_items = count(getPurchaseProductSerial($purchase['product_id'], $purchase['serial_purchase_code']));
												$num_count = 0;
											@endphp

											@if ($num_of_items > 0)
												<br>SL :
											@endif

											@php
												foreach (getPurchaseProductSerial($purchase['product_id'], $purchase['serial_purchase_code']) as $serial_number) {
													echo "<small style='font-weight: 700'>".$serial_number->serial_number."</small>";
													$num_count = $num_count + 1;
													if ($num_count < $num_of_items){ 
														if ($num_count % 4==0) { 
															echo "<br>" ; 
														}else{ 
															echo ", " ; 
														} 
													} 
												}
											@endphp 

										@endif
									@endif 
								@endif
								
								
								
								@php
									$custom_labels = json_decode(session('business.custom_labels'), true);
									$product_custom_fields = !empty($custom_labels['product']) ? $custom_labels['product'] : [];
									$product_cf_details = !empty($custom_labels['product_cf_details']) ? $custom_labels['product_cf_details'] : [];

								@endphp

								@foreach($product_custom_fields as $index => $cf)
									@if(!empty($cf))
										@php
											$db_field_name = 'product_custom_field'.$loop_key;
											$cf_type = !empty($product_cf_details[$loop_key]['type']) ? $product_cf_details[$loop_key]['type'] : 'text';
											$dropdown = !empty($product_cf_details[$loop_key]['dropdown_options']) 
														? explode(PHP_EOL, $product_cf_details[$loop_key]['dropdown_options']) 
														: [];
											$value = $purchase[$db_field_name] ?? null;
										@endphp
										<br>
										@if(in_array($cf_type, ['text', 'date']))
											{{ $cf }} : {{ $value }}
										@elseif($cf_type == 'dropdown')
											{{ $cf }} : {{$dropdown[$purchase[$db_field_name]] ?? ''}}
										@endif 
									@endif
								@endforeach

								<br>
								<span style="background-color: rgb(255, 0, 0)">Exchange Recived</span>

							</td>


							<td class="text-right" style="padding: 12px 8px; border-right: 1px solid #dee2e6; text-align: right; vertical-align: top;">
								{{$purchase['quantity']}} {{$purchase['units']}} 

								@if($receipt_details->show_base_unit_details && $purchase['quantity'] && $purchase['base_unit_multiplier'] !== 1)
									<br><small>
										{{$purchase['quantity']}} x {{$purchase['base_unit_multiplier']}} = {{$purchase['orig_quantity']}} {{$purchase['base_unit_name']}}
									</small>
								@endif

								@if($receipt_details->show_multi_unit_details)
									@if(!empty($purchase['first_conversion_unit_id']))
										<br>
										@php
											$first_quantity = $purchase['quantity_uf'] / $purchase['first_conversion_unit_rate'];
											$first_unit = App\Unit::where('id', $purchase['first_conversion_unit_id'])->first();
										@endphp
										{{ $first_quantity }} {{ $first_unit->short_name }}
									@endif
									@if(!empty($purchase['second_conversion_unit_id']))
										<br>
										@php
											$second_quantity = $purchase['quantity_uf'] / ($purchase['first_conversion_unit_rate'] *$purchase['second_conversion_unit_rate']);
											$second_unit = App\Unit::where('id', $purchase['second_conversion_unit_id'])->first();
										@endphp
										{{ $second_quantity }} {{ $second_unit->short_name }}
									@endif
									
								@endif
							</td>

							<td class="text-right" style="padding: 12px 8px; border-right: 1px solid #dee2e6; text-align: right; vertical-align: top;">
								{{$purchase['unit_price_before_discount']}}
							</td>


							@if(!empty($receipt_details->discounted_unit_price_label))
								<td class="text-right" style="padding: 12px 8px; border-right: 1px solid #dee2e6; text-align: right; vertical-align: top;">
									{{$purchase['unit_price_inc_tax']}}
								</td>
							@endif


							@if(!empty($receipt_details->item_discount_label))
								<td class="text-right" style="padding: 12px 8px; border-right: 1px solid #dee2e6; text-align: right; vertical-align: top;">
									{{$purchase['total_line_discount'] ?? '0.00'}}

									@if(!empty($purchase['line_discount_percent']))
										({{$purchase['line_discount_percent']}}%)
									@endif
								</td>
							@endif

							<td class="text-right" style="padding: 12px 8px; text-align: right; vertical-align: top; font-weight: bold;">
								{{$purchase['line_total']}}
							</td>

						</tr>
					@endforeach	
				@endif

		

				@forelse($receipt_details->lines as $line)

					<tr @if($line['not_for_selling'] == 1) style="display: none;" @endif style="border-bottom: 1px solid #dee2e6;">
							
						<td style="padding: 12px 8px; border-right: 1px solid #dee2e6; vertical-align: top;">
							@if(!empty($line['image']))
								<img src="{{$line['image']}}" alt="Image" width="50" style="float: left; margin-right: 8px;">
							@endif
							{{$line['name']}} {{$line['product_variation']}} {{$line['variation']}} 
							@if(!empty($line['sub_sku'])), {{$line['sub_sku']}} @endif @if(!empty($line['brand'])), {{$line['brand']}} @endif @if(!empty($line['cat_code'])), {{$line['cat_code']}}@endif
							@if(!empty($line['product_custom_fields'])), {{$line['product_custom_fields']}} @endif
							@if(!empty($line['product_description']))
								<small>
									{!!$line['product_description']!!}
								</small>
							@endif 

							@if(!empty($line['sell_line_note']))
							<br>
							<small>
								{!!$line['sell_line_note']!!}
							</small>
							@endif 
							@if(!empty($line['lot_number']))<br> {{$line['lot_number_label']}}:  {{$line['lot_number']}} @endif 
							@if(!empty($line['product_expiry'])), {{$line['product_expiry_label']}}:  {{$line['product_expiry']}} @endif

							@if(!empty($line['warranty_name'])) <br><small>{{$line['warranty_name']}} </small>@endif @if(!empty($line['warranty_exp_date'])) <small>- {{@format_date($line['warranty_exp_date'])}} </small>@endif
							@if(!empty($line['warranty_description'])) <small> {{$line['warranty_description'] ?? ''}}</small>@endif



							@if($receipt_details->show_base_unit_details && $line['quantity'] && $line['base_unit_multiplier'] !== 1)
								<br>
								<small>
									1 {{$line['units']}} = {{$line['base_unit_multiplier']}} {{$line['base_unit_name']}} <br>
									{{$line['base_unit_price']}} x {{$line['orig_quantity']}} = {{$line['line_total']}}
								</small>
							@endif



							@if($receipt_details->show_serial_number)
								@if(!empty(getSellsProductSerial($line['product_id'], $receipt_details->product_Transaction_id)))
									@if(!empty(getSellsProductSerial($line['product_id'], $receipt_details->product_Transaction_id)))
										
										@php
											$num_of_items = count(getSellsProductSerial($line['product_id'], $receipt_details->product_Transaction_id));
											$num_count = 0;
										@endphp

										@if ($num_of_items > 0)
											<br>SL :
										@endif

										@php
											foreach (getSellsProductSerial($line['product_id'], $receipt_details->product_Transaction_id) as $serial_number) {
												echo "<small style='font-weight: 700'>".$serial_number->serial_number."</small>";
												$num_count = $num_count + 1;
												if ($num_count < $num_of_items){ 
													if ($num_count % 4==0) { 
														echo "<br>" ; 
													}else{ 
														echo ", " ; 
													} 
												} 
											}
										@endphp 

									@endif
								@endif 
							@endif
							
							
							
							@php
								$custom_labels = json_decode(session('business.custom_labels'), true);
								$product_custom_fields = !empty($custom_labels['product']) ? $custom_labels['product'] : [];
								$product_cf_details = !empty($custom_labels['product_cf_details']) ? $custom_labels['product_cf_details'] : [];

							@endphp

							@foreach($product_custom_fields as $index => $cf)
								@if(!empty($cf))
									@php
										$db_field_name = 'product_custom_field'.$loop->iteration;
										$cf_type = !empty($product_cf_details[$loop->iteration]['type']) ? $product_cf_details[$loop->iteration]['type'] : 'text';
										$dropdown = !empty($product_cf_details[$loop->iteration]['dropdown_options']) 
													? explode(PHP_EOL, $product_cf_details[$loop->iteration]['dropdown_options']) 
													: [];
										$value = $line[$db_field_name] ?? null;
									@endphp
									<br>
									@if(in_array($cf_type, ['text', 'date']))
										{{ $cf }} : {{ $value }}
									@elseif($cf_type == 'dropdown')
										{{ $cf }} : {{$dropdown[$line[$db_field_name]] ?? ''}}
									@endif 
								@endif
							@endforeach
							
						</td>


						<td class="text-right" style="padding: 12px 8px; border-right: 1px solid #dee2e6; text-align: right; vertical-align: top;">
					


							@if ($receipt_details->show_only_sold_unit)

								{{$line['sell_unit_quantity']}} 

							@else

								{{$line['quantity']}} {{$line['units']}} 

								@if($receipt_details->show_base_unit_details && $line['quantity'] && $line['base_unit_multiplier'] !== 1)
									<br><small>
										{{$line['quantity']}} x {{$line['base_unit_multiplier']}} = {{$line['orig_quantity']}} {{$line['base_unit_name']}}
									</small>
								@endif

								
								@if($receipt_details->show_multi_unit_details)
									@if(!empty($line['first_conversion_unit_id']))
										<br>
										@php
											$first_quantity = $line['quantity_uf'] / $line['first_conversion_unit_rate'];
											$first_unit = App\Unit::where('id', $line['first_conversion_unit_id'])->first();
										@endphp
										{{ $first_quantity }} {{ $first_unit->short_name }}
									@endif
									@if(!empty($line['second_conversion_unit_id']))
										<br>
										@php
											$second_quantity = $line['quantity_uf'] / ($line['first_conversion_unit_rate'] *$line['second_conversion_unit_rate']);
											$second_unit = App\Unit::where('id', $line['second_conversion_unit_id'])->first();
										@endphp
										{{ $second_quantity }} {{ $second_unit->short_name }}
									@endif
									
								@endif

							@endif

						</td>

							
						<td class="text-right" style="padding: 12px 8px; border-right: 1px solid #dee2e6; text-align: right; vertical-align: top;">
							@if ($receipt_details->show_only_sold_unit)
								{{$line['sell_unit_price_before_discount']}} 
							@else
								{{$line['unit_price_before_discount']}}
							@endif
						</td>

						@if(!empty($receipt_details->discounted_unit_price_label))
							<td class="text-right" style="padding: 12px 8px; border-right: 1px solid #dee2e6; text-align: right; vertical-align: top;">
								@if ($receipt_details->show_only_sold_unit)
									{{$line['sell_unit_price_inc_tax']}} 
								@else
									{{$line['unit_price_inc_tax']}}
								@endif
							</td>
						@endif

						@if(!empty($receipt_details->item_discount_label))
							<td class="text-right" style="padding: 12px 8px; border-right: 1px solid #dee2e6; text-align: right; vertical-align: top;">
								{{$line['total_line_discount'] ?? '0.00'}}

								@if(!empty($line['line_discount_percent']))
									({{$line['line_discount_percent']}}%)
								@endif
							</td>
						@endif
						<td class="text-right" style="padding: 12px 8px; text-align: right; vertical-align: top; font-weight: bold;">
							{{$line['line_total']}}
						</td>
					</tr>





					
					@if(!empty($line['modifiers']))
						@foreach($line['modifiers'] as $modifier)
							<tr>
								<td>
		                            {{$modifier['name']}} {{$modifier['variation']}} 
		                            @if(!empty($modifier['sub_sku'])), {{$modifier['sub_sku']}} @endif @if(!empty($modifier['cat_code'])), {{$modifier['cat_code']}}@endif
		                            @if(!empty($modifier['sell_line_note']))({!!$modifier['sell_line_note']!!}) @endif 
		                        </td>
								<td class="text-right">{{$modifier['quantity']}} {{$modifier['units']}} </td>
								<td class="text-right">{{$modifier['unit_price_inc_tax']}}</td>
								@if(!empty($receipt_details->discounted_unit_price_label))
									<td class="text-right">{{$modifier['unit_price_exc_tax']}}</td>
								@endif
								@if(!empty($receipt_details->item_discount_label))
									<td class="text-right">0.00</td>
								@endif
								<td class="text-right">{{$modifier['line_total']}}</td>
							</tr>
						@endforeach
					@endif


				@empty
					<tr>
						<td colspan="4">&nbsp;</td>
						@if(!empty($receipt_details->discounted_unit_price_label))
    					<td></td>
    					@endif
    					@if(!empty($receipt_details->item_discount_label))
    					<td></td>
    					@endif
					</tr>
				@endforelse

				
			</tbody>
		</table>
	</div>
</div>

<div class="row" style="color: #000000 !important;">
	<div class="col-md-12"><hr/></div>
	<div class="col-xs-6">

		<table class="table table-slim">

			@if(!empty($receipt_details->payments))
				@foreach($receipt_details->payments as $payment)
					<tr>
						<td>{{$payment['method']}}</td>
						<td class="text-right" >{{$payment['amount']}}</td>
						<td class="text-right">{{$payment['date']}}</td>
					</tr>
				@endforeach
			@endif

			<!-- Total Paid-->
			@if(!empty($receipt_details->total_paid))
				<tr>
					<th>
						{!! $receipt_details->total_paid_label !!}
					</th>
					<td class="text-right">
						{{$receipt_details->total_paid}}
					</td>
				</tr>
			@endif

			<!-- Total Due-->
			@if(!empty($receipt_details->total_due) && !empty($receipt_details->total_due_label))
			<tr>
				<th>
					{!! $receipt_details->total_due_label !!}
				</th>
				<td class="text-right">
					{{$receipt_details->total_due}}
				</td>
			</tr>
			@endif

			@if(!empty($receipt_details->all_due))
			<tr>
				<th>
					{!! $receipt_details->all_bal_label !!}
				</th>
				<td class="text-right">
					{{$receipt_details->all_due}}
				</td>
			</tr>
			@endif
		</table>
	</div>

	<div class="col-xs-6">
        <div class="table-responsive">
          	<table class="table table-slim">
				<tbody>
					@if(!empty($receipt_details->total_quantity_label))
						<tr>
							<th style="width:70%">
								{!! $receipt_details->total_quantity_label !!}
							</th>
							<td class="text-right">
								{{$receipt_details->total_quantity}}
							</td>
						</tr>
					@endif

					@if(!empty($receipt_details->total_items_label))
						<tr>
							<th style="width:70%">
								{!! $receipt_details->total_items_label !!}
							</th>
							<td class="text-right">
								{{$receipt_details->total_items}}
							</td>
						</tr>
					@endif
					<tr>
						<th style="width:70%">
							{!! $receipt_details->subtotal_label !!}
						</th>
						<td class="text-right">
							{{$receipt_details->subtotal}}
						</td>
					</tr>
					@if(!empty($receipt_details->total_exempt_uf))
					<tr>
						<th style="width:70%">
							@lang('lang_v1.exempt')
						</th>
						<td class="text-right">
							{{$receipt_details->total_exempt}}
						</td>
					</tr>
					@endif
					<!-- Shipping Charges -->
					@if(!empty($receipt_details->shipping_charges))
						<tr>
							<th style="width:70%">
								{!! $receipt_details->shipping_charges_label !!}
							</th>
							<td class="text-right">
								{{$receipt_details->shipping_charges}}
							</td>
						</tr>
					@endif

					@if(!empty($receipt_details->packing_charge))
						<tr>
							<th style="width:70%">
								{!! $receipt_details->packing_charge_label !!}
							</th>
							<td class="text-right">
								{{$receipt_details->packing_charge}}
							</td>
						</tr>
					@endif

					<!-- Discount -->
					@if( !empty($receipt_details->discount) )
						<tr>
							<th>
								{!! $receipt_details->discount_label !!}
							</th>

							<td class="text-right">
								(-) {{$receipt_details->discount}}
							</td>
						</tr>
					@endif

					@if( !empty($receipt_details->total_line_discount) )
						<tr>
							<th>
								{!! $receipt_details->line_discount_label !!}
							</th>

							<td class="text-right">
								(-) {{$receipt_details->total_line_discount}}
							</td>
						</tr>
					@endif

					@if( !empty($receipt_details->additional_expenses) )
						@foreach($receipt_details->additional_expenses as $key => $val)
							<tr>
								<td>
									{{$key}}:
								</td>

								<td class="text-right">
									(+) {{$val}}
								</td>
							</tr>
						@endforeach
					@endif

					@if( !empty($receipt_details->reward_point_label) )
						<tr>
							<th>
								{!! $receipt_details->reward_point_label !!}
							</th>

							<td class="text-right">
								(-) {{$receipt_details->reward_point_amount}}
							</td>
						</tr>
					@endif

					<!-- Tax -->
					@if( !empty($receipt_details->tax) )
						<tr>
							<th>
								{!! $receipt_details->tax_label !!}
							</th>
							<td class="text-right">
								(+) {{$receipt_details->tax}}
							</td>
						</tr>
					@endif

					@if( $receipt_details->round_off_amount > 0)
						<tr>
							<th>
								{!! $receipt_details->round_off_label !!}
							</th>
							<td class="text-right">
								{{$receipt_details->round_off}}
							</td>
						</tr>
					@endif

					<!-- Total -->
					<tr>
						<th>
							{!! $receipt_details->total_label !!}
						</th>
						<td class="text-right">
							{{$receipt_details->total}}
							@if(!empty($receipt_details->total_in_words))
								<br>
								<small>({{$receipt_details->total_in_words}})</small>
							@endif
						</td>
					</tr>
				</tbody>
        	</table>
        </div>
    </div>

    <div class="border-bottom col-md-12">
	    @if(empty($receipt_details->hide_price) && !empty($receipt_details->tax_summary_label) )
	        <!-- tax -->
	        @if(!empty($receipt_details->taxes))
	        	<table class="table table-slim table-bordered">
	        		<tr>
	        			<th colspan="2" class="text-center">{{$receipt_details->tax_summary_label}}</th>
	        		</tr>
	        		@foreach($receipt_details->taxes as $key => $val)
	        			<tr>
	        				<td class="text-center"><b>{{$key}}</b></td>
	        				<td class="text-center">{{$val}}</td>
	        			</tr>
	        		@endforeach
	        	</table>
	        @endif
	    @endif
	</div>

	@if(!empty($receipt_details->additional_notes))
	    <div class="col-xs-12">
	    	<p>{!! nl2br($receipt_details->additional_notes) !!}</p>
	    </div>
    @endif
    
</div>

<!-- Terms and Conditions Section -->
<div class="row" style="color: #000000 !important; margin-top: 20px;">
	<div class="col-xs-12">
		<div style="background-color: #f8f9fa; padding: 15px; border: 1px solid #dee2e6; border-radius: 5px;">
			<h4 style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #495057;">Terms & Conditions:</h4>
			<p style="margin: 0; font-size: 12px; line-height: 1.4; color: #6c757d;">
				<strong>বি:দ্র:</strong> বি:দ্র: ডিসপ্লে এর কোনো ওয়ারেন্টি নেই। সফটওয়‍্যার আপডেট জনিত কারণে অথবা অটোমেটিক ডিসপ্লে গ্রিন লাইন হলে, অথবা কোনো লাইন হলে অথবা ডিসপ্লে নষ্ট হলে, অথবা বৈদ্যুতিক শর্ট সার্কিট ও ওয়াটার ড্যামেজ ওয়ারেন্টি/গ্যারান্টির আওতায় পরবে না।
			</p>
		</div>
	</div>
</div>

<!-- Signature Section -->
<div class="row" style="color: #000000 !important; margin-top: 40px;">
	<div class="col-xs-6">
		<div style="text-align: center; padding-top: 10px; margin-top: 20px;">
			<div style="height: 60px; border-bottom: 1px solid #000; margin-bottom: 5px;"></div>
			<strong>Customer Signature</strong>
		</div>
	</div>
	<div class="col-xs-6">
		<div style="text-align: center; padding-top: 10px; margin-top: 20px;">
			<div style="height: 60px; border-bottom: 1px solid #000; margin-bottom: 5px;"></div>
			<strong>Shop Owner Signature</strong>
		</div>
	</div>
</div>

<!-- Barcode Section -->
<div class="row" style="color: #000000 !important; margin-top: 20px;">
	<div class="col-xs-12">
		<div style="text-align: center;">
			@if($receipt_details->show_barcode)
				{{-- Barcode --}}
				<img class="center-block" src="data:image/png;base64,{{DNS1D::getBarcodePNG($receipt_details->invoice_no, 'C128', 2,30,array(39, 48, 54), true)}}">
			@endif
		</div>
	</div>
</div>

<div class="row" style="color: #000000 !important;">
	@if(!empty($receipt_details->footer_text))
	<div class="col-xs-12">
		{!! $receipt_details->footer_text !!}
	</div>
	@endif
	@if($receipt_details->show_qr_code && !empty($receipt_details->qr_code_text))
		<div class="col-xs-12 text-center">
			<img class="center-block mt-5" src="data:image/png;base64,{{DNS2D::getBarcodePNG($receipt_details->qr_code_text, 'QRCODE', 3, 3, [39, 48, 54])}}">
		</div>
	@endif
</div>

<!-- Xspider Footer -->
<div class="row" style="color: #000000 !important; margin-top: 30px; border-top: 1px solid #dee2e6; padding-top: 15px;">
	<div class="col-xs-12 text-center">
		<p style="margin: 0; font-size: 10px; color: #6c757d; font-style: italic;">
			Powered by <strong>Xspider</strong> | <a href="http://www.xspider.net" target="_blank" style="color: #6c757d; text-decoration: none;">www.xspider.net</a>
		</p>
	</div>
</div>