@forelse($products as $product)
	<div class="product_list no-print" style="margin-top: 2px; padding: 1px; float: left;">
		<div class="product_box" style="background: #ffffff; border: 1px solid #e5e7eb; border-radius: 10px; position: relative; box-shadow: 0 2px 8px rgba(0,0,0,0.08), 0 1px 3px rgba(0,0,0,0.04); transition: all 0.2s ease; cursor: pointer; padding: 0; overflow: hidden;" data-variation_id="{{$product->id}}" title="{{$product->name}} @if($product->type == 'variable')- {{$product->variation}} @endif {{ '(' . $product->sub_sku . ')'}} @if(!empty($show_prices)) @lang('lang_v1.default') - @format_currency($product->selling_price) @foreach($product->group_prices as $group_price) @if(array_key_exists($group_price->price_group_id, $allowed_group_prices)) {{$allowed_group_prices[$group_price->price_group_id]}} - @format_currency($group_price->price_inc_tax) @endif @endforeach @endif">


			<div class="stock_base" @if($product->qty_available < 0) style="background: #ff1100;color: #fff;" @elseif($product->qty_available > 0) style="background: #008246;color: #fff;" @else style="background: #ffad46;color: #fff;" @endif>
				@if($product->enable_stock)
					@if($product->qty_available < 0)
						-
					@endif
					{{ @num_format($product->qty_available) }} 
					{{$product->unit}}
				@else
					0.00 {{$product->unit}}
				@endif
			</div>

			<div class="image-container" 
				@if(count($product->media) > 0)
					style="background-image: url({{$product->media->first()->display_url}}); background-repeat: no-repeat; background-position: center; background-size: contain;"
				@elseif(!empty($product->product_image))
					style="background-image: url({{asset('/uploads/img/' . rawurlencode($product->product_image))}}); background-repeat: no-repeat; background-position: center; background-size: contain;"
				@else
					style="background-image: none; background-color: #ffffff; display: flex; align-items: center; justify-content: center;"
				@endif>
				@if(count($product->media) == 0 && empty($product->product_image))
					<i class="fas fa-cube" style="font-size: 32px;"></i>
				@endif
			</div>

			<div class="text_div">
				<small class="text product-name">{{$product->name}} 
				@if($product->type == 'variable')
					- {{$product->variation}}
				@endif
				</small>

				<small class="product-sku">
					({{$product->sub_sku}})
				</small>
				
				<!-- Price moved to upper position -->
				<small class="product-price" style="font-size: 80%; background: #fbbf24; color: #111827; font-weight: 700; padding: 3px 8px; border-radius: 6px; box-shadow: 0 1px 4px rgba(0,0,0,0.15); display: inline-block; margin-top: 2px; margin-bottom: 2px; text-shadow: none;">
					@format_currency($product->selling_price)
				</small>
				
				<!-- Quantity Input Box with +/- controls -->
				<div class="product-qty-input" style="margin: 2px 0; display: flex; align-items: center; gap: 3px; justify-content: center;">
					<button type="button" class="qty-btn qty-minus" data-variation_id="{{$product->id}}" style="width: 28px; height: 28px; padding: 0; border: 1px solid #d1d5db; border-radius: 4px 0 0 4px; background: #f3f4f6; cursor: pointer; display: flex; align-items: center; justify-content: center; font-size: 14px; font-weight: bold; color: #374151; line-height: 1;">
						-
					</button>
					<input type="number" 
						   id="product_qty_{{$product->id}}" 
						   class="product-qty-input-field" 
						   data-variation_id="{{$product->id}}"
						   value="1" 
						   min="1" 
						   step="1"
						   style="width: 60px; height: 28px; padding: 2px 6px; font-size: 13px; font-weight: 600; border: 1px solid #d1d5db; border-left: none; border-right: none; text-align: center; -moz-appearance: textfield;">
					<button type="button" class="qty-btn qty-plus" data-variation_id="{{$product->id}}" style="width: 28px; height: 28px; padding: 0; border: 1px solid #d1d5db; border-radius: 0 4px 4px 0; background: #f3f4f6; cursor: pointer; display: flex; align-items: center; justify-content: center; font-size: 14px; font-weight: bold; color: #374151; line-height: 1;">
						+
					</button>
				</div>
				
				<!-- Add to Cart Button -->
				<button type="button" 
						class="add-to-cart-btn" 
						data-variation_id="{{$product->id}}"
						style="width: 100%; margin-top: 2px; padding: 8px 12px; font-size: 11px; background: #22c55e; color: #ffffff; border: none; border-radius: 5px; cursor: pointer; font-weight: 700; display: flex; align-items: center; justify-content: center; gap: 6px; min-height: 36px;">
					<i class="fas fa-shopping-cart" style="font-size: 12px;"></i>
					<span>Add to Cart</span>
				</button>
			</div>
			
		</div>
	</div>
@empty
	<input type="hidden" id="no_products_found">
	<div class="col-md-12">
		<h4 class="text-center">
			@lang('lang_v1.no_products_to_display')
		</h4>
	</div>
@endforelse


<style>
	.product_list {
		margin-bottom: 4px !important;
		box-sizing: border-box !important;
	}
	
	/* Desktop - 4 per row */
	@media (min-width: 1200px) {
		.product_list {
			width: 25% !important;
			max-width: 25% !important;
		}
	}
	
	/* Tablet Landscape - 3 per row */
	@media (max-width: 1199.98px) and (min-width: 992px) {
		.product_list {
			width: 33.333% !important;
			max-width: 33.333% !important;
		}
	}
	
	/* Tablet Portrait - 3 per row */
	@media (max-width: 991.98px) and (min-width: 769px) {
		.product_list {
			width: 33.333% !important;
			max-width: 33.333% !important;
		}
	}
	
	/* Mobile Landscape - 2 per row */
	@media (max-width: 768px) and (min-width: 481px) {
		.product_list {
			width: 50% !important;
			max-width: 50% !important;
		}
	}
	
	/* Mobile Portrait - 2 per row */
	@media (max-width: 480px) and (min-width: 361px) {
		.product_list {
			width: 50% !important;
			max-width: 50% !important;
		}
	}
	
	/* Small Mobile - 1 per row */
	@media (max-width: 360px) {
		.product_list {
			width: 100% !important;
			max-width: 100% !important;
		}
	}
	.product_box {
		background: #ffffff !important;
		border: 1px solid #e5e7eb !important;
		min-height: 0 !important;
		height: auto !important;
		position: relative;
	}
	.product_box:hover {
		transform: translateY(-3px);
		box-shadow: 0 4px 15px rgba(0,0,0,0.12), 0 2px 6px rgba(0,0,0,0.08) !important;
		border-color: #3b82f6 !important;
	}
	.product_box .stock_base {
		position: absolute;
		left: 0;
		top: 0;
		width: 60px;
		height: 25px;
		box-shadow: 0 2px 8px rgba(0,0,0,0.15), 0 1px 3px rgba(0,0,0,0.1);
		border-top-left-radius: 10px;
		border-bottom-right-radius: 12px;
		padding: 0;
		font-weight: 700;
		font-size: 10px;
		z-index: 10;
		line-height: 25px;
		text-align: center;
		display: flex;
		align-items: center;
		justify-content: center;
		transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
		backdrop-filter: blur(4px);
		border: none;
		text-shadow: 0 1px 2px rgba(0,0,0,0.1);
		letter-spacing: 0.3px;
		overflow: hidden;
		white-space: nowrap;
	}
	.product_box .stock_base::before {
		content: '';
		position: absolute;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, rgba(255,255,255,0) 100%);
		pointer-events: none;
	}
	.product_box:hover .stock_base {
		transform: scale(1.05);
		box-shadow: 0 4px 12px rgba(0,0,0,0.2), 0 2px 6px rgba(0,0,0,0.15);
	}
	.product_box .text_div {
		padding: 3px 5px !important;
		position: relative;
		z-index: 1;
	}
	.product_box .text_div .product-name {
		color: #111827 !important;
		font-weight: 500;
		font-size: 13px;
		line-height: 1.2;
		display: block;
		margin-bottom: 0;
	}
	.product_box .text_div .product-sku {
		color: #6b7280 !important;
		font-size: 11px;
		line-height: 1.1;
		display: block;
		margin-bottom: 0;
	}
	.product_box .image-container {
		height: 75px !important;
		margin: 1px !important;
		background-color: #ffffff !important;
		border-radius: 6px;
		border: none !important;
		border-style: none !important;
		box-shadow: inset 0 1px 2px rgba(0,0,0,0.05);
	}
	
	div.image-container {
		border-style: none !important;
	}
	
	.product_box .image-container i.fas.fa-cube {
		color: #0c343d !important;
	}
	
	/* Minimize product box dimensions */
	.product_box {
		padding: 2px !important;
		margin: 0 !important;
	}
	
	.product_list {
		padding: 1px !important;
		margin-top: 2px !important;
	}
	
	.product_box .text_div {
		padding: 2px 4px !important;
	}
	
	.product_box .text_div .product-name {
		font-size: 13px !important;
		line-height: 1.3 !important;
		margin-bottom: 0 !important;
	}
	
	.product_box .text_div .product-sku {
		font-size: 11px !important;
		line-height: 1.2 !important;
		margin-bottom: 1px !important;
	}
	
	.product_box .text_div .product-price {
		font-size: 75% !important;
		padding: 2px 6px !important;
		margin-top: 1px !important;
	}
	
	.product_box .stock_base {
		width: 50px !important;
		height: 20px !important;
		font-size: 9px !important;
		line-height: 20px !important;
	}
	
	/* Product Quantity Input Styles */
	.product-qty-input {
		margin: 2px 0 !important;
	}
	
	.product-qty-input-field {
		width: 60px !important;
		height: 28px !important;
		padding: 2px 6px !important;
		font-size: 13px !important;
		font-weight: 600 !important;
		border: 1px solid #d1d5db !important;
		border-radius: 4px !important;
		text-align: center !important;
		background-color: #ffffff !important;
	}
	
	.product-qty-input-field:focus {
		outline: none !important;
		border-color: #3b82f6 !important;
		box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.1) !important;
	}
	
	/* Hide number input arrows */
	.product-qty-input-field::-webkit-outer-spin-button,
	.product-qty-input-field::-webkit-inner-spin-button {
		-webkit-appearance: none;
		margin: 0;
	}
	
	/* Quantity control buttons */
	.qty-btn {
		transition: all 0.2s ease !important;
		width: 28px !important;
		height: 28px !important;
		font-size: 14px !important;
		font-weight: bold !important;
	}
	
	.qty-btn:hover {
		background: #e5e7eb !important;
		border-color: #9ca3af !important;
		transform: scale(1.05);
	}
	
	.qty-btn:active {
		background: #d1d5db !important;
		transform: scale(0.95);
	}
	
	/* Add to Cart button - 2025 Modern Design */
	.add-to-cart-btn {
		transition: all 0.15s cubic-bezier(0.4, 0, 0.2, 1) !important;
		padding: 8px 12px !important;
		font-size: 11px !important;
		font-weight: 700 !important;
		min-height: 36px !important;
		background: #22c55e !important;
		background-color: #0b5394 !important;
		color: #ffffff !important;
		border: none !important;
		border-radius: 6px !important;
		box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05) !important;
		position: relative !important;
		overflow: hidden !important;
	}
	
	button.add-to-cart-btn {
		background-color: #0b5394 !important;
	}
	
	.add-to-cart-btn::before {
		content: '';
		position: absolute;
		top: 0;
		left: -100%;
		width: 100%;
		height: 100%;
		background: rgba(255, 255, 255, 0.1);
		transition: left 0.3s ease;
	}
	
	.add-to-cart-btn:hover {
		background: #16a34a !important;
		background-color: #084d82 !important;
		box-shadow: 0 2px 4px rgba(11, 83, 148, 0.2),
					0 1px 2px rgba(0, 0, 0, 0.1) !important;
		transform: translateY(-1px) !important;
	}
	
	.add-to-cart-btn:hover::before {
		left: 100%;
	}
	
	.add-to-cart-btn:active {
		background: #15803d !important;
		background-color: #073d6b !important;
		transform: translateY(0) !important;
		box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1) !important;
	}
	
	.add-to-cart-btn:focus {
		outline: none !important;
		box-shadow: 0 0 0 3px rgba(34, 197, 94, 0.2) !important;
	}
	
	.add-to-cart-btn i {
		font-size: 12px !important;
		position: relative;
		z-index: 1;
	}
	
	.add-to-cart-btn span {
		position: relative;
		z-index: 1;
	}
</style>