
<div class="col-lg-12">
    <table class="table" id="producttable">
        <thead style="background: #3c8dbc;color: #fff;">
            <th>IMAGE</th>
            <th>PRODUCT</th>
            <th>UNIT PRICE</th>
            <th>QUANTITY</th>
            <th>ACTION</th>
        </thead>

        <tbody>
            @forelse($products as $product)
                <tr class="product_list">
                    <td>
                        <div style="display: flex;">
                            <img src="@if(count($product->media) > 0) {{$product->media->first()->display_url}} @elseif(!empty($product->product_image)) {{asset('/uploads/img/' . rawurlencode($product->product_image))}} @else{{asset('/img/default.png')}}@endif" alt="Product image" class="product-thumbnail-small">
                        </div>
                    </td>
                    <td>
                        <small class="text text-muted">
                            {{$product->name}} 
                            @if($product->type == 'variable')
                                - {{$product->variation}}
                            @endif
                        </small>
        
                        <small class="text-muted">
                            ({{$product->sub_sku}})
                        </small>
                        <br>
                        <small class="text-muted" style="font-size: 60%;">
                            @if($product->enable_stock)
                            {{ @num_format($product->qty_available) }} {{$product->unit}} @lang('lang_v1.in_stock')
                            @else
                                --
                            @endif
                        </small>
                    </td>
                    <td>
                        <small style="font-size: 70%;color:black">
                            @format_currency($product->selling_price)
                        </small>
                    </td>
                    <td>
                        <div class="input-group input-number">
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-default btn-flat quantity-down">
                                    <i class="fa fa-minus text-danger"></i>
                                </button>
                            </span>
                            <input type="text" data-min="0.001"  min="0.001" id="entered_quantity_{{$product->id}}" class="form-control pos_quantity input_number mousetrap input_quantity" value="1" data-rule-required="true">
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-default btn-flat quantity-up">
                                    <i class="fa fa-plus text-success"></i>
                                </button>
                            </span>
                        </div>

                    </td>
                    <td>
                        <button type="button" class="btn btn-primary btn-sm add_product_box" data-variation_id="{{$product->id}}" title="{{$product->name}} @if($product->type == 'variable')- {{$product->variation}} @endif {{ '(' . $product->sub_sku . ')'}} @if(!empty($show_prices)) @lang('lang_v1.default') - @format_currency($product->selling_price) @foreach($product->group_prices as $group_price) @if(array_key_exists($group_price->price_group_id, $allowed_group_prices)) {{$allowed_group_prices[$group_price->price_group_id]}} - @format_currency($group_price->price_inc_tax) @endif @endforeach @endif">
                            @lang('Add')
                        </button>
                    </td>
                </tr>
            @empty
                <input type="hidden" id="no_products_found">
                <tr>
                    <td class="text-center" colspan="5">@lang('lang_v1.no_products_to_display')</td>
                </tr>
            @endforelse

        </tbody>

    </table>
</div>


