<!-- Row 1: Date (Left) and Customer (Right) in single line -->
<div class="row">
	@if(!empty($pos_settings['enable_transaction_date']) && ($pos_settings['enable_transaction_date'] == 1 || $pos_settings['enable_transaction_date'] == '1'))
		<!-- Date Field - Left Side -->
		<div class="sell_mode col-md-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fa fa-calendar"></i>
					</span>
					{!! Form::text('transaction_date', $default_datetime, ['class' => 'form-control', 'readonly', 'required', 'id' => 'transaction_date']); !!}
				</div>
			</div>
		</div>
		<!-- Customer Field - Right Side -->
		<div class="col-md-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fa fa-user"></i>
					</span>
					<input type="hidden" id="default_customer_id" value="{{ $walk_in_customer['id'] ?? ''}}" >
					<input type="hidden" id="default_customer_name" value="{{ $walk_in_customer['name'] ?? ''}}" >
					<input type="hidden" id="default_customer_balance" value="{{ $walk_in_customer['balance'] ?? ''}}" >
					<input type="hidden" id="default_customer_address" value="{{ $walk_in_customer['shipping_address'] ?? ''}}" >
					@if(!empty($walk_in_customer['price_calculation_type']) && $walk_in_customer['price_calculation_type'] == 'selling_price_group')
						<input type="hidden" id="default_selling_price_group" value="{{ $walk_in_customer['selling_price_group_id'] ?? ''}}" >
					@endif
					{!! Form::select('contact_id', [], null, ['class' => 'form-control mousetrap', 'id' => 'customer_id', 'placeholder' => 'Enter Customer name / phone', 'required']); !!}
					<span class="input-group-btn">
						<button type="button" class="btn btn-default bg-white btn-flat add_new_customer" data-name=""  @if(!auth()->user()->can('customer.create')) disabled @endif><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
					</span>
				</div>
				<small class="text-danger hide contact_due_text">
					<strong>@lang('account.customer_due'):</strong> <span></span>
				</small>
			</div>
		</div>
	@else
		<!-- If transaction date is disabled, show only Customer taking full width -->
		<div class="col-md-12">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fa fa-user"></i>
					</span>
					<input type="hidden" id="default_customer_id" value="{{ $walk_in_customer['id'] ?? ''}}" >
					<input type="hidden" id="default_customer_name" value="{{ $walk_in_customer['name'] ?? ''}}" >
					<input type="hidden" id="default_customer_balance" value="{{ $walk_in_customer['balance'] ?? ''}}" >
					<input type="hidden" id="default_customer_address" value="{{ $walk_in_customer['shipping_address'] ?? ''}}" >
					@if(!empty($walk_in_customer['price_calculation_type']) && $walk_in_customer['price_calculation_type'] == 'selling_price_group')
						<input type="hidden" id="default_selling_price_group" value="{{ $walk_in_customer['selling_price_group_id'] ?? ''}}" >
					@endif
					{!! Form::select('contact_id', [], null, ['class' => 'form-control mousetrap', 'id' => 'customer_id', 'placeholder' => 'Enter Customer name / phone', 'required']); !!}
					<span class="input-group-btn">
						<button type="button" class="btn btn-default bg-white btn-flat add_new_customer" data-name=""  @if(!auth()->user()->can('customer.create')) disabled @endif><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
					</span>
				</div>
				<small class="text-danger hide contact_due_text">
					<strong>@lang('account.customer_due'):</strong> <span></span>
				</small>
			</div>
		</div>
	@endif
</div>

<!-- Row 2: Product Search Box -->
<div class="row">
	<div class="sell_mode col-md-12">
		<div class="form-group">
			<div class="input-group">
				<div class="input-group-btn">
					<button type="button" class="btn btn-default bg-white btn-flat" data-toggle="modal" data-target="#configure_search_modal" title="{{__('lang_v1.configure_product_search')}}"><i class="fas fa-search-plus"></i></button>
				</div>
                {{-- Removed mousetrap class as it was causing issue with barcode scanning --}}
				{!! Form::text('search_product', null, ['class' => 'form-control', 'id' => 'search_product', 'placeholder' => __('lang_v1.search_product_placeholder'), 'disabled' => is_null($default_location)? true : false]); !!}
				<span class="input-group-btn">
					<!-- Show button for weighing scale modal -->
					@if(isset($pos_settings['enable_weighing_scale']) && $pos_settings['enable_weighing_scale'] == 1)
						<button type="button" class="btn btn-default bg-white btn-flat" id="weighing_scale_btn" data-toggle="modal" data-target="#weighing_scale_modal" title="@lang('lang_v1.weighing_scale')">
							<i class="fa fa-digital-tachograph text-primary fa-lg"></i>
						</button>
					@endif
					<button type="button" class="btn btn-default bg-white btn-flat pos_add_quick_product" data-href="{{action([\App\Http\Controllers\ProductController::class, 'quickAdd'])}}" data-container=".quick_add_product_modal"><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
				</span>
			</div>
		</div>
	</div>
</div>

<!-- Row 3: Exchange Mode, Warehouse (if needed) -->
<div class="row">

	@if(!empty($pos_settings['enable_exchange_module']))
		<div class="col-md-4">
			<div class="form-group">
				<div class="input-group" style="display: block;">
					{!! Form::select('exchange_system', ['sell' => 'Sell Mode', 'exchange' => 'Exchange Mode'], 'sell', ['class' => 'form-control mousetrap', 'id' => 'exchange_system', 'required']); !!}
				</div>
			</div>
		</div>
	@endif

	@php
		$warehouses_list = isset($warehouses) ? $warehouses : [];
		$has_warehouses = !empty($warehouses_list) && count($warehouses_list) > 0;
	@endphp
	@if($has_warehouses)
	<div class="sell_mode col-md-4">
		<div class="form-group">
			<div class="input-group">
				<span class="input-group-addon">
					<i class="fa fa-warehouse"></i>
				</span>
				{!! Form::select('warehouse_id', $warehouses_list, isset($default_warehouse) && $default_warehouse ? $default_warehouse->id : null, ['class' => 'form-control mousetrap', 'id' => 'warehouse_id', 'required']); !!}
			</div>
		</div>
	</div>
	@endif
</div>

<!-- Serch Only by Barcode - Second Row -->
<div class="row">
	<div class="sell_mode col-md-12">
		<div class="form-group">
			<div class="input-group">
				<span class="input-group-addon">
					<i class="fa fa-barcode"></i>
				</span>
				{!! Form::text('search_product_barcode_type_check', null, ['class' => 'form-control', 'id' => 'search_product_barcode_type_check', 'placeholder' => __('Search product barcode time check'), 'disabled' => is_null($default_location)? true : false, 'autofocus' => is_null($default_location)? false : true,]); !!}
			</div>
		</div>
	</div>
	<!-- Serch Only by Barcode -->


	<div class="exchange_mode hide col-md-4">
		<div class="form-group">
			<div class="input-group">
				{!! Form::text('search_product_for_exchange_recived', null, ['class' => 'form-control', 'id' => 'search_product_for_exchange_recived', 'placeholder' => __('lang_v1.search_exchange_recived_product_placeholder'), 'disabled' => is_null($default_location)? true : false]); !!}
				<span class="input-group-btn">
					<!-- Show button for weighing scale modal -->
					@if(isset($pos_settings['enable_weighing_scale']) && $pos_settings['enable_weighing_scale'] == 1)
						<button type="button" class="btn btn-default bg-white btn-flat" id="weighing_scale_btn" data-toggle="modal" data-target="#weighing_scale_modal" title="@lang('lang_v1.weighing_scale')">
							<i class="fa fa-digital-tachograph text-primary fa-lg"></i>
						</button>
					@endif
					<button type="button" class="btn btn-default bg-white btn-flat pos_add_quick_product" data-href="{{action([\App\Http\Controllers\ProductController::class, 'quickAdd'])}}" data-container=".quick_add_product_modal">
						<i class="fa fa-plus-circle text-primary fa-lg"></i>
					</button>
				</span>
			</div>
		</div>
	</div>

	<div class="exchange_mode hide col-md-4">
		<div class="form-group">
			<div class="input-group">

				<div class="input-group-btn">
					<button type="button" class="btn btn-default bg-white btn-flat" data-toggle="modal" data-target="#configure_search_modal" title="{{__('lang_v1.configure_product_search')}}">
						<i class="fas fa-search-plus"></i>
					</button>
				</div>

                {{-- Removed mousetrap class as it was causing issue with barcode scanning --}}
				{!! Form::text('search_exchange_given_product', null, ['class' => 'form-control', 'id' => 'search_exchange_given_product', 'placeholder' => __('lang_v1.search_exchange_given_product_placeholder'), 'disabled' => is_null($default_location)? true : false]); !!}
				<span class="input-group-btn">
					<!-- Show button for weighing scale modal -->
					@if(isset($pos_settings['enable_weighing_scale']) && $pos_settings['enable_weighing_scale'] == 1)
						<button type="button" class="btn btn-default bg-white btn-flat" id="weighing_scale_btn" data-toggle="modal" data-target="#weighing_scale_modal" title="@lang('lang_v1.weighing_scale')">
							<i class="fa fa-digital-tachograph text-primary fa-lg"></i>
						</button>
					@endif
					<button type="button" class="btn btn-default bg-white btn-flat pos_add_quick_product" data-href="{{action([\App\Http\Controllers\ProductController::class, 'quickAdd'])}}" data-container=".quick_add_product_modal">
						<i class="fa fa-plus-circle text-primary fa-lg"></i>
					</button>
				</span>

			</div>
		</div>
	</div>
	<div class="exchange_mode hide col-md-4">
		<div class="form-group">
			<div class="input-group" style="width: 100%;">
				{!! Form::file('exchange_document', ['id' => 'exchange_document', 'accept' => 'image/*', 'class' => 'upload-element']); !!}
			</div>
		</div>
	</div>



</div>
<div class="row">
	@if(!empty($pos_settings['show_invoice_layout']))
	<div class="col-md-4">
		<div class="form-group">
		{!! Form::select('invoice_layout_id', 
					$invoice_layouts, !empty($default_location) ? $default_location->invoice_layout_id : null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.select_invoice_layout'), 'id' => 'invoice_layout_id']); !!}
		</div>
	</div>
	@endif
	<input type="hidden" name="pay_term_number" id="pay_term_number" value="{{$walk_in_customer['pay_term_number'] ?? ''}}">
	<input type="hidden" name="pay_term_type" id="pay_term_type" value="{{$walk_in_customer['pay_term_type'] ?? ''}}">
	
	@if(!empty($commission_agent))
		@php
			$is_commission_agent_required = !empty($pos_settings['is_commission_agent_required']);
		@endphp
		<div class="col-md-4">
			<div class="form-group">
			{!! Form::select('commission_agent', $commission_agent, null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.commission_agent'), 'id' => 'commission_agent', 'required' => $is_commission_agent_required]); !!}
			</div>
		</div>
	@endif
	@if(config('constants.enable_sell_in_diff_currency') == true)
		<div class="col-md-4 col-sm-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fas fa-exchange-alt"></i>
					</span>
					{!! Form::text('exchange_rate', config('constants.currency_exchange_rate'), ['class' => 'form-control input-sm input_number', 'placeholder' => __('lang_v1.currency_exchange_rate'), 'id' => 'exchange_rate']); !!}
				</div>
			</div>
		</div>
	@endif
	@if(!empty($price_groups) && count($price_groups) > 1)
		<div class="col-md-4 col-sm-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fas fa-money-bill-alt"></i>
					</span>
					@php
						reset($price_groups);
						$selected_price_group = !empty($default_price_group_id) && array_key_exists($default_price_group_id, $price_groups) ? $default_price_group_id : null;
					@endphp
					{!! Form::hidden('hidden_price_group', key($price_groups), ['id' => 'hidden_price_group']) !!}
					{!! Form::select('price_group', $price_groups, $selected_price_group, ['class' => 'form-control select2', 'id' => 'price_group']); !!}
					<span class="input-group-addon">
						@show_tooltip(__('lang_v1.price_group_help_text'))
					</span> 
				</div>
			</div>
		</div>
	@else
		@php
			reset($price_groups);
		@endphp
		{!! Form::hidden('price_group', key($price_groups), ['id' => 'price_group']) !!}
	@endif
	@if(!empty($default_price_group_id))
		{!! Form::hidden('default_price_group', $default_price_group_id, ['id' => 'default_price_group']) !!}
	@endif

	@if(in_array('types_of_service', $enabled_modules) && !empty($types_of_service))
		<div class="col-md-4 col-sm-6">
			<div class="form-group">
				<div class="input-group">
					<span class="input-group-addon">
						<i class="fa fa-external-link-square-alt text-primary service_modal_btn"></i>
					</span>
					{!! Form::select('types_of_service_id', $types_of_service, null, ['class' => 'form-control', 'id' => 'types_of_service_id', 'style' => 'width: 100%;', 'placeholder' => __('lang_v1.select_types_of_service')]); !!}

					{!! Form::hidden('types_of_service_price_group', null, ['id' => 'types_of_service_price_group']) !!}

					<span class="input-group-addon">
						@show_tooltip(__('lang_v1.types_of_service_help'))
					</span> 
				</div>
				<small><p class="help-block hide" id="price_group_text">@lang('lang_v1.price_group'): <span></span></p></small>
			</div>
		</div>
		<div class="modal fade types_of_service_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
	@endif

	@if(!empty($pos_settings['show_invoice_scheme']))
		@php
			$invoice_scheme_id = !empty($default_invoice_schemes) ? $default_invoice_schemes->id : null;
			if(!empty($default_location) && !empty($default_location->invoice_scheme_id)) {
				$invoice_scheme_id = $default_location->invoice_scheme_id;
			}
		@endphp
		<div class="col-md-4 col-sm-6">
			<div class="form-group">
				{!! Form::select('invoice_scheme_id', $invoice_schemes, $invoice_scheme_id, 
					['class' => 'form-control', 'placeholder' => __('lang_v1.select_invoice_scheme'), 
					'id' => 'invoice_scheme_id']); !!}
			</div>
		</div>
	@endif
	@if(in_array('subscription', $enabled_modules))
		<div class="col-md-4 col-sm-6">
			<label>
              {!! Form::checkbox('is_recurring', 1, false, ['class' => 'input-icheck', 'id' => 'is_recurring']); !!} @lang('lang_v1.subscribe')?
            </label><button type="button" data-toggle="modal" data-target="#recurringInvoiceModal" class="btn btn-link"><i class="fa fa-external-link-square-alt"></i></button>@show_tooltip(__('lang_v1.recurring_invoice_help'))
		</div>
	@endif
	
	<!-- Call restaurant module if defined -->
    @if(in_array('tables' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules))
    	<div class="clearfix"></div>
    	<span id="restaurant_module_span">
      		<div class="col-md-3"></div>
    	</span>
    @endif

	@if(in_array('kitchen' ,$enabled_modules))
		<div class="col-md-3">
			<div class="form-group">
				<div class="checkbox">
				<label>
						{!! Form::checkbox('is_kitchen_order', 1, false, ['class' => 'input-icheck status', 'id' => 'is_kitchen_order']); !!} {{ __('lang_v1.kitchen_order') }}
				</label>
				@show_tooltip(__('lang_v1.kitchen_order_tooltip'))
				</div>
			</div>
		</div>
    @endif
    
</div>
<!-- include module fields -->
@if(!empty($pos_module_data))
    @foreach($pos_module_data as $key => $value)
        @if(!empty($value['view_path']))
            @includeIf($value['view_path'], ['view_data' => $value['view_data']])
        @endif
    @endforeach
@endif
<div class="row">
	<div class="col-sm-12 pos_product_div">
		<input type="hidden" name="sell_price_tax" id="sell_price_tax" value="{{$business_details->sell_price_tax}}">

		<!-- Keeps count of product rows -->
		<input type="hidden" id="product_row_count" value="0">
		<input type="hidden" id="row_count" value="0">
		
		
		@php
			$hide_tax = '';
			if( session()->get('business.enable_inline_tax') == 0){
				$hide_tax = 'hide';
			}
		@endphp
		<table class="table table-condensed table-bordered table-striped table-responsive" id="pos_table">
			<thead>
				<tr>
					<th class="tex-center tw-text-sm md:!tw-text-base tw-font-bold">	
						@lang('sale.product') @show_tooltip(__('lang_v1.tooltip_sell_product_column'))
					</th>

					@if(!empty($common_settings['enable_serial_number']))
						<th class="text-center fs-12">Product Serial</th>
					@endif

					<th class="text-center tw-text-sm md:!tw-text-base tw-font-bold">
						@lang('lang_v1.qty')
					</th>

					<th class="text-center tw-text-sm md:!tw-text-base tw-font-bold">
						@lang('product.unit')
					</th>

					<th class="text-center tw-text-sm md:!tw-text-base tw-font-bold @if(!auth()->user()->can('edit_product_price_from_sale_screen')) hide @endif">
						@lang('sale.unit_price')
					</th>

					<th class="text-center tw-text-sm md:!tw-text-base tw-font-bold @if(!$edit_discount) hide @endif">
						@lang('lang_v1.set_discount')
					</th>

					<th class="text-center tw-text-sm md:!tw-text-base tw-font-bold @if(!$edit_discount) hide @endif">
						@lang('sale.discount_type')
					</th>

					@if(!empty($pos_settings['show_multi_unit']))
						<th class="text-center fs-12">Other Unit </th>
					@endif

					@if(!empty($pos_settings['inline_service_staff']))
						<th class="text-center tw-text-sm md:!tw-text-base tw-font-bold">
							@lang('restaurant.service_staff')
						</th>
					@endif
					<th class="text-center tw-text-sm md:!tw-text-base tw-font-bold col-md-2 {{$hide_tax}}">
						@lang('sale.price_inc_tax')
					</th>
					<th class="text-center tw-text-sm md:!tw-text-base tw-font-bold">
						@lang('sale.subtotal')
					</th>
					<th class="text-center"><i class="fas fa-times tw-text-base" aria-hidden="true"></i></th>
				</tr>
			</thead>
			<tbody></tbody>
		</table>
	</div>
</div>