<div class="modal fade" tabindex="-1" role="dialog" id="modal_payment">
	<style>
		/* Payment modal responsive sizing */
		#modal_payment .modal-dialog { width: 88vw; max-width: 1200px; margin: 10px auto; }
		@media (min-width: 1200px) {
			#modal_payment .modal-dialog { width: 70%; }
		}

		/* Layout: side panel on desktop, stacked on tablets/phones */
		@media (min-width: 992px) {
			#modal_payment .modal-body .col-md-9 { width: 75%; float: left; }
			#modal_payment .modal-body .col-md-3 { width: 25%; float: left; }
		}
		@media (max-width: 991.98px) {
			#modal_payment .modal-body .col-md-9,
			#modal_payment .modal-body .col-md-3 { width: 100%; float: none; }
			#modal_payment .btn { white-space: normal; }
		}

		/* Minimal height - ultra compact payment rows - remove all unnecessary space */
		#modal_payment #payment_rows_div { margin: 0 !important; padding: 0 !important; min-height: 0 !important; height: auto !important; }
		#modal_payment .col-md-9 { min-height: 0 !important; height: auto !important; }
		#modal_payment #payment_rows_div .col-md-12 { padding-left: 0 !important; padding-right: 0 !important; margin-bottom: 0 !important; }
		#modal_payment .modal-body { min-height: 0 !important; height: auto !important; overflow: visible !important; }
		#modal_payment .modal-content { height: auto !important; }
		#modal_payment .modal-dialog { height: auto !important; max-height: none !important; }
		#modal_payment .payment_row .box { margin: 3px 0 2px 0; }
		#modal_payment .payment_row .box-header { padding: 2px 4px; min-height: 24px; }
		#modal_payment .payment_row .box-header .btn { padding: 0 4px; font-size: 11px; line-height: 1.2; }
		#modal_payment .payment_row .box-body { padding: 2px 6px; }
		#modal_payment .payment_row .form-group { margin-bottom: 3px; }
		#modal_payment .modal-body { padding: 8px 12px; }
		#modal_payment .payment_row .input-group .form-control { height: 28px; padding-top: 2px; padding-bottom: 2px; font-size: 13px; }
		#modal_payment .payment_row .select2-container .select2-selection--single { height: 28px; }
		#modal_payment .payment_row .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 26px; font-size: 13px; }
		#modal_payment .payment_row .select2-container--default .select2-selection--single .select2-selection__arrow { height: 26px; }
		#modal_payment .payment_row .input-group-addon { padding: 4px 8px; font-size: 12px; }
		#modal_payment .box.payment_row { margin-bottom: 4px; min-height: 0 !important; height: auto !important; }
		#modal_payment .box { min-height: 0 !important; height: auto !important; }
		#modal_payment .box-body { min-height: 0 !important; height: auto !important; }
		#modal_payment .row { min-height: 0 !important; }
		#modal_payment .col-md-9 > .row:first-child { margin: 0 !important; min-height: 0 !important; height: auto !important; padding: 0 !important; }
		#modal_payment .col-md-9 > .row:first-child > #payment_rows_div { width: 100%; }
		#modal_payment .modal-header { padding: 6px 12px; min-height: 42px; }
		#modal_payment .modal-header h4.modal-title { margin: 0; line-height: 1.2; font-size: 14px; }
        #modal_payment .modal-header .btn { padding: 4px 8px; font-size: 12px; }
        #modal_payment .payment_row label { margin-bottom: 2px; font-size: 12px; }
        /* Compact Add Payment Row button */
        #modal_payment #add-payment-row { padding: 6px 12px; font-size: 13px; margin-top: 4px; margin-bottom: 4px; }
        /* Inline Sell note label and input - minimal spacing */
        #modal_payment .sell-note-inline { display: flex; align-items: center; gap: 6px; margin-top: 4px; margin-bottom: 2px; }
        #modal_payment .sell-note-inline label { margin: 0; white-space: nowrap; font-size: 12px; }
        #modal_payment .sell-note-inline input[type="text"] { flex: 1 1 auto; height: 28px; padding: 4px 8px; font-size: 13px; }

		/* Finalize Payment button custom color */
		#modal_payment #pos-save.btn { background-color: #28a745; border-color: #218838; color: #fff; }
		#modal_payment #pos-save.btn:hover, 
		#modal_payment #pos-save.btn:focus { background-color: #218838; border-color: #1e7e34; color: #fff; }

		/* Hide original right sidebar and build footer summary - completely remove from layout */
		#modal_payment .pos-summary-sidebar { display: none !important; visibility: hidden !important; height: 0 !important; padding: 0 !important; margin: 0 !important; overflow: hidden !important; }
		#modal_payment .modal-body .col-md-9 { width: 100% !important; float: none !important; margin: 0 !important; padding-right: 0 !important; }
		#modal_payment .modal-body .row { margin-left: 0 !important; margin-right: 0 !important; margin-top: 2px !important; margin-bottom: 2px !important; }
		#modal_payment .modal-body .row:first-child { margin-top: 0 !important; }
		/* Ensure hidden elements don't take up space */
		#modal_payment .hide { display: none !important; height: 0 !important; padding: 0 !important; margin: 0 !important; visibility: hidden !important; overflow: hidden !important; }
        /* 3D dark-blue footer summary bar - minimal height */
        #modal_payment .pos-summary-footer {
            margin: 4px 0 0;
            padding: 8px 12px;
            border-radius: 8px;
            background: linear-gradient(180deg, #1565c0 0%, #0d47a1 100%); /* dark blue gradient */
            color: #fff;
            border: 1px solid rgba(0,0,0,0.25);
            box-shadow: 0 6px 14px rgba(0,0,0,0.28), inset 0 1px 0 rgba(255,255,255,0.08); /* outer + subtle inner highlight */
        }
		#modal_payment .summary-grid { display: grid; grid-template-columns: repeat(5, 1fr); gap: 6px; }
		#modal_payment .summary-item { text-align: left; }
        #modal_payment .summary-item strong { display: block; font-weight: 700; color: #e3f2fd; text-shadow: 0 1px 0 rgba(0,0,0,0.4); font-size: 11px; line-height: 1.2; }
        #modal_payment .summary-item .lead { font-size: 14px; color: #ffffff !important; line-height: 1.3; }
        #modal_payment .pos-summary-footer .total_payable_span,
        #modal_payment .pos-summary-footer .total_paying,
        #modal_payment .pos-summary-footer .change_return_span,
        #modal_payment .pos-summary-footer .balance_due { color: #ffffff !important; }
        /* Shortcut captions like (F2), (F5) */
        #modal_payment .shortcut-label { color: #ffffff !important; font-size: 0.95em; font-weight: 700; letter-spacing: 0.3px; }
		@media (max-width: 991.98px) {
			#modal_payment .summary-grid { grid-template-columns: repeat(2, 1fr); }
		}
	</style>
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title">@lang('lang_v1.payment') | <strong>@lang('lang_v1.advance_balance'):</strong> <span id="advance_balance_text" style="color:green"></span>
						{!! Form::hidden('advance_balance', null, ['id' => 'advance_balance', 'data-error-msg' => __('lang_v1.required_advance_balance_not_available')]); !!} | <button type="button" class="btn btn-primary" data-dismiss="modal">@lang('messages.close')</button>
				<button type="submit" class="btn btn-danger btn-lg" id="pos-save">@lang('sale.finalize_payment')</button></h4> 
			</div>
			<div class="modal-body">
			<div class="row">
			<!--		<div class="col-md-12 mb-12">
						<strong>@lang('lang_v1.advance_balance'):</strong> <span id="advance_balance_text"></span>
						{!! Form::hidden('advance_balance', null, ['id' => 'advance_balance', 'data-error-msg' => __('lang_v1.required_advance_balance_not_available')]); !!} 
					</div>  -->
					
		<!--	    <div class="col-md-12 mb-12">
			        
			        <button type="button" class="btn btn-primary" data-dismiss="modal">@lang('messages.close')</button>
				<button type="submit" class="btn btn-danger btn-lg" id="pos-save">@lang('sale.finalize_payment')</button>
			        
			        
			    </div> -->
			
					
					<div class="col-md-9">
						<div class="row">
							<div id="payment_rows_div">
								@foreach($payment_lines as $payment_line)
									
									@if(isset($payment_line['is_return']) && $payment_line['is_return'] == 1)
										@php
											$change_return = $payment_line;
										@endphp

										@continue
									@endif

									@include('sale_pos.partials.payment_row', ['removable' => !$loop->first, 'row_index' => $loop->index, 'payment_line' => $payment_line])
								@endforeach
							</div>
							<input type="hidden" id="payment_row_index" value="{{count($payment_lines)}}">
						</div>
						<div class="row" style="margin-top: 4px; margin-bottom: 4px;">
							<div class="col-md-12">
								<button type="button" class="btn btn-primary btn-block" id="add-payment-row">@lang('sale.add_payment_row')</button>
							</div>
						</div>
						<div class="row @if($change_return['amount'] == 0) hide @endif payment_row" id="change_return_payment_data">
							<div class="col-md-12">
								<div class="box box-solid payment_row bg-lightgray">
									<div class="box-body" >
										<div class="col-md-4">
											<div class="form-group">
												{!! Form::label("change_return_method" , __('lang_v1.change_return_payment_method') . ':*') !!}
												<div class="input-group">
													<span class="input-group-addon">
														<i class="fas fa-money-bill-alt"></i>
													</span>
													@php
														$_payment_method = empty($change_return['method']) && array_key_exists('cash', $payment_types) ? 'cash' : $change_return['method'];

														$_payment_types = $payment_types;
														if(isset($_payment_types['advance'])) {
															unset($_payment_types['advance']);
														}
													@endphp
													{!! Form::select("payment[change_return][method]", $_payment_types, $_payment_method, ['class' => 'form-control col-md-12 payment_types_dropdown', 'id' => 'change_return_method', 'style' => 'width:100%;']); !!}
												</div>
											</div>
										</div>
										@if(!empty($accounts))
										<div class="col-md-4">
											<div class="form-group">
												{!! Form::label("change_return_account" , __('lang_v1.change_return_payment_account') . ':') !!}
												<div class="input-group">
													<span class="input-group-addon">
														<i class="fas fa-money-bill-alt"></i>
													</span>
													{!! Form::select("payment[change_return][account_id]", $accounts, !empty($change_return['account_id']) ? $change_return['account_id'] : '' , ['class' => 'form-control select2', 'id' => 'change_return_account', 'style' => 'width:100%;']); !!}
												</div>
											</div>
										</div>
										@endif
										<div class="clearfix"></div>
										@include('sale_pos.partials.payment_type_details', ['payment_line' => $change_return, 'row_index' => 'change_return'])
									</div>
								</div>
							</div>
						</div>
						<div class="row">
                    <div class="col-md-6">
                        <div class="form-group sell-note-inline">
							{!! Form::label('sale_note', __('sale.sell_note') . ':') !!}
							{!! Form::text('sale_note', !empty($transaction)? $transaction->additional_notes:null, ['class' => 'form-control', 'placeholder' => __('sale.sell_note')]); !!}
						</div>
					</div>
							<!-- Removed Staff note field -->
				</div>
			</div>
			<div class="col-md-3 pos-summary-sidebar">
						<div class="box box-solid bg-orange">
				            <div class="box-body">
				            	<div class="col-md-12">
				            		<strong>
				            			@lang('lang_v1.total_items'):
				            		</strong>
				            		<br/>
				            		<span class="lead text-bold total_quantity">0</span>
				            	</div>

				            	<div class="col-md-12">
				            		<hr>
				            		<strong>
				            			@lang('sale.total_payable'):
				            		</strong>
				            		<br/>
				            		<span class="lead text-bold  total_payable_span" style="color:blue">0</span>
				            	</div>

				            	<div class="col-md-12">
				            		<hr>
				            		<strong>
				            			@lang('lang_v1.total_paying'):
				            		</strong>
				            		<br/>
				            		<span class="lead text-bold total_paying" style="color:green">0</span>
				            		<input type="hidden" id="total_paying_input">
				            	</div>

				            	<div class="col-md-12">
				            		<hr>
				            		<strong>
				            			@lang('lang_v1.change_return'):
				            		</strong>
				            		<br/>
				            		<span class="lead text-bold change_return_span">0</span>
				            		{!! Form::hidden("change_return", $change_return['amount'], ['class' => 'form-control change_return input_number', 'required', 'id' => "change_return"]); !!}
				            		<!-- <span class="lead text-bold total_quantity">0</span> -->
				            		@if(!empty($change_return['id']))
				                		<input type="hidden" name="change_return_id" 
				                		value="{{$change_return['id']}}">
				                	@endif
				            	</div>

				            	<div class="col-md-12">
				            		<hr>
				            		<strong>
				            			@lang('lang_v1.balance'):
				            		</strong>
				            		<br/>
				            		<span class="lead text-bold balance_due">0</span>
				            		<input type="hidden" id="in_balance_due" value=0>
				            	</div>


				            					              
				            </div>
				            <!-- /.box-body -->
					  </div>
				</div>
			</div>
			<!-- Footer summary bar (replaces sidebar) -->
			<div class="col-md-12 pos-summary-footer">
				<div class="summary-grid">
					<div class="summary-item">
						<strong>@lang('lang_v1.total_items'):</strong>
						<span class="lead text-bold total_quantity">0</span>
					</div>
					<div class="summary-item">
						<strong>@lang('sale.total_payable'):</strong>
						<span class="lead text-bold total_payable_span" style="color:blue">0</span>
					</div>
					<div class="summary-item">
						<strong>@lang('lang_v1.total_paying'):</strong>
						<span class="lead text-bold total_paying" style="color:green">0</span>
						<input type="hidden" id="total_paying_input">
					</div>
					<div class="summary-item">
						<strong>@lang('lang_v1.change_return'):</strong>
						<span class="lead text-bold change_return_span">0</span>
						{!! Form::hidden("change_return", $change_return['amount'], ['class' => 'form-control change_return input_number', 'required', 'id' => "change_return_footer"]) !!}
					</div>
					<div class="summary-item">
						<strong>@lang('lang_v1.balance'):</strong>
						<span class="lead text-bold balance_due">0</span>
						<input type="hidden" id="in_balance_due_footer" value=0>
					</div>
				</div>
			</div>
		</div>
	<!--		<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
				<button type="submit" class="btn btn-primary" id="pos-save">@lang('sale.finalize_payment')</button>
			</div> -->
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- Used for express checkout card transaction -->
<script>
// Keyboard shortcuts for Payment modal
$(function () {
	var $modal = $('#modal_payment');

	function focusFirstAmount() {
		var $first = $modal.find('.payment_row input[id^="amount_"]').first();
		if ($first.length) { $first.focus().select(); }
	}

	function parseMoney(text) {
		if (text == null) return NaN;
		var cleaned = String(text).replace(/[^0-9,\.\-]/g, '');
		// handle commas as thousand separators
		cleaned = cleaned.replace(/,(?=\d{3}(\D|$))/g, '');
		return parseFloat(cleaned);
	}

	function getRemainingAmount() {
		// Try reliable computed remaining = payable - sum(amount inputs)
		var payable = parseMoney($modal.find('.total_payable_span').text());
		var sum = 0;
		$modal.find('input[id^="amount_"]').each(function(){
			var v = parseMoney($(this).val());
			if (!isNaN(v)) sum += v;
		});
		if (!isNaN(payable)) {
			var rem = payable - sum;
			if (isFinite(rem)) return rem;
		}
		// Fallback to balance due UI if available
		var v = parseMoney($('#in_balance_due').val());
		if (!isNaN(v)) return v;
		var txt = parseMoney($modal.find('.balance_due').text());
		return isNaN(txt) ? 0 : txt;
	}

	$modal.on('shown.bs.modal', function () {
		// Focus first amount when modal opens
		setTimeout(focusFirstAmount, 50);

		$(document).on('keydown.paymentModal', function (e) {
			var key = e.key;
			var ctrl = e.ctrlKey || e.metaKey;
			// Close: Esc
			if (key === 'Escape') {
				e.preventDefault();
				$modal.modal('hide');
				return;
			}
			// Finalize: F3 or F10 only (Enter is disabled for finalize)
			if (key === 'F3' || key === 'F10') {
				e.preventDefault();
				$('#pos-save').trigger('click');
				return;
			}
			// Add payment row: F7
			if (key === 'F7') {
				e.preventDefault();
				$('#add-payment-row').trigger('click');
				return;
			}
			// Focus Sell note: Alt+S
			if (e.altKey && (key === 's' || key === 'S')) {
				e.preventDefault();
				$modal.find('textarea[name="sale_note"]').focus();
				return;
			}
			// Navigate between amount inputs: Ctrl+ArrowUp/ArrowDown
			if (ctrl && (key === 'ArrowUp' || key === 'ArrowDown')) {
				e.preventDefault();
				var $amounts = $modal.find('input[id^="amount_"]');
				if (!$amounts.length) { return; }
				var idx = $amounts.index($(document.activeElement));
				if (idx === -1) { idx = 0; }
				if (key === 'ArrowDown') { idx = Math.min(idx + 1, $amounts.length - 1); }
				if (key === 'ArrowUp') { idx = Math.max(idx - 1, 0); }
				$amounts.eq(idx).focus().select();
				return;
			}
		});

		// Excel-like navigation within Amount inputs
		$modal.on('keydown.paymentExcel', 'input[id^="amount_"]', function (e) {
			var $amounts = $modal.find('input[id^="amount_"]');
			var idx = $amounts.index(this);
			var ctrl = e.ctrlKey || e.metaKey;
			var key = e.key;

			function focusIdx(newIdx) {
				if (newIdx < 0) newIdx = 0;
				if (newIdx > $amounts.length - 1) newIdx = $amounts.length - 1;
				$amounts.eq(newIdx).focus().select();
			}

			// Move up/down with arrows
			if (key === 'ArrowDown') {
				e.preventDefault();
				focusIdx(idx + 1);
				return;
			}
			if (key === 'ArrowUp') {
				e.preventDefault();
				focusIdx(idx - 1);
				return;
			}

			// Enter: always add a new row and focus its Amount
			if (key === 'Enter') {
				e.preventDefault();
				var remainingBeforeAdd = getRemainingAmount();
				$('#add-payment-row').trigger('click');
				setTimeout(function () {
					var $last = $modal.find('input[id^="amount_"]').last();
					var remaining = remainingBeforeAdd; // compute before totals refresh for accuracy
					if ($last.length) {
						$last.val(remaining > 0 ? remaining : 0).trigger('change').focus().select();
					}
				}, 30);
				return;
			}

			// Ctrl+D to duplicate previous row's values into current row
			if (ctrl && (key === 'd' || key === 'D')) {
				e.preventDefault();
				if (idx > 0) {
					var $curRow = $(this).closest('.payment_row');
					var $prevRow = $amounts.eq(idx - 1).closest('.payment_row');
					// copy amount
					$(this).val($amounts.eq(idx - 1).val()).trigger('change');
					// copy payment method
					var $curMethod = $curRow.find('select.payment_types_dropdown').first();
					var $prevMethod = $prevRow.find('select.payment_types_dropdown').first();
					if ($curMethod.length && $prevMethod.length) {
						$curMethod.val($prevMethod.val()).trigger('change');
					}
					// copy account
					var $curAccount = $curRow.find('select.account-dropdown').first();
					var $prevAccount = $prevRow.find('select.account-dropdown').first();
					if ($curAccount.length && $prevAccount.length) {
						$curAccount.val($prevAccount.val()).trigger('change');
					}
				}
				return;
			}

			// Ctrl+Plus or Ctrl+Insert to add new row
			if (ctrl && (key === 'Insert' || key === '+' || key === '=')) {
				e.preventDefault();
				var remainingBeforeAdd2 = getRemainingAmount();
				$('#add-payment-row').trigger('click');
				setTimeout(function () {
					var $last = $modal.find('input[id^="amount_"]').last();
					var remaining = remainingBeforeAdd2;
					if ($last.length) {
						$last.val(remaining > 0 ? remaining : 0).trigger('change').focus().select();
					}
				}, 30);
				return;
			}

			// Insert: set current row Payment Method to 'mobile'
			if (!ctrl && key === 'Insert') {
				e.preventDefault();
				var $row = $(this).closest('.payment_row');
				var $method = $row.find('select.payment_types_dropdown').first();
				if ($method.length) {
					var setMobile = function() { $method.val('mobile').trigger('change'); };
					// try by value first
					if ($method.find("option[value='mobile']").length) {
						setMobile();
					} else {
						// fallback: find by visible text containing 'Mobile'
						var opt = $method.find('option').filter(function(){
							return ($(this).text() || '').toLowerCase().indexOf('mobile') !== -1;
						}).first();
						if (opt.length) {
							$method.val(opt.val()).trigger('change');
						}
					}
				}
				return;
			}
		});
	});

	$modal.on('hidden.bs.modal', function () {
		$(document).off('keydown.paymentModal');
		$modal.off('keydown.paymentExcel');
	});

	// Prevent Enter from submitting the form anywhere in this modal
	$modal.on('keydown', 'input, select', function(e){
		if (e.key === 'Enter') {
			// Amount fields have their own handler; let that run
			if ($(this).is('input[id^="amount_"]')) { return; }
			e.preventDefault();
		}
	});
});
</script>
<div class="modal fade" tabindex="-1" role="dialog" id="card_details_modal">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title">@lang('lang_v1.card_transaction_details')</h4>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-md-12">

		<div class="col-md-4">
			<div class="form-group">
				{!! Form::label("card_number", __('lang_v1.card_no')) !!}
				{!! Form::text("", null, ['class' => 'form-control', 'placeholder' => __('lang_v1.card_no'), 'id' => "card_number", 'autofocus']); !!}
			</div>
		</div>
		<div class="col-md-4">
			<div class="form-group">
				{!! Form::label("card_holder_name", __('lang_v1.card_holder_name')) !!}
				{!! Form::text("", null, ['class' => 'form-control', 'placeholder' => __('lang_v1.card_holder_name'), 'id' => "card_holder_name"]); !!}
			</div>
		</div>
		<div class="col-md-4">
			<div class="form-group">
				{!! Form::label("card_transaction_number",__('lang_v1.card_transaction_no')) !!}
				{!! Form::text("", null, ['class' => 'form-control', 'placeholder' => __('lang_v1.card_transaction_no'), 'id' => "card_transaction_number"]); !!}
			</div>
		</div>
		<div class="clearfix"></div>
		<div class="col-md-3">
			<div class="form-group">
				{!! Form::label("card_type", __('lang_v1.card_type')) !!}
				{!! Form::select("", ['visa' => 'Visa', 'master' => 'MasterCard'], 'visa',['class' => 'form-control select2', 'id' => "card_type" ]); !!}
			</div>
		</div>
		<div class="col-md-3">
			<div class="form-group">
				{!! Form::label("card_month", __('lang_v1.month')) !!}
				{!! Form::text("", null, ['class' => 'form-control', 'placeholder' => __('lang_v1.month'),
				'id' => "card_month" ]); !!}
			</div>
		</div>
		<div class="col-md-3">
			<div class="form-group">
				{!! Form::label("card_year", __('lang_v1.year')) !!}
				{!! Form::text("", null, ['class' => 'form-control', 'placeholder' => __('lang_v1.year'), 'id' => "card_year" ]); !!}
			</div>
		</div>
		<div class="col-md-3">
			<div class="form-group">
				{!! Form::label("card_security",__('lang_v1.security_code')) !!}
				{!! Form::text("", null, ['class' => 'form-control', 'placeholder' => __('lang_v1.security_code'), 'id' => "card_security"]); !!}
			</div>
		</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-primary" id="pos-save-card">@lang('sale.finalize_payment')</button>
			</div>

		</div>
	</div>
</div>