@extends('layouts.app')

@section('title', __('sale.pos_sale'))

@section('content')


<style>
    #tags {
      margin-bottom: 10px;
    }
  
    #tags .tag {
      display: inline-block;
      margin-right: 10px;
      padding: 5px 9px;
      font-size: 14px;
      background: #ddd;
      border-radius: 4px;
    }
    #tags .tag span {
      margin-right: 20px;
      display: inline;
    }
  
    #tags .tag .remove-button {
      display: inline;
      cursor: pointer;
    }
  </style>

<section class="content no-print">
	<input type="hidden" id="amount_rounding_method" value="{{$pos_settings['amount_rounding_method'] ?? ''}}">
	@if(!empty($pos_settings['allow_overselling']))
		<input type="hidden" id="is_overselling_allowed">
	@endif
	@if(session('business.enable_rp') == 1)
        <input type="hidden" id="reward_point_enabled">
    @endif
    @php
		$is_discount_enabled = $pos_settings['disable_discount'] != 1 ? true : false;
		$is_rp_enabled = session('business.enable_rp') == 1 ? true : false;
	@endphp
	{!! Form::open(['url' => action([\App\Http\Controllers\SellPosController::class, 'update'], [$transaction->id]), 'method' => 'post', 'id' => 'edit_pos_sell_form' ]) !!}
	{{ method_field('PUT') }}
	<div class="row mb-12" style="position: absolute;width:100%">
		<div class="col-md-12 tw-pt-0 tw-mb-14">
			<div class="row tw-flex lg:tw-flex-row md:tw-flex-col sm:tw-flex-col tw-flex-col tw-items-start md:tw-gap-4">
				<div class="tw-px-3 tw-w-full  lg:tw-px-0 lg:tw-pr-0 @if(empty($pos_settings['hide_product_suggestion'])) lg:tw-w-[60%]  @else lg:tw-w-[100%] @endif">
					<div class=" tw-rounded-2xl tw-bg-white tw-mb-2 md:tw-mb-8 tw-p-2">
							<div class="box-body pb-0">
								{!! Form::hidden('location_id', $transaction->location_id, ['id' => 'location_id', 'data-receipt_printer_type' => !empty($location_printer_type) ? $location_printer_type : 'browser', 'data-default_payment_accounts' => $transaction->location->default_payment_accounts]); !!}
								<!-- sub_type -->
								{!! Form::hidden('sub_type', isset($sub_type) ? $sub_type : null) !!}
								<input type="hidden" id="item_addition_method" value="{{$business_details->item_addition_method}}">
								@include('sale_pos.partials.pos_form_edit')

								@include('sale_pos.partials.payment_modal')

								@if(empty($pos_settings['disable_suspend']))
									@include('sale_pos.partials.suspend_note_modal')
								@endif

								@if(empty($pos_settings['disable_recurring_invoice']))
									@include('sale_pos.partials.recurring_invoice_modal')
								@endif

							</div>

							@if(!empty($only_payment))
								<div class="overlay"></div>
							@endif
							
						</div>
					</div>
				@if(empty($pos_settings['hide_product_suggestion'])  && !isMobile() && empty($only_payment))
					<div class="col-md-5 no-padding">
						@include('sale_pos.partials.pos_sidebar')
					</div>
				@endif
			</div>
		</div>
	</div>
	@include('sale_pos.partials.pos_form_actions', ['edit' => true])
	{!! Form::close() !!}
</section>

<!-- This will be printed -->
<section class="invoice print_section" id="receipt_section">
</section>
<div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
	@include('contact.create', ['quick_add' => true])
</div>
@if(empty($pos_settings['hide_product_suggestion']) && isMobile())
	@include('sale_pos.partials.mobile_product_suggestions')
@endif
<!-- /.content -->
<div class="modal fade register_details_modal" tabindex="-1" role="dialog" 
	aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade close_register_modal" tabindex="-1" role="dialog" 
	aria-labelledby="gridSystemModalLabel">
</div>
<!-- quick product modal -->
<div class="modal fade quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>

@include('sale_pos.partials.configure_search_modal')

@include('sale_pos.partials.recent_transactions_modal')

@include('sale_pos.partials.weighing_scale_modal')







<div class="modal fade serial_modal" id="purchases_serial_numberModel" tabindex="-1" role="dialog"
	aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" style="width: 50%;" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Edit Serial Number</h5>
			</div>
			<div class="modal-body">
				<div class="tags_list">
					<div id="tags">
						<!-- tag list -->
					</div>
				</div>

				<input value="" id="purchases_serial_number" class="purchases_serial_numberclass form-control input-sm"
					type="text" class="form-control">
			</div>
			<div class="modal-footer">
				<button type="button" id="modelReload" class="btn btn-primary" data-dismiss="modal">Save</button>
			</div>
		</div>
	</div>
</div>







@stop

@section('javascript')
	<script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/printer.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>
	@include('sale_pos.partials.keyboard_shortcuts')


	<script>



		$(document).ready( function(){

			checkMode();

			function checkMode() {
				var current_mode = $('#exchange_system').val();
				if (current_mode === 'sell') {
                    $('.sell_mode').removeClass('hide');
                    $('.exchange_mode').addClass('hide');
                } else if (current_mode === 'exchange') {
                    $('.sell_mode').addClass('hide');
                    $('.exchange_mode').removeClass('hide');
                }
			}

            // Exchange Module Code
            $(document).on('change', '#exchange_system', function() {
                var current_mode = $(this).val();
                if (current_mode === 'sell') {
                    $('.sell_mode').removeClass('hide');
                    $('.exchange_mode').addClass('hide');
                } else if (current_mode === 'exchange') {
                    $('.sell_mode').addClass('hide');
                    $('.exchange_mode').removeClass('hide');
                }
            });
            // Exchange Module Code

			// 
			const selectElement = document.getElementById("purchases_serial_number");
			const tagsContainer = document.getElementById("tags");
			let tags = [];
			// ---------------------------------------------------------------------------------
			$(document).on('click', '.purchases_serial_numberModelButton', function (params) {

				// Set ID For Input Id
				var inputfindid = this.value;
				const key = 'inputfindid';
				localStorage.setItem(key, inputfindid);


				// Set ID For Value Set
				var valueSetId = this.getAttribute('data-value');
				const key1 = 'valueSetId';
				localStorage.setItem(key1, valueSetId);
				
				
				
				// Get Previous value
				var previousValue = document.getElementById(valueSetId).value;
				
				console.log(previousValue);

			
				var previousValueArry = previousValue.split(",");
				
				var previousValueArryLength = previousValueArry.length;

				if (previousValue === "") {
				// tags = [];
				}else{
				for (var i = 0; i < previousValueArry.length; i++) {
					$("#tags").append(
					"<div class='tag'><span>" + previousValueArry[i] + "</span><div class='remove-button'>x</div></div>"
					);
					tags.push(previousValueArry[i]);
				}
				}

			})
			let lastSelectedValue;
			selectElement.addEventListener("keyup", (event) => {

				if (event.key === "Enter" || event.key === ",") {
				const value = selectElement.value.trim();
				if (value) {

					if (tags.includes(value) || value == "") {
					
					} else {
					addTag(value);
					countUpFunction(value);
					}
					selectElement.value = "";
				}
				}
			});
			function renderTags() {
				tagsContainer.innerHTML = "";
				tags.forEach((value) => {
				const tagElement = document.createElement("div");
				tagElement.classList.add("tag");
				tagElement.innerHTML = `<span>${value}</span><div class="remove-button">x</div>`;
				tagElement
					.querySelector(".remove-button")
					.addEventListener("click", function () {
					// removeTag(value);
					// renderTags();
					});
				tagsContainer.appendChild(tagElement);
				});
			}
			function addTag(value) {
				tags.push(value);

				var getValueSetId = localStorage.getItem('valueSetId');

				document.getElementById(getValueSetId).value = tags;

				renderTags();
			}
			function removeTag(value) {
				const index = tags.indexOf(value);
				if (index >= 0) {
				tags.splice(index, 1);
				}

				var getValueSetId = localStorage.getItem('valueSetId');

				document.getElementById(getValueSetId).value = tags;

				renderTags();
			}
			$(document).on("click", '.remove-button',
				function () {
				if (event.target.className === "remove-button") {
					var tag = event.target.closest(".tag");
					var spanTag = tag.querySelector("span");
					var value = spanTag.innerHTML;
					removeTag(value);
					countDownFunction(value);
				}

			});
			// 
			function countUpFunction(lastSelectedValue) {

				count = 1;

				var getInputFindId = localStorage.getItem('inputfindid');
				var input = $("#" + getInputFindId + "")
				.find('input');
				var qty = __read_number(input);

				if (qty >= 0) {
				__write_number(input, qty + count);
				input.change();
				}


			}
			// Count Up
			// Count Down
			function countDownFunction(unselectedValue) {
				count = 1;
				var getInputFindId = localStorage.getItem('inputfindid');

				var input = $("#" + getInputFindId + "")
				.find('input');
				var qty = __read_number(input);

				if (qty > 0) {
				__write_number(input, qty - count);
				input.change();
				}


			}
			// modelReload
			$(document).on('click', '#modelReload', function () {
				tags = []
				$(".tag").remove();
			});
			$(document).on('hidden.bs.modal', '.serial_modal', function (e) {
						tags = []
						$(".tag").remove();
					});

			// ---------------------------------------------------------------------------
			$('#product_serial_numberP').select2();



		});









		$(document).on('change', '.product_serial_number', function () {
			// Set ID
			var valueSetId = this.getAttribute('data-value');
			var valueSetthisId = this.getAttribute('data-thisId');
		
			var count = $("#"+valueSetthisId+" :selected").length;
			var input = $("#"+valueSetId+"").find('input');
			var qty = __read_number(input);

			__write_number(input, count);
			input.change();

		});

	</script>






	<!-- Call restaurant module if defined -->
    @if(in_array('tables' ,$enabled_modules) || in_array('modifiers' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules))
    	<script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
    @endif

    <!-- include module js -->
    @if(!empty($pos_module_data))
	    @foreach($pos_module_data as $key => $value)
            @if(!empty($value['module_js_path']))
                @includeIf($value['module_js_path'], ['view_data' => $value['view_data']])
            @endif
	    @endforeach
	@endif
	
@endsection

@section('css')
	<style type="text/css">
		/*CSS to print receipts*/
		.print_section{
		    display: none;
		}
		@media print{
		    .print_section{
		        display: block !important;
		    }
		}
		@page {
		    size: 3.1in auto;/* width height */
		    height: auto !important;
		    margin-top: 0mm;
		    margin-bottom: 0mm;
		}
		.overlay {
			background: rgba(255,255,255,0) !important;
			cursor: not-allowed;
		}
	</style>
	<!-- include module css -->
    @if(!empty($pos_module_data))
        @foreach($pos_module_data as $key => $value)
            @if(!empty($value['module_css_path']))
                @includeIf($value['module_css_path'])
            @endif
        @endforeach
    @endif
@endsection