@extends('layouts.app')

@section('title', __('sale.pos_sale'))

@section('content')


    <style>
        .tags {
            margin-bottom: 10px;
        }

        .tags .tag {
            display: inline-block;
            margin-right: 10px;
            padding: 5px 9px;
            font-size: 14px;
            background: #ddd;
            border-radius: 4px;
        }

        .tags .tag span {
            margin-right: 20px;
            display: inline;
        }

        .tags .tag .remove-button {
            display: inline;
            cursor: pointer;
        }

        /* Microsoft Excel Style Table Styling */
        /* POS left panel modern 3D style - Responsive */
        #pos_left_panel {
            border: 1px solid rgba(208, 215, 226, 0.6);
            border-radius: 16px;
            background: #ffffff;
            box-shadow: 0 12px 32px rgba(0, 0, 0, 0.12), 0 4px 12px rgba(0, 0, 0, 0.08), inset 0 1px 0 rgba(255, 255, 255, 0.9);
            position: relative;
            overflow: hidden;
            min-height: 75vh;
            height: auto;
        }
        #pos_left_panel .box-body {
            min-height: calc(75vh - 120px);
        }
        /* Responsive adjustments for POS panel */
        @media (max-width: 991.98px) {
            #pos_left_panel {
                min-height: auto;
                border-radius: 12px;
                margin-bottom: 12px !important;
            }
            #pos_left_panel .box-body {
                min-height: auto;
                overflow-x: auto;
            }
        }
        @media (max-width: 768px) {
            #pos_left_panel {
                min-height: auto;
                border-radius: 8px;
                margin-bottom: 8px !important;
            }
        }
        #pos_left_panel:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.8), transparent);
            pointer-events: none;
            z-index: 1;
        }
        #pos_table {
            border-collapse: collapse;
            width: 100%;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 13px;
            border: 1px solid #d4d4d4;
            background-color: #ffffff;
        }

        #pos_table thead {
            background-color: #0b5394;
            color: #ffffff;
        }

        #pos_table thead th {
            border: 1px solid #084d82;
            padding: 5px 8px;
            text-align: center;
            font-weight: 600;
            font-size: 12px !important;
            background-color: #0b5394;
            color: #ffffff;
            white-space: nowrap;
            vertical-align: middle;
            line-height: 1.3;
        }

        #pos_table tbody tr {
            border-bottom: 1px solid #d4d4d4;
        }

        #pos_table tbody tr:hover {
            background-color: #F2F2F2;
        }

        #pos_table tbody tr:nth-child(even) {
            background-color: #F9F9F9;
        }

        #pos_table tbody tr:nth-child(even):hover {
            background-color: #EBEBEB;
        }

        #pos_table tbody td {
            border: 1px solid #d4d4d4;
            padding: 3px 5px;
            vertical-align: middle;
            background-color: inherit;
        }

        #pos_table tbody tr {
            height: auto;
        }

        #pos_table tbody td .form-group {
            margin-bottom: 0;
        }

        #pos_table tbody td input[type="text"],
        #pos_table tbody td input[type="number"],
        #pos_table tbody td select,
        #pos_table tbody td .form-control {
            border: 1px solid #a0a0a0;
            border-radius: 0;
            padding: 2px 4px;
            font-size: 12px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #ffffff;
            width: 100%;
            box-sizing: border-box;
            height: 28px;
            line-height: 1.4;
        }

        #pos_table tbody td input.input-sm,
        #pos_table tbody td select.input-sm {
            height: 26px;
            padding: 2px 4px;
        }

        #pos_table tbody td input[type="text"]:focus,
        #pos_table tbody td input[type="number"]:focus,
        #pos_table tbody td select:focus {
            border: 2px solid #4472C4;
            outline: none;
            background-color: #E7F3FF;
        }

        #pos_table tbody td .input-group-btn button {
            border: 1px solid #a0a0a0;
            border-radius: 0;
            padding: 4px 8px;
            font-size: 12px;
        }

        #pos_table tbody td .pos_remove_row {
            color: #E74C3C;
            font-size: 16px;
            cursor: pointer;
        }

        #pos_table tbody td .pos_remove_row:hover {
            color: #C0392B;
        }

        /* Minimal height for product information */
        #pos_table tbody td small,
        #pos_table tbody td .text-muted {
            font-size: 10px;
            line-height: 1.2;
            margin: 0;
            padding: 0;
            display: block;
        }

        #pos_table tbody td strong {
            font-size: 12px;
            line-height: 1.3;
            display: inline;
            margin-bottom: 0;
        }

        #pos_table tbody td br {
            display: none;
        }

        #pos_table tbody td .help-block {
            margin: 2px 0 0 0;
            padding: 0;
            font-size: 10px;
            line-height: 1.2;
        }

        /* Ensure all product rows maintain Excel-style regardless of how they're added */
        #pos_table tbody tr.product_row {
            background-color: #ffffff !important;
            border: none !important;
        }

        #pos_table tbody tr.product_row:nth-child(even) {
            background-color: #F9F9F9 !important;
        }

        #pos_table tbody tr.product_row td {
            border: 1px solid #d4d4d4 !important;
            padding: 3px 5px !important;
            vertical-align: middle !important;
        }

        /* Product information cell styling - light grey background like first image */
        #pos_table tbody tr.product_row td:first-child {
            background-color: #F5F5F5 !important;
            padding: 4px 6px !important;
        }

        #pos_table tbody tr.product_row:nth-child(even) td:first-child {
            background-color: #EEEEEE !important;
        }

        /* Ensure consistent input styling in all rows */
        #pos_table tbody tr.product_row .form-control,
        #pos_table tbody tr.product_row input[type="text"],
        #pos_table tbody tr.product_row input[type="number"],
        #pos_table tbody tr.product_row select {
            border: 1px solid #a0a0a0 !important;
            border-radius: 0 !important;
            padding: 2px 4px !important;
            font-size: 12px !important;
            height: 28px !important;
            background-color: #ffffff !important;
        }

        #pos_table tbody tr.product_row .form-control.input-sm,
        #pos_table tbody tr.product_row select.input-sm {
            height: 26px !important;
        }

        /* Remove any extra spacing or margins */
        #pos_table tbody tr.product_row td > * {
            margin: 0;
        }

        #pos_table tbody tr.product_row td .input-group {
            margin: 0;
        }

        /* Serial number button styling */
        #pos_table tbody tr.product_row .btn-modal,
        #pos_table tbody tr.product_row .btn-info {
            padding: 3px 8px;
            font-size: 11px;
            border-radius: 0;
            border: 1px solid #0b5394;
            background-color: #0b5394;
            color: #ffffff;
        }

        /* Override any Bootstrap or other styles that might interfere */
        #pos_table tbody tr.product_row td * {
            box-sizing: border-box;
        }

        /* Ensure consistent row height */
        #pos_table tbody tr.product_row {
            min-height: 35px;
            max-height: none;
        }

        /* Highlight last added product with light lemon color and animation */
        @keyframes highlightNewRow {
            0% {
                background-color: #fde68a;
                transform: translateX(-5px);
                opacity: 0.7;
            }
            50% {
                background-color: #fef9e7;
                transform: translateX(0);
                opacity: 1;
            }
            100% {
                background-color: #fef9e7;
                transform: translateX(0);
                opacity: 1;
            }
        }
        @keyframes pulseBorder {
            0%, 100% {
                border-left-color: #fbbf24;
                box-shadow: 0 0 0 0 rgba(251, 191, 36, 0.7);
            }
            50% {
                border-left-color: #f59e0b;
                box-shadow: 0 0 8px 2px rgba(251, 191, 36, 0.5);
            }
        }
        #pos_table tbody tr.product_row:last-child {
            background-color: #fef9e7 !important;
            border-left: 3px solid #fbbf24;
            animation: highlightNewRow 0.8s ease-out, pulseBorder 2s ease-in-out infinite;
        }
        #pos_table tbody tr.product_row:last-child td {
            background-color: #fef9e7 !important;
        }
        #pos_table tbody tr.product_row:last-child td:first-child {
            background-color: #fef3c7 !important;
        }
        #pos_table tbody tr.product_row:last-child:hover {
            background-color: #fef3c7 !important;
            animation: none;
        }
        #pos_table tbody tr.product_row:last-child:hover td {
            background-color: #fef3c7 !important;
        }
        
        /* Disable animation for products with Select Serial button */
        /* CSS :has() selector (modern browsers) - targets rows containing .btn-modal class */
        #pos_table tbody tr.product_row:last-child:has(.btn-modal) {
            background-color: #ffffff !important;
            border-left: 1px solid #d4d4d4 !important;
            animation: none !important;
        }
        #pos_table tbody tr.product_row:last-child:has(.btn-modal) td {
            background-color: #ffffff !important;
        }
        #pos_table tbody tr.product_row:last-child:has(.btn-modal) td:first-child {
            background-color: #F5F5F5 !important;
        }
        #pos_table tbody tr.product_row:last-child:has(.btn-modal):hover {
            background-color: #F2F2F2 !important;
        }
        #pos_table tbody tr.product_row:last-child:has(.btn-modal):hover td {
            background-color: #F2F2F2 !important;
        }
        
        /* JavaScript fallback class for older browsers */
        #pos_table tbody tr.product_row.no-animation-product:last-child {
            background-color: #ffffff !important;
            border-left: 1px solid #d4d4d4 !important;
            animation: none !important;
        }
        #pos_table tbody tr.product_row.no-animation-product:last-child td {
            background-color: #ffffff !important;
        }
        #pos_table tbody tr.product_row.no-animation-product:last-child td:first-child {
            background-color: #F5F5F5 !important;
        }
        #pos_table tbody tr.product_row.no-animation-product:last-child:hover {
            background-color: #F2F2F2 !important;
        }
        #pos_table tbody tr.product_row.no-animation-product:last-child:hover td {
            background-color: #F2F2F2 !important;
        }

        /* Product name styling - maintain clean look like first image */
        #pos_table tbody tr.product_row td:first-child strong {
            color: #000000;
            font-weight: 600;
            font-size: 12px;
            margin-right: 5px;
        }

        /* Barcode styling */
        #pos_table tbody tr.product_row td:first-child span span {
            color: #666666 !important;
            font-weight: normal;
            font-size: 11px;
        }

        /* Stock information styling */
        #pos_table tbody tr.product_row td:first-child small {
            color: #888888;
            margin-top: 3px;
        }

        /* Remove any background colors or borders from first cell that don't match */
        #pos_table tbody tr.product_row td:first-child {
            border-right: 1px solid #d4d4d4 !important;
        }

        /* Premium Product Catalog Grid - Responsive Base Styles */
        .product_list {
            box-sizing: border-box !important;
            display: inline-block !important;
            vertical-align: top !important;
            float: left !important;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        @media (max-width: 768px) {
            .product_list {
                border-radius: 16px !important;
                overflow: hidden;
                box-shadow: 0 4px 12px rgba(0,0,0,0.08) !important;
                margin-bottom: 12px;
                background: #ffffff;
            }
            
            .product_list:active {
                transform: scale(0.97);
            }
            
            .product_box {
                border-radius: 16px !important;
                overflow: hidden;
                transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            }
        }
        
        /* Override inline styles for product_list width - More specific selector */
        .product_list[style*="width: 25%"],
        .product_list[style*="width:25%"],
        .product_list[style*="width: 33.333%"],
        .product_list[style*="width:33.333%"],
        .product_list[style*="width: 50%"],
        .product_list[style*="width:50%"] {
            width: auto !important; /* Let media queries control width */
        }
        
        /* Clear float container */
        #product_list_div:after,
        .product_list_container:after,
        .row:has(.product_list):after {
            content: "";
            display: table;
            clear: both;
        }
        
        /* Desktop - Default 4 per row (25% each) */
        @media (min-width: 1200px) {
            .product_list {
                width: 25% !important;
                max-width: 25% !important;
                flex: 0 0 25% !important;
            }
        }

        /* Comprehensive Responsive Design for All Devices */
        @media (max-width: 1199.98px) {
            /* Tablet Landscape */
            #pos_table {
                font-size: 12px;
            }
            #pos_table thead th {
                font-size: 12px !important;
                padding: 4px 6px;
            }
            #pos_table tbody td {
                padding: 2px 4px;
            }
            
            /* Product grid - 3 per row on tablet landscape */
            .product_list {
                width: 33.333% !important;
                max-width: 33.333% !important;
            }
            
            /* Product sidebar responsive */
            .pos_sidebar {
                padding: 10px !important;
            }
            
            #product_list_div {
                padding: 10px !important;
            }
        }

        @media (max-width: 991.98px) {
            /* Tablet Portrait */
            .tw-w-\[60\%\] {
                width: 100% !important;
            }
            .tw-w-\[40\%\] {
                width: 100% !important;
            }
            
            /* Make table horizontally scrollable */
            #pos_table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
                font-size: 11px;
            }
            #pos_table thead {
                display: table-header-group;
            }
            #pos_table tbody {
                display: table-row-group;
            }
            #pos_table tr {
                display: table-row;
            }
            #pos_table thead th {
                font-size: 12px !important;
                padding: 3px 5px;
            }
            #pos_table tbody td {
                padding: 2px 3px;
                font-size: 10px;
            }
            
            /* Product grid - 3 per row on tablet portrait */
            .product_list {
                width: 33.333% !important;
                max-width: 33.333% !important;
            }
            
            /* Product sidebar responsive adjustments */
            .pos_sidebar {
                padding: 8px !important;
                max-width: 100% !important;
                overflow-x: hidden !important;
            }
            
            /* Product list container responsive */
            #product_list_div {
                padding: 8px !important;
                max-width: 100% !important;
                overflow-x: hidden !important;
            }
            
            /* Ensure product grid container is responsive */
            .product_list_container,
            .row[class*="product"] {
                max-width: 100% !important;
                overflow-x: hidden !important;
            }
        }

        @media (max-width: 768px) {
            /* Mobile Landscape - Hide Unit, Discount, and Type columns */
            #pos_table thead th:nth-child(4),
            #pos_table tbody td:nth-child(4) {
                display: none !important; /* Hide Unit column */
            }
            #pos_table thead th:nth-child(6),
            #pos_table tbody td:nth-child(6) {
                display: none !important; /* Hide Discount column */
            }
            #pos_table thead th:nth-child(7),
            #pos_table tbody td:nth-child(7) {
                display: none !important; /* Hide Discount Type column */
            }
            
            #pos_table {
                font-size: 10px;
            }
            #pos_table thead th {
                font-size: 12px !important;
                padding: 2px 4px;
            }
            #pos_table tbody td {
                padding: 2px 3px;
                font-size: 9px;
            }
            #pos_table tbody td input[type="text"],
            #pos_table tbody td input[type="number"],
            #pos_table tbody td select {
                font-size: 10px !important;
                padding: 2px 4px !important;
                height: 24px !important;
            }
            
            /* Product grid - 2 per row on mobile */
            .product_list {
                width: 50% !important;
            }
            
            /* Header adjustments */
            .tw-px-3 {
                padding-left: 8px !important;
                padding-right: 8px !important;
            }
        }

        @media (max-width: 480px) {
            /* Mobile Portrait - Hide Unit, Discount, and Type columns */
            #pos_table thead th:nth-child(4),
            #pos_table tbody td:nth-child(4) {
                display: none !important; /* Hide Unit column */
            }
            #pos_table thead th:nth-child(6),
            #pos_table tbody td:nth-child(6) {
                display: none !important; /* Hide Discount column */
            }
            #pos_table thead th:nth-child(7),
            #pos_table tbody td:nth-child(7) {
                display: none !important; /* Hide Discount Type column */
            }
            
            #pos_table {
                font-size: 9px;
            }
            #pos_table thead th {
                font-size: 12px !important;
                padding: 2px 3px;
            }
            #pos_table tbody td {
                padding: 1px 2px;
                font-size: 8px;
            }
            #pos_table tbody td input[type="text"],
            #pos_table tbody td input[type="number"],
            #pos_table tbody td select {
                font-size: 9px !important;
                padding: 1px 3px !important;
                height: 22px !important;
            }
            
            /* Product grid - 2 per row */
            .product_list {
                width: 50% !important;
            }
            
            /* Compact spacing */
            .tw-px-3 {
                padding-left: 6px !important;
                padding-right: 6px !important;
            }
        }

        @media (max-width: 360px) {
            /* Small Mobile - Hide Unit, Discount, and Type columns */
            #pos_table thead th:nth-child(4),
            #pos_table tbody td:nth-child(4) {
                display: none !important; /* Hide Unit column */
            }
            #pos_table thead th:nth-child(6),
            #pos_table tbody td:nth-child(6) {
                display: none !important; /* Hide Discount column */
            }
            #pos_table thead th:nth-child(7),
            #pos_table tbody td:nth-child(7) {
                display: none !important; /* Hide Discount Type column */
            }
            
            #pos_table {
                font-size: 8px;
            }
            #pos_table thead th {
                font-size: 12px !important;
                padding: 1px 2px;
            }
            #pos_table tbody td {
                padding: 1px 2px;
                font-size: 7px;
            }
            
            .product_list {
                width: 100% !important;
            }
        }

        /* Ensure proper scrolling on mobile */
        @media (max-width: 991.98px) {
            html, body {
                overflow-x: hidden;
            }
            .box-body {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }
        }

        /* Mobile Product Grid Toggle Button */
        .mobile-product-toggle {
            display: none;
        }
        @media (max-width: 991.98px) {
            .mobile-product-toggle {
                display: block;
                position: fixed;
                bottom: 200px;
                right: 20px;
                width: 60px;
                height: 60px;
                background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
                color: #ffffff;
                border-radius: 50%;
                box-shadow: 0 4px 15px rgba(37, 99, 235, 0.4);
                z-index: 9998;
                border: none;
                cursor: pointer;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 24px;
                transition: all 0.3s ease;
            }
            @media (max-width: 480px) {
                .mobile-product-toggle {
                    bottom: 180px;
                    right: 15px;
                    width: 56px;
                    height: 56px;
                }
                .mobile-product-toggle i {
                    font-size: 24px;
                }
            }
            .mobile-product-toggle:hover,
            .mobile-product-toggle:active {
                transform: scale(1.1);
                box-shadow: 0 6px 20px rgba(37, 99, 235, 0.5);
            }
            .mobile-product-toggle i {
                font-size: 28px;
            }
        }

        /* Mobile Product Grid Modal - Refactored for Single Instance */
        .mobile-product-modal-header {
            display: none;
        }

        @media (max-width: 991.98px) {
            /* Products now show directly in Products tab - no modal needed */
            #pos-sidebar-wrapper {
                position: static !important;
                display: block !important;
                background: transparent !important;
                z-index: auto !important;
                overflow-y: visible !important;
                padding: 12px !important;
                width: 100% !important;
                max-width: 100% !important;
                height: auto !important;
            }
            
            .mobile-product-modal-header,
            .mobile-product-close {
                display: none !important;
            }
            
            /* Adjust sidebar content for mobile */
            #pos-sidebar-wrapper .pos_sidebar {
                padding: 10px !important;
                display: block !important;
            }
            
            /* Ensure product list is visible */
            #product_list_div,
            .product_list_container {
                display: block !important;
            }
        }
        
        @media (min-width: 992px) {
            .mobile-product-toggle {
                display: none !important;
            }
            #pos-sidebar-wrapper {
                display: block !important;
            }
        }

        /* Fix Select2 dropdown z-index in Serial Number Modal */
        .serial_modal .select2-container {
            z-index: 10050 !important; /* Bootstrap modal z-index is usually 1050, backdrop is 1040 */
        }
        .serial_modal .select2-dropdown {
            z-index: 10051 !important;
        }
        .serial_modal .select2-search__field {
            z-index: 10052 !important;
        }
        /* Ensure Select2 dropdown appears above modal backdrop */
        .modal-backdrop + .select2-container {
            z-index: 1051 !important;
        }
        .modal-backdrop + .select2-container .select2-dropdown {
            z-index: 1052 !important;
        }

        /* Contact Modal - Minimal Height */
        .contact_modal .modal-dialog {
            height: auto !important;
            max-height: 85vh !important;
            margin: 10px auto !important;
        }
        .contact_modal .modal-content {
            height: auto !important;
            max-height: 85vh !important;
        }
        .contact_modal .modal-body {
            padding: 8px 15px !important;
            max-height: calc(85vh - 120px) !important;
            overflow-y: auto !important;
        }
        .contact_modal .form-group {
            margin-bottom: 6px !important;
        }
        .contact_modal .row {
            margin-bottom: 4px !important;
        }
        .contact_modal .col-md-3,
        .contact_modal .col-md-4,
        .contact_modal .col-md-6,
        .contact_modal .col-md-12 {
            padding-left: 8px !important;
            padding-right: 8px !important;
            margin-bottom: 2px !important;
        }
        .contact_modal .form-control,
        .contact_modal input[type="text"],
        .contact_modal input[type="email"],
        .contact_modal input[type="number"],
        .contact_modal select {
            height: 30px !important;
            padding: 4px 8px !important;
            font-size: 13px !important;
            line-height: 1.4 !important;
        }
        .contact_modal .input-group-addon {
            padding: 4px 8px !important;
            font-size: 12px !important;
            line-height: 1.4 !important;
            height: 30px !important;
        }
        .contact_modal label {
            margin-bottom: 2px !important;
            font-size: 12px !important;
            font-weight: 600 !important;
        }
        .contact_modal .help-block {
            margin-top: 2px !important;
            margin-bottom: 2px !important;
            font-size: 11px !important;
        }
        .contact_modal .modal-header {
            padding: 8px 15px !important;
            min-height: 42px !important;
        }
        .contact_modal .modal-header h4 {
            margin: 0 !important;
            font-size: 16px !important;
            line-height: 1.4 !important;
        }
        
        /* Modal Title Color */
        h4.modal-title {
            color: #ffffff;
        }
        .contact_modal .modal-footer {
            padding: 8px 15px !important;
            margin-top: 8px !important;
        }
        .contact_modal .modal-footer .btn {
            padding: 6px 12px !important;
            font-size: 13px !important;
        }
        .contact_modal .clearfix {
            margin: 2px 0 !important;
            height: 2px !important;
        }
        .contact_modal hr {
            margin: 6px 0 !important;
        }
        .contact_modal .more_btn {
            margin-bottom: 4px !important;
            padding: 6px 12px !important;
            font-size: 12px !important;
        }
        .contact_modal #more_div {
            margin-top: 4px !important;
        }
        .contact_modal .select2-container .select2-selection--single {
            height: 30px !important;
        }
        .contact_modal .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 28px !important;
            font-size: 13px !important;
        }
        .contact_modal .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 28px !important;
        }

        /* POS Basket - Custom Design - Minimal Height */
        div.pos-basket {
            width: 760px !important;
            height: auto !important;
            min-height: fit-content !important;
            max-height: none !important;
            margin-right: -20px !important;
            margin-bottom: 0px !important;
            padding: 12px 16px !important; /* Reduced from default */
        }
        
        /* Reduce spacing between basket sections */
        div.pos-basket .basket-amount {
            margin-bottom: 8px !important; /* Reduced spacing */
        }
        
        div.pos-basket .basket-metrics {
            margin-bottom: 10px !important; /* Reduced spacing */
            gap: 6px !important; /* Reduced gap */
        }
        
        div.pos-basket .pos-actions-grid {
            gap: 8px !important; /* Reduced gap between buttons */
            margin-bottom: 0 !important; /* Remove bottom margin */
        }
        
        /* Reduce padding in metrics */
        div.pos-basket .metric {
            padding: 6px 10px !important; /* Reduced padding */
            border-style: solid !important;
            border-color: #b7b7b7 !important;
        }
        
        /* Reduce button padding for more compact look */
        div.pos-basket .pos-actions-grid .btn {
            padding: 10px 14px !important; /* Reduced padding */
        }
        
        /* Ensure no extra bottom space */
        div.pos-basket .action_button_list {
            margin-bottom: 0 !important;
            padding-bottom: 0 !important;
        }

        /* Product Box Minimal Dimensions - Override All Styles */
        .product_box {
            padding: 2px !important;
            margin: 0 !important;
        }
        
        .product_box .image-container {
            height: 75px !important;
            margin: 1px !important;
            background-color: #ffffff !important;
            border: none !important;
            border-style: none !important;
        }
        
        div.image-container {
            border-style: none !important;
        }
        
        .product_box .image-container i.fas.fa-cube {
            color: #0c343d !important;
        }
        
        button.add-to-cart-btn {
            background-color: #0b5394 !important;
        }
        
        button.add-to-cart-btn:hover {
            background-color: #084d82 !important;
        }
        
        button.add-to-cart-btn:active {
            background-color: #073d6b !important;
        }
        
        .product_box .text_div {
            padding: 2px 4px !important;
        }
        
        .product_box .text_div .product-name {
            font-size: 13px !important;
            line-height: 1.3 !important;
            margin-bottom: 0 !important;
        }
        
        .product_box .text_div .product-sku {
            font-size: 11px !important;
            line-height: 1.2 !important;
            margin-bottom: 1px !important;
        }
        
        .product_box .text_div .product-price {
            font-size: 75% !important;
            padding: 2px 6px !important;
            margin-top: 1px !important;
        }
        
        .product_box .stock_base {
            width: 50px !important;
            height: 20px !important;
            font-size: 9px !important;
            line-height: 20px !important;
        }
        
        .product_list {
            padding: 1px !important;
            margin-top: 2px !important;
            margin-bottom: 2px !important;
        }

        /* Product Sidebar Container - Responsive Styles */
        .pos_sidebar,
        #product_list_div,
        .product_list_container {
            width: 100% !important;
            max-width: 100% !important;
            box-sizing: border-box !important;
        }
        
        /* Medium Desktop/Laptop - 4 per row */
        @media (max-width: 1399.98px) and (min-width: 1200px) {
            .product_list {
                width: 25% !important;
                max-width: 25% !important;
            }
            
            .pos_sidebar {
                padding: 12px !important;
            }
        }
        
        /* Tablet - Large */
        @media (max-width: 991.98px) and (min-width: 769px) {
            .product_list {
                width: 33.333% !important;
            }
            
            .pos_sidebar {
                padding: 10px !important;
            }
        }

            /* Product Grid Styling for App Mode */
            .product_box {
                border: none !important;
                box-shadow: 0 4px 12px rgba(0,0,0,0.08) !important;
                border-radius: 12px !important;
                overflow: hidden;
                margin-bottom: 16px !important;
                background: #ffffff;
                transition: transform 0.2s;
            }
            
            .product_box:active {
                transform: scale(0.98);
            }
            
            .product_box .image-container {
                height: 120px !important;
                background: #f9fafb;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            
            .product_box .image-container img {
                max-height: 100%;
                max-width: 100%;
                object-fit: contain;
            }
            
            .product_box .text_div {
                padding: 10px !important;
                text-align: left !important;
            }
            
            .product_box .text_div small {
                font-size: 10px;
                color: #9ca3af;
                display: block;
                margin-bottom: 4px;
            }
            
            .product_box .text_div b {
                font-size: 13px;
                color: #111827;
                display: block;
                line-height: 1.3;
                margin-bottom: 6px;
                height: 34px; /* Limit to 2 lines */
                overflow: hidden;
            }
            
            /* Category Tabs Styling */
            #product_category_div {
                overflow-x: auto;
                white-space: nowrap;
                padding: 10px 0;
                margin-bottom: 10px;
                -webkit-overflow-scrolling: touch;
                scrollbar-width: none; /* Firefox */
            }
            
            #product_category_div::-webkit-scrollbar {
                display: none; /* Chrome/Safari */
            }
            
            /* Assuming buttons are inside, style them as chips */
            #product_category_div button, 
            #product_category_div .btn {
                border-radius: 20px !important;
                padding: 6px 16px !important;
                font-size: 13px !important;
                margin-right: 8px !important;
                border: 1px solid #e5e7eb !important;
                background: #ffffff !important;
                color: #4b5563 !important;
                box-shadow: none !important;
            }
            
            #product_category_div button.active,
            #product_category_div .btn-primary {
                background: #0b5394 !important;
                color: #ffffff !important;
                border-color: #0b5394 !important;
            }

        /* =========================================
           MODERN MOBILE UI DESIGN - USER FRIENDLY
           ========================================= */
        @media (max-width: 768px) {
            /* Global App Styling - Modern Design */
            * {
                -webkit-tap-highlight-color: transparent;
            }
            
            body {
                background: #f8fafc;
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Inter', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
                overflow-x: hidden;
            }
            
            /* Hide Default Header Elements */
            .main-header, 
            .main-sidebar, 
            .content-header,
            .pos-form-actions-desktop {
                display: none !important;
            }
            
            /* Adjust Content Wrapper - Modern Spacing */
            .content-wrapper {
                margin-left: 0 !important;
                padding-top: 70px !important;
                padding-bottom: 90px !important;
                background: #f8fafc !important;
                min-height: 100vh;
            }
            
            .content {
                padding: 12px !important;
                max-width: 100%;
                margin: 0 auto;
            }
            
            /* Modern Container */
            .container-fluid,
            .container {
                padding-left: 12px !important;
                padding-right: 12px !important;
                max-width: 100% !important;
            }

            /* --- MODERN INPUTS --- */
            .form-group {
                margin-bottom: 20px !important;
            }
            
            .input-group {
                background: #ffffff;
                border-radius: 12px;
                box-shadow: 0 2px 8px rgba(0,0,0,0.06);
                border: 1.5px solid #e2e8f0;
                overflow: hidden;
                padding: 4px;
                transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
            }
            
            .input-group:focus-within {
                border-color: #0b5394;
                box-shadow: 0 4px 16px rgba(11, 83, 148, 0.12);
            }
            
            .input-group .form-control {
                border: none !important;
                box-shadow: none !important;
                height: 50px !important;
                background: transparent !important;
                font-size: 16px !important;
                font-weight: 500;
                color: #1e293b !important;
                padding: 0 14px !important;
            }
            
            .input-group .form-control::placeholder {
                color: #94a3b8;
                font-weight: 400;
            }
            
            .input-group-addon {
                border: none !important;
                background: transparent !important;
                color: #64748b;
                font-size: 18px;
                padding: 0 14px;
            }
            
            .input-group-btn .btn {
                border: none !important;
                background: transparent !important;
                box-shadow: none !important;
                color: #0b5394 !important;
                font-weight: 600;
                padding: 0 18px;
                transition: all 0.2s ease;
                min-height: 50px;
            }
            
            .input-group-btn .btn:active {
                transform: scale(0.96);
                background: #f1f5f9 !important;
            }
            
            /* Modern Select2 Styling */
            .select2-container--default .select2-selection--single {
                border: 1.5px solid #e2e8f0 !important;
                height: 50px !important;
                background: #ffffff !important;
                border-radius: 12px !important;
                transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
                box-shadow: 0 2px 8px rgba(0,0,0,0.06);
            }
            
            .select2-container--default.select2-container--open .select2-selection--single {
                border-color: #0b5394 !important;
                box-shadow: 0 4px 16px rgba(11, 83, 148, 0.12) !important;
            }
            
            .select2-container--default .select2-selection--single .select2-selection__rendered {
                line-height: 50px !important;
                padding-left: 16px !important;
                font-size: 16px !important;
                font-weight: 500;
                color: #1e293b !important;
            }
            
            .select2-container--default .select2-selection--single .select2-selection__arrow {
                height: 50px !important;
                right: 14px !important;
            }
            
            .select2-container--default .select2-selection--single .select2-selection__arrow b {
                border-color: #64748b transparent transparent transparent;
            }

            /* --- CLEAN CARD DESIGN (Red Box Style) --- */
            /* Hide Table Header */
            #pos_table thead {
                display: none !important;
            }
            
            /* Cart Container - Full Width */
            #pos_table {
                width: 100% !important;
                max-width: 100% !important;
            }
            
            #pos_table tbody {
                width: 100% !important;
                display: flex !important;
                flex-direction: column !important;
                gap: 12px;
            }
            
            #pos_table tbody tr {
                display: flex !important;
                flex-direction: column !important;
                background: #ffffff !important;
                margin-bottom: 0 !important;
                border-radius: 14px !important;
                box-shadow: 0 2px 8px rgba(0,0,0,0.06), 0 1px 3px rgba(0,0,0,0.04) !important;
                padding: 16px !important;
                border: 1px solid #e2e8f0 !important;
                position: relative;
                width: 100% !important;
                max-width: 100% !important;
                box-sizing: border-box !important;
                transition: all 0.2s ease;
            }
            
            #pos_table tbody tr:active {
                transform: scale(0.98);
                box-shadow: 0 1px 4px rgba(0,0,0,0.08) !important;
            }
            
            /* Product Name - Modern Typography */
            #pos_table tbody tr td:nth-child(1) {
                width: 100% !important;
                max-width: 100% !important;
                border: none !important;
                padding: 0 45px 12px 0 !important;
                font-weight: 600 !important;
                font-size: 16px !important;
                line-height: 1.5 !important;
                color: #1e293b !important;
                margin-bottom: 12px !important;
                box-sizing: border-box !important;
                letter-spacing: -0.01em;
            }
            
            /* Hide stock info, product ID - keep name only */
            #pos_table tbody tr td:nth-child(1) small.text-muted {
                display: none !important;
            }
            
            /* Standardize product name color */
            #pos_table tbody tr td:nth-child(1) strong {
                color: #111827 !important;
                font-weight: 600 !important;
            }
            
            /* Quantity Row - Clean Layout with Labels */
            #pos_table tbody tr td:nth-child(2) {
                width: 100% !important;
                max-width: 100% !important;
                border: none !important;
                padding: 0 0 10px 0 !important;
                display: flex !important;
                align-items: flex-start !important;
                gap: 20px;
                margin-bottom: 10px !important;
                box-sizing: border-box !important;
            }
            
            /* Quantity Section Wrapper */
            #pos_table tbody tr td:nth-child(2) > div:has(.input-group.input-number),
            #pos_table tbody tr td:nth-child(2) .input-group-wrapper {
                display: flex;
                flex-direction: column;
                gap: 6px;
            }
            
            /* Quantity Label - Add before input group */
            #pos_table tbody tr td:nth-child(2) .input-group.input-number {
                position: relative;
            }
            
            #pos_table tbody tr td:nth-child(2) .input-group.input-number::before {
                content: 'Qty';
                position: absolute;
                top: -20px;
                left: 0;
                font-size: 12px;
                font-weight: 600;
                color: #6b7280;
                white-space: nowrap;
            }
            
            /* Quantity Control - Modern Design */
            #pos_table .input-group.input-number {
                width: 120px !important;
                border: 1.5px solid #e2e8f0 !important;
                border-radius: 10px !important;
                padding: 3px !important;
                background: #ffffff;
                margin-top: 22px !important;
                box-shadow: 0 1px 3px rgba(0,0,0,0.05);
                transition: all 0.2s ease;
            }
            
            #pos_table .input-group.input-number:focus-within {
                border-color: #0b5394 !important;
                box-shadow: 0 0 0 3px rgba(11, 83, 148, 0.1) !important;
            }
            
            #pos_table .input-group.input-number .btn {
                padding: 6px 10px !important;
                color: #475569 !important;
                font-size: 16px !important;
                font-weight: 600 !important;
                min-width: 36px;
                min-height: 36px;
                background: transparent !important;
                border: none !important;
                border-radius: 6px !important;
                transition: all 0.2s ease;
            }
            
            #pos_table .input-group.input-number .btn:active {
                background: #f1f5f9 !important;
                color: #0b5394 !important;
                transform: scale(0.95);
            }
            
            #pos_table .input-group.input-number .form-control {
                height: 36px !important;
                text-align: center !important;
                font-weight: 700 !important;
                font-size: 15px !important;
                color: #1e293b !important;
                border: none !important;
            }
            
            /* Price Section Wrapper */
            #pos_table tbody tr td:nth-child(2) .display_currency {
                position: relative;
                display: flex;
                flex-direction: column;
                align-items: flex-end;
                gap: 6px;
                margin-left: auto;
                padding-top: 20px;
            }
            
            /* Price Label */
            #pos_table tbody tr td:nth-child(2) .display_currency::before {
                content: 'Price';
                position: absolute;
                top: 0;
                right: 0;
                font-size: 12px;
                font-weight: 600;
                color: #6b7280;
                white-space: nowrap;
            }
            
            /* Price Display - Modern Style */
            #pos_table tbody tr td:nth-child(2) .display_currency {
                font-size: 17px !important;
                font-weight: 700 !important;
                color: #1e293b !important;
                letter-spacing: -0.02em;
            }
            
            /* Serial Number Section - Modern Button */
            #pos_table tbody tr td .btn-modal {
                background: #0b5394 !important;
                color: #ffffff !important;
                border: none !important;
                padding: 10px 16px !important;
                border-radius: 10px !important;
                font-size: 14px !important;
                font-weight: 600 !important;
                margin-bottom: 10px !important;
                box-shadow: 0 2px 6px rgba(11, 83, 148, 0.2);
                transition: all 0.2s ease;
                min-height: 44px;
            }
            
            #pos_table tbody tr td .btn-modal:active {
                transform: scale(0.97);
                box-shadow: 0 1px 3px rgba(11, 83, 148, 0.2);
            }
            
            /* Serial Input Fields - Modern Style */
            #pos_table tbody tr input[type="text"][name*="serial"],
            #pos_table tbody tr input[type="text"][id*="serial"] {
                width: 100% !important;
                max-width: 100% !important;
                padding: 12px 14px !important;
                border: 1.5px solid #e2e8f0 !important;
                border-radius: 10px !important;
                font-size: 15px !important;
                margin-bottom: 10px !important;
                background: #ffffff !important;
                box-sizing: border-box !important;
                transition: all 0.2s ease;
                color: #1e293b !important;
            }
            
            #pos_table tbody tr input[type="text"][name*="serial"]:focus,
            #pos_table tbody tr input[type="text"][id*="serial"]:focus {
                border-color: #0b5394 !important;
                box-shadow: 0 0 0 3px rgba(11, 83, 148, 0.1) !important;
                outline: none !important;
            }
            
            /* Price Input Fields - Modern Style */
            #pos_table tbody tr input[type="text"][name*="price"],
            #pos_table tbody tr input[type="number"][name*="price"] {
                width: 100% !important;
                max-width: 100% !important;
                padding: 12px 14px !important;
                border: 1.5px solid #e2e8f0 !important;
                border-radius: 10px !important;
                font-size: 15px !important;
                margin-bottom: 10px !important;
                margin-top: 22px !important;
                background: #ffffff !important;
                box-sizing: border-box !important;
                position: relative;
                transition: all 0.2s ease;
                color: #1e293b !important;
                font-weight: 600 !important;
            }
            
            #pos_table tbody tr input[type="text"][name*="price"]:focus,
            #pos_table tbody tr input[type="number"][name*="price"]:focus {
                border-color: #0b5394 !important;
                box-shadow: 0 0 0 3px rgba(11, 83, 148, 0.1) !important;
                outline: none !important;
            }
            
            /* Price Input Label - Add before input */
            #pos_table tbody tr td:has(input[name*="price"]) {
                position: relative;
            }
            
            #pos_table tbody tr td:has(input[name*="price"])::before {
                content: 'Price';
                position: absolute;
                top: 0;
                left: 0;
                font-size: 12px;
                font-weight: 600;
                color: #6b7280;
                z-index: 1;
            }
            
            /* Alternative: Label for price inputs in their container */
            #pos_table tbody tr input[type="text"][name*="price"]::before,
            #pos_table tbody tr input[type="number"][name*="price"]::before {
                content: 'Price';
                position: absolute;
                top: -18px;
                left: 0;
                font-size: 12px;
                font-weight: 600;
                color: #6b7280;
            }
            
            /* All Input Fields - Full Width */
            #pos_table tbody tr input[type="text"],
            #pos_table tbody tr input[type="number"] {
                width: 100% !important;
                max-width: 100% !important;
                box-sizing: border-box !important;
            }
            
            /* Labels - Clean Style */
            #pos_table tbody tr label {
                display: block !important;
                font-size: 12px !important;
                font-weight: 600 !important;
                color: #6b7280 !important;
                margin-bottom: 6px !important;
            }
            
            /* Hide Price/Unit table columns */
            #pos_table tbody tr td:nth-child(3),
            #pos_table tbody tr td:nth-child(4) {
                display: none !important; 
            }
            
            #pos_table tbody tr td {
                border: none !important;
            }
            
            /* Remove Button - Top Right */
            #pos_table tbody tr td:last-child {
                position: absolute !important;
                top: 10px !important;
                right: 10px !important;
                width: auto !important;
                padding: 0 !important;
            }
            
            #pos_table tbody tr td i.fa-times,
            #pos_table tbody tr td .pos_remove_row {
                color: #64748b !important;
                font-size: 18px !important;
                background: #f1f5f9 !important;
                width: 36px;
                height: 36px;
                min-width: 44px;
                min-height: 44px;
                display: flex;
                align-items: center;
                justify-content: center;
                border-radius: 10px;
                cursor: pointer;
                transition: all 0.2s ease;
            }
            
            #pos_table tbody tr td i.fa-times:hover,
            #pos_table tbody tr td .pos_remove_row:hover {
                background: #fee2e2 !important;
                color: #dc2626 !important;
            }
            
            #pos_table tbody tr td i.fa-times:active,
            #pos_table tbody tr td .pos_remove_row:active {
                transform: scale(0.9);
                background: #fecaca !important;
            }
            
            /* Subtotal - Bottom */
            #pos_table tbody tr td:nth-last-child(2) {
                width: 100% !important;
                max-width: 100% !important;
                text-align: right !important;
                padding: 10px 0 0 0 !important;
                border-top: 1px solid #f3f4f6 !important;
                margin-top: 8px;
                box-sizing: border-box !important;
            }
            
            /* Ensure cart container uses full width */
            #pos_left_panel {
                width: 100% !important;
                max-width: 100% !important;
            }
            
            #pos_left_panel .box-body {
                width: 100% !important;
                max-width: 100% !important;
            }
            
            #pos_table tbody tr td:nth-last-child(2) .display_currency {
                font-size: 16px !important;
                font-weight: 700 !important;
                color: #111827 !important;
            }
            /* Modern App Header */
            .pos-app-header {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                height: 70px;
                background: #ffffff;
                backdrop-filter: blur(20px);
                -webkit-backdrop-filter: blur(20px);
                display: flex;
                align-items: center;
                justify-content: space-between;
                padding: 0 20px;
                z-index: 10020;
                box-shadow: 0 1px 3px rgba(0,0,0,0.08);
                border-bottom: 1px solid #e2e8f0;
            }
            
            .pos-app-logo {
                font-size: 20px;
                font-weight: 700;
                color: #1e293b;
                display: flex;
                align-items: center;
                letter-spacing: -0.02em;
            }
            
            .pos-app-location {
                font-size: 12px;
                color: #64748b;
                margin-left: 8px;
                font-weight: 500;
                max-width: 140px;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
                padding: 4px 10px;
                background: #f1f5f9;
                border-radius: 8px;
            }
            
            .pos-app-menu-btn {
                background: #f1f5f9;
                border: none;
                font-size: 20px;
                color: #475569;
                padding: 10px;
                border-radius: 10px;
                transition: all 0.2s ease;
                cursor: pointer;
                min-width: 44px;
                min-height: 44px;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            
            .pos-app-menu-btn:active {
                transform: scale(0.95);
                background: #e2e8f0;
            }

            /* --- VIEW SWITCHING (TABS) --- */
            /* By default, we show Product Grid (Right Panel) and hide Cart (Left Panel) */
            
            /* Cart Panel - Default state on Mobile (shown by default) */
            .row.tw-flex > div:first-child,
            .tw-w-full[class*="lg:tw-w-[60%]"],
            div[class*="lg:tw-w-[60%]"] {
                display: block !important; /* Show cart by default */
                width: 100% !important;
                max-width: 100% !important;
            }
            
            /* Products Panel - Show directly in main content area (not modal) */
            #pos-sidebar-wrapper {
                display: block !important;
                position: static !important;
                width: 100% !important;
                max-width: 100% !important;
                height: auto !important;
                min-height: 200px !important;
                background: transparent !important;
                z-index: auto !important;
                overflow-y: visible !important;
                overflow-x: hidden !important;
                padding: 12px !important;
                padding-top: 0 !important;
                padding-bottom: 80px !important; /* Space for bottom nav */
                opacity: 1 !important;
                transform: none !important;
                transition: none !important;
                visibility: visible !important;
            }
            
            /* Ensure parent container shows products */
            body:not(.show-cart) .row.tw-flex {
                display: flex !important;
                flex-direction: column !important;
            }
            
            body:not(.show-cart) .row.tw-flex #pos-sidebar-wrapper {
                order: 1 !important;
                flex: 1 1 auto !important;
            }
            
            /* Hide modal header on mobile - not needed */
            .mobile-product-modal-header {
                display: none !important;
            }
            
            /* When Products Tab is Active - Show Products, Hide Cart */
            body:not(.show-cart) .row.tw-flex > div:first-child,
            body:not(.show-cart) .tw-w-full[class*="lg:tw-w-[60%]"],
            body:not(.show-cart) div[class*="lg:tw-w-[60%]"],
            body:not(.show-cart) #pos_left_panel {
                display: none !important;
            }
            
            /* Show Products when Products tab is active */
            body:not(.show-cart) #pos-sidebar-wrapper {
                display: block !important;
                visibility: visible !important;
                opacity: 1 !important;
                position: static !important;
                width: 100% !important;
                max-width: 100% !important;
                height: auto !important;
                overflow: visible !important;
            }
            
            /* Ensure product list is visible */
            body:not(.show-cart) #pos-sidebar-wrapper .pos_sidebar,
            body:not(.show-cart) #pos-sidebar-wrapper #product_list_div,
            body:not(.show-cart) #pos-sidebar-wrapper .product_list_container {
                display: block !important;
                visibility: visible !important;
            }
            
            /* When Cart Tab is Active - Show Cart, Hide Products */
            body.show-cart .row.tw-flex > div:first-child,
            body.show-cart .tw-w-full[class*="lg:tw-w-[60%]"],
            body.show-cart div[class*="lg:tw-w-[60%]"],
            body.show-cart #pos_left_panel {
                display: block !important;
            }
            
            body.show-cart #pos-sidebar-wrapper {
                display: none !important;
                visibility: hidden !important;
            }

            /* --- PREMIUM BOTTOM NAVIGATION --- */
            .pos-mobile-footer {
            position: fixed;
                bottom: 75px;
                left: 16px;
                right: 16px;
                background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
                backdrop-filter: blur(20px);
                -webkit-backdrop-filter: blur(20px);
                padding: 16px 20px;
                box-shadow: 0 -8px 24px rgba(0,0,0,0.12), 0 -4px 8px rgba(0,0,0,0.06);
                display: none !important;
            justify-content: space-between;
            align-items: center;
            z-index: 999;
                border-radius: 20px;
                border: 1px solid rgba(255,255,255,0.8);
        }
            
        .pos-bottom-nav {
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                height: 80px;
                background: #ffffff;
                backdrop-filter: blur(20px);
                -webkit-backdrop-filter: blur(20px);
                display: flex;
                justify-content: space-around;
                align-items: center;
                z-index: 10030;
                box-shadow: 0 -2px 10px rgba(0,0,0,0.08);
                border-top: 1px solid #e2e8f0;
                padding-bottom: env(safe-area-inset-bottom);
            }
            
            .nav-item {
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                color: #94a3b8;
                font-size: 12px;
                font-weight: 600;
                width: 50%;
                height: 100%;
                border: none;
                background: none;
                position: relative;
                transition: all 0.2s ease;
                cursor: pointer;
                min-height: 44px;
            }
            
            .nav-item::before {
                content: '';
                position: absolute;
                top: 0;
                left: 50%;
                transform: translateX(-50%);
                width: 0;
                height: 3px;
                background: #0b5394;
                border-radius: 0 0 3px 3px;
                transition: width 0.25s ease;
            }
            
            .nav-item.active {
                color: #0b5394;
            }
            
            .nav-item.active::before {
                width: 50%;
            }
            
            .nav-item:active {
                transform: scale(0.96);
            }
            
            .nav-item i {
                font-size: 22px;
                margin-bottom: 4px;
                transition: all 0.2s ease;
            }
            
            .nav-item.active i {
                color: #0b5394;
            }
            
            .cart-badge {
                position: absolute;
                top: 2px;
                right: calc(50% - 18px);
                background: #ef4444;
                color: white;
                font-size: 10px;
                font-weight: 700;
                padding: 2px 6px;
                border-radius: 10px;
                min-width: 18px;
                text-align: center;
                box-shadow: 0 2px 6px rgba(239, 68, 68, 0.3);
                border: 2px solid #ffffff;
            }

            /* --- HIDE OLD ELEMENTS --- */
            .pos-mobile-footer {
                /* Only show sticky footer in Cart Mode */
                display: none; 
            }
            
            body.show-cart .pos-mobile-footer {
                display: flex !important;
                bottom: 85px;
                border-radius: 20px;
                box-shadow: 0 -8px 32px rgba(0,0,0,0.15), 0 -4px 12px rgba(0,0,0,0.1);
                animation: slideUp 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            }
            
            @keyframes slideUp {
                from {
                    opacity: 0;
                    transform: translateY(20px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
            
            /* Premium Mobile Footer Content */
            .pos-mobile-footer .pos-mobile-total {
                display: flex;
                flex-direction: column;
            }
            
            .pos-mobile-footer .pos-mobile-total .label {
                font-size: 12px;
                font-weight: 600;
                color: #6b7280;
                margin-bottom: 4px;
            }
            
            .pos-mobile-footer .pos-mobile-total .amount {
                font-size: 24px;
                font-weight: 800;
                background: linear-gradient(135deg, #0b5394 0%, #1e88e5 100%);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
            }
            
            .pos-mobile-btn {
                background: #0b5394;
                color: white;
                border: none;
                padding: 14px 24px;
                border-radius: 12px;
                font-weight: 600;
                font-size: 15px;
                box-shadow: 0 2px 8px rgba(11, 83, 148, 0.25);
                transition: all 0.2s ease;
                cursor: pointer;
                min-height: 48px;
            }
            
            .pos-mobile-btn:active {
                transform: scale(0.97);
                box-shadow: 0 1px 4px rgba(11, 83, 148, 0.25);
                background: #094d82;
            }
            
            .pos-mobile-footer .pos-mobile-total .label {
                font-size: 12px;
                font-weight: 600;
                color: #64748b;
                margin-bottom: 4px;
            }
            
            .pos-mobile-footer .pos-mobile-total .amount {
                font-size: 22px;
                font-weight: 700;
                color: #1e293b;
            }
            
            /* Hide Floating Product Button - Not Needed */
            #mobile-product-toggle-btn {
                display: none !important;
            }
            
            /* ============================================
               PROFESSIONAL MOBILE PRODUCT PAGE DESIGN
               ============================================ */
            
            /* Main Product Container - Clean */
            #pos-sidebar-wrapper {
                padding: 12px !important;
                background: #f9fafb !important;
                min-height: 100vh !important;
            }
            
            /* Search and Filter Section - Clean */
            #pos-sidebar-wrapper .row:first-child {
                background: #ffffff !important;
                border-radius: 8px !important;
                padding: 12px !important;
                margin-bottom: 12px !important;
                border: 1px solid #e5e7eb !important;
            }
            
            /* Search Input - Clean & Simple */
            #pos-sidebar-wrapper input[type="text"][id*="search"],
            #search_suggestion_list_tab {
                border-radius: 8px !important;
                border: 1px solid #d1d5db !important;
                padding: 10px 14px !important;
                font-size: 14px !important;
                background: #ffffff !important;
                transition: all 0.2s ease !important;
                color: #111827 !important;
            }
            
            #pos-sidebar-wrapper input[type="text"][id*="search"]::placeholder,
            #search_suggestion_list_tab::placeholder {
                color: #9ca3af !important;
            }
            
            #pos-sidebar-wrapper input[type="text"][id*="search"]:focus,
            #search_suggestion_list_tab:focus {
                border-color: #0b5394 !important;
                background: #ffffff !important;
                box-shadow: 0 0 0 3px rgba(11, 83, 148, 0.1) !important;
                outline: none !important;
            }
            
            /* Category/Brand Filter Tabs - Clean Design */
            .product-filter-tabs {
                margin-bottom: 16px !important;
                display: flex !important;
                gap: 8px !important;
                align-items: center !important;
                flex-wrap: wrap !important;
            }
            
            .filter-tab-btn {
                border-radius: 6px !important;
                padding: 8px 16px !important;
                font-size: 13px !important;
                font-weight: 600 !important;
                border: 1px solid #d1d5db !important;
                transition: all 0.2s ease !important;
                background: #ffffff !important;
                color: #374151 !important;
            }
            
            .filter-tab-btn.active {
                background: #0b5394 !important;
                color: #ffffff !important;
                border-color: #0b5394 !important;
            }
            
            .filter-tab-btn:active {
                transform: scale(0.98);
            }
            
            /* Category/Brand Items - Clean */
            .category-item,
            .brand-item {
                border-radius: 6px !important;
                border: 1px solid #d1d5db !important;
                background: #ffffff !important;
                transition: all 0.2s ease !important;
                margin-bottom: 8px !important;
            }
            
            .category-item.active,
            .brand-item.active {
                border-color: #0b5394 !important;
                background: #f0f7ff !important;
            }
            
            /* Product Grid Container - Clean & Simple */
            #product_list_body,
            .product_list_container {
                display: flex !important;
                flex-wrap: wrap !important;
                gap: 10px !important;
                margin: 0 !important;
                padding: 0 !important;
            }
            
            /* Product List Item - Clean Design */
            .product_list {
                width: calc(50% - 5px) !important;
                flex: 0 0 calc(50% - 5px) !important;
                margin: 0 !important;
                padding: 0 !important;
                border-radius: 12px !important;
                overflow: hidden !important;
                transition: all 0.2s ease !important;
                background: transparent !important;
            }
            
            .product_list:active {
                transform: scale(0.98);
            }
            
            /* Clean Product Card Design */
            .product_box {
                border-radius: 12px !important;
                overflow: hidden !important;
                background: #ffffff !important;
                box-shadow: 0 1px 3px rgba(0,0,0,0.1) !important;
                border: 1px solid #e5e7eb !important;
                transition: all 0.2s ease !important;
                height: 100% !important;
                display: flex !important;
                flex-direction: column !important;
                cursor: pointer !important;
            }
            
            .product_box:active {
                transform: scale(0.98);
                box-shadow: 0 1px 2px rgba(0,0,0,0.1) !important;
            }
            
            /* Simple Product Image Container */
            .product_box .image-container {
                width: 100% !important;
                height: 130px !important;
                background: #f9fafb !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                position: relative !important;
                overflow: hidden !important;
            }
            
            /* Product Image Styling */
            .product_box .image-container img {
                max-width: 85% !important;
                max-height: 85% !important;
                object-fit: contain !important;
            }
            
            /* Clean Product Text Content */
            .product_box .text_div {
                padding: 10px !important;
                flex: 1 !important;
                display: flex !important;
                flex-direction: column !important;
                gap: 4px !important;
                background: #ffffff !important;
            }
            
            /* Product Name - Simple & Clear */
            .product_box .text_div small.text.text-muted:first-child {
                font-size: 13px !important;
                font-weight: 600 !important;
                color: #111827 !important;
                line-height: 1.4 !important;
                display: -webkit-box !important;
                -webkit-line-clamp: 2 !important;
                -webkit-box-orient: vertical !important;
                overflow: hidden !important;
                text-overflow: ellipsis !important;
                margin-bottom: 4px !important;
            }
            
            /* Product SKU - Simple */
            .product_box .text_div small.text-muted:nth-of-type(2) {
                font-size: 10px !important;
                color: #6b7280 !important;
                font-weight: 400 !important;
                margin-bottom: 6px !important;
            }
            
            /* Stock Information - Simple Badge */
            .product_box .text_div small.text-muted:last-child {
                font-size: 9px !important;
                color: #6b7280 !important;
                padding: 3px 6px !important;
                background: #f3f4f6 !important;
                border-radius: 4px !important;
                display: inline-block !important;
                width: fit-content !important;
                font-weight: 500 !important;
                margin-top: auto !important;
            }
            
            /* Empty State - Simple */
            #product_list_body:empty::after,
            .product_list_container:empty::after {
                content: 'No products found';
                display: block;
                text-align: center;
                padding: 40px 20px;
                color: #6b7280;
                font-size: 14px;
                width: 100%;
            }
            
            /* Loading Spinner - Simple */
            #suggestion_page_loader {
                padding: 40px !important;
                text-align: center !important;
            }
            
            #suggestion_page_loader i {
                color: #0b5394 !important;
                font-size: 24px !important;
            }
            
            /* Grid View Toggle Button */
            #product_show_style_switch_tab {
                border-radius: 10px !important;
                border: 2px solid #e2e8f0 !important;
                transition: all 0.3s ease !important;
            }
            
            #product_show_style_switch_tab:hover {
                border-color: #0b5394 !important;
                transform: scale(1.05);
            }
            
            #product_show_style_switch_tab:active {
                transform: scale(0.95);
            }
            
            /* Modern Empty State */
            #pos_table tbody:empty::after {
                content: 'No items in cart';
                display: block;
                text-align: center;
                padding: 60px 20px;
                color: #94a3b8;
                font-size: 16px;
                font-weight: 500;
            }
            
            /* Modern Cart Container */
            #pos_left_panel {
                background: #ffffff !important;
                border-radius: 16px !important;
                box-shadow: 0 2px 8px rgba(0,0,0,0.06) !important;
                border: 1px solid #e2e8f0 !important;
                padding: 16px !important;
                margin-bottom: 12px !important;
            }
            
            /* Better Touch Targets */
            button, a, .btn {
                min-height: 44px;
                min-width: 44px;
            }
            
            /* Modern Scrollbar */
            #pos-sidebar-wrapper::-webkit-scrollbar {
                width: 4px;
            }
            
            #pos-sidebar-wrapper::-webkit-scrollbar-track {
                background: transparent;
            }
            
            #pos-sidebar-wrapper::-webkit-scrollbar-thumb {
                background: #cbd5e1;
                border-radius: 2px;
            }
            
            #pos-sidebar-wrapper::-webkit-scrollbar-thumb:hover {
                background: #94a3b8;
            }
            
            /* Category/Brand Selection - Professional Design */
            #product_category_div,
            #product_brand_div {
                margin-bottom: 20px !important;
                overflow-x: auto !important;
                overflow-y: hidden !important;
                -webkit-overflow-scrolling: touch !important;
                padding-bottom: 4px !important;
            }
            
            /* Category/Brand Buttons - Modern Professional Design */
            #product_category_div button,
            #product_category_div .btn,
            #product_brand_div button,
            #product_brand_div .btn {
                border-radius: 10px !important;
                padding: 10px 18px !important;
                font-size: 13px !important;
                font-weight: 600 !important;
                margin-right: 8px !important;
                margin-bottom: 8px !important;
                border: 2px solid #e2e8f0 !important;
                background: #ffffff !important;
                color: #475569 !important;
                box-shadow: 0 1px 3px rgba(0,0,0,0.06) !important;
                transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
                min-height: 40px !important;
                white-space: nowrap !important;
            }
            
            #product_category_div button:hover,
            #product_category_div .btn:hover,
            #product_brand_div button:hover,
            #product_brand_div .btn:hover {
                border-color: #0b5394 !important;
                background: #f0f7ff !important;
                color: #0b5394 !important;
                transform: translateY(-1px);
                box-shadow: 0 4px 8px rgba(11, 83, 148, 0.15) !important;
            }
            
            #product_category_div button.active,
            #product_category_div .btn-primary,
            #product_category_div .btn.active,
            #product_brand_div button.active,
            #product_brand_div .btn-primary,
            #product_brand_div .btn.active {
                background: linear-gradient(135deg, #0b5394 0%, #084d82 100%) !important;
                color: #ffffff !important;
                border-color: #0b5394 !important;
                box-shadow: 0 4px 12px rgba(11, 83, 148, 0.25) !important;
                transform: translateY(-1px);
            }
            
            #product_category_div button:active,
            #product_brand_div button:active {
                transform: scale(0.96) translateY(0);
            }
            
            /* Category/Brand Scrollbar */
            #product_category_div::-webkit-scrollbar,
            #product_brand_div::-webkit-scrollbar {
                height: 4px !important;
            }
            
            #product_category_div::-webkit-scrollbar-track,
            #product_brand_div::-webkit-scrollbar-track {
                background: #f1f5f9 !important;
                border-radius: 2px !important;
            }
            
            #product_category_div::-webkit-scrollbar-thumb,
            #product_brand_div::-webkit-scrollbar-thumb {
                background: #cbd5e1 !important;
                border-radius: 2px !important;
            }
            
            /* Smooth Scrolling */
            html {
                scroll-behavior: smooth;
            }
            
            /* Premium Loading States */
            .loading-overlay {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(255, 255, 255, 0.95);
                backdrop-filter: blur(10px);
                display: flex;
                align-items: center;
                justify-content: center;
                z-index: 99999;
            }
            
            .loading-spinner {
                width: 48px;
                height: 48px;
                border: 4px solid #e5e7eb;
                border-top-color: #0b5394;
                border-radius: 50%;
                animation: spin 0.8s linear infinite;
            }
            
            @keyframes spin {
                to { transform: rotate(360deg); }
            }
            
            /* Premium Scrollbar */
            ::-webkit-scrollbar {
                width: 6px;
                height: 6px;
            }
            
            ::-webkit-scrollbar-track {
                background: #f1f5f9;
                border-radius: 10px;
            }
            
            ::-webkit-scrollbar-thumb {
                background: linear-gradient(135deg, #0b5394 0%, #1e88e5 100%);
                border-radius: 10px;
            }
            
            ::-webkit-scrollbar-thumb:hover {
                background: linear-gradient(135deg, #094d82 0%, #1565c0 100%);
            }
            
            /* Premium Focus States */
            button:focus-visible,
            input:focus-visible,
            select:focus-visible {
                outline: 2px solid #0b5394;
                outline-offset: 2px;
            }
            
            /* Premium Transitions for All Interactive Elements */
            button, a, input, select {
                transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            }
            
            /* Premium Box Shadows for Depth */
            #pos_left_panel {
                box-shadow: 0 8px 32px rgba(0,0,0,0.1), 0 4px 12px rgba(0,0,0,0.06) !important;
            }
            
            /* Premium Typography Hierarchy */
            h1, h2, h3, h4, h5, h6 {
                font-weight: 700;
                letter-spacing: -0.02em;
            }
            
            /* Premium Button Hover Effects */
            .btn:not(:disabled):hover {
                transform: translateY(-1px);
                box-shadow: 0 6px 20px rgba(0,0,0,0.15);
            }
            
            .btn:not(:disabled):active {
                transform: translateY(0);
            }
        }

        /* =========================================
           DESKTOP ONLY - Hide Mobile Elements
           ========================================= */
        @media (min-width: 769px) {
            /* Hide all mobile-specific elements on desktop */
            .pos-app-header,
            .pos-bottom-nav,
            .pos-mobile-footer,
            #mobile-product-toggle-btn,
            .mobile-product-modal-header {
                display: none !important;
            }
            
            /* Ensure desktop layout is visible */
            .main-header,
            .main-sidebar,
            .content-header,
            .pos-form-actions-desktop {
                display: block !important;
            }
            
            .content-wrapper {
                margin-left: 250px !important; /* Adjust based on sidebar width */
                padding-top: 0 !important;
                padding-bottom: 0 !important;
            }
            
            /* Desktop table should be visible */
            #pos_table {
                display: table !important;
            }
            
            #pos_table thead {
                display: table-header-group !important;
            }
            
            #pos_table tbody tr {
                display: table-row !important;
            }
            
            #pos_table tbody tr td {
                display: table-cell !important;
            }
        }

        /* =========================================
           MOBILE ONLY - Hide Desktop Elements
           ========================================= */
        @media (max-width: 768px) {
            /* Hide desktop-specific elements on mobile */
            .main-header,
            .main-sidebar,
            .content-header,
            .pos-form-actions-desktop,
            #recent_transaction,
            #recent_transactions {
                display: none !important;
            }
        }

        /* Product Search Loading Indicator */
        #search_product.search-loading {
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 24 24'%3E%3Cpath fill='%23007bff' d='M12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,19a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z' opacity='.25'/%3E%3Cpath fill='%23007bff' d='M10.14,1.16a11,11,0,0,0-9,8.92A1.59,1.59,0,0,0,2.46,12,1.52,1.52,0,0,0,4.11,10.7a8,8,0,0,1,6.66-6.61A1.42,1.42,0,0,0,12,2.69h0A1.57,1.57,0,0,0,10.14,1.16Z'%3E%3CanimateTransform attributeName='transform' type='rotate' dur='0.75s' values='0 12 12;360 12 12' repeatCount='indefinite'/%3E%3C/path%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 10px center;
            background-size: 18px 18px;
            padding-right: 35px !important;
        }
        
        #search_product.search-loading:focus {
            background-position: right 10px center;
        }
        
        @media (max-width: 768px) {
            #search_product.search-loading {
                background-size: 16px 16px;
                padding-right: 32px !important;
            }
        }

    </style>

    <!-- Loading Overlay -->
    <div id="pos-loading-overlay" class="loading-overlay" style="display: none;">
        <div class="loading-spinner"></div>
    </div>

    @php
        $is_mobile = isMobile();
    @endphp

    @if ($is_mobile)
        <!-- Mobile App Mode Header - ONLY on Mobile -->
    <div class="pos-app-header">
        <div class="pos-app-logo">
            POS <span class="pos-app-location">{{ $default_location->name ?? '' }}</span>
        </div>
        <button class="pos-app-menu-btn" onclick="$('.main-header').toggle();">
            <i class="fas fa-bars"></i>
        </button>
    </div>

        <!-- Mobile Bottom Navigation - ONLY on Mobile -->
    <div class="pos-bottom-nav">
            <button class="nav-item" id="nav-products" onclick="switchAppTab('products')">
            <i class="fas fa-th-large"></i>
            <span>Products</span>
        </button>
            <button class="nav-item active" id="nav-cart" onclick="switchAppTab('cart')">
            <i class="fas fa-shopping-cart"></i>
            <span class="cart-badge" id="app-cart-badge">0</span>
            <span>Cart</span>
        </button>
    </div>
        
        <!-- Initialize: Show Cart by Default on Mobile -->
        <script>
            // Run immediately to show cart on page load
            (function() {
                if (window.innerWidth <= 768) {
                    document.body.classList.add('show-cart');
                }
            })();
        </script>
    @endif

    <section class="content no-print">
        
        <input type="hidden" id="p_code" value="{{$currency_details->code}}">
        <input type="hidden" id="p_symbol" value="{{$currency_details->symbol}}">
        <input type="hidden" id="p_thousand" value="{{$currency_details->thousand_separator}}">
        <input type="hidden" id="p_decimal" value="{{$currency_details->decimal_separator}}">


        <input type="hidden" id="amount_rounding_method" value="{{ $pos_settings['amount_rounding_method'] ?? '' }}">
        @if (!empty($pos_settings['allow_overselling']))
            <input type="hidden" id="is_overselling_allowed">
        @endif
        @if (session('business.enable_rp') == 1)
            <input type="hidden" id="reward_point_enabled">
        @endif
        @php
            $is_discount_enabled = $pos_settings['disable_discount'] != 1 ? true : false;
            $is_rp_enabled = session('business.enable_rp') == 1 ? true : false;
        @endphp

        {!! Form::open(['url' => action([\App\Http\Controllers\SellPosController::class, 'store']), 'method' => 'post', 'id' => 'add_pos_sell_form',]) !!}
            
            <div class="row mb-12" style="position: absolute;width: 100%;">
                <div class="col-md-12 tw-pt-0 tw-mb-14">
                    <div style="background-color: white" class="row tw-flex lg:tw-flex-row md:tw-flex-col sm:tw-flex-col tw-flex-col tw-items-start md:tw-gap-4">
                        {{-- <div class="@if (empty($pos_settings['hide_product_suggestion'])) col-md-7 @else col-md-10 col-md-offset-1 @endif no-padding pr-12"> --}}
                        <div class="tw-px-3 tw-w-full  lg:tw-px-0 lg:tw-pr-0 @if(empty($pos_settings['hide_product_suggestion'])) lg:tw-w-[60%]  @else lg:tw-w-[100%] @endif">

                            <div id="pos_left_panel" class=" tw-rounded-2xl tw-bg-white tw-mb-2 md:tw-mb-8 tw-p-2">

                                {{-- <div class="box box-solid mb-12 @if (!isMobile()) mb-40 @endif"> --}}
                                    <div class="box-body pb-0">
                                        {!! Form::hidden('location_id', $default_location->id ?? null, ['id' => 'location_id', 'data-receipt_printer_type' => !empty($default_location->receipt_printer_type) ? $default_location->receipt_printer_type : 'browser', 'data-default_payment_accounts' => $default_location->default_payment_accounts ?? '']) !!}
                                        <!-- sub_type -->
                                        {!! Form::hidden('sub_type', isset($sub_type) ? $sub_type : null) !!}
                                        <input type="hidden" id="item_addition_method" value="{{ $business_details->item_addition_method }}">
                                        @include('sale_pos.partials.pos_form')

                                        @if ($is_mobile)
                                            @include('sale_pos.partials.pos_form_totals')
                                        @endif
                                        @include('sale_pos.partials.payment_modal')

                                        @if (empty($pos_settings['disable_suspend']))
                                            @include('sale_pos.partials.suspend_note_modal')
                                        @endif

                                        @if (empty($pos_settings['disable_recurring_invoice']))
                                            @include('sale_pos.partials.recurring_invoice_modal')
                                        @endif
                                    </div>
                                {{-- </div> --}}
                            </div>
                        </div>
                        @if (empty($pos_settings['hide_product_suggestion']))
                            <div id="pos-sidebar-wrapper" class="md:tw-no-padding tw-w-full lg:tw-w-[40%] tw-px-5">
                                @include('sale_pos.partials.pos_sidebar')
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Floating Product Button Removed - Products show directly in Products tab -->


                @if (isset($transaction))
                    @include('sale_pos.partials.edit_discount_modal', [
                        'sales_discount' => $transaction->discount_amount,
                        'discount_type' => $transaction->discount_type,
                        'rp_redeemed' => $transaction->rp_redeemed ?? 0,
                        'rp_redeemed_amount' => $transaction->rp_redeemed_amount ?? 0,
                        'max_available' => !empty($redeem_details['points']) ? $redeem_details['points'] : 0,
                    ])
                @else
                    @include('sale_pos.partials.edit_discount_modal', [
                        'sales_discount' => $business_details->default_sales_discount,
                        'discount_type' => 'percentage',
                        'rp_redeemed' => 0,
                        'rp_redeemed_amount' => 0,
                        'max_available' => 0,
                    ])
                @endif

                @if (isset($transaction))
                    @include('sale_pos.partials.edit_order_tax_modal', ['selected_tax' => $transaction->tax_id])
                @else
                    @include('sale_pos.partials.edit_order_tax_modal', [
                        'selected_tax' => $business_details->default_sales_tax,
                    ])
                @endif

                @include('sale_pos.partials.edit_shipping_modal')

                <!-- Desktop Form Actions - ONLY on Desktop -->
                @if (!$is_mobile)
                <div class="col-md-12 pos-form-actions-desktop">
                    @include('sale_pos.partials.pos_form_actions')
                </div>
                @endif
            </div>

            <!-- Mobile Sticky Footer - ONLY on Mobile -->
            @if ($is_mobile)
            <div class="pos-mobile-footer">
                <div class="pos-mobile-total">
                        <span class="label">@lang('sale.total_payable')</span>
                    <span class="amount total_payable_span">0.00</span>
                </div>
                <button type="button" class="pos-mobile-btn" id="pos-finalize-mobile" title="@lang('lang_v1.tooltip_checkout_multi_pay')">
                        <i class="fas fa-shopping-bag tw-mr-2"></i>
                        @lang('lang_v1.checkout')
                </button>
            </div>
            @endif

        {!! Form::close() !!}


        
        @if (!$is_mobile)
            <style>
                #recent_transaction{
                    position: fixed;
                    right: 1%;
                    bottom: 20%;
                    z-index: 111111;
                }
                div#recent_transactions {
                    position: fixed;
                    right: 0;
                    bottom: 16%;
                    width: 100%;
                    z-index: 11111;
                    display: none;
                }
                div#recent_transactions.expend_recent_transactions {
                    transition: all 0.3s linear;
                    display: block;
                }
                .closs_recent_transaction{
                    right: 0;
                    position: absolute;
                    background: transparent;
                    border: 0;
                    font-size: 31px;
                }
                .d-none{
                    display: none;
                }

            </style>

            {{-- <div id="recent_transaction">
                <button type="button" class="recent_transaction_button btn btn-default bg-red text-white btn-flat no-print">
                    <i class="fas fa-clock"></i> 
                    @lang('lang_v1.recent_transactions')
                </button>
            </div> --}}
            
            <div id="recent_transactions">
                <div class="col-md-7"></div>
                <div class="col-md-5">

                    <style>
                        .nav-tabs-custom>.tab-content{
                            font-size: 14px !important;
                            font-weight: 400 !important;
                            padding: 5px 3px !important;
                        }
                    </style>

                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs" style="position: relative;">
                            <li class="active">
                                <a href="#tab_final" data-toggle="tab" aria-expanded="true">
                                    <b>
                                        <i class="fa fa-check"></i> 
                                        @lang('sale.final')
                                    </b>
                                </a>
                            </li>
                            <li class="">
                                <a href="#tab_quotation" data-toggle="tab" aria-expanded="false">
                                    <b>
                                        <i class="fa fa-terminal"></i> 
                                        @lang('lang_v1.quotation')
                                    </b>
                                </a>
                            </li>
                            <li class="">
                                <a href="#tab_draft" data-toggle="tab" aria-expanded="false">
                                    <b>
                                        <i class="fa fa-terminal"></i> 
                                        @lang('sale.draft')
                                    </b>
                                </a>
                            </li>

                            <button type="button" class="closs_recent_transaction">
                                -
                            </button>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_final"></div>
                            <div class="tab-pane" id="tab_quotation"></div>
                            <div class="tab-pane" id="tab_draft"></div>
                        </div>
                    </div>

                </div>
            </div>

        @endif


    </section>

    <!-- This will be printed -->
    <section class="invoice print_section" id="receipt_section">
    </section>
    <div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        @include('contact.create', ['quick_add' => true])
    </div>
    @if (empty($pos_settings['hide_product_suggestion']) && isMobile())
        @include('sale_pos.partials.mobile_product_suggestions')
    @endif
    <!-- /.content -->
    <div class="modal fade register_details_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>
    <div class="modal fade close_register_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>
    <!-- quick product modal -->
    <div class="modal fade quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>

    <div class="modal fade" id="expense_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>

    @include('sale_pos.partials.configure_search_modal')

    @include('sale_pos.partials.recent_transactions_modal')

    @include('sale_pos.partials.weighing_scale_modal')


    <!-- Product Last Purchase Details Modal -->
    <div class="modal fade" id="product_purchase_details_modal" tabindex="-1" role="dialog" aria-labelledby="productPurchaseModalLabel">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header" style="background-color: #0b5394; color: #ffffff;">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: #ffffff; opacity: 0.8;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title" id="productPurchaseModalLabel">Product Last Purchase Details</h4>
                </div>
                <div class="modal-body" id="product_purchase_details_content">
                    <div class="text-center" style="padding: 20px;">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading...</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Purchase Invoice Preview Modal -->
    <div class="modal fade" id="purchase_invoice_preview_modal" tabindex="-1" role="dialog" aria-labelledby="purchaseInvoicePreviewLabel">
        <div class="modal-dialog modal-xl" role="document" style="width: 95%; max-width: 1200px;">
            <div class="modal-content">
                <div class="modal-header" style="background-color: #0b5394; color: #ffffff;">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: #ffffff; opacity: 0.8;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title" id="purchaseInvoicePreviewLabel">Purchase Invoice Preview</h4>
                </div>
                <div class="modal-body" id="purchase_invoice_preview_content" style="max-height: 80vh; overflow-y: auto;">
                    <div class="text-center" style="padding: 40px;">
                        <i class="fa fa-spinner fa-spin fa-3x"></i>
                        <p style="margin-top: 15px;">Loading invoice...</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary no-print" onclick="$(this).closest('div.modal-content').printThis();">
                        <i class="fa fa-print"></i> Print
                    </button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade serial_modal" id="purchases_serial_numberModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog" style="width: 50%;" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel">Edit Serial Number</h5>
				</div>
				<div class="modal-body">
					<div class="tags_list">
						<div id="tags" class="tags">
							<!-- tag list -->
						</div>
					</div>
					<input value="" id="purchases_serial_number" class="purchases_serial_numberclass form-control input-sm" type="text">
				</div>
				<div class="modal-footer">
					<button type="button" id="modelReload" class="btn btn-primary" data-dismiss="modal">Save</button>
				</div>
			</div>
		</div>
	</div>


@stop
@section('css')
    <!-- include module css -->
    @if (!empty($pos_module_data))
        @foreach ($pos_module_data as $key => $value)
            @if (!empty($value['module_css_path']))
                @includeIf($value['module_css_path'])
            @endif
        @endforeach
    @endif
@stop
@section('javascript')

    <script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/printer.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>


    <script>

        $(document).ready(function () {

            // Exchange Module Code
            $(document).on('change', '#exchange_system', function() {
                var current_mode = $(this).val();
                if (current_mode === 'sell') {
                    $('.sell_mode').removeClass('hide');
                    $('.exchange_mode').addClass('hide');
                } else if (current_mode === 'exchange') {
                    $('.sell_mode').addClass('hide');
                    $('.exchange_mode').removeClass('hide');
                }

            });
            // Exchange Module Code

            // Global F1 keyboard shortcut - checks Suspended Sales modal Edit, Select Serial, or focus quantity
            $(document).on('keydown', function(event) {
                if (event.key === 'F1') {
                    // Check if suspended sales modal is open first
                    if (isSuspendedSalesModalOpen()) {
                        // F1 - Edit Sale in Suspended Sales modal (first visible edit link)
                        var $editSaleBtn = $('.view_modal a.bg-blue.p-10, .view_modal a.small-box-footer.bg-blue').filter(function() {
                            return $(this).text().toLowerCase().includes('edit');
                        }).first();
                        if ($editSaleBtn.length && $editSaleBtn.is(':visible')) {
                            event.preventDefault();
                            $editSaleBtn.trigger('click');
                        }
                    }
                    // Check if Select Serial button exists in the last row
                    else {
                    var lastRow = $('#pos_table tbody').find('tr').last();
                    if (lastRow.length > 0) {
                        var $selectSerialBtn = lastRow.find('button:contains("Select Serial")');
                        if ($selectSerialBtn.length > 0 && $selectSerialBtn.is(':visible') && !$selectSerialBtn.is(':disabled')) {
                            event.preventDefault();
                            // Get the modal target from the button
                            var modalTarget = $selectSerialBtn.attr('data-target');
                            if (modalTarget) {
                                // Open the serial modal
                                $(modalTarget).modal('show');
                            } else {
                                // Fallback: trigger button click
                                $selectSerialBtn.trigger('click');
                            }
                        }
                        // If no Select Serial button, let the input-specific handler take over or default behavior
                        }
                    }
                }
            });

            // Global F4 keyboard shortcut - checks Suspended Sales modal Delete or Credit Sale
            $(document).on('keydown', function(event) {
                if (event.key === 'F4') {
                    // Check if suspended sales modal is open first
                    if (isSuspendedSalesModalOpen()) {
                        // F4 - Delete in Suspended Sales modal (first visible delete link)
                        var $deleteBtn = $('.view_modal a.delete-sale.is_suspended, .view_modal a.is_suspended').filter(function() {
                            return $(this).hasClass('delete-sale') || $(this).hasClass('bg-red');
                        }).first();
                        if ($deleteBtn.length && $deleteBtn.is(':visible')) {
                            event.preventDefault();
                            $deleteBtn.trigger('click');
                        }
                    } else {
                        // Default behavior: Credit Sale
                    event.preventDefault();
                    $('.is_credit_sale').trigger('click');
                    }
                }
            });

            // Global F5 keyboard shortcut - checks Suspended Sales modal Close, Contact modal Close, Payment modal Close, or Card Payment
            $(document).on('keydown', function(event) {
                if (event.key === 'F5') {
                    // Check if suspended sales modal is open first
                    if (isSuspendedSalesModalOpen()) {
                        // F5 - Close Suspended Sales modal
                        var $closeBtn = $('.view_modal button[data-dismiss="modal"], .view_modal .modal-footer button[data-dismiss="modal"]').first();
                        if ($closeBtn.length && $closeBtn.is(':visible')) {
                    event.preventDefault();
                            $closeBtn.trigger('click');
                        }
                    }
                    // Check if contact modal is open
                    else {
                        var $contactModal = $('.contact_modal');
                        if (($contactModal.hasClass('in') || $contactModal.hasClass('show') || $contactModal.is(':visible')) && $contactModal.length > 0) {
                            // F5 - Close Contact modal
                            event.preventDefault();
                            var $closeBtn = $contactModal.find('button[data-dismiss="modal"]').first();
                            if ($closeBtn.length && $closeBtn.is(':visible')) {
                                $closeBtn.trigger('click');
                            }
                        }
                        // Check if payment modal is open
                        else {
                            var $paymentModal = $('#modal_payment');
                            if (($paymentModal.hasClass('in') || $paymentModal.hasClass('show') || $paymentModal.is(':visible')) && $paymentModal.length > 0) {
                                // F5 - Close Payment modal
                                event.preventDefault();
                                var $closeBtn = $paymentModal.find('button[data-dismiss="modal"]').first();
                                if ($closeBtn.length && $closeBtn.is(':visible')) {
                                    $closeBtn.trigger('click');
                                }
                            } else {
                                // Default behavior: Card Payment
                                event.preventDefault();
                                $('button[data-pay_method="card"]:visible:first').trigger('click');
                            }
                        }
                    }
                }
            });

            // Global F6 keyboard shortcut for Multiple Pay (works from anywhere on POS screen)
            $(document).on('keydown', function(event) {
                if (event.key === 'F6') {
                    event.preventDefault();
                    $('#pos-finalize').trigger('click');
                }
            });

            // Helper function to check if Suspended Sales modal is open
            function isSuspendedSalesModalOpen() {
                var $suspendedModal = $('.view_modal .modal-title');
                var modalTitleText = '';
                if ($suspendedModal.length) {
                    modalTitleText = $suspendedModal.text().trim();
                }
                // Check if modal contains "Suspended Sales" text
                var hasSuspendedTitle = modalTitleText.toLowerCase().includes('suspended') || 
                                       modalTitleText.toLowerCase().includes('suspend');
                var isViewModalVisible = $('.view_modal').is(':visible') || 
                                        $('.view_modal .modal').is(':visible') ||
                                        $('.view_modal').hasClass('in') ||
                                        $('.view_modal').hasClass('show');
                return hasSuspendedTitle && isViewModalVisible;
            }

            // Global F2 keyboard shortcut - checks Serial Modal or Cash Sell
            $(document).on('keydown', function(event) {
                if (event.key === 'F2') {
                    // Check for serial modal
                    var $serialModal = $('.serial_modal[id^="sell_serial_numberModel"]:visible');
                    if ($serialModal.length > 0) {
                        event.preventDefault();
                        var $saveBtn = $serialModal.find('button.btn-primary[data-dismiss="modal"]');
                        if ($saveBtn.length && $saveBtn.is(':visible')) {
                            $saveBtn.trigger('click');
                        }
                    }
                    // If serial modal not open, let default F2 behavior (Cash Sell) work
                }
            });

            // Global F3 keyboard shortcut - checks discount, suspend, payment, or customer modal
            $(document).on('keydown', function(event) {
                if (event.key === 'F3') {
                    // Check for discount modal first
                    var $discountModal = $('#posEditDiscountModal');
                    if (($discountModal.hasClass('in') || $discountModal.hasClass('show') || $discountModal.is(':visible')) && $discountModal.length > 0) {
                        event.preventDefault();
                        var $updateBtn = $discountModal.find('button#posEditDiscountModalUpdate');
                        if ($updateBtn.length && $updateBtn.is(':visible')) {
                            $updateBtn.trigger('click');
                        }
                    }
                    // Check for suspend modal
                    else {
                        var $suspendModal = $('#confirmSuspendModal');
                        if (($suspendModal.hasClass('in') || $suspendModal.hasClass('show') || $suspendModal.is(':visible')) && $suspendModal.length > 0) {
                            event.preventDefault();
                            var $saveBtn = $suspendModal.find('button#pos-suspend');
                            if ($saveBtn.length && $saveBtn.is(':visible')) {
                                $saveBtn.trigger('click');
                            }
                        }
                    // Check for payment modal
                        else {
                    var $paymentModal = $('#modal_payment');
                    if (($paymentModal.hasClass('in') || $paymentModal.hasClass('show') || $paymentModal.is(':visible')) && $paymentModal.length > 0) {
                        event.preventDefault();
                        var $finalizeBtn = $('#pos-save');
                        if ($finalizeBtn.length && $finalizeBtn.is(':visible')) {
                            $finalizeBtn.trigger('click');
                                }
                            }
                        }
                    }
                }
            });

            // Global F7 keyboard shortcut for Suspend (works from anywhere on POS screen)
            $(document).on('keydown', function(event) {
                if (event.key === 'F7') {
                    event.preventDefault();
                    // Only trigger the first visible suspend button to avoid multiple triggers
                    var $suspendBtn = $('button[data-pay_method="suspend"]:visible:first');
                    if ($suspendBtn.length && !$suspendBtn.is(':disabled')) {
                        $suspendBtn.trigger('click');
                    }
                }
            });

            // Global F10 keyboard shortcut for Add Customer (works from anywhere on POS screen)
            $(document).on('keydown', function(event) {
                if (event.key === 'F10') {
                    event.preventDefault();
                    var $addCustomerBtn = $('.add_new_customer');
                    if ($addCustomerBtn.length && $addCustomerBtn.is(':visible') && !$addCustomerBtn.is(':disabled')) {
                        $addCustomerBtn.trigger('click');
                    }
                }
            });

            // Global F11 keyboard shortcut for View Suspend Sales (works from anywhere on POS screen)
            $(document).on('keydown', function(event) {
                if (event.key === 'F11') {
                    event.preventDefault();
                    var $viewSuspendBtn = $('#view_suspended_sales');
                    if ($viewSuspendBtn.length && $viewSuspendBtn.is(':visible') && !$viewSuspendBtn.is(':disabled')) {
                        $viewSuspendBtn.trigger('click');
                    }
                }
            });


			const functionalKeys = ['F1', 'F2', 'F3', 'F4', 'F5', 'F6', 'F7', 'F8', 'F9', 'F10', 'F11', '+', '-', 'Enter'];
            $(document).on('keydown', 'input#search_product_barcode_type_check, .pos_quantity, .pos_unit_price, .pos_unit_price_inc_tax, input#send_for_sell_return_invoice_no', function (event) {

                
                if (functionalKeys.includes(event.key)) {
                    event.preventDefault();
					
                    if (event.key == "F1") {
                        // Check if suspended sales modal is open first
                        if (isSuspendedSalesModalOpen()) {
                            // F1 - Edit Sale in Suspended Sales modal (first visible edit link)
                            var $editSaleBtn = $('.view_modal a.bg-blue.p-10, .view_modal a.small-box-footer.bg-blue').filter(function() {
                                return $(this).text().toLowerCase().includes('edit');
                            }).first();
                            if ($editSaleBtn.length && $editSaleBtn.is(':visible')) {
                                $editSaleBtn.trigger('click');
                            }
                        }
                        // Check if Select Serial button exists and is visible/enabled in the last row
                        else {
                            var lastRow = $('#pos_table tbody').find('tr').last();
                        var $selectSerialBtn = lastRow.find('button:contains("Select Serial")');
                        if ($selectSerialBtn.length > 0 && $selectSerialBtn.is(':visible') && !$selectSerialBtn.is(':disabled')) {
                            // Get the modal target from the button
                            var modalTarget = $selectSerialBtn.attr('data-target');
                            if (modalTarget) {
                                // Open the serial modal
                                $(modalTarget).modal('show');
                            } else {
                                // Fallback: trigger button click
                                $selectSerialBtn.trigger('click');
                            }
                        } else {
                            // Default behavior: Focus on quantity input
                            var qty_element = lastRow.find('.pos_quantity');
                            if (qty_element.length) {
                                qty_element.focus();
                                qty_element.select();
                                }
                            }
                        }
                    }	
                    if (event.key == "F2") {
                        // Check for serial modal
                        var $serialModal = $('.serial_modal[id^="sell_serial_numberModel"]:visible');
                        if ($serialModal.length > 0) {
                            var $saveBtn = $serialModal.find('button.btn-primary[data-dismiss="modal"]');
                            if ($saveBtn.length && $saveBtn.is(':visible')) {
                                $saveBtn.trigger('click');
                            }
                        } else {
                            // Default behavior: Cash Sell
                            $('#cash_sell_btn').trigger('click');
                        }
                    }	
                    if (event.key == "F3") {
                        // Check for discount modal first
                        var $discountModal = $('#posEditDiscountModal');
                        if (($discountModal.hasClass('in') || $discountModal.hasClass('show') || $discountModal.is(':visible')) && $discountModal.length > 0) {
                            var $updateBtn = $discountModal.find('button#posEditDiscountModalUpdate');
                            if ($updateBtn.length && $updateBtn.is(':visible')) {
                                $updateBtn.trigger('click');
                            }
                        }
                        // Check for suspend modal
                        else {
                            var $suspendModal = $('#confirmSuspendModal');
                            if (($suspendModal.hasClass('in') || $suspendModal.hasClass('show') || $suspendModal.is(':visible')) && $suspendModal.length > 0) {
                                var $saveBtn = $suspendModal.find('button#pos-suspend');
                                if ($saveBtn.length && $saveBtn.is(':visible')) {
                                    $saveBtn.trigger('click');
                                }
                            }
                        // Check for payment modal
                            else {
                        var $paymentModal = $('#modal_payment');
                        if (($paymentModal.hasClass('in') || $paymentModal.hasClass('show') || $paymentModal.is(':visible')) && $paymentModal.length > 0) {
                            var $finalizeBtn = $('#pos-save');
                            if ($finalizeBtn.length && $finalizeBtn.is(':visible')) {
                                $finalizeBtn.trigger('click');
                            }
                        } else {
                            // Otherwise, reset POS form (original F3 behavior)
                            reset_pos_form();
                                }
                            }
                        }
                    }
                    if (event.key == "F4") {
                        // Check if suspended sales modal is open first
                        if (isSuspendedSalesModalOpen()) {
                            // F4 - Delete in Suspended Sales modal (first visible delete link)
                            var $deleteBtn = $('.view_modal a.delete-sale.is_suspended, .view_modal a.is_suspended').filter(function() {
                                return $(this).hasClass('delete-sale') || $(this).hasClass('bg-red');
                            }).first();
                            if ($deleteBtn.length && $deleteBtn.is(':visible')) {
                                $deleteBtn.trigger('click');
                            }
                        } else {
                            // Default behavior: Credit Sale
                        $('.is_credit_sale').trigger('click');
                        }
                    }
                    if (event.key == "F5") {
                        // Check if suspended sales modal is open first
                        if (isSuspendedSalesModalOpen()) {
                            // F5 - Close Suspended Sales modal
                            var $closeBtn = $('.view_modal button[data-dismiss="modal"], .view_modal .modal-footer button[data-dismiss="modal"]').first();
                            if ($closeBtn.length && $closeBtn.is(':visible')) {
                                $closeBtn.trigger('click');
                            }
                        }
                        // Check if contact modal is open
                        else {
                            var $contactModal = $('.contact_modal');
                            if (($contactModal.hasClass('in') || $contactModal.hasClass('show') || $contactModal.is(':visible')) && $contactModal.length > 0) {
                                // F5 - Close Contact modal
                                var $closeBtn = $contactModal.find('button[data-dismiss="modal"]').first();
                                if ($closeBtn.length && $closeBtn.is(':visible')) {
                                    $closeBtn.trigger('click');
                                }
                            }
                            // Check if payment modal is open
                            else {
                                var $paymentModal = $('#modal_payment');
                                if (($paymentModal.hasClass('in') || $paymentModal.hasClass('show') || $paymentModal.is(':visible')) && $paymentModal.length > 0) {
                                    // F5 - Close Payment modal
                                    var $closeBtn = $paymentModal.find('button[data-dismiss="modal"]').first();
                                    if ($closeBtn.length && $closeBtn.is(':visible')) {
                                        $closeBtn.trigger('click');
                                    }
                                } else {
                                    // Default behavior: Card Payment
                                    $('button[data-pay_method="card"]:visible:first').trigger('click');
                                }
                            }
                        }
                    }	                    
                    
                    if (event.key == "F6") {
                        $('#pos-finalize').trigger('click');
                    }	         
                    
                    if (event.key == "F7") {
                            // Only trigger the first visible suspend button to avoid multiple triggers
                            var $suspendBtn = $('button[data-pay_method="suspend"]:visible:first');
                            if ($suspendBtn.length && !$suspendBtn.is(':disabled')) {
                                $suspendBtn.trigger('click');
                            }
                    }	
                    if (event.key == "F8") {
                        var lastRow = $('#pos_table tbody').find('tr').last();
                        var row_element = lastRow.find('.pricemodel_btn');
                        row_element.trigger('click');    
                    }	   
                    
                    if (event.key == "F9") {
                        $('#pos-edit-discount').trigger('click');
                    }	

                    if (event.key == "F10") {
                        var $addCustomerBtn = $('.add_new_customer');
                        if ($addCustomerBtn.length && $addCustomerBtn.is(':visible') && !$addCustomerBtn.is(':disabled')) {
                            $addCustomerBtn.trigger('click');
                        }
                    }
                    if (event.key == "F11") {
                        var $viewSuspendBtn = $('#view_suspended_sales');
                        if ($viewSuspendBtn.length && $viewSuspendBtn.is(':visible') && !$viewSuspendBtn.is(':disabled')) {
                            $viewSuspendBtn.trigger('click');
                        }
                    }	
            
				}
            });

			$('input.payment-amount.input_number, #change_return_method, #sale_note, #staff_note').on('keydown', function (event) {
				const functionalKeys = ['Enter'];
				if (functionalKeys.includes(event.key)) {
					if ($('#pos-save').length > 0) {
						$('#pos-save').trigger('click');    
				
					}
				}
			})

			$('#additional_notes').on('keydown', function (event) {
				const functionalKeys = ['Enter'];
				if (functionalKeys.includes(event.key)) {
					if ($('#pos-suspend').length > 0) {
						$('#pos-suspend').trigger('click');    
					}
				}
			})


			$('#discount_amount_modal, #discount_type_modal').on('keydown', function (event) {
				const functionalKeys = ['Enter'];
				if (functionalKeys.includes(event.key)) {
					if ($('#posEditDiscountModalUpdate').length > 0) {
						$('#posEditDiscountModalUpdate').trigger('click');    
					}
				}

				// setMouseInInput()
			})

			// Handle Enter key in Card transaction details modal to trigger Finalize Payment
			$(document).on('keydown', '#card_details_modal input, #card_details_modal select', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					event.stopPropagation();
					// Trigger Finalize Payment button
					$('#pos-save-card').trigger('click');
					return false;
				}
			});

			// Price Modal: Auto-focus Unit Price input when modal opens
			$(document).on('shown.bs.modal', '.row_edit_product_price_model', function() {
				var $modal = $(this);
				var $unitPriceInput = $modal.find('input.pos_unit_price');
				if ($unitPriceInput.length && $unitPriceInput.is(':visible')) {
					setTimeout(function() {
						$unitPriceInput.focus().select();
					}, 100);
				}
			});

			// Price Modal: Enter key navigation - Unit Price → Discount Amount → Close Button
			$(document).on('keydown', '.row_edit_product_price_model input.pos_unit_price', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					var $modal = $(this).closest('.row_edit_product_price_model');
					var $discountInput = $modal.find('input.row_discount_amount');
					
					// If discount input is visible, move to it
					if ($discountInput.length && $discountInput.is(':visible')) {
						$discountInput.focus().select();
					} else {
						// If discount is hidden, go to close button
						var $closeBtn = $modal.find('button[data-dismiss="modal"]');
						if ($closeBtn.length) {
							$closeBtn.focus();
							setTimeout(function() {
								$closeBtn.trigger('click');
							}, 50);
						}
					}
					return false;
				}
			});

			// Price Modal: Enter key on Discount Amount → Close Button
			$(document).on('keydown', '.row_edit_product_price_model input.row_discount_amount', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					var $modal = $(this).closest('.row_edit_product_price_model');
					var $closeBtn = $modal.find('button[data-dismiss="modal"]');
					if ($closeBtn.length) {
						$closeBtn.focus();
						setTimeout(function() {
							$closeBtn.trigger('click');
						}, 50);
					}
					return false;
				}
			});

			// Payment Modal: Auto-focus Amount input when modal opens
			$(document).on('shown.bs.modal', '#modal_payment', function() {
				setTimeout(function() {
					var $modal = $(this);
					var $amountInput = $modal.find('input.payment-amount:first');
					if ($amountInput.length && $amountInput.is(':visible')) {
						$amountInput.focus().select();
					}
				}.bind(this), 150);
			});

			// Payment Modal: Navigation tracking for Enter key sequence
			var paymentModalFirstEnter = true;

			// Reset navigation state when modal opens
			$(document).on('shown.bs.modal', '#modal_payment', function() {
				paymentModalFirstEnter = true;
			});

			// Payment Modal: Disable Enter key behavior on Amount input
			$(document).on('keydown', '#modal_payment input.payment-amount', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					return false;
				}
			});

			// Payment Modal: Add F1 label to Add Payment Row button on open
			$(document).on('shown.bs.modal', '#modal_payment', function() {
				var $btn = $('#modal_payment').find('button#add-payment-row');
				if ($btn.length && !$btn.find('small.shortcut-label').length) {
					var html = $btn.html();
					$btn.html(html + ' <small class="shortcut-label" style="font-size:0.95em;">(F1)</small>');
				}

				// Add (F2) hint next to each removable row's close (X) button
				$('#modal_payment .payment_row .remove_payment_row').each(function() {
					var $xBtn = $(this);
					if (!$xBtn.next('span.shortcut-label').length) {
						$xBtn.after('<span class="shortcut-label" style="margin-left:6px;">F2</span>');
					}
				});
			});

			// Payment Modal: Global F1 shortcut to add a payment row when modal is visible
			$(document).on('keydown', function(event) {
				if (event.key === 'F1') {
					var $paymentModal = $('#modal_payment');
					if ($paymentModal.length && ($paymentModal.hasClass('in') || $paymentModal.hasClass('show') || $paymentModal.is(':visible'))) {
						event.preventDefault();
						$('#add-payment-row').trigger('click');
						return false;
					}
				}

				// F2 behavior
				if (event.key === 'F2') {
					// 1) If a confirmation dialog is open, confirm it first
					var $openDialog = $('.modal.in:visible, .modal.show:visible').not('#modal_payment').last();
					if ($openDialog.length) {
						var $okBtn = $openDialog.find('button[data-bb-handler="confirm"]:visible, .bootbox .btn-primary:visible, .swal2-confirm:visible, button:contains("OK"):visible, button:contains("Yes"):visible, .modal-footer .btn-primary:visible').first();
						if ($okBtn.length) {
							event.preventDefault();
							$okBtn.trigger('click');
					return false;
				}
					}

					// 2) Otherwise close current payment row (or last removable)
					var $paymentModal = $('#modal_payment');
					if ($paymentModal.length && ($paymentModal.hasClass('in') || $paymentModal.hasClass('show') || $paymentModal.is(':visible'))) {
						event.preventDefault();
						var $focusedRow = $(document.activeElement).closest('.payment_row');
						var $targetRow = $focusedRow.length ? $focusedRow : $paymentModal.find('#payment_rows_div .payment_row').last();
						var $removeBtn = $targetRow.find('.remove_payment_row');
						if ($removeBtn.length) { $removeBtn.trigger('click'); }
						return false;
					}
				}

				// Also handle F2 when focus is inside any open Bootstrap/Bootbox modal (OK/Confirm)
			});

			$(document).on('keydown', '.modal.in, .modal.show, .bootbox.modal', function(event) {
				if (event.key === 'F2') {
					var $dlg = $(this);
					if ($dlg.is('#modal_payment')) { return; }
					var $okBtn = $dlg.find('button[data-bb-handler="confirm"]:visible, .swal2-confirm:visible, .modal-footer .btn-primary:visible, .bootbox .btn-primary:visible, .modal-footer .btn-danger:visible, button:contains("OK"):visible, button:contains("Yes"):visible').first();
					if ($okBtn.length) {
						event.preventDefault();
						$okBtn.trigger('click');
						return false;
					}
				}
			});

			// Payment Modal: Disable Enter key on Add Payment Row button
			$(document).on('keydown', '#modal_payment #add-payment-row', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					return false;
				}
			});

			// After Add Payment Row button is clicked, focus the new/current Amount input
			$(document).on('click', '#modal_payment #add-payment-row', function() {
				setTimeout(function() {
					var $lastAmountInput = $('#modal_payment').find('input.payment-amount').last();
					if ($lastAmountInput.length) {
						$lastAmountInput.focus().select();
					}
				}, 200);
			});

			// Payment Modal: Disable Enter key on Payment Method select
			$(document).on('keydown', '#modal_payment select.payment_types_dropdown', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					return false;
				}
			});

			// Payment Modal: Disable Enter key inside select2 search field
			$(document).on('keydown', '#modal_payment .select2-search__field', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					return false;
				}
			});

			// Customer Modal: Auto-select Individual radio button and focus First Name when modal opens
			$(document).on('shown.bs.modal', '.contact_modal', function() {
				var $modal = $(this);
				
				// Auto-select Individual radio button
				var $individualRadio = $modal.find('input[name="contact_type_radio"][value="individual"]');
				if ($individualRadio.length && !$individualRadio.is(':checked')) {
					$individualRadio.prop('checked', true).trigger('change');
				}
				
				// Auto-focus First Name input after a short delay to ensure fields are visible
				setTimeout(function() {
					var $firstNameInput = $modal.find('input[name="first_name"]');
					if ($firstNameInput.length && $firstNameInput.is(':visible')) {
						$firstNameInput.focus().select();
					} else {
						// If First Name is not visible yet, wait a bit more for the individual fields to show
						setTimeout(function() {
							$firstNameInput = $modal.find('input[name="first_name"]');
							if ($firstNameInput.length && $firstNameInput.is(':visible')) {
								$firstNameInput.focus().select();
							}
						}, 100);
					}
				}, 200);
			});

			// Customer Modal: Enter key on Individual radio button → Focus First Name
			$(document).on('keydown', '.contact_modal input[name="contact_type_radio"][value="individual"]', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					var $modal = $(this).closest('.contact_modal');
					var $firstNameInput = $modal.find('input[name="first_name"]');
					if ($firstNameInput.length && $firstNameInput.is(':visible')) {
						$firstNameInput.focus().select();
					}
					return false;
				}
			});

			// Product Name Click: Show Last Purchase Details Modal
			$(document).on('click', '#pos_table .product-name-clickable', function(e) {
				e.preventDefault();
				e.stopPropagation();
				
				var productId = $(this).data('product-id');
				var variationId = $(this).data('variation-id');
				var productName = $(this).data('product-name');
				
				// Update modal title
				$('#productPurchaseModalLabel').text('Last Purchase Details - ' + productName);
				
				// Show modal with loading
				$('#product_purchase_details_modal').modal('show');
				$('#product_purchase_details_content').html('<div class="text-center" style="padding: 20px;"><i class="fa fa-spinner fa-spin fa-2x"></i><p>Loading purchase details...</p></div>');
				
				// Get location_id from the form
				var locationId = $('input#location_id').val();
				
				// AJAX call to get last purchase details
				$.ajax({
					url: '/sale_pos/get-product-last-purchase',
					method: 'GET',
					data: {
						product_id: productId,
						variation_id: variationId,
						location_id: locationId
					},
					success: function(response) {
						if (response.success) {
							var html = '<div class="table-responsive">';
							html += '<table class="table table-bordered" style="margin-bottom: 0;">';
							
							// If both purchase and opening stock exist
							if (response.has_both) {
								// Row 1: Product Name | Last Purchase Price
								html += '<tr>';
								html += '<th style="width: 35%; background-color: #f5f5f5;">Product Name:</th>';
								html += '<td colspan="2"><strong>' + (response.data.product_name || productName) + '</strong></td>';
								html += '</tr>';
								
								// Row: Current Stock (if stock enabled)
								if (response.data.enable_stock == 1) {
									html += '<tr>';
									html += '<th style="background-color: #f5f5f5;">Current Stock:</th>';
									var stockColor = parseFloat(response.data.current_stock) > 0 ? '#28a745' : '#dc3545';
									html += '<td colspan="2"><strong style="color: ' + stockColor + '; font-size: 16px;">' + response.data.current_stock + '</strong></td>';
									html += '</tr>';
								}
								
								// Row 2: Last Purchase Price
								html += '<tr>';
								html += '<th style="background-color: #f5f5f5;">Last Purchase Price:</th>';
								html += '<td colspan="2"><strong style="color: #0b5394; font-size: 16px;">' + response.data.last_purchase_price + '</strong> <small style="color: #666;">(' + (response.data.supplier_name || 'N/A') + ')</small></td>';
								html += '</tr>';
								
								// Row 3: Opening Stock Costing
								html += '<tr>';
								html += '<th style="background-color: #f5f5f5;">Opening Stock Costing:</th>';
								html += '<td colspan="2"><strong style="color: #0b5394; font-size: 16px;">' + response.data.opening_stock_price + '</strong></td>';
								html += '</tr>';
								
								// Row 4: Average Costing Price
								html += '<tr style="background-color: #e8f4f8;">';
								html += '<th style="background-color: #d0e8f0; font-weight: 700;">Average Costing Price:</th>';
								html += '<td colspan="2"><strong style="color: #0b5394; font-size: 18px;">' + response.data.average_costing_price + '</strong></td>';
								html += '</tr>';
								
								// Optional: Show dates
								if (response.data.last_purchase_date) {
									html += '<tr><td colspan="3" style="padding: 8px; font-size: 11px; color: #666; border-top: 2px solid #0b5394;">';
									html += '<strong>Last Purchase Date:</strong> ' + response.data.last_purchase_date;
									if (response.data.opening_stock_date) {
										html += ' | <strong>Opening Stock Date:</strong> ' + response.data.opening_stock_date;
									}
									html += '</td></tr>';
								}
								
								// Show invoice history table if available
								if (response.data.invoice_history && response.data.invoice_history.length > 0) {
									html += '<tr><td colspan="3" style="padding: 15px 0 0 0; border-top: 2px solid #0b5394;"><h5 style="margin: 0 0 10px 0; color: #0b5394;"><strong>Last Purchase Invoice History</strong></h5></td></tr>';
									html += '<tr><td colspan="3" style="padding: 0;">';
									html += '<table class="table table-bordered table-striped" style="margin: 0; width: 100%;">';
									html += '<thead><tr style="background-color: #0b5394; color: #ffffff;">';
									html += '<th style="width: 50px; text-align: center; padding: 8px;">SL</th>';
									html += '<th style="padding: 8px;">Supplier Name</th>';
									html += '<th style="padding: 8px;">Purchase Invoice Number</th>';
									html += '<th style="width: 120px; text-align: center; padding: 8px;">Quantity</th>';
									html += '</tr></thead>';
									html += '<tbody>';
									for (var i = 0; i < response.data.invoice_history.length; i++) {
										var invoice = response.data.invoice_history[i];
										html += '<tr>';
										html += '<td style="text-align: center; padding: 8px;">' + invoice.sl + '</td>';
										html += '<td style="padding: 8px;">' + invoice.supplier_name + '</td>';
										html += '<td style="padding: 8px;"><a href="#" class="view-purchase-invoice" data-transaction-id="' + invoice.transaction_id + '" style="color: #0b5394; text-decoration: underline; cursor: pointer; font-weight: 600;">' + invoice.invoice_no + '</a></td>';
										html += '<td style="text-align: center; padding: 8px; font-weight: 600;">' + (invoice.quantity || '0.00') + '</td>';
										html += '</tr>';
									}
									html += '</tbody>';
									html += '</table>';
									html += '</td></tr>';
								}
							} else {
								// Only one source (either purchase or opening stock)
								html += '<tr><th style="width: 40%; background-color: #f5f5f5;">Product Name:</th><td colspan="2"><strong>' + (response.data.product_name || productName) + '</strong></td></tr>';
								
								// Row: Current Stock (if stock enabled)
								if (response.data.enable_stock == 1) {
									html += '<tr>';
									html += '<th style="background-color: #f5f5f5;">Current Stock:</th>';
									var stockColor = parseFloat(response.data.current_stock) > 0 ? '#28a745' : '#dc3545';
									html += '<td colspan="2"><strong style="color: ' + stockColor + '; font-size: 16px;">' + response.data.current_stock + '</strong></td>';
									html += '</tr>';
								}
								
								// Show source type (Purchase or Opening Stock)
								if (response.data.source_type && response.data.source_type === 'Opening Stock') {
									html += '<tr><th style="background-color: #f5f5f5;">Source:</th><td colspan="2"><span class="label label-info">Opening Stock</span></td></tr>';
								} else {
									html += '<tr><th style="background-color: #f5f5f5;">Last Purchase Supplier:</th><td colspan="2">' + (response.data.supplier_name || 'N/A') + '</td></tr>';
								}
								
								html += '<tr><th style="background-color: #f5f5f5;">Costing Price:</th><td colspan="2"><strong style="color: #0b5394; font-size: 16px;">' + (response.data.purchase_price || 'N/A') + '</strong></td></tr>';
								html += '<tr><th style="background-color: #f5f5f5;">Date:</th><td colspan="2">' + (response.data.purchase_date || 'N/A') + '</td></tr>';
								if (response.data.transaction_ref_no) {
									html += '<tr><th style="background-color: #f5f5f5;">Reference No:</th><td colspan="2">' + response.data.transaction_ref_no + '</td></tr>';
								}
								
								// Show invoice history table if available
								if (response.data.invoice_history && response.data.invoice_history.length > 0) {
									html += '<tr><td colspan="3" style="padding: 15px 0 0 0; border-top: 2px solid #0b5394;"><h5 style="margin: 0 0 10px 0; color: #0b5394;"><strong>Last Purchase Invoice History</strong></h5></td></tr>';
									html += '<tr><td colspan="3" style="padding: 0;">';
									html += '<table class="table table-bordered table-striped" style="margin: 0; width: 100%;">';
									html += '<thead><tr style="background-color: #0b5394; color: #ffffff;">';
									html += '<th style="width: 50px; text-align: center; padding: 8px;">SL</th>';
									html += '<th style="padding: 8px;">Supplier Name</th>';
									html += '<th style="padding: 8px;">Purchase Invoice Number</th>';
									html += '<th style="width: 120px; text-align: center; padding: 8px;">Quantity</th>';
									html += '</tr></thead>';
									html += '<tbody>';
									for (var i = 0; i < response.data.invoice_history.length; i++) {
										var invoice = response.data.invoice_history[i];
										html += '<tr>';
										html += '<td style="text-align: center; padding: 8px;">' + invoice.sl + '</td>';
										html += '<td style="padding: 8px;">' + invoice.supplier_name + '</td>';
										html += '<td style="padding: 8px;"><a href="#" class="view-purchase-invoice" data-transaction-id="' + invoice.transaction_id + '" style="color: #0b5394; text-decoration: underline; cursor: pointer; font-weight: 600;">' + invoice.invoice_no + '</a></td>';
										html += '<td style="text-align: center; padding: 8px; font-weight: 600;">' + (invoice.quantity || '0.00') + '</td>';
										html += '</tr>';
									}
									html += '</tbody>';
									html += '</table>';
									html += '</td></tr>';
								}
							}
							
							html += '</table>';
							html += '</div>';
							$('#product_purchase_details_content').html(html);
							
							// Bind click event to invoice links
							$(document).off('click', '.view-purchase-invoice').on('click', '.view-purchase-invoice', function(e) {
								e.preventDefault();
								e.stopPropagation();
								
								var transactionId = $(this).data('transaction-id');
								var invoiceNo = $(this).text();
								
								if (!transactionId) {
									toastr.error('Transaction ID not found');
									return;
								}
								
								// Show invoice preview modal
								$('#purchase_invoice_preview_modal').modal('show');
								$('#purchase_invoice_preview_content').html('<div class="text-center" style="padding: 40px;"><i class="fa fa-spinner fa-spin fa-3x"></i><p style="margin-top: 15px;">Loading invoice...</p></div>');
								
								// AJAX call to get invoice details
								$.ajax({
									url: '/purchases/print/' + transactionId,
									method: 'GET',
									success: function(response) {
										if (response.success && response.receipt && response.receipt.html_content) {
											$('#purchase_invoice_preview_content').html(response.receipt.html_content);
											$('#purchase_invoice_preview_modal .modal-title').text('Purchase Invoice - ' + invoiceNo);
											
											// Trigger currency conversion if function exists
											if (typeof __currency_convert_recursively === 'function') {
												var element = $('#purchase_invoice_preview_modal');
												__currency_convert_recursively(element);
											}
										} else {
											$('#purchase_invoice_preview_content').html('<div class="alert alert-danger text-center" style="margin: 20px;"><i class="fa fa-exclamation-triangle"></i> Error loading invoice. Please try again.</div>');
										}
									},
									error: function(xhr, status, error) {
										$('#purchase_invoice_preview_content').html('<div class="alert alert-danger text-center" style="margin: 20px;"><i class="fa fa-exclamation-triangle"></i> Error loading invoice. Please try again.</div>');
										console.error('Error:', error);
									}
								});
							});
						} else {
							$('#product_purchase_details_content').html('<div class="alert alert-info text-center" style="margin: 20px;"><i class="fa fa-info-circle"></i> ' + (response.message || 'No purchase history or opening stock found for this product.') + '</div>');
						}
					},
					error: function(xhr, status, error) {
						$('#product_purchase_details_content').html('<div class="alert alert-danger text-center" style="margin: 20px;"><i class="fa fa-exclamation-triangle"></i> Error loading purchase details. Please try again.</div>');
						console.error('Error:', error);
					}
				});
			});

			// Customer Modal: Enter key on First Name → Focus Mobile
			$(document).on('keydown', '.contact_modal input[name="first_name"]', function(event) {
				if (event.key === 'Enter') {
					event.preventDefault();
					var $modal = $(this).closest('.contact_modal');
					var $mobileInput = $modal.find('input[name="mobile"]');
					if ($mobileInput.length && $mobileInput.is(':visible')) {
						$mobileInput.focus().select();
					}
					return false;
				}
			});

			// Customer Modal: F3 keyboard shortcut for Save button (only when customer modal is open)
			$(document).on('keydown', function(event) {
				if (event.key === 'F3') {
					var $customerModal = $('.contact_modal');
					// Only trigger Save if customer modal is open (not payment modal)
					if (($customerModal.hasClass('in') || $customerModal.hasClass('show') || $customerModal.is(':visible')) && 
						$customerModal.length > 0 && 
						!$('#modal_payment').is(':visible')) {
						event.preventDefault();
						var $saveBtn = $customerModal.find('button[type="submit"]');
						if ($saveBtn.length && $saveBtn.is(':visible')) {
							$saveBtn.trigger('click');
						}
					}
				}
			});

			// Customer Modal: F3 in input fields within customer modal → Save
			$(document).on('keydown', '.contact_modal input, .contact_modal select, .contact_modal textarea', function(event) {
				if (event.key === 'F3') {
					event.preventDefault();
					var $modal = $(this).closest('.contact_modal');
					var $saveBtn = $modal.find('button[type="submit"]');
					if ($saveBtn.length && $saveBtn.is(':visible')) {
						$saveBtn.trigger('click');
					}
					return false;
				}
			});

			// Select Serial Button Click: Set quantity to 0 when modal is about to open
			$(document).on('click', '.btn-modal[data-target^="#sell_serial_numberModel"]', function() {
				var targetModalId = $(this).attr('data-target');
				var rowCountMatch = targetModalId.match(/sell_serial_numberModel(\d+)/);
				if (rowCountMatch && rowCountMatch[1]) {
					var rowCount = rowCountMatch[1];
					var $quantityInput = $('#quentity_box' + rowCount).find('input');
					if ($quantityInput.length) {
						// Set quantity to 0 when Select Serial is clicked
						__write_number($quantityInput, 0);
						$quantityInput.change();
					}
					
					// Ensure Color and Storage are visible in product details
					var $productRow = $('#pos_table tbody tr.product_row[data-row_index="' + rowCount + '"]');
					if ($productRow.length) {
						var $productCell = $productRow.find('td:first-child');
						var $stockText = $productCell.find('small.text-muted');
						if ($stockText.length) {
							var stockText = $stockText.text();
							// Check if Color/Storage exist in the text but might be hidden
							if (stockText.includes('Color:') || stockText.includes('Storage:')) {
								// Ensure the text is visible
								$stockText.css('display', 'block');
							}
						}
					}
				}
			});

			// Select Serial Modal: Initialize Select2 and auto-focus dropdown when modal opens
			$(document).on('shown.bs.modal', '.serial_modal[id^="sell_serial_numberModel"]', function() {
				var $modal = $(this);
				var $select2Dropdown = $modal.find('select.product_serial_number, select.productserialnumber');
				
				// Initialize Select2 if not already initialized
				if ($select2Dropdown.length && !$select2Dropdown.hasClass('select2-hidden-accessible')) {
					try {
						$select2Dropdown.select2({
							width: '100%',
							dropdownParent: $modal // Ensure dropdown appears within modal context
						});
					} catch(e) {
						// Select2 might already be partially initialized, destroy and reinitialize
						try {
							if ($select2Dropdown.hasClass('select2-hidden-accessible')) {
								$select2Dropdown.select2('destroy');
							}
						} catch(destroyError) {
							// Ignore destroy errors
						}
						$select2Dropdown.select2({
							width: '100%',
							dropdownParent: $modal
						});
					}
				}
				
				// Auto-open Select2 dropdown after a short delay
				setTimeout(function() {
					var $select2 = $modal.find('select.product_serial_number, select.productserialnumber');
					if ($select2.length && $select2.hasClass('select2-hidden-accessible')) {
						// Ensure dropdown parent is set correctly
						var $select2Container = $select2.data('select2');
						if ($select2Container && $select2Container.options.dropdownParent) {
							$select2Container.options.dropdownParent = $modal;
						}
						// Open the Select2 dropdown
						$select2.select2('open');
					}
				}, 100);
			});

			// Select Serial Modal: Handle quantity update and display serial numbers when selected
			$(document).on('change', '.serial_modal select.product_serial_number, .serial_modal select.productserialnumber', function() {
				var $select = $(this);
				var selectedOptions = $select.find(':selected');
				var selectedCount = selectedOptions.length;
				var selectedSerials = [];
				selectedOptions.each(function() {
					selectedSerials.push($(this).val());
				});
				
				var $modal = $select.closest('.serial_modal');
				var modalId = $modal.attr('id');
				
				// Extract row count from modal ID (e.g., "sell_serial_numberModel1" -> "1")
				var rowCountMatch = modalId.match(/sell_serial_numberModel(\d+)/);
				if (rowCountMatch && rowCountMatch[1]) {
					var rowCount = rowCountMatch[1];
					var $quantityInput = $('#quentity_box' + rowCount).find('input');
					
					// Update quantity to match selected serial count
					if ($quantityInput.length) {
						__write_number($quantityInput, selectedCount);
						$quantityInput.change();
					}
					
					// Display selected serial numbers in product details
					var $productRow = $('#pos_table tbody tr.product_row[data-row_index="' + rowCount + '"]');
					if ($productRow.length) {
						var $productCell = $productRow.find('td:first-child');
						var $existingSerialDisplay = $productCell.find('.selected-serials-display');
						
						// Remove existing serial display
						$existingSerialDisplay.remove();
						
						// Get Color and Storage attributes from the product row
						var colorValue = '';
						var storageValue = '';
						
						// Try to extract from existing display text
						var $stockText = $productCell.find('small.text-muted');
						if ($stockText.length) {
							var stockText = $stockText.text();
							// Extract Color
							var colorMatch = stockText.match(/Color:\s*([^|]+)/i);
							if (colorMatch && colorMatch[1]) {
								colorValue = colorMatch[1].trim();
							}
							// Extract Storage
							var storageMatch = stockText.match(/Storage:\s*([^|]+)/i);
							if (storageMatch && storageMatch[1]) {
								storageValue = storageMatch[1].trim();
							}
						}
						
						// Add serial numbers display if any are selected
						if (selectedCount > 0) {
							var serialDisplay = '<small class="selected-serials-display" style="display: block; font-size: 10px; line-height: 1.6; margin-top: 3px; color: #4472C4;">';
							
							// Show Color and Storage if available
							if (colorValue || storageValue) {
								serialDisplay += '<span style="color: #666;">';
								if (colorValue) {
									serialDisplay += '<strong>Color:</strong> ' + colorValue + ' | ';
								}
								if (storageValue) {
									serialDisplay += '<strong>Storage:</strong> ' + storageValue;
								}
								serialDisplay += '</span><br>';
							}
							
							// Show Serial numbers
							serialDisplay += '<strong style="color: #4472C4;">Serials:</strong> ' + selectedSerials.join(', ');
							serialDisplay += '</small>';
							$productCell.append(serialDisplay);
						} else if (colorValue || storageValue) {
							// Show Color/Storage even if no serials selected
							var attrDisplay = '<small class="selected-serials-display" style="display: block; font-size: 10px; line-height: 1.6; margin-top: 3px; color: #666;">';
							if (colorValue) {
								attrDisplay += '<strong>Color:</strong> ' + colorValue;
							}
							if (storageValue) {
								if (colorValue) attrDisplay += ' | ';
								attrDisplay += '<strong>Storage:</strong> ' + storageValue;
							}
							attrDisplay += '</small>';
							$productCell.append(attrDisplay);
						}
					}
				}
			});
			
			// Handle modal save: Also update serial display when Save button is clicked
			$(document).on('click', '.serial_modal button.btn-primary[data-dismiss="modal"]', function() {
				var $modal = $(this).closest('.serial_modal');
				var modalId = $modal.attr('id');
				var rowCountMatch = modalId.match(/sell_serial_numberModel(\d+)/);
				
				if (rowCountMatch && rowCountMatch[1]) {
					var rowCount = rowCountMatch[1];
					var $select = $modal.find('select.product_serial_number, select.productserialnumber');
					var selectedOptions = $select.find(':selected');
					var selectedSerials = [];
					selectedOptions.each(function() {
						selectedSerials.push($(this).val());
					});
					
					// Trigger change event to update display
					$select.trigger('change');
				}
			});

			// Select Serial Modal: F2 keyboard shortcut for Save button
			$(document).on('keydown', function(event) {
				if (event.key === 'F2') {
					var $serialModal = $('.serial_modal[id^="sell_serial_numberModel"]:visible');
					// Only trigger Save if serial modal is open
					if ($serialModal.length > 0) {
						event.preventDefault();
						var $saveBtn = $serialModal.find('button.btn-primary[data-dismiss="modal"]');
						if ($saveBtn.length && $saveBtn.is(':visible')) {
							$saveBtn.trigger('click');
						}
					}
				}
			});

			// Select Serial Modal: F2 in input/select fields within serial modal → Save
			$(document).on('keydown', '.serial_modal[id^="sell_serial_numberModel"] input, .serial_modal[id^="sell_serial_numberModel"] select', function(event) {
				if (event.key === 'F2') {
					event.preventDefault();
					var $modal = $(this).closest('.serial_modal');
					var $saveBtn = $modal.find('button.btn-primary[data-dismiss="modal"]');
					if ($saveBtn.length && $saveBtn.is(':visible')) {
						$saveBtn.trigger('click');
					}
					return false;
				}
			});

			// Also handle F2 when Select2 search field is focused
			$(document).on('keydown', '.serial_modal[id^="sell_serial_numberModel"] .select2-search__field', function(event) {
				if (event.key === 'F2') {
					event.preventDefault();
					var $modal = $(this).closest('.serial_modal');
					var $saveBtn = $modal.find('button.btn-primary[data-dismiss="modal"]');
					if ($saveBtn.length && $saveBtn.is(':visible')) {
						$saveBtn.trigger('click');
					}
					return false;
				}
			});

			// Auto-focus barcode search input after any modal closes (for quick product scanning)
			// Always focus barcode input when payment modal closes (whether saved or just closed)
			$(document).on('hidden.bs.modal', function(event) {
				var $closedModal = $(event.target);
				// Always focus barcode input after modal closes, including payment modal
					setTimeout(function() {
						var $barcodeInput = $('#search_product_barcode_type_check');
						if ($barcodeInput.length && $barcodeInput.is(':visible') && !$barcodeInput.is(':disabled')) {
							$barcodeInput.focus();
						}
				}, 250);
			});

			// Function to add keyboard shortcut labels to buttons
			function addShortcutLabels() {
				// F2 - Cash Sell button
				$('#cash_sell_btn').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F2)</small>');
					}
				});

				// F4 - Credit Sale button
				$('.is_credit_sale').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F4)</small>');
					}
				});

				// F5 - Card Payment button
				$('button[data-pay_method="card"]').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F5)</small>');
					}
				});

				// F6 - Multiple Pay button (ensure caption is visible)
				$('#pos-finalize').each(function() {
					var $btn = $(this);
					if ($btn.length) {
						// Remove any existing labels to avoid duplicates
						$btn.find('small.shortcut-label, span.shortcut-label').remove();
						var currentHtml = $btn.html();
						// Check if button has text content or is icon-only
						if ($btn.text().trim().length > 0 && !currentHtml.includes('(F6)')) {
							$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8; margin-left:5px;">(F6)</small>');
						} else if (!currentHtml.includes('(F6)')) {
							// For icon-only buttons or buttons without visible text
							var $icon = $btn.find('i, img');
							if ($icon.length) {
								$icon.after('<span class="shortcut-label" style="font-size:0.65em; color:#666; margin-left:3px; display:inline-block;">(F6)</span>');
							} else {
								$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F6)</small>');
							}
						}
					}
				});

				// F7 - Suspend button
				$('button[data-pay_method="suspend"]').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F7)</small>');
					}
				});

				// F3 - Save button in Suspend Modal
				$('#confirmSuspendModal button#pos-suspend').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F3)</small>');
					}
				});

				// F8 - Price Model button (added dynamically in product rows)
				$('.pricemodel_btn').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('span.shortcut-label').length && !$btn.attr('title').includes('F8')) {
						var currentTitle = $btn.attr('title') || '';
						$btn.attr('title', currentTitle + ' (F8)');
					}
				});

				// F9 - Edit Discount button
				$('#pos-edit-discount').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.next('span.shortcut-label').length) {
						var currentTitle = $btn.attr('title') || '';
						if (!currentTitle.includes('F9')) {
							$btn.attr('title', (currentTitle ? currentTitle + ' ' : '') + '(F9)');
						}
						// Add visible label after the icon
						$btn.after('<span class="shortcut-label" style="font-size:0.7em; color:#666; margin-left:3px; vertical-align:middle;">(F9)</span>');
					}
				});

				// F10 - Add Customer button
				$('.add_new_customer').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('span.shortcut-label').length) {
						var currentTitle = $btn.attr('title') || '';
						if (currentTitle && !currentTitle.includes('F10')) {
							$btn.attr('title', (currentTitle ? currentTitle + ' | ' : '') + 'F10');
						} else if (!currentTitle) {
							$btn.attr('title', 'F10');
						}
						// Add visible label inside the button
						if (!$btn.find('span.shortcut-label').length) {
							var $icon = $btn.find('i');
							if ($icon.length) {
								$icon.after('<span class="shortcut-label" style="font-size:0.65em; color:#666; margin-left:2px; display:inline-block; line-height:1;">(F10)</span>');
							} else {
								$btn.append('<span class="shortcut-label" style="font-size:0.7em; color:#666; margin-left:2px;">(F10)</span>');
							}
						}
					}
				});

				// F11 - View Suspend Sales button
				$('#view_suspended_sales').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.attr('title').includes('F11')) {
						var currentTitle = $btn.attr('title') || '';
						$btn.attr('title', (currentTitle ? currentTitle + ' | ' : '') + 'F11');
					}
				});

				// Suspended Sales Modal: Add shortcut labels to buttons
				// F1 - Edit Sale button (check for buttons containing "Edit")
				$('.view_modal a.bg-blue.p-10, .view_modal a.small-box-footer.bg-blue').filter(function() {
					return $(this).text().toLowerCase().includes('edit');
				}).each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8; margin-left:5px;">(F1)</small>');
					}
				});

				// F4 - Delete button in Suspended Sales modal
				$('.view_modal a.delete-sale.is_suspended, .view_modal a.is_suspended').filter(function() {
					return $(this).hasClass('delete-sale') || $(this).hasClass('bg-red') || $(this).text().toLowerCase().includes('delete');
				}).each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8; margin-left:5px;">(F4)</small>');
					}
				});

				// F5 - Close button in Suspended Sales modal
				$('.view_modal .modal-footer button[data-dismiss="modal"]').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8; margin-left:5px;">(F5)</small>');
					}
				});

				// F3 - Finalize Payment button in Payment Modal
				$('#modal_payment button#pos-save').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F3)</small>');
					}
				});

				// F5 - Close button in Payment Modal
				$('#modal_payment button[data-dismiss="modal"]').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length && !$btn.find('span.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8; margin-left:5px;">(F5)</small>');
					}
				});

				// F2 - Save button in Serial Modal
				$('.serial_modal[id^="sell_serial_numberModel"] button.btn-primary[data-dismiss="modal"]').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F2)</small>');
					}
				});

				// F3 - Save button in Customer Modal
				$('.contact_modal button[type="submit"]').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.8em; opacity:0.8;">(F3)</small>');
					}
				});

				// F5 - Close button in Customer Modal
				$('.contact_modal button[data-dismiss="modal"]').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8; margin-left:5px;">(F5)</small>');
					}
				});

				// F3 - Update button in Discount Modal
				$('#posEditDiscountModal button#posEditDiscountModalUpdate').each(function() {
					var $btn = $(this);
					if ($btn.length && !$btn.find('small.shortcut-label').length) {
						var currentHtml = $btn.html();
						$btn.html(currentHtml + ' <small class="shortcut-label" style="font-size:0.75em; opacity:0.8;">(F3)</small>');
					}
				});
			}

			// Add shortcut labels on page load and set up observers
			$(document).ready(function() {
				// Call immediately
				addShortcutLabels();
				
				// Call again after a short delay to catch conditionally rendered elements
				setTimeout(addShortcutLabels, 500);
				setTimeout(addShortcutLabels, 1000);

				// Use MutationObserver for better performance to detect new product rows
				if (window.MutationObserver) {
					var $posTable = $('#pos_table tbody');
					if ($posTable.length) {
						var observer = new MutationObserver(function(mutations) {
							mutations.forEach(function(mutation) {
								if (mutation.addedNodes.length) {
									setTimeout(addShortcutLabels, 100);
								}
							});
						});

						observer.observe($posTable[0], {
							childList: true,
							subtree: true
						});
					}
				}

				// Also observe the discount area for Edit Discount button
				if (window.MutationObserver) {
					var $discountArea = $('span[id*="total_discount"], .discount-section').parent();
					if ($discountArea.length) {
						var discountObserver = new MutationObserver(function(mutations) {
							mutations.forEach(function(mutation) {
								if (mutation.addedNodes.length || mutation.type === 'attributes') {
									setTimeout(addShortcutLabels, 100);
								}
							});
						});

						$discountArea.each(function() {
							discountObserver.observe(this, {
								childList: true,
								subtree: true,
								attributes: true
							});
						});
					}
				}
			});

			// Suspend Modal: Auto-focus textarea when modal opens
			$(document).on('shown.bs.modal', '#confirmSuspendModal', function() {
				setTimeout(function() {
					var $modal = $(this);
					var $textarea = $modal.find('textarea#additional_notes');
					if ($textarea.length && $textarea.is(':visible')) {
						$textarea.focus();
					}
				}.bind(this), 100);
			});

			// Suspend Modal: F3 keyboard shortcut for Save button
			$(document).on('keydown', function(event) {
				if (event.key === 'F3') {
					var $suspendModal = $('#confirmSuspendModal');
					// Check for suspend modal
					if (($suspendModal.hasClass('in') || $suspendModal.hasClass('show') || $suspendModal.is(':visible')) && 
						$suspendModal.length > 0 &&
						!$('#posEditDiscountModal').is(':visible') &&
						!$('#modal_payment').is(':visible') &&
						!$('.contact_modal').is(':visible') &&
						!$('.serial_modal[id^="sell_serial_numberModel"]').is(':visible')) {
						event.preventDefault();
						var $saveBtn = $suspendModal.find('button#pos-suspend');
						if ($saveBtn.length && $saveBtn.is(':visible')) {
							$saveBtn.trigger('click');
						}
					}
				}
			});

			// Suspend Modal: F3 in textarea within suspend modal → Save
			$(document).on('keydown', '#confirmSuspendModal textarea, #confirmSuspendModal input', function(event) {
				if (event.key === 'F3') {
					event.preventDefault();
					var $saveBtn = $('#confirmSuspendModal button#pos-suspend');
					if ($saveBtn.length && $saveBtn.is(':visible')) {
						$saveBtn.trigger('click');
					}
					return false;
				}
			});

			// Discount Modal: Auto-select "Fixed" and focus Discount Amount when modal opens
			$(document).on('shown.bs.modal', '#posEditDiscountModal', function() {
				setTimeout(function() {
					var $modal = $(this);
					// Auto-select "Fixed" in Discount Type dropdown
					var $discountTypeSelect = $modal.find('select#discount_type_modal');
					if ($discountTypeSelect.length) {
						$discountTypeSelect.val('fixed').trigger('change');
					}
					
					// Auto-focus Discount Amount input
					var $discountAmountInput = $modal.find('input#discount_amount_modal');
					if ($discountAmountInput.length && $discountAmountInput.is(':visible')) {
						setTimeout(function() {
							$discountAmountInput.focus().select();
						}, 150);
					}
				}.bind(this), 100);
			});

			// Discount Modal: F3 keyboard shortcut for Update button
			$(document).on('keydown', function(event) {
				if (event.key === 'F3') {
					var $discountModal = $('#posEditDiscountModal');
					// Only trigger Update if discount modal is open (not other modals)
					if (($discountModal.hasClass('in') || $discountModal.hasClass('show') || $discountModal.is(':visible')) && 
						$discountModal.length > 0 &&
						!$('#modal_payment').is(':visible') &&
						!$('.contact_modal').is(':visible') &&
						!$('.serial_modal[id^="sell_serial_numberModel"]').is(':visible')) {
						event.preventDefault();
						var $updateBtn = $discountModal.find('button#posEditDiscountModalUpdate');
						if ($updateBtn.length && $updateBtn.is(':visible')) {
							$updateBtn.trigger('click');
						}
					}
				}
			});

			// Discount Modal: F3 in input/select fields within discount modal → Update
			$(document).on('keydown', '#posEditDiscountModal input, #posEditDiscountModal select', function(event) {
				if (event.key === 'F3') {
					event.preventDefault();
					var $updateBtn = $('#posEditDiscountModal button#posEditDiscountModalUpdate');
					if ($updateBtn.length && $updateBtn.is(':visible')) {
						$updateBtn.trigger('click');
					}
					return false;
				}
			});

		// Function to make product grid responsive by overriding inline styles
		function makeProductGridResponsive() {
			// Remove inline width styles from product_list elements
			$('.product_list').each(function() {
				var $item = $(this);
				var currentStyle = $item.attr('style') || '';
				
				// Remove width from inline style if present
				if (currentStyle.includes('width')) {
					var newStyle = currentStyle
						.replace(/width\s*:\s*[^;]+;?/gi, '')
						.replace(/max-width\s*:\s*[^;]+;?/gi, '')
						.replace(/min-width\s*:\s*[^;]+;?/gi, '')
						.trim();
					
					// If style becomes empty or only whitespace, remove the style attribute
					if (!newStyle || newStyle === '' || newStyle === ';') {
						$item.removeAttr('style');
					} else {
						// Clean up any double semicolons or trailing semicolons
						newStyle = newStyle.replace(/;;+/g, ';').replace(/;+$/, '').replace(/^\s*;\s*/, '');
						if (newStyle) {
							$item.attr('style', newStyle);
						} else {
							$item.removeAttr('style');
						}
					}
				}
			});
			
			// Ensure product list container is responsive
			$('#product_list_div, .product_list_container').css({
				'width': '100%',
				'max-width': '100%',
				'overflow-x': 'hidden',
				'box-sizing': 'border-box'
			});
		}

		// Function to disable animation and set quantity to 0 for product rows with Select Serial button
		function disableAnimationForSerialProducts() {
			$('#pos_table tbody tr.product_row').each(function() {
				var $row = $(this);
				// Check if row contains Select Serial button (.btn-modal or button with text "Select Serial")
				var hasSelectSerial = $row.find('.btn-modal').length > 0 || 
									  $row.find('button').filter(function() {
										  return $(this).text().trim().toLowerCase().includes('select serial');
									  }).length > 0;
				
				if (hasSelectSerial) {
					$row.addClass('no-animation-product');
					
					// Set quantity to 0 if product has Select Serial button and no serials are selected
					var rowIndex = $row.attr('data-row_index');
					if (rowIndex) {
						var $quantityInput = $('#quentity_box' + rowIndex).find('input.pos_quantity');
						if ($quantityInput.length) {
							// Check if serials are already selected
							var $selectSerialBtn = $row.find('.btn-modal[data-target^="#sell_serial_numberModel"]');
							var hasSelectedSerials = false;
							
							if ($selectSerialBtn.length) {
								var modalId = $selectSerialBtn.attr('data-target');
								var rowCountMatch = modalId.match(/sell_serial_numberModel(\d+)/);
								if (rowCountMatch && rowCountMatch[1]) {
									var modalRowCount = rowCountMatch[1];
									// Check if serials are selected in hidden input or select
									var $serialInput = $row.find('input[name*="[product_serial_number]"]');
									var $serialSelect = $('#product_serial_number' + modalRowCount);
									
									if ($serialInput.length && $serialInput.val()) {
										var serialValue = $serialInput.val().toString().trim();
										if (serialValue && serialValue !== '' && serialValue !== '[]') {
											hasSelectedSerials = true;
										}
									}
									if ($serialSelect.length && $serialSelect.find(':selected').length > 0) {
										hasSelectedSerials = true;
									}
								}
							}
							
							// If no serials selected, set quantity to 0
							if (!hasSelectedSerials) {
								__write_number($quantityInput, 0);
								$quantityInput.change();
							}
						}
					}
				} else {
					$row.removeClass('no-animation-product');
				}
			});
		}

		// Run on page load
		$(document).ready(function() {
			disableAnimationForSerialProducts();
			makeProductGridResponsive();
			
			// Re-apply responsive styles after a short delay to ensure all elements are loaded
			setTimeout(function() {
				makeProductGridResponsive();
			}, 500);
			
			// Handle window resize
			var resizeTimer;
			$(window).on('resize', function() {
				clearTimeout(resizeTimer);
				resizeTimer = setTimeout(function() {
					makeProductGridResponsive();
				}, 250);
			});
			
			// Listen for AJAX complete events in case products are loaded via AJAX
			$(document).ajaxComplete(function(event, xhr, settings) {
				// Check if the AJAX request might be loading products
				if (settings.url && (
					settings.url.includes('product') || 
					settings.url.includes('search') ||
					settings.url.includes('category') ||
					settings.url.includes('brand')
				)) {
					setTimeout(makeProductGridResponsive, 200);
				}
			});
		});

		// Run when new product rows are added (observe POS table changes)
		if (window.MutationObserver) {
			var $posTable = $('#pos_table tbody');
			if ($posTable.length) {
				var animationObserver = new MutationObserver(function(mutations) {
					mutations.forEach(function(mutation) {
						if (mutation.addedNodes.length) {
							setTimeout(disableAnimationForSerialProducts, 100);
						}
					});
				});

				animationObserver.observe($posTable[0], {
					childList: true,
					subtree: false
				});
			}
			
			// Observe product list container for responsive updates
			var $productListContainer = $('#product_list_div, .product_list_container');
			if ($productListContainer.length) {
				var productGridObserver = new MutationObserver(function(mutations) {
					mutations.forEach(function(mutation) {
						if (mutation.addedNodes.length || mutation.type === 'attributes') {
							setTimeout(makeProductGridResponsive, 100);
						}
					});
				});

				$productListContainer.each(function() {
					productGridObserver.observe(this, {
						childList: true,
						subtree: true,
						attributes: true,
						attributeFilter: ['style', 'class']
					});
				});
			}
			
			// Also observe document body for dynamically added product lists
			var bodyObserver = new MutationObserver(function(mutations) {
				mutations.forEach(function(mutation) {
					var hasProductList = false;
					if (mutation.addedNodes.length) {
						Array.from(mutation.addedNodes).forEach(function(node) {
							if (node.nodeType === 1) { // Element node
								if (node.classList && node.classList.contains('product_list')) {
									hasProductList = true;
								} else if (node.querySelector && node.querySelector('.product_list')) {
									hasProductList = true;
								}
							}
						});
						if (hasProductList) {
							setTimeout(makeProductGridResponsive, 100);
						}
					}
				});
			});
			
			bodyObserver.observe(document.body, {
				childList: true,
				subtree: true
			});
		}

		// Function to validate zero quantity products
		function validateZeroQuantity() {
			var zeroQtyProducts = [];
			var allValid = true;
			
			$('#pos_table tbody tr.product_row').each(function() {
				var $row = $(this);
				var rowIndex = $row.attr('data-row_index');
				
				if (rowIndex) {
					var $quantityInput = $('#quentity_box' + rowIndex).find('input.pos_quantity');
					if ($quantityInput.length) {
						// Read quantity using the same method as the POS system
						var qty = __read_number($quantityInput);
						// Also check the raw value to ensure we catch 0.00, 0, empty, etc.
						var rawValue = $quantityInput.val();
						var numericQty = parseFloat(qty) || 0;
						
						// Check if quantity is 0 or less (including negative, empty, null, etc.)
						if (numericQty <= 0 || isNaN(numericQty) || rawValue === '' || rawValue === '0' || rawValue === '0.00') {
							var productName = $row.find('td:first-child strong').text().trim() || 'Product';
							// Avoid duplicates
							if (zeroQtyProducts.indexOf(productName) === -1) {
								zeroQtyProducts.push(productName);
							}
							allValid = false;
						}
					}
				}
			});
			
			if (!allValid && zeroQtyProducts.length > 0) {
				var productList = zeroQtyProducts.join(', ');
				if (zeroQtyProducts.length === 1) {
					toastr.error('Cannot complete sale. Product with zero quantity: ' + productList + '. Please set quantity or remove the product.', 'Zero Quantity Error');
				} else {
					toastr.error('Cannot complete sale. Products with zero quantity: ' + productList + '. Please set quantities or remove these products.', 'Zero Quantity Error');
				}
				return false;
			}
			
			return true;
		}

		// Function to validate serial numbers before sale completion
		function validateSerialNumbers() {
			var invalidProducts = [];
			var allValid = true;
			
			$('#pos_table tbody tr.product_row').each(function() {
				var $row = $(this);
				var $selectSerialBtn = $row.find('.btn-modal[data-target^="#sell_serial_numberModel"]');
				
				// Check if product requires serial selection
				if ($selectSerialBtn.length) {
					var modalId = $selectSerialBtn.attr('data-target');
					var rowCountMatch = modalId.match(/sell_serial_numberModel(\d+)/);
					
					if (rowCountMatch && rowCountMatch[1]) {
						var rowCount = rowCountMatch[1];
						var productName = $row.find('td:first-child strong').text().trim() || 'Product';
						
						// Check if serials are selected
						var $serialSelect = $('#product_serial_number' + rowCount);
						var $serialInput = $row.find('input[name*="[product_serial_number]"]');
						var hasSelectedSerials = false;
						
						// Check in Select2 dropdown
						if ($serialSelect.length) {
							var selectedCount = $serialSelect.find(':selected').length;
							if (selectedCount > 0) {
								hasSelectedSerials = true;
							}
						}
						
						// Check in hidden input (for edit mode)
						if ($serialInput.length && $serialInput.val()) {
							var serialValue = $serialInput.val().toString().trim();
							// Check if it's an array string like "[]" or has actual values
							if (serialValue && serialValue !== '' && serialValue !== '[]' && serialValue !== 'null') {
								// Check if it's a JSON array with values
								try {
									var serialArray = JSON.parse(serialValue);
									if (Array.isArray(serialArray) && serialArray.length > 0) {
										hasSelectedSerials = true;
									} else if (!Array.isArray(serialArray) && serialValue.length > 0) {
										hasSelectedSerials = true;
									}
								} catch(e) {
									// If not JSON, check if it's a comma-separated string
									if (serialValue.length > 0) {
										hasSelectedSerials = true;
									}
								}
							}
						}
						
						// Check quantity - if quantity > 0, serials must be selected
						var $quantityInput = $('#quentity_box' + rowCount).find('input.pos_quantity');
						if ($quantityInput.length) {
							var qty = __read_number($quantityInput);
							if (qty > 0 && !hasSelectedSerials) {
								invalidProducts.push(productName);
								allValid = false;
							}
						}
					}
				}
			});
			
			if (!allValid && invalidProducts.length > 0) {
				var productList = invalidProducts.join(', ');
				if (invalidProducts.length === 1) {
					toastr.error('Please select serial number(s) for: ' + productList, 'Serial Number Required');
				} else {
					toastr.error('Please select serial number(s) for the following products: ' + productList, 'Serial Numbers Required');
				}
				return false;
			}
			
			return true;
		}

		// Combined validation function
		function validateSaleCompletion() {
			// First check for zero quantity products
			if (!validateZeroQuantity()) {
				return false;
			}
			
			// Then check for serial number requirements
			if (!validateSerialNumbers()) {
				return false;
			}
			
			return true;
		}

		// Intercept form submission to validate before sale completion - MULTIPLE INTERCEPT POINTS
		// Native addEventListener with capture phase for earliest interception
		document.addEventListener('submit', function(e) {
			var form = e.target;
			if (form && form.id === 'add_pos_sell_form') {
				if (!validateSaleCompletion()) {
					e.preventDefault();
					e.stopPropagation();
					e.stopImmediatePropagation();
					return false;
				}
			}
		}, true); // Capture phase - runs BEFORE jQuery handlers

		// jQuery handler as backup
		$(document).on('submit', '#add_pos_sell_form', function(e) {
			if (!validateSaleCompletion()) {
				e.preventDefault();
				e.stopPropagation();
				return false;
			}
		});

		// Intercept pos-save button clicks
		$(document).on('click', '#pos-save, #pos-save-card', function(e) {
			if (!validateSaleCompletion()) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			}
		});

		// Intercept pos-finalize button clicks
		$(document).on('click', '#pos-finalize', function(e) {
			if (!validateSaleCompletion()) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			}
		});

		// Intercept suspend button clicks
		$(document).on('click', 'button[data-pay_method="suspend"], #pos-suspend', function(e) {
			if (!validateSaleCompletion()) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			}
		});

		// Intercept credit sale button clicks
		$(document).on('click', '.is_credit_sale, button[data-pay_method="credit_sale"]', function(e) {
			if (!validateSaleCompletion()) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			}
		});

		// Intercept cash sell button clicks - CRITICAL for Cash (F2) button
		$(document).on('click', '#cash_sell_btn, button[data-pay_method="cash"]', function(e) {
			if (!validateSaleCompletion()) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			}
		});

		// Intercept ALL pos-express-finalize buttons (cash, card, suspend, credit sale) - HIGH PRIORITY
		// Must run before pos.js handlers - bind directly to elements
		$(document).on('click', '.pos-express-finalize', function(e) {
			// Validate immediately and block if invalid
			if (!validateSaleCompletion()) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			}
		});

		// Additional validation for all payment method buttons
		$(document).on('click', 'button[data-pay_method]', function(e) {
			if (!validateSaleCompletion()) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			}
		});

		// CRITICAL: Use native addEventListener with capture phase to intercept BEFORE jQuery handlers
		// This ensures validation runs before pos.js handlers
		document.addEventListener('click', function(e) {
			var target = e.target;
			var isPaymentButton = false;
			
			// Check various ways the button might be identified
			// 1. Check if it's the cash button directly
			if (target.id === 'cash_sell_btn') {
				isPaymentButton = true;
			}
			// 2. Check if it's inside the cash button
			else if (target.closest && target.closest('#cash_sell_btn')) {
				isPaymentButton = true;
			}
			// 3. Check if it has pos-express-finalize class
			else if (target.classList && target.classList.contains('pos-express-finalize')) {
				isPaymentButton = true;
			}
			// 4. Check if it's inside an element with pos-express-finalize class
			else if (target.closest && target.closest('.pos-express-finalize')) {
				isPaymentButton = true;
			}
			// 5. Check data-pay_method attribute
			else if (target.getAttribute && target.getAttribute('data-pay_method')) {
				var payMethod = target.getAttribute('data-pay_method');
				if (payMethod === 'cash' || payMethod === 'suspend' || payMethod === 'credit_sale' || payMethod === 'card') {
					isPaymentButton = true;
				}
			}
			// 6. Check if parent has data-pay_method
			else if (target.closest) {
				var parentWithPayMethod = target.closest('[data-pay_method]');
				if (parentWithPayMethod) {
					var payMethod = parentWithPayMethod.getAttribute('data-pay_method');
					if (payMethod === 'cash' || payMethod === 'suspend' || payMethod === 'credit_sale' || payMethod === 'card') {
						isPaymentButton = true;
					}
				}
			}
			
			if (isPaymentButton) {
				// Validate before allowing the click to propagate
				if (!validateSaleCompletion()) {
					e.preventDefault();
					e.stopPropagation();
					e.stopImmediatePropagation();
					return false;
				}
			}
		}, true); // Capture phase - runs BEFORE other handlers including jQuery

		// Add shortcut labels when modals are shown
		$(document).on('shown.bs.modal', '#modal_payment', function() {
			setTimeout(addShortcutLabels, 100);
		});

		$(document).on('shown.bs.modal', '.serial_modal[id^="sell_serial_numberModel"]', function() {
			setTimeout(addShortcutLabels, 100);
		});

		$(document).on('shown.bs.modal', '.contact_modal', function() {
			setTimeout(addShortcutLabels, 100);
		});

		$(document).on('shown.bs.modal', '#posEditDiscountModal', function() {
			setTimeout(addShortcutLabels, 100);
		});

		$(document).on('shown.bs.modal', '#confirmSuspendModal', function() {
			setTimeout(addShortcutLabels, 100);
		});

		// Add shortcut labels when Suspended Sales modal is loaded via AJAX
		// Note: DOMNodeInserted is deprecated, using MutationObserver instead (see below)

		// Also observe .view_modal for changes (when AJAX loads suspended sales)
		if (window.MutationObserver) {
			var $viewModal = $('.view_modal');
			if ($viewModal.length) {
				var viewModalObserver = new MutationObserver(function(mutations) {
					mutations.forEach(function(mutation) {
						if (mutation.addedNodes.length) {
							setTimeout(addShortcutLabels, 200);
						}
					});
				});

				$viewModal.each(function() {
					viewModalObserver.observe(this, {
						childList: true,
						subtree: true
					});
				});
			}
		}

			// Re-add labels when new product rows are added
			// Note: Using MutationObserver (above) instead of deprecated DOMNodeInserted

		});
		
		$(document).ready(function() {
			var forcedInput = $('#search_product_barcode_type_check');
			var focusTimer;

			// Function to force focus on the input field
			function forceFocus() {
				setTimeout(function() {
					forcedInput.focus();
				}, 10);
			}

			forcedInput.on('blur', function(event) {
				setTimeout(function() {
					if (!$(':focus').is('input, select, textarea')) {
						forceFocus();
					}
				}, 10);
			});
		});
		
		// closs_recent_transaction
		// expend_recent_transactions
		$(document).on('click', '.recent_transaction_button', function(e) {
            $('#recent_transactions').addClass('expend_recent_transactions');
			$('#recent_transaction').addClass('d-none');
            get_recent_transactions('final', $('div#tab_final'));
		});
        
		$(document).on('click', '.closs_recent_transaction', function(e) {
            $('#recent_transactions').removeClass('expend_recent_transactions');
			$('#recent_transaction').removeClass('d-none');
		});
        
   
        $(document).ready( function(){
            // 
            const selectElement = document.getElementById("purchases_serial_number");
            const tagsContainer = document.getElementById("tags");
            let tags = [];

            // ---------------------------------------------------------------------------------
            $(document).on('click', '.purchases_serial_numberModelButton', function (params) {

                // Set ID For Input Id
                var inputfindid = this.value;
                const key = 'inputfindid';
                localStorage.setItem(key, inputfindid);

                // Set ID For Value Set
                var valueSetId = this.getAttribute('data-value');
                const key1 = 'valueSetId';
                localStorage.setItem(key1, valueSetId);
                // Get Previous value
                var previousValue = document.getElementById(valueSetId).value;
                var previousValueArry = previousValue.split(",");
                var previousValueArryLength = previousValueArry.length;
                if (previousValue === "") {
                    // tags = [];
                }else{
                    for (var i = 0; i < previousValueArry.length; i++) {
                        $("#tags").append(
                            "<div class='tag'><span>" + previousValueArry[i] + "</span><div class='remove-button'>x</div></div>"
                        );
                        tags.push(previousValueArry[i]);
                    }
                }

            })

            let lastSelectedValue;
            selectElement.addEventListener("keyup", (event) => {
                if (event.key === "Enter" || event.key === ",") {


                    // var getProductSetId = localStorage.getItem('productSetId');
                    // var getvariationidSetId = localStorage.getItem('variationidSetId');
                    // var location_id = $('select#location_id').find(':selected').val();


                    const value = selectElement.value.trim();
                    if (value) {

                        if (tags.includes(value) || value == "") {
                            
                        } else {
                            // $.ajax({
                            // 	url: '/serial/check_serial',
                            // 	type: 'POST',
                            // 	dataType: 'html',
                            // 	data: {
                            // 		serial_number: value,
                            // 		product_id: getProductSetId,
                            // 		location_id: location_id,
                            // 		variation_id: getvariationidSetId
                            // 	},
                            // 	success: function (result) {
                            // 		if (result == "0") {
                                        addTag(value);
                                        countUpFunction(value);
                            // 			} else {
                            // 				alert("This Serial Number Already Added");
                            // 			}
                            // 		},
                            // 	});
                        }
                        selectElement.value = "";
                    }
                }
            });

            function renderTags() {
                tagsContainer.innerHTML = "";
                tags.forEach((value) => {
                    const tagElement = document.createElement("div");
                    tagElement.classList.add("tag");
                    tagElement.innerHTML = `<span>${value}</span><div class="remove-button">x</div>`;
                    tagElement
                    .querySelector(".remove-button")
                    .addEventListener("click", function () {
                        // removeTag(value);
                        // renderTags();
                    });
                    tagsContainer.appendChild(tagElement);
                });
            }

            function addTag(value) {
                tags.push(value);

                var getValueSetId = localStorage.getItem('valueSetId');

                document.getElementById(getValueSetId).value = tags;

                renderTags();
            }

            function removeTag(value) {
                const index = tags.indexOf(value);
                if (index >= 0) {
                    tags.splice(index, 1);
                }

                var getValueSetId = localStorage.getItem('valueSetId');

                document.getElementById(getValueSetId).value = tags;

                renderTags();
            }

            $(document).on("click", '.remove-button', function (event) {
                if (event.target.className === "remove-button") {
                    var tag = event.target.closest(".tag");
                    var spanTag = tag.querySelector("span");
                    var value = spanTag.innerHTML;
                    removeTag(value);
                    countDownFunction(value);
                }
            });

            // 
            function countUpFunction(lastSelectedValue) {
                count = 1;
                var getInputFindId = localStorage.getItem('inputfindid');
                var input = $("#" + getInputFindId + "").find('input');
                var qty = __read_number(input);
                if (qty >= 0) {
                    __write_number(input, qty + count);
                    input.change();
                }

            }
            // Count Up

            // Count Down
            function countDownFunction(unselectedValue) {
                count = 1;
                var getInputFindId = localStorage.getItem('inputfindid');

                var input = $("#" + getInputFindId + "")
                    .find('input');
                var qty = __read_number(input);

                if (qty > 0) {
                    __write_number(input, qty - count);
                    input.change();
                }
            }

            // modelReload
            $(document).on('click', '#modelReload', function () {
                tags = []
                $(".tag").remove();
            });

            $(document).on('hidden.bs.modal', '.serial_modal', function (e) {
                tags = []
                $(".tag").remove();
            });

            $('#product_serial_numberP').select2();
            // ---------------------------------------------------------------------------

            // Products now show directly in Products tab - no modal functionality needed

        });
		
		// Override product box click to use quantity from input
		// Use capture phase or early binding to ensure this runs before pos.js handler
		$(document).on('click', 'div.product_box', function(e) {
			// Don't trigger if clicking on the quantity input, buttons, or add to cart button
			if ($(e.target).hasClass('product-qty-input-field') || 
				$(e.target).hasClass('qty-plus') || 
				$(e.target).hasClass('qty-minus') || 
				$(e.target).hasClass('add-to-cart-btn') ||
				$(e.target).closest('.product-qty-input').length ||
				$(e.target).closest('.add-to-cart-btn').length) {
				return;
			}
			
			var $productBox = $(this);
			var variationId = $productBox.data('variation_id');
			
			if (!variationId) {
				return; // No variation ID, let default handler work
			}
			
			// Check if location is set
			if ($('input#location_id').val() == '') {
				toastr.warning(LANG.select_location);
				e.stopPropagation();
				e.preventDefault();
				return false;
			}
			
			// Get quantity from input box within this product box
			var quantity = 1; // Default quantity
			var $qtyInput = $productBox.find('.product-qty-input-field[data-variation_id="' + variationId + '"]');
			
			if ($qtyInput.length) {
				var qtyValue = parseFloat($qtyInput.val());
				if (!isNaN(qtyValue) && qtyValue > 0) {
					quantity = qtyValue;
				}
			}
			
			// Call pos_product_row with the quantity
			if (typeof pos_product_row === 'function') {
				pos_product_row(variationId, null, null, quantity, null);
				// Stop event propagation to prevent default handler in pos.js
				e.stopPropagation();
				e.stopImmediatePropagation();
				return false;
			}
		});
		
		// Prevent product box click when interacting with quantity input
		$(document).on('click', '.product-qty-input-field', function(e) {
			e.stopPropagation();
		});
		
		$(document).on('focus', '.product-qty-input-field', function(e) {
			e.stopPropagation();
		});
		
		$(document).on('change', '.product-qty-input-field', function(e) {
			e.stopPropagation();
			// Ensure value is valid
			var $input = $(this);
			var value = parseFloat($input.val());
			var min = parseFloat($input.attr('min')) || 1;
			
			if (isNaN(value) || value < min) {
				$input.val(min);
			} else {
				// Ensure whole numbers if step is 1
				var step = parseFloat($input.attr('step')) || 1;
				if (step >= 1) {
					$input.val(Math.floor(value));
				}
			}
		});
		
		// Quantity +/- button handlers
		$(document).on('click', '.qty-plus', function(e) {
			e.stopPropagation();
			e.stopImmediatePropagation();
			e.preventDefault();
			var variationId = $(this).data('variation_id');
			var $input = $('#product_qty_' + variationId);
			if ($input.length) {
				var currentValue = parseFloat($input.val()) || 1;
				var step = parseFloat($input.attr('step')) || 1;
				var newValue = currentValue + step;
				// Format as integer if step is 1, otherwise keep decimals
				if (step >= 1) {
					$input.val(Math.floor(newValue)).trigger('change');
				} else {
					$input.val(newValue.toFixed(2)).trigger('change');
				}
			}
			return false;
		});
		
		$(document).on('click', '.qty-minus', function(e) {
			e.stopPropagation();
			e.stopImmediatePropagation();
			e.preventDefault();
			var variationId = $(this).data('variation_id');
			var $input = $('#product_qty_' + variationId);
			if ($input.length) {
				var currentValue = parseFloat($input.val()) || 1;
				var step = parseFloat($input.attr('step')) || 1;
				var min = parseFloat($input.attr('min')) || 1;
				var newValue = Math.max(min, currentValue - step);
				// Format as integer if step is 1, otherwise keep decimals
				if (step >= 1) {
					$input.val(Math.floor(newValue)).trigger('change');
				} else {
					$input.val(newValue.toFixed(2)).trigger('change');
				}
			}
			return false;
		});
		
		// Add to Cart button handler
		$(document).on('click', '.add-to-cart-btn', function(e) {
			e.stopPropagation();
			e.preventDefault();
			e.stopImmediatePropagation();
			
			var $btn = $(this);
			var variationId = $btn.data('variation_id');
			
			// Check if location is set
			if ($('input#location_id').val() == '') {
				toastr.warning(LANG.select_location);
				return false;
			}
			
			// Get quantity from input box - read the current displayed value
			var quantity = 1; // Default quantity
			var $qtyInput = $('#product_qty_' + variationId);
			
			if ($qtyInput.length) {
				// Get the current value from the input
				var inputValue = $qtyInput.val();
				var qtyValue = parseFloat(inputValue);
				
				// Validate quantity
				if (!isNaN(qtyValue) && qtyValue > 0) {
					quantity = qtyValue;
				} else {
					// If invalid, set to 1 and show message
					$qtyInput.val(1);
					quantity = 1;
					toastr.warning('Invalid quantity. Setting to 1.');
				}
			}
			
			// Debug: Log the quantity being added
			console.log('Adding product to cart - Variation ID:', variationId, 'Quantity:', quantity);
			
			// Call pos_product_row with the quantity
			if (typeof pos_product_row === 'function') {
				pos_product_row(variationId, null, null, quantity, null);
				
				// Visual feedback - briefly disable button
				$btn.prop('disabled', true).css('opacity', '0.6');
				setTimeout(function() {
					$btn.prop('disabled', false).css('opacity', '1');
				}, 300);
			} else {
				console.error('pos_product_row function not found');
				toastr.error('Error: Unable to add product to cart');
			}
			
			return false;
		});

	</script>
    <script>
        $(document).ready(function() {
            // Proxy click for mobile finalize button - ONLY on Mobile
            $(document).on('click', '#pos-finalize-mobile', function() {
                // Only work on mobile
                if (window.innerWidth > 768) {
                    return;
                }
                
                // Trigger the original finalize button
                // We use the class selector or ID if available in the original form actions
                var $originalBtn = $('#pos-finalize');
                if ($originalBtn.length) {
                    $originalBtn.trigger('click');
                } else {
                    // Fallback if ID not found (though it should be there)
                    $('.pos-express-finalize[data-pay_method="cash"]').trigger('click');
                }
            });
            
            // Update Cart Badge - ONLY on Mobile
            if (window.innerWidth <= 768) {
            setInterval(function() {
                    // Only update if still on mobile
                    if (window.innerWidth > 768) {
                        return;
                    }
                    
                var totalItems = 0;
                $('#pos_table tbody tr.product_row').each(function() {
                    var qty = parseFloat($(this).find('.product-qty-input-field').val());
                    if (!isNaN(qty)) {
                        totalItems += qty;
                    }
                });
                
                // Format badge: 99+ if over 99
                var badgeText = totalItems > 99 ? '99+' : Math.round(totalItems);
                $('#app-cart-badge').text(badgeText);
                
                // Animate badge if changed (simple check)
                // ...
            }, 1000);
            }
        });

        // App Tab Switching Logic - ONLY on Mobile (Global function)
        function switchAppTab(tab) {
            // Only execute on mobile devices
            if (window.innerWidth > 768) {
                return;
            }
            
            if (tab === 'products') {
                // Show Products, Hide Cart
                $('body').removeClass('show-cart');
                $('#nav-products').addClass('active');
                $('#nav-cart').removeClass('active');
                
                // Force show products wrapper and all child elements
                $('#pos-sidebar-wrapper').css({
                    'display': 'block !important',
                    'visibility': 'visible !important',
                    'opacity': '1 !important'
                });
                
                // Ensure all product elements are visible
                $('#pos-sidebar-wrapper .pos_sidebar').css('display', 'block');
                $('#pos-sidebar-wrapper #product_list_div').css('display', 'block');
                $('#pos-sidebar-wrapper .product_list_container').css('display', 'block');
                
                // Scroll to top to show products
                setTimeout(function() {
                    $('html, body').animate({
                        scrollTop: 0
                    }, 300);
                }, 100);
            } else if (tab === 'cart') {
                // Show Cart, Hide Products
                $('body').addClass('show-cart');
                $('#nav-products').removeClass('active');
                $('#nav-cart').addClass('active');
                
                // Force hide products wrapper
                $('#pos-sidebar-wrapper').css({
                    'display': 'none !important',
                    'visibility': 'hidden !important'
                });
            }
        }
        
        // Initialize: Show cart by default on mobile
        $(document).ready(function() {
            // Check if mobile device
            if (window.innerWidth <= 768) {
                // Hide product grid
                $('#pos-sidebar-wrapper').removeClass('active');
                // Show cart view by default
                $('body').addClass('show-cart');
                // Set cart tab as active
                $('#nav-cart').addClass('active');
                $('#nav-products').removeClass('active');
            }
        });
        
        // Also run on window load to ensure it executes
        $(window).on('load', function() {
            if (window.innerWidth <= 768) {
                if (!$('body').hasClass('show-cart')) {
                    $('body').addClass('show-cart');
                    $('#nav-cart').addClass('active');
                    $('#nav-products').removeClass('active');
                }
            }
        });
        
        // Auto-switch to cart when product added (optional, maybe annoying?)
        // Let's keep it manual for now, or maybe show a toast.
        
        // Toast Notification for App Mode
        function showAppToast(message) {
            // Create toast element if not exists
            if ($('#app-toast').length === 0) {
                $('body').append('<div id="app-toast" style="position: fixed; bottom: 80px; left: 50%; transform: translateX(-50%); background: rgba(0,0,0,0.8); color: white; padding: 10px 20px; border-radius: 20px; font-size: 14px; z-index: 10050; display: none; transition: opacity 0.3s;"></div>');
            }
            
            var $toast = $('#app-toast');
            $toast.text(message);
            $toast.fadeIn().delay(2000).fadeOut();
        }
        
        // Hook into product add event (using the existing click handler I added earlier)
        $(document).on('click', '.product_box', function() {
            if (window.innerWidth <= 768) {
                setTimeout(function() {
                    showAppToast("Product added to cart");
                }, 200);
            }
        });

        // Loading state management
        function showLoading() {
            const overlay = document.getElementById('pos-loading-overlay');
            if (overlay) {
                overlay.style.display = 'flex';
            }
        }

        function hideLoading() {
            const overlay = document.getElementById('pos-loading-overlay');
            if (overlay) {
                overlay.style.display = 'none';
            }
        }

        // Show loading on form submissions
        document.addEventListener('DOMContentLoaded', function() {
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                form.addEventListener('submit', function(e) {
                    // Only show loading for non-AJAX forms
                    if (!form.hasAttribute('data-ajax')) {
                        showLoading();
                    }
                });
            });

            // Hide loading when page is fully loaded
            window.addEventListener('load', hideLoading);
        });

        // Global error handler
        window.addEventListener('error', function(e) {
            hideLoading();
            console.error('POS Error:', e);
        });
    </script>

    @include('sale_pos.partials.keyboard_shortcuts')

    <!-- Call restaurant module if defined -->
    @if(in_array('tables', $enabled_modules) ||
            in_array('modifiers', $enabled_modules) ||
            in_array('service_staff', $enabled_modules))
        <script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
    @endif
    <!-- include module js -->
    @if (!empty($pos_module_data))
        @foreach ($pos_module_data as $key => $value)
            @if (!empty($value['module_js_path']))
                @includeIf($value['module_js_path'], ['view_data' => $value['view_data']])
            @endif
        @endforeach
    @endif
@endsection

