 @if(count($module_permissions) > 0)
  @php
    $module_role_permissions = [];
    if(!empty($role_permissions)) {
      $module_role_permissions = $role_permissions;
    }
  @endphp
  @foreach($module_permissions as $key => $value)
  <hr>
  <div class="row check_group">
    <div class="col-md-3">
      <h4>{{$key}}</h4>
    </div>
    <div class="col-md-9">
      @foreach($value as $module_permission)
      @php
        if(empty($role_permissions) && isset($module_permission['default']) && $module_permission['default']) {
          $module_role_permissions[] = $module_permission['value'];
        }
      @endphp
      @if(isset($module_permission['is_heading']) && $module_permission['is_heading'])
      <div class="col-md-12" style="margin-top: 15px; margin-bottom: 10px;">
        <h5 style="color: #d32f2f; font-weight: bold; border-bottom: 1px solid #d32f2f; padding-bottom: 5px;">
          {{ $module_permission['label'] }}
        </h5>
      </div>
      @else
      <div class="col-md-12">
        <div class="checkbox">
          <label>
            @if(!empty($module_permission['is_radio']))
              {!! Form::radio('radio_option[' . $module_permission['radio_input_name'] . ']', $module_permission['value'], in_array($module_permission['value'], $module_role_permissions), 
            [ 'class' => 'input-icheck']); !!} {{ $module_permission['label'] }}
            @else
            {!! Form::checkbox('permissions[]', $module_permission['value'], in_array($module_permission['value'], $module_role_permissions), 
            [ 'class' => 'input-icheck']); !!} {{ $module_permission['label'] }}
            @endif
          </label>
        </div>

        @if(isset($module_permission['end_group']) && $module_permission['end_group'])
        <hr>
        @endif
      </div>
      @endif
      @endforeach
    </div>
  </div>
  @endforeach
@endif