@extends('layouts.app')
@section('title', __('lang_v1.z_report'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>{{ __('lang_v1.z_report')}}</h1>
</section>

<!-- Main content -->
<section class="content">

    <style>
        #item_wise_sales .dt-buttons.btn-group {
            display: none !important;
        }
        
        #z_purchase_payment_report_table .dt-buttons.btn-group {
            display: none !important;
        }
        #expense_report_table .dt-buttons.btn-group {
            display: none !important;
        }
    </style>

    <div class="row no-print">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
                {!! Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'zReport']), 'method' => 'get' ]) !!}
                    <div class="col-md-4">
                        <div class="form-group">
                            {!! Form::label('location_id',  __('purchase.business_location') . ':') !!}
                            {!! Form::select('location_id', $business_locations, $location_id ? $location_id : null, ['class' => 'form-control select2', 'style' => 'width:100%']); !!}
                        </div>
                    </div>
                    
                    {{--  --}}
                    <div class="col-md-4">
                        <div class="form-group">
                            {!! Form::label('date_range', __('report.date_range') . ':') !!}
                            {!! Form::text('date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_range', 'readonly']); !!}
                        </div>
                    </div>    
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <br>
                            {!! Form::label('date_range', __('report.date_range') . ':') !!}
                            @if (!empty($start_date))
                                {{ $start_date }}
                            @endif  
                            to
                            @if (!empty($end_date))
                                {{ $end_date }}
                            @endif
                        </div>
                    </div>

                    <input type="hidden" name="start_date" id="start_date" value="{{ $start_date }}">
                    <input type="hidden" name="end_date" id="end_date" value="{{ $end_date }}">

                    <div class="col-sm-12">
                        <button type="submit" class="btn btn-primary pull-right">
                            @lang('report.apply_filters')
                        </button>
                    </div> 
                {!! Form::close() !!}
            @endcomponent   
        </div>
    </div>

    <div class="reports">
        <div class="row">
            <div class="col-md-12">
                @component('components.widget', ['class' => 'box-primary', 'button'=> '<a class="buttons-print tw-dw-btn-xs tw-dw-btn tw-dw-btn-outline tw-my-2 no-print" id="dailyReportPrint"><span><i class="fa fa-print" aria-hidden="true"></i>Print</span></a>', 'title' => __('report.sales_and_taxes_summary')])
                    <table class="table" id="sales_and_taxes_summary_tabale">
                        <thead>
                            <tr>
                                <th>@lang( 'report.title' )</th>
                                <th>@lang( 'report.amount' )</th>
                            </tr>
                        </thead>
                        <tbody>
    
                            <tr>
                                <td>Total Itme Sale Without Tax</td>
                                <td>
                                    <span class="display_currency" data-currency_symbol="true">
                                        {{$sell_details['total_sell_exc_tax']}}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td>Total Sale Due</td>
                                <td>
                                    <span class="display_currency" data-currency_symbol="true">
                                        {{$sell_details['invoice_due']}}
                                    </span>
                                </td>
                            </tr>      
                            
                            
                            <tr>
                                <td>Delivary Charge (+)</td>
                                <td>
                                    <span class="display_currency" data-currency_symbol="true">
                                        {{$sell_details['total_shipping_charges']}}
                                    </span>
                                </td>
                            </tr>
    
                        </tbody>
                    </table>
    
                @endcomponent
            </div>
        </div>
    
        <div class="row">
            <div class="col-md-12">
                @component('components.widget', ['class' => 'box-primary', 'title' => __('report.payment_method_wise_breakdown')])
                    <table class="table" id="payment_method_wise_breakdown_tabale">
                        <thead>
                            <tr>
                                <th>@lang( 'report.title' )</th>
                                <th>@lang( 'report.amount' )</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($payment_method_wise['cash_payment']>0)
                                <tr>
                                    <td>Total Cash Payment</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['cash_payment']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['cheque_payment']>0)
                                <tr>
                                    <td>Total cheque Payment</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['cheque_payment']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['card_payment']>0)
                                <tr>
                                    <td>Total card Payment</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['card_payment']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['bank_transfer_payment']>0)
                                <tr>
                                    <td>Total bank transfer Payment</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['bank_transfer_payment']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['advance_payment']>0)
                                <tr>
                                    <td>Total advance Payment</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['advance_payment']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['custom_pay_1']>0)
                                <tr>
                                    <td>Total custom pay 1</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['custom_pay_1']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['custom_pay_2']>0)
                                <tr>
                                    <td>Total custom pay 2</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['custom_pay_2']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['custom_pay_3']>0)
                                <tr>
                                    <td>Total custom pay 3</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['custom_pay_3']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['custom_pay_4']>0)
                                <tr>
                                    <td>Total custom pay 4</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['custom_pay_4']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['custom_pay_5']>0)
                                <tr>
                                    <td>Total custom pay 5</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['custom_pay_5']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['custom_pay_6']>0)
                                <tr>
                                    <td>Total custom pay 6</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['custom_pay_6']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['custom_pay_7']>0)
                                <tr>
                                    <td>Total custom pay 7</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['custom_pay_7']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                            @if ($payment_method_wise['other_payment']>0)
                                <tr>
                                    <td>Total other Payment</td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">
                                            {{$payment_method_wise['other_payment']}}
                                        </span>
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
    
                @endcomponent
            </div>
        </div>
    
        <div class="row">
            <div class="col-md-12">
                @component('components.widget', ['class' => 'box-primary', 'title' => __('report.item_wise_sales')])
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="item_wise_sales">
                            <thead>
                                <tr>
                                    <th>@lang('sale.product')</th>
                                    <th>@lang('sale.qty')</th>
                                    <th>@lang('sale.total')</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr class="bg-gray font-17 footer-total text-center">
                                    <td colspan="2">
                                        <strong>@lang('sale.total'):</strong>
                                    </td>
                                    <td>
                                        <span class="display_currency" id="footer_subtotal" data-currency_symbol ="true"></span>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
    
                @endcomponent
            </div>
        </div>
    
        <div class="row">
            <div class="col-md-12">
                @component('components.widget', ['class' => 'box-primary','title' => __('report.purchase_paid_amount')])
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="z_purchase_payment_report_table">
                            <thead>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>@lang('purchase.ref_no')</th>
                                    <th>@lang('lang_v1.paid_on')</th>
                                    <th>@lang('sale.amount')</th>
                                    <th>@lang('purchase.supplier')</th>
                                    <th>@lang('lang_v1.payment_method')</th>
                                    <th>@lang('lang_v1.purchase')</th>
                                    {{-- <th>@lang('messages.action')</th> --}}
                                </tr>
                            </thead>
                            <tfoot>
                                <tr class="bg-gray font-17 footer-total text-center">
                                    <td colspan="3"><strong>@lang('sale.total'):</strong></td>
                                    <td><span class="display_currency" id="footer_total_amount" data-currency_symbol ="true"></span></td>
                                    <td colspan="3"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                @endcomponent
            </div>
        </div>
    
        <div class="row">
            <div class="col-md-12">
                @component('components.widget', ['class' => 'box-primary'])
                    <table class="table" id="z_expense_report_table">
                        <thead>
                            <tr>
                                <th>@lang( 'expense.expense_categories' )</th>
                                <th>@lang( 'report.total_expense' )</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $total_expense = 0;
                            @endphp
                            @foreach($expenses as $expense)
                                <tr>
                                    <td>{{$expense['category'] ?? __('report.others')}}</td>
                                    <td><span class="display_currency" data-currency_symbol="true">{{$expense['total_expense']}}</span></td>
                                </tr>
                                @php
                                    $total_expense += $expense['total_expense'];
                                @endphp
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <td>@lang('sale.total')</td>
                                <td><span class="display_currency" data-currency_symbol="true">{{$total_expense}}</span></td>
                            </tr>
                        </tfoot>
                    </table>
                @endcomponent
            </div>
        </div>


        {{-- <div class="row no-print">
            <div class="col-md-12">
                <button type="button" class="btn btn-primary no-print" aria-label="Print" onclick="$(this).closest('div.reports').printThis();">
                    <i class="fa fa-print"></i> 
                    Print      
                </button>
            </div>
        </div> --}}

    </div>




    {{-- <style>
      
        /* Ensure table width is 100% for printing */
        .table.dataTable {
            width: 100% !important;
        }
        /* Remove unnecessary paddings and margins */
        table {
            margin: 0;
            padding: 0;
            border-collapse: collapse;
            width: 100% !important;
        }
        /* Optional: Adjust font-size or other table styles */
        table, th, td {
            font-size: 12px;  /* Adjust this as needed */
        }
        
    </style> --}}

</section>
<!-- /.content -->

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>


    <script>
        $(document).ready(function() {

            function printPage() {
                window.print();
            }

            // Call the printPage function when a button or link is clicked
            // Example using a button with id "print-button"
            document.getElementById("dailyReportPrint").addEventListener("click", printPage);

            $('#date_range').daterangepicker({
                ranges: ranges,
                autoUpdateInput: false,
                locale: {
                    format: moment_date_format,
                    cancelLabel: LANG.clear,
                    applyLabel: LANG.apply,
                    customRangeLabel: LANG.custom_range,
                },
            });
            $('#date_range').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(
                    picker.startDate.format(moment_date_format) +
                        ' ~ ' +
                        picker.endDate.format(moment_date_format)
                );
            });

            $('#date_range').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });





            product_sell_report = $('table#item_wise_sales').DataTable({
                processing: true,
                serverSide: true,
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)

                ajax: {
                    url: '/reports/item-wise-sell-report',
                    data: function(d) {
                        var start = '';
                        var end = '';

                        if($('#start_date').val() || $('#end_date').val()) {
                            start = $('#start_date').val();
                            end = $('#end_date').val();
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.location_id = $('select#location_id').val();
                    },
                },
                columns: [
                    { data: 'product_name', name: 'p.name'},
                    { data: 'sell_qty', name: 'transaction_sell_lines.quantity' },
                    { data: 'subtotal', name: 'subtotal', searchable: false }
                ],
                fnDrawCallback: function(oSettings) {
                    $('#footer_subtotal').text(
                        sum_table_col($('#item_wise_sales'), 'row_subtotal')
                    );
                    __currency_convert_recursively($('#item_wise_sales'));
                },
            });



            //Purchase Payment Report
            z_purchase_payment_report = $('table#z_purchase_payment_report_table').DataTable({
                processing: true,
                serverSide: true,
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)

                ajax: {
                    url: '/reports/purchase-payment-report',
                    data: function(d) {
                        d.location_id = $('select#location_id').val();
                 
                        if($('#start_date').val() || $('#end_date').val()) {
                            var start = $('#start_date').val();
                            var end = $('#end_date').val();
                            d.start_date = start;
                            d.end_date = end;
                        }
                    },
                },
                columns: [
                    {
                        orderable: false,
                        searchable: false,
                        data: null,
                        defaultContent: '',
                    },
                    { data: 'payment_ref_no', name: 'payment_ref_no' },
                    { data: 'paid_on', name: 'paid_on' },
                    { data: 'amount', name: 'transaction_payments.amount' },
                    { data: 'supplier', orderable: false, searchable: false },
                    { data: 'method', name: 'method' },
                    { data: 'ref_no', name: 't.ref_no' },
                    // { data: 'action', orderable: false, searchable: false },
                ],
                fnDrawCallback: function(oSettings) {
                    var total_amount = sum_table_col($('#z_purchase_payment_report_table'), 'paid-amount');
                    $('#footer_total_amount').text(total_amount);
                    __currency_convert_recursively($('#z_purchase_payment_report_table'));
                },
                createdRow: function(row, data, dataIndex) {
                    if (!data.transaction_id) {
                        $(row).find('td:eq(0)').addClass('details-control');
                    }
                },
            });



            z_expense_report_table = $('#z_expense_report_table').DataTable({
                processing: false,  // Disable server-side processing
                serverSide: false,  // Disable server-side mode
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)
                

            });


        })

       
    </script>

@endsection