@extends('layouts.app')
@section('title', __('report.stock_report'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>{{ __('Stock History Report')}}</h1>
</section>

<!-- Main content -->
<section class="content">

    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])

              {!! Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'stockHistoryReport']), 'method' => 'get', 'id' => 'stock_history_report_filter_form' ]) !!}
                
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $business_locations, $default_location->id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%']); !!}
                    </div>
                </div>


                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category', $categories, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'category_id']); !!}
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('sub_category_id', __('product.sub_category') . ':') !!}
                        {!! Form::select('sub_category', array(), null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'sub_category_id']); !!}
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('brand', __('product.brand') . ':') !!}
                        {!! Form::select('brand', $brands, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%']); !!}
                    </div>
                </div>

                
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('unit',__('product.unit') . ':') !!}
                        {!! Form::select('unit', $units, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%']); !!}
                    </div>
                </div>
                
   
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('stock_history_report_date',__('Date') . ':') !!}
					    {!! Form::text('stock_history_report_date', null, ['class' => 'form-control', 'readonly', 'required', 'id' => 'stock_history_report_date']); !!}
                    </div>
                </div>
                
   

                
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-solid'])

                <table class="table table-bordered table-striped" id="stock_history_report_table">
                    <thead>
                        <tr>
                            <th>@lang('business.product')</th>
                            <th>@lang('Sku ')</th>
                      
                            <th>@lang('Opening Stock')</th>
                            <th>@lang('Purchase Stock')</th>
                            <th>@lang('Stock Transfers (In)')</th>
                            <th>@lang('Sell Return')</th>

                            <th>@lang('Stock Adjustment')</th>
                            <th>@lang('Sales Stock')</th>
                            <th>@lang('Purchase Return')</th>
                            <th>@lang('Stock Transfers (Out)')</th>
                            <th>@lang('Closing Stock')</th>

                        </tr>
                    </thead>
                    <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <td colspan="2">
                                <strong>@lang('sale.total'):</strong>
                            </td>
                            <td class="footer_opening_stock"></td>
                            <td class="footer_purchase_stock"></td>
                            <td class="footer_transfers_stock_in"></td>
                            <td class="footer_sales_return_stock"></td>
                            <td class="footer_adjustment_stock"></td>
                            <td class="footer_sales_stock"></td>
                            <td class="footer_purchase_return_stock"></td>
                            <td class="footer_transfers_stock_out"></td>
                            <td class="footer_closing_stock"></td>
                        </tr>
                    </tfoot>
                </table>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>



    {{-- selling_price_group --}}

@endsection