@extends('layouts.app')
@section('title', __('lang_v1.dailySummaryReport'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>{{ __('lang_v1.dailySummaryReport')}}</h1>
</section>

<!-- Main content -->
<section class="content">

    <div class="row no-print">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'dailySummaryReport']), 'method' => 'get' ]) !!}
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'id' => 'location_id','style' => 'width:100%']); !!}
                    </div>
                </div>
   
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_range', 'readonly']); !!}
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <br>
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        @if (!empty($start_date))
                            {{ $start_date }}
                        @endif  
                        to
                        @if (!empty($end_date))
                            {{ $end_date }}
                        @endif
                    </div>
                </div>

                <input type="hidden" name="start_date" id="start_date" value="{{ $start_date }}">
                <input type="hidden" name="end_date" id="end_date" value="{{ $end_date }}">

                <div class="col-sm-12">
                    <button type="submit" class="btn btn-primary pull-right">
                        @lang('report.apply_filters')
                    </button>
                </div> 
                {!! Form::close() !!}
            @endcomponent
        </div>

        {{-- <div class="col-md-12">
            <button class="btn btn-primary pull-right" onclick="printPage()">
                @lang('report.print')
            </button>
        </div> --}}
    </div>



    @component('components.widget', ['class' => 'box-primary', 'title' => 'Daily Purchase', 'button'=> '<a class="buttons-print tw-dw-btn-xs tw-dw-btn tw-dw-btn-outline tw-my-2 no-print" id="dailyReportPrint"><span><i class="fa fa-print" aria-hidden="true"></i>Print</span></a>'])
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped ajax_view" id="daily_purchase_report_table">
                <thead>
                    <tr>
                        {{-- <th>@lang('lang_v1.contact_id')</th> --}}
                        <th>@lang('purchase.ref_no')</th>
                        <th>@lang('purchase.supplier')</th>
                        <th>@lang('sale.total')</th>
                        <th>@lang('report.paid')</th>
                        <th>@lang('report.due')</th>
                    </tr>
                </thead>
                <tbody></tbody>

                <tfoot>
                    <tr class="bg-gray font-17 footer-total text-center">
                        <td colspan="2">
                            <strong>@lang('sale.total'):</strong>
                        </td>
                        <td class="text-left"><span class="display_currency" id="footer_total_amount" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="footer_total_paid" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="footer_total_due" data-currency_symbol ="true"></span></td>
                    </tr>
                </tfoot>

            </table>
        </div>
    @endcomponent


    @component('components.widget', ['class' => 'box-primary', 'title' => 'Daily Purchase Return'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped ajax_view" id="daily_purchase_return_report_table">
                <thead>
                    <tr>
                        {{-- <th>@lang('lang_v1.contact_id')</th> --}}
                        <th>@lang('purchase.ref_no')</th>
                        <th>@lang('purchase.supplier')</th>
                        <th>@lang('sale.total')</th>
                        <th>@lang('report.paid')</th>
                        <th>@lang('report.due')</th>
                    </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
                    <tr class="bg-gray font-17 footer-total text-center">
                        <td colspan="2">
                            <strong>@lang('sale.total'):</strong>
                        </td>
                        <td class="text-left"><span class="display_currency" id="return_footer_total_amount" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="return_footer_total_paid" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="return_footer_total_due" data-currency_symbol ="true"></span></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endcomponent


    @component('components.widget', ['class' => 'box-primary', 'title' => 'Suuplier Due Payment'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped ajax_view" id="daily_purchase_payment_report_table">
                <thead>
                    <tr>
                        <th>@lang('purchase.ref_no')</th>
                        <th>@lang('purchase.supplier')</th>
                        <th>@lang('report.paid')</th>
                    </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
                    <tr class="bg-gray font-17 footer-total text-center">
                        <td colspan="2">
                            <strong>@lang('sale.total'):</strong>
                        </td>
                        <td class="text-left"><span class="display_currency" id="daily_purchase_payment_footer_total_paid" data-currency_symbol ="true"></span></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary', 'title' => 'Sales'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped ajax_view" id="daily_sale_report_table">
                <thead>
                    <tr>
                        <th>@lang('lang_v1.contact_id')</th>
                        <th>@lang('sale.customer_name')</th>
                        <th>@lang('sale.invoice_no')</th>
                        <th>@lang('messages.date')</th>
                        <th>@lang('sale.total') (@lang('product.exc_of_tax'))</th>
                        <th>@lang('sale.discount')</th>
                        <th>@lang('sale.tax')</th>
                        <th>@lang('sale.total') (@lang('product.inc_of_tax'))</th>
                        <th>@lang('report.paid')</th>
                        <th>@lang('report.due')</th>
                    </tr>
                </thead>
                <tbody></tbody>
                
                
                
                
                
                
                <tfoot>
                    <tr class="bg-gray font-17 footer-total text-center">
                        <td colspan="4">
                            <strong>@lang('sale.total'):</strong>
                        </td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_footer_total_before_tax" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_footer_discount_amount" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_footer_tax_amount" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_footer_final_total" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_footer_total_paid" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_footer_total_due" data-currency_symbol ="true"></span></td>
                    </tr>
                </tfoot>
            </table>
            
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary', 'title' => 'Sales Return'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped ajax_view" id="daily_sale_return_report_table">
                <thead>
                    <tr>
                        <th>@lang('lang_v1.contact_id')</th>
                        <th>@lang('sale.customer_name')</th>
                        <th>@lang('sale.invoice_no')</th>
                        <th>@lang('messages.date')</th>
                        <th>@lang('sale.total') (@lang('product.exc_of_tax'))</th>
                        <th>@lang('sale.discount')</th>
                        <th>@lang('sale.tax')</th>
                        <th>@lang('sale.total') (@lang('product.inc_of_tax'))</th>
                        <th>@lang('report.paid')</th>
                        <th>@lang('report.due')</th>
                    </tr>
                </thead>
                <tbody></tbody>

                <tfoot>
                    <tr class="bg-gray font-17 footer-total text-center">
                        <td colspan="4">
                            <strong>@lang('sale.total'):</strong>
                        </td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_return_footer_total_before_tax" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_return_footer_discount_amount" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_return_footer_tax_amount" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_return_footer_final_total" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_return_footer_total_paid" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_return_footer_total_due" data-currency_symbol ="true"></span></td>
                    </tr>
                </tfoot>

            </table>
        </div>
    @endcomponent


    @component('components.widget', ['class' => 'box-primary', 'title' => 'Customer Due Recived'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped"  id="daily_sell_payment_report_table">
                <thead>
                    <tr>
                        <th>@lang('purchase.ref_no')</th>
                        <th>@lang('contact.customer')</th>
                        <th>@lang('sale.amount')</th>
                    </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
                    
                    <tr class="bg-gray font-17 footer-total text-center">
                        <td colspan="2">
                            <strong>@lang('sale.total'):</strong>
                        </td>
                        <td class="text-left"><span class="display_currency" id="daily_sell_payment_footer_total_paid" data-currency_symbol ="true"></span></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endcomponent
   


</section>
<!-- /.content -->

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>




    <script>


        function printPage() {
            window.print();
        }

        // Call the printPage function when a button or link is clicked
        // Example using a button with id "print-button"
        document.getElementById("dailyReportPrint").addEventListener("click", printPage);

        $(document).ready(function() {




            $('#date_range').daterangepicker({
                ranges: ranges,
                autoUpdateInput: false,
                locale: {
                    format: moment_date_format,
                    cancelLabel: LANG.clear,
                    applyLabel: LANG.apply,
                    customRangeLabel: LANG.custom_range,
                },
            });
            $('#date_range').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(
                    picker.startDate.format(moment_date_format) +
                        ' ~ ' +
                        picker.endDate.format(moment_date_format)
                );
            });

            $('#date_range').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });






            //Purchase report table
            purchase_report_table = $('#daily_purchase_report_table').DataTable({
                processing: true,
                serverSide: true,
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)
                ajax: {
                    url: '/reports/daily/purchase',
                    data: function(d) {

                        var start = '';
                        var end = '';
                        if($('#start_date').val() || $('#end_date').val()) {
                            var start = $('#start_date').val();
                            var end = $('#end_date').val();
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.location_id = $('select#location_id').val();



                        // d = __datatable_ajax_callback(d);
                    },
                },
                columns: [
                    // { data: 'contact_id', name: 'contacts.contact_id' },
                    { data: 'ref_no', name: 'ref_no' },
                    { data: 'name', name: 'contacts.name' },
                    { data: 'final_total', name: 'final_total' },
                    { data: 'total_paid', name: 'total_paid' },
                    { data: 'total_due', name: 'total_due' },
                ],
                fnDrawCallback: function(oSettings) {
                    var final_total = sum_table_col($('#daily_purchase_report_table'), 'final_total');
                    var paid_amount = sum_table_col($('#daily_purchase_report_table'), 'paid_amount');
                    var total_due = sum_table_col($('#daily_purchase_report_table'), 'total_due');
                    $('#footer_total_amount').text(final_total);
                    $('#footer_total_paid').text(paid_amount);
                    $('#footer_total_due').text(total_due);

                    __currency_convert_recursively($('#daily_purchase_report_table'));

                },
            });
            //Purchase report table
            purchase_return_report_table = $('#daily_purchase_return_report_table').DataTable({
                processing: true,
                serverSide: true,
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)
                ajax: {
                    url: '/reports/daily/purchase/return',
                    data: function(d) {
                        var start = '';
                        var end = '';
                        if($('#start_date').val() || $('#end_date').val()) {
                            var start = $('#start_date').val();
                            var end = $('#end_date').val();
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.location_id = $('select#location_id').val();

                        d = __datatable_ajax_callback(d);
                    },
                },
                columns: [
                    // { data: 'contact_id', name: 'contacts.contact_id' },
                    { data: 'ref_no', name: 'ref_no' },
                    { data: 'name', name: 'contacts.name' },
                    { data: 'final_total', name: 'final_total' },
                    { data: 'total_paid', name: 'total_paid' },
                    { data: 'total_due', name: 'total_due' },
                ],
                fnDrawCallback: function(oSettings) {
                    var final_total = sum_table_col($('#daily_purchase_return_report_table'), 'final_total');
                    var paid_amount = sum_table_col($('#daily_purchase_return_report_table'), 'paid_amount');
                    var total_due = sum_table_col($('#daily_purchase_return_report_table'), 'total_due');
                    $('#return_footer_total_amount').text(final_total);
                    $('#return_footer_total_paid').text(paid_amount);
                    $('#return_footer_total_due').text(total_due);

                    __currency_convert_recursively($('#daily_purchase_return_report_table'));

                },
            });
            //dailyPurchasePaymentReport
            daily_purchase_payment_report = $('table#daily_purchase_payment_report_table').DataTable({
                processing: true,
                serverSide: true,
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)
                aaSorting: [[2, 'desc']],
                ajax: {
                    url: '/reports/daily/purchase/payment',
                    data: function(d) {
                        var start = '';
                        var end = '';
                        if($('#start_date').val() || $('#end_date').val()) {
                            var start = $('#start_date').val();
                            var end = $('#end_date').val();
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.location_id = $('select#location_id').val();
                    },
                },
                columns: [
            
                    { data: 'payment_ref_no', name: 'payment_ref_no' },
                    { data: 'supplier', orderable: false, searchable: false },
                    { data: 'amount', name: 'transaction_payments.amount' }
                    

                ],
                fnDrawCallback: function(oSettings) {

                    var paid_amount = sum_table_col($('#daily_purchase_payment_report_table'), 'paid-amount');
                    $('#daily_purchase_payment_footer_total_paid').text(paid_amount);
                    __currency_convert_recursively($('#daily_purchase_payment_report_table'));

                }

            });

            // daily_sale_report_table
            daily_sale_report_table = $('#daily_sale_report_table').DataTable({
                processing: true,
                serverSide: true,
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)
                aaSorting: [[1, 'desc']],
                "ajax": {
                    "url": "/reports/daily/sales",
                    "data": function ( d ) {
                        var start = '';
                        var end = '';
                        if($('#start_date').val() || $('#end_date').val()) {
                            var start = $('#start_date').val();
                            var end = $('#end_date').val();
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.location_id = $('select#location_id').val();
                        d = __datatable_ajax_callback(d);
                    }
                },
                columns: [
                    { data: 'contact_id', name: 'contacts.contact_id' },
                    { data: 'name', orderable: false, searchable: false},
                    { data: 'invoice_no_text', name: 'transactions.invoice_no' },
                    { data: 'sale_date', name: 'transactions.transaction_date' },
                    { data: 'total_before_tax', name: 'total_before_tax' },
                    { data: 'discount_amount', name: 'discount_amount' },
                    { data: 'tax_amount', name: 'tax_amount' },
                    { data: 'final_total', name: 'final_total' },
                    { data: 'total_paid', name: 'total_paid' },
                    { data: 'total_due', name: 'total_due' },
                ],
                fnDrawCallback: function(oSettings) {


                    var total_before_tax = sum_table_col($('#daily_sale_report_table'), 'total_before_tax');
                    var discount_amount = sum_table_col($('#daily_sale_report_table'), 'discount_amount');
                    var tax_amount = sum_table_col($('#daily_sale_report_table'), 'tax_amount');
                    var final_total = sum_table_col($('#daily_sale_report_table'), 'final_total');
                    var total_paid = sum_table_col($('#daily_sale_report_table'), 'total_paid');
                    var total_due = sum_table_col($('#daily_sale_report_table'), 'total_due');
                    $('#daily_sell_footer_total_before_tax').text(total_before_tax);
                    $('#daily_sell_footer_discount_amount').text(discount_amount);
                    $('#daily_sell_footer_tax_amount').text(tax_amount);
                    $('#daily_sell_footer_final_total').text(final_total);
                    $('#daily_sell_footer_total_paid').text(total_paid);
                    $('#daily_sell_footer_total_due').text(total_due);

                    __currency_convert_recursively($('#daily_sale_report_table'));


                }
            });
            // daily_sale_report_table
            daily_sale_return_report_table = $('#daily_sale_return_report_table').DataTable({
                processing: true,
                serverSide: true,
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)
                aaSorting: [[1, 'desc']],
                "ajax": {
                    "url": "/reports/daily/sales/return",
                    "data": function ( d ) {
                        var start = '';
                        var end = '';
                        if($('#start_date').val() || $('#end_date').val()) {
                            var start = $('#start_date').val();
                            var end = $('#end_date').val();
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.location_id = $('select#location_id').val();
                        d = __datatable_ajax_callback(d);
                    }
                },
                columns: [
                    { data: 'contact_id', name: 'contacts.contact_id' },
                    { data: 'name', orderable: false, searchable: false},
                    { data: 'invoice_no_text', name: 'transactions.invoice_no' },
                    { data: 'sale_date', name: 'transactions.transaction_date' },
                    { data: 'total_before_tax', name: 'total_before_tax' },
                    { data: 'discount_amount', name: 'discount_amount' },
                    { data: 'tax_amount', name: 'tax_amount' },
                    { data: 'final_total', name: 'final_total' },
                    { data: 'total_paid', name: 'total_paid' },
                    { data: 'total_due', name: 'total_due' },
                ],
                fnDrawCallback: function(oSettings) {


                    var total_before_tax = sum_table_col($('#daily_sale_return_report_table'), 'total_before_tax');
                    var discount_amount = sum_table_col($('#daily_sale_return_report_table'), 'discount_amount');
                    var tax_amount = sum_table_col($('#daily_sale_return_report_table'), 'tax_amount');
                    var final_total = sum_table_col($('#daily_sale_return_report_table'), 'final_total');
                    var total_paid = sum_table_col($('#daily_sale_return_report_table'), 'total_paid');
                    var total_due = sum_table_col($('#daily_sale_return_report_table'), 'total_due');
                    $('#daily_sell_return_footer_total_before_tax').text(total_before_tax);
                    $('#daily_sell_return_footer_discount_amount').text(discount_amount);
                    $('#daily_sell_return_footer_tax_amount').text(tax_amount);
                    $('#daily_sell_return_footer_final_total').text(final_total);
                    $('#daily_sell_return_footer_total_paid').text(total_paid);
                    $('#daily_sell_return_footer_total_due').text(total_due);


                    __currency_convert_recursively($('#daily_sale_return_report_table'));
                }
            });
            //Sell Payment Report
            daily_sell_payment_report = $('table#daily_sell_payment_report_table').DataTable({
                processing: true,
                serverSide: true,
                
                // Disable search, pagination, and ordering
                searching: false,   // Disable search bar
                paging: false,      // Disable pagination
                ordering: false,    // Disable sorting
                
                // Remove all additional elements (buttons, length change, info)
                dom: 't',  // Only show the table (no buttons, no search, no pagination)
                aaSorting: [[1, 'desc']],
                ajax: {
                    url: '/reports/daily/customer-payment',
                    data: function(d) {
          
                        var start = '';
                        var end = '';
                        if($('#start_date').val() || $('#end_date').val()) {
                            var start = $('#start_date').val();
                            var end = $('#end_date').val();
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.location_id = $('select#location_id').val();
                    },
                },
                columns: [
                    { data: 'payment_ref_no', name: 'payment_ref_no' },
                    { data: 'customer', orderable: false, searchable: false },
                    { data: 'amount', name: 'transaction_payments.amount' }
                ],
                fnDrawCallback: function(oSettings) {

                    var total_paid = sum_table_col($('#daily_sell_payment_report_table'), 'paid-amount');
                    $('#daily_sell_payment_footer_total_paid').text(total_paid);

                    __currency_convert_recursively($('#daily_sell_payment_report_table'));
                }
            });




        })

            
       
    </script>

@endsection