@extends('layouts.app')
@section('title', __('lang_v1.daily_report'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>{{ __('lang_v1.daily_report')}}</h1>
</section>

<!-- Main content -->
<section class="content">

    <style>
        @media print{
            table.dataTable{
                padding-top: 0 !important;
                padding-bottom: 0 !important;
                margin-bottom: 0 !important;
                margin-top: 0 !important;

                border-bottom: 0 !important;
                border-top: 0 !important;
            }
            .table>tbody>tr>td, 
            .table>tbody>tr>th, 
            .table>tfoot>tr>td, 
            .table>tfoot>tr>th, 
            .table>thead>tr>td, 
            .table>thead>tr>th{
                padding-bottom: 2px !important;
                padding-top: 2px !important;
                border-top: 0 !important;
            }
            .table>thead{
                border-bottom: 0 !important;
                border-top: 0 !important;
            }
            .table>thead>tr>th{
                border-bottom: 0 !important;
                border-top: 0 !important;
            }
      
            tr.tabel_head>th{
                background: #d2d6de!important;
            }
            #signature{
               height: 10px !important;
            }
          
        }
    </style>

    <div class="row no-print">
        <div class="col-sm-12">
            @component('components.filters', ['title' => __('report.filters')])
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('bal_sheet_location_id',  __('purchase.business_location') . ':') !!}
                    {!! Form::select('bal_sheet_location_id', $business_locations, null, ['class' => 'form-control select2', 'style' => 'width:100%']); !!}
                </div>
            </div>
            <div class="col-sm-3 col-xs-6">
                <label for="end_date">@lang('messages.filter_by_date'):</label>
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fa fa-calendar"></i>
                    </span>
                    <input type="text" id="end_date" value="@if (isset($end_date))
                        {{ $end_date }}
                    @else
                    {{ @format_date('now')}}
                    @endif" class="form-control" readonly>
                </div>
            </div>
            @endcomponent
        </div>
    </div>




    <div class="row">
        <div class="col-md-12 col-sm-12 ">
            <p class="text-center" style="text-align: center;">
                <strong>Date: 04/07/2023</strong>
            </p>
            <div class="table-responsive">
                <table class="table dataTable no-footer" id="daily_tabel">

                    <thead>
                        <tr class="row-border blue-heading">
                            <th width="10%" class="text-center"></th>
                            <th width="10%" class="text-center"></th>
                            <th width="10%" class="text-center"></th>
                            <th width="40%" class="text-center">
                                @lang('lang_v1.daily_summary_eport') 
                                <a class="buttons-print tw-dw-btn-xs tw-dw-btn tw-dw-btn-outline tw-my-2 no-print" id="dailyReportPrint">
                                    <span>
                                        <i class="fa fa-print" aria-hidden="true"></i>
                                            Print
                                    </span>
                                </a>
                            </th>
                            <th width="10%" class="text-center">
                                
                            </th>
                            <th width="10%" class="text-center"></th>
                            <th width="10%" class="text-center"></th>
                        </tr>
                    </thead>

                    <tbody class="table dataTable no-footer">
                      
                        <tr>

                            <!-- Opning Balance Tabel -->
                            <table class="table dataTable no-footer" id="daily_opening_balance_tabel">
                                <thead>
                                    <tr class="bg-gray tabel_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">  @lang('account.opening_balance') </th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody id="opening_balance">
                                    <tr class="text-center tabel_head">
                                        <td>
                                            <span class="remote-data" >
                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Opning Balance Tabel -->
                            
                            <!-- Purchases Tabel -->
                            <table class="table dataTable no-footer">
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">
                                            @lang('lang_v1.purchase')
                                        </th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="7" class="bg-light-gray" >
                                            <table class="table table-slim mb-0 bg-light-gray" id="purchases_tabel">
                                                <thead>
                                                    <tr role="row" class="tabel_head">
                                                        <th>SN</th>
                                                        <th> @lang('lang_v1.total_purchase')</th>
                                                        <th> @lang('lang_v1.paid')</th>
                                                        <th> @lang('lang_v1.due')</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="purchases_list">
                                                    <tr class="text-center">
                                                        <td colspan="7">
                                                            <span class="remote-data" >
                                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Purchases Tabel -->
                            
                            <!-- Orders Tabel -->
                            <table class="table dataTable no-footer">
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">Sells</th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="7" class="bg-light-gray" >
                                            <table class="table table-slim mb-0 bg-light-gray" id="sell_tabel">
                                                <thead>
                                                    <tr role="row" class="tabel_head">
                                                        <th>SN</th>
                                                        <th>Total Sell</th>
                                                        <th> @lang('lang_v1.paid')</th>
                                                        <th> @lang('lang_v1.due')</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="sell_list">
                                                    <tr class="text-center">
                                                        <td colspan="7">
                                                            <span class="remote-data" >
                                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Orders Tabel -->  

                            <!-- Expenses Tabel -->
                            <table class="table dataTable no-footer">
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">Expenses</th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="7" class="bg-light-gray" >
                                            <table class="table table-slim mb-0 bg-light-gray" id="expenses_tabel">
                                                <thead>
                                                    <tr role="row" class="tabel_head">
                                                        <th>SN</th>
                                                        <th>Total Expenses</th>
                                                        <th> @lang('lang_v1.paid')</th>
                                                        <th> @lang('lang_v1.due')</th>
                                                    </tr>
                                                </thead>

                                                <tbody id="expenses_list">
                                                    <tr class="text-center">
                                                        <td colspan="7">
                                                            <span class="remote-data" >
                                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Expenses Tabel -->


                            <!-- Expenses Tabel -->
                            <table class="table dataTable no-footer">
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">Expenses Refund</th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="7" class="bg-light-gray" >
                                            <table class="table table-slim mb-0 bg-light-gray" id="expenses_refound_tabel">
                                                <thead>
                                                    <tr role="row" class="tabel_head">
                                                        <th>SN</th>
                                                        <th>Total Expenses Refund</th>
                                                        <th> @lang('lang_v1.paid')</th>
                                                        <th> @lang('lang_v1.due')</th>
                                                    </tr>
                                                </thead>

                                                <tbody id="expenses_refound_list">
                                                    <tr class="text-center">
                                                        <td colspan="7">
                                                            <span class="remote-data" >
                                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Expenses Tabel -->

                            <!-- Supplier Due Payment Tabel -->
                            <table class="table dataTable no-footer">
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">Supplier Due Payments</th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="7" class="bg-light-gray" >
                                            <table class="table table-slim mb-0 bg-light-gray" id="supplier_duepayment_tabel">
                                                <thead>
                                                    <tr role="row" class="tabel_head">
                                                        <th width="20%">SN</th>
                                                        <th> @lang('lang_v1.due')</th>
                                                        <th width="40%">Total Supplier Due Payment</th>
                                                        <th> @lang('lang_v1.paid')</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="supplier_duepayment_list">
                                                    <tr class="text-center">
                                                        <td colspan="7">
                                                            <span class="remote-data" >
                                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Supplier Due Payment Tabel -->

                            <!-- Sell Due Payment Tabel -->
                            <table class="table dataTable no-footer">
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">Customer Due Receives</th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="7" class="bg-light-gray" >
                                            <table class="table table-slim mb-0 bg-light-gray" id="sell_duepayment_tabel">
                                                <thead>
                                                    <tr role="row" class="tabel_head">
                                                        <th width="20%">SN</th>
                                                        <th> @lang('lang_v1.paid')</th>
                                                        <th width="40%">Total Customer Due Payment</th>
                                                        <th> @lang('lang_v1.due')</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="sell_duepayment_list">
                                                    <tr class="text-center">
                                                        <td colspan="7">
                                                            <span class="remote-data" >
                                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Sell Due Payment Tabel -->
                           
                            <!-- Damages Due Payment Tabel -->
                            <table class="table dataTable no-footer">
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">Damages</th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="7" class="bg-light-gray" >
                                            <table class="table table-slim mb-0 bg-light-gray" id="damages_tabel">
                                                <thead>
                                                    <tr role="row" class="tabel_head">
                                                        <th width="10%">SN</th>
                                                        <th width="20%">Loss Amount</th>
                                                        <th width="70%">Total amount recovered</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="damages_list">
                                                    <tr class="text-center">
                                                        <td colspan="7">
                                                            <span class="remote-data" >
                                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Damages Due Payment Tabel -->


                            <!-- Total Tabel -->
                            <table class="table dataTable no-footer">
                         
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">Total Balance</th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>

                                <tbody>

                                    <tr>
                                        <td colspan="7" style="position: relative;height: 100px;">
                                            <table style="width: 50%;position: absolute;left: 0;" >
                                                <tbody id="total_tabel">
                                                    <tr>
                                                        <th>Opening Balance :</th>
                                                        <td>
                                                            <span class="display_currency" id="total_opening_balance" data-currency_symbol="true"></span>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <th>Total Sell :</th>
                                                        <td>
                                                            <span id="total_sell">৳ 0.00</span>
                                                        </td>
                                                    </tr> 

                                                    <tr>
                                                        <th>Total Cus.Due.Re :</th>
                                                        <td>
                                                            <span id="customer_due">৳ 0.00</span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table style="width: 50%;position: absolute;right: 0;">
                                                <tbody id="total_s_tabel">
                                                    <tr>
                                                        <th>Total Expenses:</th>
                                                        <td>
                                                            <span id="total_expense" data-currency_symbol="true">৳ 0.00</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Total Purchase :</th>
                                                        <td>
                                                            <span id="total_purchase">৳ 0.00</span>
                                                        </td>
                                                    </tr> 
                                                    <tr>
                                                        <th>Total Sup.Due.Re :</th>
                                                        <td>
                                                            <span id="supplier_due">৳ 0.00</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Total Damages :</th>
                                                        <td>
                                                            <span class="display_currency" id="total_adjustment" data-currency_symbol="true">৳ 0.00</span>
                                                        </td>
                                                    </tr>  
                                                </tbody>
                                            </table>
                                        </td>


                                    </tr>

                                </tbody>
                            </table>
                            <!-- Total Tabel -->




                            <!-- Closing Balance Tabel -->
                            <table class="table dataTable no-footer" id="daily_closing_balance_tabel">
                                <thead>
                                    <tr class="bg-gray main_head" role="row">
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="40%" class="text-center">Closing Balance</th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                        <th width="10%"></th>
                                    </tr>
                                </thead>
                                <tbody id="closing_balance">
                                    <tr class="text-center">
                                        <td>
                                            <span class="remote-data" >
                                                <i class="fas fa-sync fa-spin fa-fw"></i>
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <!-- /Closing Balance Tabel -->


                            <table class="table">
                                <tbody>
                                    <tr role="row">
                                        <td colspan="5" class="row-border" style="width: 70%;"></td>
                                        <td colspan="2" id="signature" style="text-align: center;padding-top: 80px;width: 30%;">Signature</td>
                                    </tr>
                                </tbody>
                            </table>
                    

                        </tr>
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</section>
<!-- /.content -->

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>

    <script type="text/javascript">




        function printPage() {
            window.print();
        }

        // Call the printPage function when a button or link is clicked
        // Example using a button with id "print-button"
        document.getElementById("dailyReportPrint").addEventListener("click", printPage);















        $(document).ready( function(){

















            //Date picker
            $('#end_date').datepicker({
                autoclose: true,
                format: datepicker_date_format
            });
            update_daily_report();

            $('#end_date').change( function() {
                update_daily_report();
                $('#hidden_date').text($(this).val());
            });
            $('#bal_sheet_location_id').change( function() {
                update_daily_report();
            });
        });

        function update_daily_report(){
            var end_date = $('input#end_date').val();
            var location_id = $('#bal_sheet_location_id').val()
            $.ajax({
                url: "{{action([\App\Http\Controllers\ReportController::class, 'getDailyReport'])}}?end_date=" + end_date + '&location_id=' + location_id, 
                dataType: "json",
                success: function(result){
   
                    var today_total_transaction = result.today_all_transaction_total;
                    var serialNumber = 1;

                    var contact_payment = result.contact_payments;

                    // Opening Balance
                    var account_details_before_date = result.account_details_before_date;
                    $('table#daily_opening_balance_tabel tbody#opening_balance').html('');
                    if (account_details_before_date === null) {
                        var opening_bal_tr = '<tr role="row"><td class="row-border" colspan="2">Opening Balance</td><td></td><td></td><td></td><td> ৳ 0.00 </td><td></td></tr>'
                        $('table#daily_opening_balance_tabel tbody#opening_balance').append(opening_bal_tr);
                    } else {
                        var opening_bal_with_sym = __currency_trans_from_en(account_details_before_date.balance, true);
                        var account_name = account_details_before_date.name;
                        var opening_bal_tr = '<tr role="row"><td class="row-border" colspan="2">Opening Balance ('+ account_name +')</td><td></td><td></td><td></td><td> ' + opening_bal_with_sym + ' </td><td></td></tr>'
                        $('table#daily_opening_balance_tabel tbody#opening_balance').append(opening_bal_tr);
                        
                    }
                    // . Opening Balance


                    // purchase_
                    $('table#purchases_tabel tbody#purchases_list').html('');
                    var total_purchase = __currency_trans_from_en(today_total_transaction.total_purchase_inc_tax, true);
                    var purchase_paid = __currency_trans_from_en(today_total_transaction.purchase_paid, true);
                    var total_purchase_return_paid = __currency_trans_from_en(today_total_transaction.total_purchase_return_paid, true);
                    var purchase_due = __currency_trans_from_en(parseInt(today_total_transaction.total_purchase_inc_tax) - parseInt(today_total_transaction.purchase_paid), true);
                    var purchases_total_tr = '<tr><td width="20%">'+ serialNumber +'</td><td width="20%">'+ total_purchase +'</td><td width="40%">'+ purchase_paid +'</td><td width="20%">'+ purchase_due +'</td></tr>';
                    $('table#purchases_tabel tbody#purchases_list').append(purchases_total_tr);

                    


                    // sell_
                    $('table#sell_tabel tbody#sell_list').html('');
                    var total_sell = __currency_trans_from_en(today_total_transaction.total_sell_inc_tax, true);
                    var sell_paid = __currency_trans_from_en(today_total_transaction.total_sell_paid, true);
                    var total_sell_return_paid = __currency_trans_from_en(today_total_transaction.total_sell_return_paid, true);
                    var sell_due = __currency_trans_from_en(parseInt(today_total_transaction.total_sell_inc_tax)-parseInt(today_total_transaction.total_sell_paid), true);
                    var sell_total_tr = '<tr><td width="20%">'+ serialNumber +'</td><td width="20%">'+ total_sell +'</td><td width="40%">'+ sell_paid +'</td><td width="20%">'+ sell_due +'</td></tr>';
                    $('table#sell_tabel tbody#sell_list').append(sell_total_tr);
                    // .sell_list



                    // expenses_tabel
                    $('table#expenses_tabel tbody#expenses_list').html('');
                    var total_expense = __currency_trans_from_en(today_total_transaction.total_expense, true);
                    var expense_paid = __currency_trans_from_en(today_total_transaction.expense_paid, true);
                    var total_expense_due = __currency_trans_from_en(parseInt(today_total_transaction.total_expense)-parseInt(today_total_transaction.expense_paid), true);
                    var total_expense_tr = '<tr><td width="20%">'+ serialNumber +'</td><td width="20%">'+ total_expense +'</td><td width="40%">'+ expense_paid +'</td><td width="20%">'+ total_expense_due +'</td></tr>';
                    $('table#expenses_tabel tbody#expenses_list').append(total_expense_tr);
                    // .expenses_list


                    $('table#expenses_refound_tabel tbody#expenses_refound_list').html('');
                    var total_expense_refund = __currency_trans_from_en(today_total_transaction.total_expense_refund, true);
                    var expense_refund_paid = __currency_trans_from_en(today_total_transaction.expense_refund_paid, true);
                    var total_expense_refund_due = __currency_trans_from_en(parseInt(today_total_transaction.total_expense_refund)-parseInt(today_total_transaction.expense_refund_paid), true);
                    var total_expense_refund_tr = '<tr><td width="20%">'+ serialNumber +'</td><td width="20%">'+ total_expense_refund +'</td><td width="40%">'+ expense_refund_paid +'</td><td width="20%">'+ total_expense_refund_due +'</td></tr>';
                    $('table#expenses_refound_tabel tbody#expenses_refound_list').append(total_expense_refund_tr);
                    // 


                               
                    // damages_tabel
                    $('table#damages_tabel tbody#damages_list').html('');
                    var total_damages = __currency_trans_from_en(today_total_transaction.total_damage, true);
                    var total_damage_amount_recovered = __currency_trans_from_en(today_total_transaction.total_damage_amount_recovered, true);
                    var total_damages_tr = '<tr><td width="20%">'+ serialNumber +'</td><td width="20%">'+ total_damages +'</td><td width="40%">'+ total_damage_amount_recovered +'</td><td width="20%"></td></tr>';
                    $('table#damages_tabel tbody#damages_list').append(total_damages_tr);
                    // .damages_list



                    // supplier_duepayment_tabel
                    $('table#supplier_duepayment_tabel tbody#supplier_duepayment_list').html('');
                    var total_payamount = contact_payment.today_total_supplier_payment
                    var total_supplier_due = result.total_supplier_due;
                    var parsedTotalSupplierDue = parseInt(total_supplier_due);
                    var parsedTotalPayAmount = parseInt(total_payamount);
                    var total_previous_day_due = (parsedTotalSupplierDue+parsedTotalPayAmount);
                    var total_supplier_duepayment_tr = '<tr><td width="20%">'+ serialNumber +'</td><td width="20%">'+ __currency_trans_from_en(total_previous_day_due) +'</td><td width="40%">'+ __currency_trans_from_en(total_payamount) +'</td><td width="20%">'+ __currency_trans_from_en(parsedTotalSupplierDue) +'</td></tr>';
                    $('table#supplier_duepayment_tabel tbody#supplier_duepayment_list').append(total_supplier_duepayment_tr);
                    // .supplier_duepayment_tabel
                    
                    // supplier_duepayment_tabel
                    $('table#sell_duepayment_tabel tbody#sell_duepayment_list').html('');
                    var total_recivedamount = contact_payment.today_total_customer_payment;
                    var total_customer_due = result.total_customer_due

                    
                    var total_cus_previous_due = parseInt(total_customer_due)+parseInt(total_recivedamount);
                    var sell_recivedayment_tr = '<tr><td width="20%">'+ serialNumber +'</td><td width="20%">'+ __currency_trans_from_en(total_cus_previous_due) +'</td><td width="40%">'+ __currency_trans_from_en(total_recivedamount) +'</td><td width="20%">'+ __currency_trans_from_en(total_customer_due) +'</td></tr>';
                    $('table#sell_duepayment_tabel tbody#sell_duepayment_list').append(sell_recivedayment_tr);
                    // .supplier_duepayment_tabel
                






                    // Closing Balance
                    var account_details_with_date = result.account_details_with_date;
                    $('table#daily_closing_balance_tabel tbody#closing_balance').html('');
                    if (account_details_with_date === null) {
                        var opening_bal_tr = '<tr role="row"><td class="row-border" colspan="2">Closing Balance</td><td></td><td></td><td></td><td> ৳ 0.00 </td><td></td></tr>'
                        $('table#daily_closing_balance_tabel tbody#closing_balance').append(opening_bal_tr);
                    } else {
                        var closing_bal_with_sym = __currency_trans_from_en(account_details_with_date.balance, true);
                        var account_name = account_details_with_date.name;
                        var closing_bal_tr = '<tr role="row"><td class="row-border" colspan="2">Closing Balance ('+ account_name +')</td><td></td><td></td><td></td><td> ' + closing_bal_with_sym + ' </td><td></td></tr>'
                        $('table#daily_closing_balance_tabel tbody#closing_balance').append(closing_bal_tr);
                    }
                    
                    // . Total Tabel
                    if (account_details_before_date === null) {
                        var total_opening_bal = "৳ 0.00";
                    }else{
                        var total_opening_bal = __currency_trans_from_en(account_details_before_date.balance, true);
                    }
                    $("tbody#total_tabel #total_opening_balance").html(total_opening_bal)
                    
                    $("tbody#total_tabel #total_sell").html(total_sell)   
                    $("tbody#total_s_tabel #total_purchase").html(total_purchase)
                    
                    $("tbody#total_tabel #customer_due").html(total_recivedamount)
                    $("tbody#total_s_tabel #supplier_due").html(total_payamount)

                    var total_expense = __currency_trans_from_en(today_total_transaction.total_expense, true)
                    $("tbody#total_s_tabel #total_expense").html(total_expense)

                    
                    var total_adjustment = __currency_trans_from_en(today_total_transaction.total_adjustment, true)
                    $("tbody#total_s_tabel #total_adjustment").html(total_adjustment)
                    

                }
            });
        }

        function getContactBalance(contact_id, business_id){
         
            return new Promise(function(resolve, reject) {
                $.ajax({
                    url: "{{action([\App\Http\Controllers\ReportController::class, 'getContactBalance'])}}?contact_id=" + contact_id + '&business_id=' + business_id,
                    dataType: "json",
                    success: function(result) {
                        resolve(result);
                    },
                    error: function(error) {
                        reject(error);
                    }
                });
            });
        }

    </script>

@endsection