
<tr class="purchase_product_row" @if(!empty($purchase_order_line)) data-purchase_order_id="{{$purchase_order_line->transaction_id}}" @endif @if(!empty($purchase_requisition_line)) data-purchase_requisition_id="{{$purchase_requisition_line->transaction_id}}" @endif>
    @php
        $currency_precision = session('business.currency_precision', 2);
        $quantity_precision = session('business.quantity_precision', 2);
    @endphp
    <td>
        {{ $product->name }} ({{$variation->sub_sku}})

        @php
            $custom_labels = json_decode(session('business.custom_labels'), true);
            $product_custom_fields = !empty($custom_labels['product']) ? $custom_labels['product'] : [];
            $product_cf_details = !empty($custom_labels['product_cf_details']) ? $custom_labels['product_cf_details'] : [];
        @endphp

        @foreach($product_custom_fields as $index => $cf)
            @if(!empty($cf))
                @php
                    $db_field_name = 'product_custom_field' . $loop->iteration;
                    $cf_type = !empty($product_cf_details[$loop->iteration]['type']) ? $product_cf_details[$loop->iteration]['type'] : 'text';
                    $dropdown = !empty($product_cf_details[$loop->iteration]['dropdown_options']) 
                                ? explode(PHP_EOL, $product_cf_details[$loop->iteration]['dropdown_options']) 
                                : [];
                    $value = $product->$db_field_name ?? null;
                @endphp
                <br>
                @if(in_array($cf_type, ['text', 'date']))
                    {{ $cf }} : {{ $value }}
                @elseif($cf_type == 'dropdown')
                    {{ $cf }} : {{$dropdown[$product->$db_field_name] ?? ''}}
                
                @endif 
            @endif

        @endforeach
        
        @if( $product->type == 'variable' )
            <br/>
            (<b>{{ $variation->product_variation->name }}</b> : {{ $variation->name }})
        @endif
        @if($product->enable_stock == 1)
            <br>
            <small class="text-muted" style="white-space: nowrap;">@lang('report.current_stock'): @if(!empty($variation->variation_location_details->first())) {{@num_format($variation->variation_location_details->first()->qty_available)}} @else 0 @endif {{ $product->unit->short_name }}</small>
        @endif
    </td>













    @if(!empty($common_settings['enable_serial_number']))

        @if($product->enable_serial_number == "1")
            <td style="text-align: center">
                <div class="form-group">
                    @php
                        $serial_numbers = App\SerialNumber::where('serial_purchase_code', $purchase->serial_purchase_code)->where('stock_status','available')->get();
                    @endphp
                
                    <div class="form-group">
                        <button  type="button" data-value="product_serial_novaluesetbox{{$p_row_count}}" value="quentity_box{{$p_row_count}}" class="btn btn-info btn-xs btn-modal purchases_serial_numberModelButton" data-toggle="modal" data-target="#purchases_serial_numberModel">
                            Show Serial
                        </button>

                        <div>
                            <input id="product_serial_novaluesetbox{{$p_row_count}}" type="hidden" value="@php
                                $num_of_items = count($serial_numbers);
                                $num_count = 0;
                                foreach ($serial_numbers as $serial_number) {
                                    echo $serial_number->serial_number;
                                    $num_count = $num_count + 1;
                                    if ($num_count < $num_of_items) {
                                    echo ",";
                                    }
                                }
                            @endphp" name="purchases[{{$p_row_count}}][product_serial_no]">
                        </div>
                    </div>

                    <input type="hidden" name="purchases[{{$p_row_count}}][serial_purchase_code]" value="{{$purchase->serial_purchase_code}}"  class="form-control input-sm input_number">
                </div>
            </td>

            <td>
                @if(!empty($purchase->purchase_order_line_id) && !empty($common_settings['enable_purchase_order']))
                    {!! Form::hidden('purchases[' . $p_row_count . '][purchase_order_line_id]', $purchase->purchase_order_line_id ); !!}
                @endif

                @if(!empty($purchase->purchase_requisition_line_id) && !empty($common_settings['enable_purchase_requisition']))
                    {!! Form::hidden('purchases[' . $p_row_count . '][purchase_requisition_line_id]', $purchase->purchase_requisition_line_id ); !!}
                @endif

                {!! Form::hidden('purchases[' . $p_row_count . '][product_id]', $purchase->product_id ); !!}
                {!! Form::hidden('purchases[' . $p_row_count . '][variation_id]', $purchase->variation_id ); !!}
                {!! Form::hidden('purchases[' . $p_row_count . '][purchase_line_id]',
                $purchase->id); !!}

                @php
                    $check_decimal = 'false';
                    if($product->unit->allow_decimal == 0){
                        $check_decimal = 'true';
                    }
                    $max_quantity = 0;

                    if(!empty($purchase->purchase_order_line_id) && !empty($common_settings['enable_purchase_order'])){
                        $max_quantity = $purchase->purchase_order_line->quantity - $purchase->purchase_order_line->po_quantity_purchased + $purchase->quantity;
                    }
                @endphp

                <div class="quentity_box" id="quentity_box{{ $p_row_count }}">
                    <input type="text" 
                    name="purchases[{{$p_row_count}}][quantity]" 
                    value="{{@format_quantity($purchase->quantity)}}"
                    class="form-control input-sm purchase_quantity input_number mousetrap"
                    required
                    data-rule-abs_digit={{$check_decimal}}
                    data-msg-abs_digit="{{__('lang_v1.decimal_value_not_allowed')}}"
                    @if(!empty($max_quantity))
                        data-rule-max-value="{{$max_quantity}}"
                        data-msg-max-value="{{__('lang_v1.max_quantity_quantity_allowed', ['quantity' => $max_quantity])}}" 
                    @endif
                    >
                </div>

                <input type="hidden" class="base_unit_cost" value="{{$purchase->variations->default_purchase_price}}">
                    @if(!empty($purchase->sub_units_options))
                        <br>
                        <select name="purchases[{{$p_row_count}}][sub_unit_id]" class="form-control input-sm sub_unit">
                            @foreach($purchase->sub_units_options as $sub_units_key => $sub_units_value)
                                <option value="{{$sub_units_key}}" 
                                    data-multiplier="{{$sub_units_value['multiplier']}}"
                                    @if($sub_units_key == $purchase->sub_unit_id) selected @endif>
                                    {{$sub_units_value['name']}}
                                </option>
                            @endforeach
                        </select>
                    @else
                        {{ $product->unit->short_name }}
                    @endif

                <input type="hidden" name="purchases[{{$p_row_count}}][product_unit_id]" value="{{$product->unit->id}}">

                <input type="hidden" class="base_unit_selling_price" value="{{$purchase->variations->sell_price_inc_tax}}">

                @if(!empty($product->second_unit))
                    <br><br>
                    <span style="white-space: nowrap;">
                    @lang('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit->short_name])*:</span><br>
                    <input type="text" 
                    name="purchases[{{$p_row_count}}][secondary_unit_quantity]" 
                    value="{{@format_quantity($purchase->secondary_unit_quantity)}}"
                    class="form-control input-sm input_number"
                    required>
                @endif


            </td>

        @else
            <td>
                No Serial
            </td>

            <td>
                @if(!empty($purchase->purchase_order_line_id) && !empty($common_settings['enable_purchase_order']))
                    {!! Form::hidden('purchases[' . $p_row_count . '][purchase_order_line_id]', $purchase->purchase_order_line_id ); !!}
                @endif

                @if(!empty($purchase->purchase_requisition_line_id) && !empty($common_settings['enable_purchase_requisition']))
                    {!! Form::hidden('purchases[' . $p_row_count . '][purchase_requisition_line_id]', $purchase->purchase_requisition_line_id ); !!}
                @endif

                {!! Form::hidden('purchases[' . $p_row_count . '][product_id]', $purchase->product_id ); !!}
                {!! Form::hidden('purchases[' . $p_row_count . '][variation_id]', $purchase->variation_id ); !!}
                {!! Form::hidden('purchases[' . $p_row_count . '][purchase_line_id]',
                $purchase->id); !!}

                @php
                    $check_decimal = 'false';
                    if($product->unit->allow_decimal == 0){
                        $check_decimal = 'true';
                    }
                    $max_quantity = 0;

                    if(!empty($purchase->purchase_order_line_id) && !empty($common_settings['enable_purchase_order'])){
                        $max_quantity = $purchase->purchase_order_line->quantity - $purchase->purchase_order_line->po_quantity_purchased + $purchase->quantity;
                    }
                @endphp


                <input type="text" 
                name="purchases[{{$p_row_count}}][quantity]" 
                value="{{@format_quantity($purchase->quantity)}}"
                class="form-control input-sm purchase_quantity input_number mousetrap"
                required
                data-rule-abs_digit={{$check_decimal}}
                data-msg-abs_digit="{{__('lang_v1.decimal_value_not_allowed')}}"
                @if(!empty($max_quantity))
                    data-rule-max-value="{{$max_quantity}}"
                    data-msg-max-value="{{__('lang_v1.max_quantity_quantity_allowed', ['quantity' => $max_quantity])}}" 
                @endif
                >

                <input type="hidden" class="base_unit_cost" value="{{$purchase->variations->default_purchase_price}}">
                @if(!empty($purchase->sub_units_options))
                    <br>
                    <select name="purchases[{{$p_row_count}}][sub_unit_id]" class="form-control input-sm sub_unit">
                        @foreach($purchase->sub_units_options as $sub_units_key => $sub_units_value)
                            <option value="{{$sub_units_key}}" 
                                data-multiplier="{{$sub_units_value['multiplier']}}"
                                @if($sub_units_key == $purchase->sub_unit_id) selected @endif>
                                {{$sub_units_value['name']}}
                            </option>
                        @endforeach
                    </select>
                @else
                    {{ $product->unit->short_name }}
                @endif

                <input type="hidden" name="purchases[{{$p_row_count}}][product_unit_id]" value="{{$product->unit->id}}">

                <input type="hidden" class="base_unit_selling_price" value="{{$purchase->variations->sell_price_inc_tax}}">

                @if(!empty($product->second_unit))
                    <br><br>
                    <span style="white-space: nowrap;">
                    @lang('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit->short_name])*:</span><br>
                    <input type="text" 
                    name="purchases[{{$p_row_count}}][secondary_unit_quantity]" 
                    value="{{@format_quantity($purchase->secondary_unit_quantity)}}"
                    class="form-control input-sm input_number"
                    required>
                @endif
            </td>

        @endif

    @else

        <td>
            @if(!empty($purchase->purchase_order_line_id) && !empty($common_settings['enable_purchase_order']))
                {!! Form::hidden('purchases[' . $p_row_count . '][purchase_order_line_id]', $purchase->purchase_order_line_id ); !!}
            @endif

            @if(!empty($purchase->purchase_requisition_line_id) && !empty($common_settings['enable_purchase_requisition']))
                {!! Form::hidden('purchases[' . $p_row_count . '][purchase_requisition_line_id]', $purchase->purchase_requisition_line_id ); !!}
            @endif

            {!! Form::hidden('purchases[' . $p_row_count . '][product_id]', $purchase->product_id ); !!}
            {!! Form::hidden('purchases[' . $p_row_count . '][variation_id]', $purchase->variation_id ); !!}
            {!! Form::hidden('purchases[' . $p_row_count . '][purchase_line_id]',
            $purchase->id); !!}

            @php
                $check_decimal = 'false';
                if($product->unit->allow_decimal == 0){
                    $check_decimal = 'true';
                }
                $max_quantity = 0;

                if(!empty($purchase->purchase_order_line_id) && !empty($common_settings['enable_purchase_order'])){
                    $max_quantity = $purchase->purchase_order_line->quantity - $purchase->purchase_order_line->po_quantity_purchased + $purchase->quantity;
                }
            @endphp

            <input type="text" 
            name="purchases[{{$p_row_count}}][quantity]" 
            value="{{@format_quantity($purchase->quantity)}}"
            class="form-control input-sm purchase_quantity input_number mousetrap"
            required
            data-rule-abs_digit={{$check_decimal}}
            data-msg-abs_digit="{{__('lang_v1.decimal_value_not_allowed')}}"
            @if(!empty($max_quantity))
                data-rule-max-value="{{$max_quantity}}"
                data-msg-max-value="{{__('lang_v1.max_quantity_quantity_allowed', ['quantity' => $max_quantity])}}" 
            @endif
            >

            <input type="hidden" class="base_unit_cost" value="{{$purchase->variations->default_purchase_price}}">
            @if(!empty($purchase->sub_units_options))
                <br>
                <select name="purchases[{{$p_row_count}}][sub_unit_id]" class="form-control input-sm sub_unit">
                    @foreach($purchase->sub_units_options as $sub_units_key => $sub_units_value)
                        <option value="{{$sub_units_key}}" 
                            data-multiplier="{{$sub_units_value['multiplier']}}"
                            @if($sub_units_key == $purchase->sub_unit_id) selected @endif>
                            {{$sub_units_value['name']}}
                        </option>
                    @endforeach
                </select>
            @else
                {{ $product->unit->short_name }}
            @endif

            <input type="hidden" name="purchases[{{$p_row_count}}][product_unit_id]" value="{{$product->unit->id}}">

            <input type="hidden" class="base_unit_selling_price" value="{{$purchase->variations->sell_price_inc_tax}}">

            @if(!empty($product->second_unit))
                <br><br>
                <span style="white-space: nowrap;">
                @lang('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit->short_name])*:</span><br>
                <input type="text" 
                name="purchases[{{$p_row_count}}][secondary_unit_quantity]" 
                value="{{@format_quantity($purchase->secondary_unit_quantity)}}"
                class="form-control input-sm input_number"
                required>
            @endif
        </td>

    @endif





    @if ($product->use_multi_unit == 1)

        @php
            $pos_unit_price = !empty($product->unit_price_before_discount) ? $product->unit_price_before_discount : $product->default_sell_price;
        @endphp
        @if (!empty($product->first_conversion_unit_id))
            <input type="hidden" class="is_enable_product_multi_unit" value="1" name="purchases[{{$p_row_count}}][is_enable_product_multi_unit]">
        @endif

        <input type="hidden" class="main_unit" value="1" data-name="{{$product->unit}}" data-id="{{$product->unit_id}}">
        <input type="hidden" class="first_unit" name="purchases[{{$p_row_count}}][first_conversion_unit_rate]" value="{{$product->first_conversion_unit_rate}}" data-name="{{$product->first_conversion_short_name}}" data-id="{{$product->first_conversion_unit_id}}">
        <input type="hidden" class="second_unit" name="purchases[{{$p_row_count}}][second_conversion_unit_rate]"  value="{{$product->second_conversion_unit_rate}}" data-name="{{$product->second_conversion_short_name}}" data-id="{{$product->second_conversion_unit_id}}">
        <input type="hidden" class="base_unit_quantity" name="purchases[{{$p_row_count}}][base_unit_quantity]" value="{{$product->quantity_ordered}}">
        <input type="hidden" class="fu_default_sell_price" name="purchases[{{$p_row_count}}][fu_default_sell_price]" value="{{$product->fu_default_sell_price}}">			
        <input type="hidden" class="su_default_sell_price" name="purchases[{{$p_row_count}}][su_default_sell_price]" value="{{$product->su_default_sell_price}}">
        
        <input type="hidden" class="" name="purchases[{{$p_row_count}}][first_conversion_unit_id]" value="{{$product->first_conversion_unit_id}}">			
        <input type="hidden" class="" name="purchases[{{$p_row_count}}][second_conversion_unit_id]" value="{{$product->second_conversion_unit_id}}">			
        

        @if(!empty($pos_settings['show_multi_unit']))
            <td class="text-center use_multi_unit">
                @php
                    $first_unit_id = null;
                    $second_unit_id = null;
                    $first_unit_c_rate = null;
                    $second_unit_c_rate = null;
                    $first_quantity = $product->quantity_ordered;
                    $second_quantity = $product->quantity_ordered;

                    
                    $first_unit_name = null;
                    $second_unit_name = null;

                    if ($product->sell_unit_id == $product->unit_id || empty($product->sell_unit_id)) {
                        $first_unit_id = $product->first_conversion_unit_id;
                        $second_unit_id = $product->second_conversion_unit_id;
            
                        $first_unit_c_rate = $product->first_conversion_unit_rate;
                        $second_unit_c_rate = $product->second_conversion_unit_rate;

                        if (!empty($first_unit_id)) {
                            $first_unit = App\Unit::where('id', $first_unit_id)->first();
                            $first_unit_name = $first_unit->short_name;
                            $first_quantity = $product->quantity_ordered/$first_unit_c_rate;
                        }

                        if (!empty($second_unit_id)) {
                            $second_unit = App\Unit::where('id', $second_unit_id)->first();
                            $second_unit_name = $second_unit->short_name;
                            $second_quantity = $product->quantity_ordered/$second_unit_c_rate;
                        }

                    }

                    if (($product->sell_unit_id == $product->first_conversion_unit_id) && !empty($product->sell_unit_id)) {
                        $first_unit_id = $product->unit_id;
                        $second_unit_id = $product->second_conversion_unit_id;
                        

                        $first_unit_c_rate = 1*$product->first_conversion_unit_rate;
                        $second_unit_c_rate = '';
                        if ($product->second_conversion_unit_rate>0) {
                            $second_unit_c_rate = 1/$product->second_conversion_unit_rate;
                        }





                        if (!empty($first_unit_id)) {
                            $first_unit = App\Unit::where('id', $first_unit_id)->first();
                            $first_unit_name = $first_unit->short_name;
                            $first_quantity = $product->quantity_ordered*$first_unit_c_rate;
                        }

                        if (!empty($second_unit_id)) {
                            $second_unit = App\Unit::where('id', $second_unit_id)->first();
                            $second_unit_name = $second_unit->short_name;
                            $second_quantity = $product->quantity_ordered*$second_unit_c_rate;
                        }


        
                    }

                    if (($product->sell_unit_id == $product->second_conversion_unit_id) && !empty($product->sell_unit_id)) {
                        $first_unit_id = $product->unit_id;
                        $second_unit_id = $product->first_conversion_unit_id;
                        
                        $first_unit_c_rate = 1*($product->first_conversion_unit_rate*$product->second_conversion_unit_rate);
                        $second_unit_c_rate = 1*$product->second_conversion_unit_rate;


                        if (!empty($first_unit_id)) {
                            $first_unit = App\Unit::where('id', $first_unit_id)->first();
                            $first_unit_name = $first_unit->short_name;
                            $first_quantity = $product->quantity_ordered*$first_unit_c_rate;
                        }

                        if (!empty($second_unit_id)) {
                            $second_unit = App\Unit::where('id', $second_unit_id)->first();
                            $second_unit_name = $second_unit->short_name;
                            $second_quantity = $product->quantity_ordered*$second_unit_c_rate;
                        }
            
                    }

                @endphp

                <span class="first_conversion_unit_rate" style="display: block;">
                    @if (!empty($product->first_conversion_unit_rate))
                        <span class="">
                            {{ $first_quantity }}&nbsp;{{ $first_unit_name }}
                        </span>
                    @else
                        --
                    @endif
                </span>

                <span class="second_conversion_unit_rate">
                    @if (!empty($product->second_conversion_unit_rate))
                        <span class="">
                            {{ $second_quantity }}&nbsp;{{ $second_unit_name }}
                        </span>
                    @else
                        --
                    @endif
                </span>

            </td>
        @endif

    @else
        @if(!empty($pos_settings['show_multi_unit']))
            <td class="text-center">
                --
                <input type="hidden" class="is_enable_product_multi_unit"  name="purchases[{{$p_row_count}}][is_enable_product_multi_unit]">
            </td>
        @endif
    @endif

    <td>
        {!! Form::text('purchases[' . $p_row_count . '][pp_without_discount]', number_format($purchase->pp_without_discount, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator), ['class' => 'form-control input-sm purchase_unit_cost_without_discount input_number', 'required']); !!}
    </td>









    <td class="hide">
        @php
            $discount_type = !empty($purchase->line_discount_type) ? $purchase->line_discount_type : 'fixed';
            $discount_amount = !empty($purchase->line_discount_amount) ? $purchase->line_discount_amount : 0;
            $discount_type = 'fixed';
        @endphp

        {!! Form::text('purchases[' . $p_row_count . '][discount_percent]', number_format($purchase->discount_percent, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator), ['class' => 'form-control input-sm inline_discounts input_number', 'required']); !!} <b>%</b>
    
        {!! Form::select("purchases[$p_row_count][line_discount_type]", ['fixed' => __('lang_v1.fixed'), 'percentage' => __('lang_v1.percentage')], $discount_type, ['class' => 'form-control row_discount_type']); !!}

    </td>

    <td class="hide">
         {!! Form::text('purchases[' . $p_row_count . '][purchase_price]', number_format($purchase->purchase_price, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator), ['class' => 'form-control input-sm purchase_unit_cost input_number', 'required']); !!}
    </td>



    <td class="hide">
        <div class="input-group">
            <select name="purchases[{{ $p_row_count }}][purchase_line_tax_id]" class="form-control select2 input-sm purchase_line_tax_id" placeholder="'Please Select'">
                <option value="" data-tax_amount="0"  selected>
                    @lang('lang_v1.none')
                </option>
            </select>
            {!! Form::hidden('purchases[' . $p_row_count . '][item_tax]', number_format($purchase->item_tax, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator), ['class' => 'purchase_product_unit_tax']); !!}
            <span class="input-group-addon purchase_product_unit_tax_text">
                {{number_format($purchase->item_tax, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator)}}
            </span>
        </div>
    </td>



    <td>
        {!! Form::text('purchases[' . $p_row_count . '][purchase_price_inc_tax]', number_format($purchase->purchase_price_inc_tax, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator), ['class' => 'form-control input-sm purchase_unit_cost_after_tax input_number', 'required']); !!}
    </td>



    <td class="hide">
       <span class="row_subtotal_after_tax">
            {{number_format($purchase->purchase_price_inc_tax * $purchase->quantity, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator)}}
        </span>
        <input type="hidden" class="row_subtotal_after_tax_hidden" value="{{number_format($purchase->purchase_price_inc_tax * $purchase->quantity, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator)}}">
    </td>



    <td class="hide">
        @php
            $pp = $purchase->purchase_price_inc_tax;
            $sp = $purchase->variations->sell_price_inc_tax;
            if(!empty($purchase->sub_unit->base_unit_multiplier)) {
                $sp = $sp * $purchase->sub_unit->base_unit_multiplier;
            }
            if($pp == 0){
                $profit_percent = 100;
            } else {
                $profit_percent = (($sp - $pp) * 100 / $pp);
            }
        @endphp
        {!! Form::text('purchases[' . $p_row_count . '][profit_percent]', number_format($profit_percent, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator), ['class' => 'form-control input-sm input_number profit_percent', 'required']); !!}
    </td>










    @if(empty($is_purchase_order))
        <td class="hide">
            @if(session('business.enable_editing_product_from_purchase'))
                {!! Form::text('purchases[' . $p_row_count . '][default_sell_price]', number_format($sp, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator), ['class' => 'form-control input-sm input_number default_sell_price', 'required']); !!}
            @else
                {{number_format($sp, $currency_precision, $currency_details->decimal_separator, $currency_details->thousand_separator)}}
            @endif
        </td>


        @if(session('business.enable_lot_number'))
            <td class="hide">
                {!! Form::text('purchases[' . $p_row_count . '][lot_number]', $purchase->lot_number, ['class' => 'form-control input-sm']); !!}
            </td>
        @endif

        @php
            $mfg_date = null;
            $exp_date = null;
            if(!empty($purchase->mfg_date)){
                $mfg_date = $purchase->mfg_date;
            }
            if(!empty($purchase->exp_date)){
                $exp_date = $purchase->exp_date;
            }
        @endphp

        @if(session('business.enable_product_expiry'))
            <td class="hide" style="text-align: left;">
                @php
                    $expiry_period_type = !empty($product->expiry_period_type) ? $product->expiry_period_type : 'month';
                @endphp
                @if(!empty($expiry_period_type))
                <input type="hidden" class="row_product_expiry" value="{{ $product->expiry_period }}">
                <input type="hidden" class="row_product_expiry_type" value="{{ $expiry_period_type }}">

                @if(session('business.expiry_type') == 'add_manufacturing')
                    @php
                        $hide_mfg = false;
                    @endphp
                @else
                    @php
                        $hide_mfg = true;
                    @endphp
                @endif

                @php
                    $mfg_date = !empty($imported_data['mfg_date']) ? $imported_data['mfg_date'] : null;
                    $exp_date = !empty($imported_data['exp_date']) ? $imported_data['exp_date'] : null;
                @endphp

                <b class="hide"><small>@lang('product.mfg_date'):</small></b>
                <div class="input-group hide">
                    <span class="input-group-addon">
                        <i class="fa fa-calendar"></i>
                    </span>
                    {!! Form::text('purchases[' . $p_row_count . '][mfg_date]', !empty($mfg_date) ? @format_date($mfg_date) : null, ['class' => 'form-control input-sm expiry_datepicker mfg_date', 'readonly']); !!}
                </div>
                <b><small>@lang('product.exp_date'):</small></b>
                <div class="input-group hide">
                    <span class="input-group-addon">
                        <i class="fa fa-calendar"></i>
                    </span>
                    {!! Form::text('purchases[' . $p_row_count . '][exp_date]', !empty($exp_date) ? @format_date($exp_date) : null, ['class' => 'form-control input-sm expiry_datepicker exp_date', 'readonly']); !!}
                </div>
                @else
                <div class="text-center">
                    @lang('product.not_applicable')
                </div>
                @endif
            </td>
        @endif
    @endif



    <?php $p_row_count++ ;?>

    <td>
        <i class="fa fa-times remove_purchase_entry_row text-danger" title="Remove" style="cursor:pointer;"></i>
    </td>

</tr>


