@if(!session('business.enable_price_tax')) 
  @php
    $default = 0;
    $class = 'hide';
  @endphp
@else
  @php
    $default = null;
    $class = '';
  @endphp
@endif

<div class="table-responsive">
    <table class="table table-bordered add-product-price-table table-condensed {{$class}}">
      
        <tr>
          <th>@lang('product.default_purchase_price')</th>
          <th>@lang('product.profit_percent') @show_tooltip(__('tooltip.profit_percent'))</th>
          <th>@lang('product.default_selling_price')</th>
          @if(empty($quick_add))
            <th>@lang('lang_v1.product_image')</th>
          @endif
        </tr>

        <tr class="single_variation">
          <td>
            <div class="col-sm-6">
              {!! Form::label('single_dpp', trans('product.exc_of_tax') . ':*') !!}

              {!! Form::text('single_dpp', $default, ['class' => 'form-control input-sm dpp input_number', 'placeholder' => __('product.exc_of_tax'), 'required']); !!}
            </div>

            <div class="col-sm-6">
              {!! Form::label('single_dpp_inc_tax', trans('product.inc_of_tax') . ':*') !!}
            
              {!! Form::text('single_dpp_inc_tax', $default, ['class' => 'form-control input-sm dpp_inc_tax input_number', 'placeholder' => __('product.inc_of_tax'), 'required']); !!}
            </div>
          </td>

          <td>
            <br/>
            {!! Form::text('profit_percent', @num_format($profit_percent), ['class' => 'form-control input-sm input_number', 'id' => 'profit_percent', 'required']); !!}
          </td>

          <td>
            <label><span class="dsp_label">@lang('product.exc_of_tax')</span></label>
            {!! Form::text('single_dsp', $default, ['class' => 'form-control input-sm dsp input_number', 'placeholder' => __('product.exc_of_tax'), 'id' => 'single_dsp', 'required']); !!}

            {!! Form::text('single_dsp_inc_tax', $default, ['class' => 'form-control input-sm hide input_number', 'placeholder' => __('product.inc_of_tax'), 'id' => 'single_dsp_inc_tax', 'required']); !!}
          </td>
          @if(empty($quick_add))
          <td>
              <div class="form-group">
                {!! Form::label('variation_images', __('lang_v1.product_image') . ':') !!}
                {!! Form::file('variation_images[]', ['class' => 'variation_images', 
                    'accept' => 'image/*', 'multiple']); !!}
                <small><p class="help-block">@lang('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)]) <br> @lang('lang_v1.aspect_ratio_should_be_1_1')</p></small>
              </div>
          </td>
          @endif

        </tr>

        <tr class="multi_unit fu_variation_value_row @if($use_multi_unit == 0 || $first_conversion_unit_id == 0) hide @endif single_variation">
          <td>
            <div class="col-sm-6">
              {!! Form::label('fu_single_dpp', trans('product.exc_of_tax') . ':*') !!}
              {!! Form::text('fu_single_dpp', $default, ['class' => 'form-control input-sm fu_dpp input_number', 'placeholder' => __('product.exc_of_tax')]); !!}
            </div>

            <div class="col-sm-6">
              {!! Form::label('fu_single_dpp_inc_tax', trans('product.inc_of_tax') . ':*') !!}
              {!! Form::text('fu_single_dpp_inc_tax', $default, ['class' => 'form-control input-sm fu_dpp_inc_tax input_number', 'placeholder' => __('product.inc_of_tax')]); !!}
            </div>
          </td>

          <td>
            <br/>
            {!! Form::text('fu_profit_percent', @num_format($profit_percent), ['class' => 'form-control input-sm input_number fu_profit_percent', 'id' => 'fu_profit_percent']); !!}
          </td>

          <td>
            <label>
              <span class="dsp_label">
                @lang('product.exc_of_tax')
              </span>
            </label>
            {!! Form::text('fu_single_dsp', $default, ['class' => 'form-control input-sm fu_dsp input_number fu_single_dsp', 'placeholder' => __('product.exc_of_tax'), 'id' => 'fu_single_dsp']); !!}
            {!! Form::text('fu_single_dsp_inc_tax', $default, ['class' => 'form-control input-sm hide input_number fu_single_dsp_inc_tax', 'placeholder' => __('product.inc_of_tax'), 'id' => 'fu_single_dsp_inc_tax']); !!}
          </td>
          <td>
            SKU For First Unit
            {!! Form::text('fu_sub_sku', null, ['class' => 'form-control input-sm input_number fu_sub_sku', 'id' => 'fu_sub_sku', 'placeholder' => __('sku')]); !!}
          </td>
        </tr>
        <tr class="multi_unit su_variation_value_row @if($use_multi_unit == 0 || $second_conversion_unit_id == 0) hide @endif single_variation">
          <td>
            <div class="col-sm-6">
              {!! Form::label('su_single_dpp', trans('product.exc_of_tax') . ':*') !!}
              {!! Form::text('su_single_dpp', $default, ['class' => 'form-control input-sm su_dpp input_number', 'placeholder' => __('product.exc_of_tax')]); !!}
            </div>

            <div class="col-sm-6">
              {!! Form::label('su_single_dpp_inc_tax', trans('product.inc_of_tax') . ':*') !!}
              {!! Form::text('su_single_dpp_inc_tax', $default, ['class' => 'form-control input-sm su_dpp_inc_tax input_number', 'placeholder' => __('product.inc_of_tax')]); !!}
            </div>
          </td>

          <td>
            <br/>
            {!! Form::text('su_profit_percent', @num_format($profit_percent), ['class' => 'form-control input-sm input_number su_profit_percent', 'id' => 'su_profit_percent']); !!}
          </td>

          <td>
            <label>
              <span class="dsp_label">
                @lang('product.su_exc_of_tax')
              </span>
            </label>
            {!! Form::text('su_single_dsp', $default, ['class' => 'form-control input-sm su_dsp input_number su_single_dsp', 'placeholder' => __('product.exc_of_tax'), 'id' => 'su_single_dsp']); !!}
            {!! Form::text('su_single_dsp_inc_tax', $default, ['class' => 'form-control input-sm hide input_number su_single_dsp_inc_tax', 'placeholder' => __('product.su_inc_of_tax'), 'id' => 'su_single_dsp_inc_tax']); !!}
          </td>
          <td>
            SKU For Second Unit
            {!! Form::text('su_sub_sku', null, ['class' => 'form-control input-sm input_number su_sub_sku', 'id' => 'su_sub_sku','placeholder' => __('sku')]); !!}
          </td>
        </tr>

    </table>
</div>