@php
	$common_settings = session()->get('business.common_settings');
	$multiplier = 1;
	$action = !empty($action) ? $action : '';
	$is_enable_product_multi_unit = !empty($common_settings['enable_product_multi_unit']);
@endphp

@foreach($sub_units as $key => $value)

	@if (!empty($product->first_conversion_unit_id) && $product->sub_unit_id == $product->first_conversion_unit_id)
		@php
			$multiplier = $product->first_conversion_unit_rate;	
		@endphp
	@elseif (!empty($product->second_conversion_unit_id) && $product->sub_unit_id == $product->second_conversion_unit_id)
		@php
			$multiplier = $product->first_conversion_unit_rate*$product->second_conversion_unit_rate;	
		@endphp
	@else
		@if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key)
			@php
				$multiplier = $value['multiplier'];
			@endphp
		@endif
	@endif

@endforeach


<tr class="product_row" data-row_index="{{$row_count}}">

    <td>
		@php
			$product_name = $product->product_name . '<br/>' . $product->sub_sku ;
			if(!empty($product->brand)){ $product_name .= ' ' . $product->brand ;}
		@endphp
		
		{!! $product_name !!}
		
		@if(!empty($pos_settings['show_last_price']))
			<div class="text-left" style="font-size: 10px;">
				@if(!empty($last_purchase_line))
					<small class="text-muted">@lang('lang_v1.last_purchase_price'): @format_currency($last_purchase_line->pp_without_discount)</small>
				@else
					<small class="text-muted">@lang('lang_v1.last_purchase_price'): @format_currency($product->default_purchase_price)</small>
				@endif
				@if(!empty($last_sell_line))
					<br>
					<small class="text-muted">
						@lang('lang_v1.last_selling_price'): @format_currency($last_sell_line->unit_price_before_discount)
					</small>
				@else
					<br>
					<small class="text-muted">
						@lang('lang_v1.last_selling_price'): @format_currency($product->sell_price_inc_tax)
					</small>
				@endif
			</div>
		@endif

	</td>
  
    <td style="display: flex;">
        <!-- If edit then transaction sell lines will be present -->
        @if(!empty($product->transaction_sell_lines_id))
            <input type="hidden" name="products[{{$row_count}}][transaction_sell_lines_id]" class="form-control" value="{{$product->transaction_sell_lines_id}}">
        @endif
        <input type="hidden" name="products[{{$row_count}}][product_id]" class="form-control product_id" value="{{$product->product_id}}">
        <input type="hidden" value="{{$product->variation_id}}" name="products[{{$row_count}}][variation_id]" class="row_variation_id">
        <input type="hidden" name="products[{{$row_count}}][product_unit_id]" value="{{$product->unit_id}}">

        @if(empty($product->quantity_ordered))
            @php
                $product->quantity_ordered = 1;
            @endphp
        @endif
        @php
            $allow_decimal = true;
            if($product->unit_allow_decimal != 1) {
                $allow_decimal = false;
            }
        @endphp

        @foreach($sub_units as $key => $value)
            @if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key)
                @php
                    $unit_name = $value['name'];
                    if($value['allow_decimal']) {
                        $allow_decimal = true;
                    }
                @endphp
            @endif
        @endforeach



        <div class="input-group input-number">
            <span class="input-group-btn">
                <button type="button" style="padding: 4px 3px !important;" class="btn btn-default btn-flat quantity-down">
                    <i class="fa fa-minus text-danger"></i>
                </button>
            </span>
            <input style="padding: 4px 3px;height: 30px;" type="text" data-min="1" min="1" class="form-control premade_quantity input_number input_quantity" value="{{@format_quantity($product->quantity_ordered)}}" name="products[{{$row_count}}][quantity]" data-allow-overselling="@if(empty($pos_settings['allow_overselling'])){{'false'}}@else{{'true'}}@endif" @if($allow_decimal) data-decimal=1 @else data-decimal=0 data-rule-abs_digit="true" data-msg-abs_digit="@lang('lang_v1.decimal_value_not_allowed')" @endif data-rule-required="true" data-msg-required="@lang('validation.custom-messages.this_field_is_required')">
            <span class="input-group-btn">
                <button type="button" style="padding: 4px 3px !important;" class="btn btn-default btn-flat quantity-up">
                    <i class="fa fa-plus text-success"></i>
                </button>
            </span>
        </div>
        

        @if(count($sub_units) > 0)
            <br>
            <select name="products[{{$row_count}}][sub_unit_id]" class="form-control input-sm sub_unit">
                @foreach($sub_units as $key => $value)
                    <option value="{{$key}}" data-multiplier="{{$value['multiplier']}}" data-unit_name="{{$value['name']}}" data-allow_decimal="{{$value['allow_decimal']}}" 
                    
                        @if($product->use_multi_unit == 1)
                            @if(!empty($product->sell_unit_id) && $product->sell_unit_id == $key) selected @endif
                        @else
                            @if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key) selected @endif
                        @endif

                        >

                        {{$value['name']}}
                    </option>
                @endforeach
        </select>

        @else
            {{$product->unit}}
            <input type="hidden" name="products[{{$row_count}}][sub_unit_id]" value="{{$product->unit_id}}">
        @endif

        @if(!empty($product->second_unit))
            <br>
            <span style="white-space: nowrap;">
                @lang('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit])*:
            </span>
            <br>
            <input type="text" name="products[{{$row_count}}][secondary_unit_quantity]" value="{{@format_quantity($product->secondary_unit_quantity)}}" class="form-control input-sm input_number" required>
        @endif

        <input type="hidden" class="base_unit_multiplier" name="products[{{$row_count}}][base_unit_multiplier]" value="{{$multiplier}}">
        <input type="hidden" class="hidden_base_unit_sell_price" value="{{$product->default_sell_price / $multiplier}}">

        <!-- Hidden fields for combo products -->
        @if($product->product_type == 'combo'&& !empty($product->combo_products))

            @foreach($product->combo_products as $k => $combo_product)

                @if(!empty($action) && $action == 'edit')
                    @php
                        $combo_product['qty_required'] = $combo_product['quantity'] / $product->quantity_ordered;

                        $qty_total = $combo_product['quantity'];
                    @endphp
                @else
                    @php
                        $qty_total = $combo_product['qty_required'];
                    @endphp
                @endif

                <input type="hidden" name="products[{{$row_count}}][combo][{{$k}}][product_id]" value="{{$combo_product['product_id']}}">

                <input type="hidden" name="products[{{$row_count}}][combo][{{$k}}][variation_id]" value="{{$combo_product['variation_id']}}">

                <input type="hidden" class="combo_product_qty" name="products[{{$row_count}}][combo][{{$k}}][quantity]" data-unit_quantity="{{$combo_product['qty_required']}}" value="{{$qty_total}}">

                @if(!empty($action) && $action == 'edit')
                    <input type="hidden" name="products[{{$row_count}}][combo][{{$k}}][transaction_sell_lines_id]" value="{{$combo_product['id']}}">
                @endif

            @endforeach

        @endif

    </td>


    <td class="text-center v-center">
        <input type="hidden" class="form-control default_purchase_price" name="products[{{$row_count}}][default_purchase_price]" value="{{@num_format($product->default_purchase_price )}}">
		<span class="display_currency default_purchase_price_text" data-currency_symbol="true">
            {{$product->default_purchase_price}}
        </span>
    </td>
    <td class="text-center v-center">
        <input type="hidden" class="form-control profit_percent" name="products[{{$row_count}}][profit_percent]" value="{{@num_format($product->profit_percent )}}">
		<span class="display_currency profit_percent_text" data-currency_symbol="true">
            {{$product->profit_percent}}
        </span>
    </td>
    <td class="text-center v-center">
        <input type="hidden" class="form-control premade_unit_price" name="products[{{$row_count}}][premade_unit_price]" value="{{@num_format($product->sell_price_inc_tax )}}">
        <input type="hidden" class="form-control premade_unit_price_inc_tax" name="products[{{$row_count}}][premade_unit_price_inc_tax]" value="{{@num_format($product->sell_price_inc_tax )}}">
        <input type="hidden" class="form-control item_tax" name="products[{{$row_count}}][item_tax]" value="{{$product->sell_price_inc_tax - $product->default_sell_price}}">
		<span class="display_currency premade_unit_price_text" data-currency_symbol="true">
            {{$product->default_sell_price}}
        </span>
    </td>    
    
    <td class="text-center v-center">
        <input type="hidden" class="form-control premade_line_total" name="products[{{$row_count}}][premade_line_total]" value="{{@num_format($product->quantity_ordered * $product->sell_price_inc_tax)}}">
		<span class="display_currency premade_line_total_text" data-currency_symbol="true">
            {{$product->quantity_ordered * $product->sell_price_inc_tax}}
        </span>
    </td>

    <td class="text-center v-center">
		<i class="fa fa-times text-danger premade_remove_row cursor-pointer" aria-hidden="true"></i>
	</td>

</tr>
