<div class="row">
	<div class="col-sm-12">
		@forelse($locations as $key => $value)
			<div class="box box-solid">

				<div class="box-header with-border">
					<h3 class="box-title">@lang('sale.location'): {{$value}}</h3>
				</div>

				<div class="box-body">
					<div class="row tw-overflow-scroll">
						<div class="col-sm-12">

							<table class="table table-condensed table-bordered text-center table-responsive table-striped add_opening_stock_table">
								
								<thead>
									<tr class="bg-green">
										<th>@lang( 'product.product_name' )</th>
										<th>Product Serial</th>
										<th>@lang( 'lang_v1.quantity_left' )</th>
										@php
											$warehouses_list = isset($warehouses) ? $warehouses : [];
											$has_warehouses = !empty($warehouses_list) && count($warehouses_list) > 0;
										@endphp
										@if($has_warehouses)
										<th>@lang( 'lang_v1.warehouse' )</th>
										@endif
										<th>@lang( 'purchase.unit_cost_before_tax' )</th>
										@if($enable_expiry == 1 && $product->enable_stock == 1)
											<th>Exp. Date</th>
										@endif
										@if($enable_lot == 1)
											<th>@lang( 'lang_v1.lot_number' )</th>
										@endif
										<th>@lang( 'purchase.subtotal_before_tax' )</th>
										<th>@lang( 'lang_v1.date' )</th>
										<th>@lang( 'brand.note' )</th>
										<th>&nbsp;</th>
									</tr>
								</thead>

								<tbody>

									@php
										$subtotal = 0;
									@endphp

									@foreach($product->variations as $variation)
										@if(empty($purchases[$key][$variation->id]))
											@php
												$purchases[$key][$variation->id][] = [
													'quantity' => 0, 
													'purchase_price' => $variation->default_purchase_price,
													'purchase_line_id' => null,
													'sub_unit_id' => null,
													'lot_number' => null,
													'transaction_date' => null,
													'purchase_line_note' => null,
													'secondary_unit_quantity' => 0
												]
											@endphp
										@endif

										@foreach($purchases[$key][$variation->id] as $sub_key => $var)

											@php
												$purchase_line_id = $var['purchase_line_id'];
												$qty = $var['quantity'];
												$sub_unit_id = $var['sub_unit_id'];
												$purcahse_price = $var['purchase_price'];
												$row_total = $qty * $purcahse_price;
												$subtotal += $row_total;
												$lot_number = $var['lot_number'];
												$transaction_date = $var['transaction_date'];
												$purchase_line_note = $var['purchase_line_note'];
											@endphp


											<tr>

												<td>
													{{ $product->name }} @if( $product->type == 'variable' ) (<b>{{ $variation->product_variation->name }}</b> : {{ $variation->name }}) @endif

													{!! Form::hidden('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][product_id]', $product->id); !!}
													@if(!empty($purchase_line_id))
														{!! Form::hidden('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][purchase_line_id]', $purchase_line_id); !!}
													@endif



													@if ($product->use_multi_unit == 1)

														@if (!empty($product->first_conversion_unit_id))
															<input type="hidden" class="is_enable_product_multi_unit" value="1" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][is_enable_product_multi_unit]">
															<input type="hidden" class="main_unit" value="1" data-name="{{$product->unit->short_name}}" data-id="{{$product->unit->id}}">
															<input type="hidden" class="base_unit_quantity" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][base_unit_quantity]" value="{{$qty}}">
															<input type="hidden" class="second_unit" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][second_conversion_unit_rate]"  value="{{$product->second_conversion_unit_rate}}" data-name="{{$product->second_conversion_short_name}}" data-id="{{$product->second_conversion_unit_id}}">
															<input type="hidden" class="fu_default_sell_price" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][fu_default_sell_price]" value="{{$product->fu_default_sell_price}}">			
															<input type="hidden" class="su_default_sell_price" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][su_default_sell_price]" value="{{$product->su_default_sell_price}}">
														@endif
										
													@else
														<input type="hidden" class="is_enable_product_multi_unit" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][is_enable_product_multi_unit]">
													@endif

												</td>




												

												@if ($product->enable_serial_number == "1")

													<td>
														@if (!empty($purchase_line_id))
															<div class="form-group">
																@php
																	$serial_numbers = App\SerialNumber::where('serial_purchase_code', $var['serial_purchase_code'])->where('stock_status','available')->get();
																@endphp
															
																<div class="form-group">

																	<button  type="button" data-value="product_serial_novaluesetbox{{$key}}{{$variation->id}}{{$sub_key}}" value="quentity_box{{$key}}{{$variation->id}}{{$sub_key}}" class="btn btn-info btn-xs btn-modal purchases_serial_numberModelButton" data-toggle="modal" data-target="#purchases_serial_numberModel">
																		Show Serial
																	</button>

																	<div>
																		<input id="product_serial_novaluesetbox{{$key}}{{$variation->id}}{{$sub_key}}" type="hidden" value="@php
																			$num_of_items = count($serial_numbers);
																			$num_count = 0;
																			foreach ($serial_numbers as $serial_number) {
																				echo $serial_number->serial_number;
																				$num_count = $num_count + 1;
																				if ($num_count < $num_of_items) {
																				echo ",";
																				}
																			}
																		@endphp" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][product_serial_no]">
																	</div>

																</div>

																<input type="hidden" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][serial_purchase_code]" value="{{$var['serial_purchase_code']}}"  class="form-control input-sm input_number">
															</div>
														@else
															<div class="form-group">

																<button  type="button" data-thisproduct_id="{{ $product->id }}" data-value="product_serial_novaluesetbox{{$key}}{{$variation->id}}{{$sub_key}}" value="quentity_box{{$key}}{{$variation->id}}{{$sub_key}}" class="btn btn-info btn-xs btn-modal purchases_serial_numberModelButton" data-toggle="modal" data-target="#purchases_serial_numberModel">
																	Add Serial
																</button>
																<div>
																	<input id="product_serial_novaluesetbox{{$key}}{{$variation->id}}{{$sub_key}}" type="hidden" value="" name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][product_serial_no]">
																</div>

															</div>
														@endif
													</td>

													<td>
														<div class="input-group">
															<div class="quentity_box" id="quentity_box{{$key}}{{$variation->id}}{{$sub_key}}">
																{!! Form::text('stocks['.$key.']['.$variation->id.']['.$sub_key.'][quantity]', @format_quantity($qty) , ['class' => 'form-control input-sm input_number purchase_quantity input_quantity', 'readonly', 'required']); !!}
															</div>
															<span class="input-group-addon">
																{{ $product->unit->short_name }}
															</span>
															<input type="hidden" class="base_unit_cost" value="{{$variation->default_purchase_price}}">
															<input type="hidden" class="base_unit_selling_price" value="{{$variation->sell_price_inc_tax}}">
															@if(!empty($product->second_unit))
																{!! Form::hidden('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][secondary_unit_quantity]', @format_quantity($var['secondary_unit_quantity']) , ['class' => 'form-control input-sm input_number input_quantity']); !!}
															@endif
														</div>
													</td>

												@else
													<td>
														No Serial
													</td>
													<td>

														<div class="input-group">
															{!! Form::text('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][quantity]', @format_quantity($qty) , ['class' => 'form-control input-sm input_number purchase_quantity input_quantity', 'required']); !!}
														</div>
														@if(!empty($sub_units))
															<input type="hidden" class="base_unit_cost" value="{{$variation->default_purchase_price}}">
															<input type="hidden" class="base_unit_selling_price" value="{{$variation->sell_price_inc_tax}}">
															<br>
															<select name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][sub_unit_id]" class="form-control input-sm sub_unit">
																@foreach($sub_units as $sub_unit_key => $sub_unit_value)
																	<option value="{{$sub_unit_key}}" data-multiplier="{{$sub_unit_value['multiplier']}}" @if($sub_unit_key == $sub_unit_id) selected @endif >
																		{{$sub_unit_value['name']}}
																	</option>
																@endforeach
															</select>
														@else 
															{{ $product->unit->short_name }}
														@endif
														@if(!empty($product->second_unit))
															<br>
															<span>
															@lang('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit->short_name])*:</span><br>
															{!! Form::text('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][secondary_unit_quantity]', @format_quantity($var['secondary_unit_quantity']) , ['class' => 'form-control input-sm input_number input_quantity', 'required']); !!}
														@endif
													</td>
												@endif

												@php
													$warehouses_list = isset($warehouses) ? $warehouses : [];
													$has_warehouses = !empty($warehouses_list) && count($warehouses_list) > 0;
												@endphp
												@if($has_warehouses)
												<td>
													<select name="stocks[{{$key}}][{{$variation->id}}][{{$sub_key}}][warehouse_id]" class="form-control input-sm" required>
														<option value="">@lang('lang_v1.please_select')</option>
														@foreach($warehouses_list as $warehouse_id => $warehouse_name)
															<option value="{{$warehouse_id}}" @if(isset($default_warehouse) && $default_warehouse && $default_warehouse->id == $warehouse_id) selected @endif>
																{{$warehouse_name}}
															</option>
														@endforeach
													</select>
												</td>
												@endif

												<td>
													{!! Form::text('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][purchase_price]', @num_format($purcahse_price) , ['class' => 'form-control input-sm input_number unit_price', 'required']); !!}
												</td>

												@if($enable_expiry == 1 && $product->enable_stock == 1)
													<td>
														{!! Form::text('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][exp_date]', !empty($var['exp_date']) ? @format_date($var['exp_date']) : null , ['class' => 'form-control input-sm os_exp_date', 'readonly']); !!}
													</td>
												@endif

												@if($enable_lot == 1)
													<td>
														{!! Form::text('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][lot_number]', $lot_number , ['class' => 'form-control input-sm']); !!}
													</td>
												@endif
												
												<td>
													<span class="row_subtotal_before_tax">{{@num_format($row_total)}}</span>
												</td>
												<td>
													<div class="input-group date">
													{!! Form::text('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][transaction_date]', $transaction_date , ['class' => 'form-control input-sm os_date', 'readonly']); !!}
													</div>
												</td>
												<td>
													{!! Form::textarea('stocks[' . $key . '][' . $variation->id . '][' . $sub_key . '][purchase_line_note]', $purchase_line_note , ['class' => 'form-control input-sm', 'rows' => 3 ]); !!}
												</td>

												<td>
													@if($loop->index == 0)
														<button type="button" class="tw-dw-btn tw-dw-btn-xs tw-dw-btn-outline  tw-dw-btn-primary add_stock_row" data-sub-key="{{ count($purchases[$key][$variation->id])}}" 
															data-row-html='<tr>
																<td>
																	{{ $product->name }} @if( $product->type == "variable" ) (<b>{{ $variation->product_variation->name }}</b> : {{ $variation->name }}) @endif

																	<input type="hidden" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][product_id]" value="{{$product->id}}">
																	<input type="hidden" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][purchase_line_id]" value="{{$purchase_line_id}}">

																	@if ($product->use_multi_unit == 1)

																		@if (!empty($product->first_conversion_unit_id))
																			<input type="hidden" class="is_enable_product_multi_unit" value="1" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][is_enable_product_multi_unit]">
																			<input type="hidden" class="main_unit" value="1" data-name="{{$product->unit->short_name}}" data-id="{{$product->unit->id}}">
																			<input type="hidden" class="base_unit_quantity" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][base_unit_quantity]" value="{{$qty}}">
																			
																			<input type="hidden" class="second_unit" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][second_conversion_unit_rate]"  value="{{$product->second_conversion_unit_rate}}" data-name="{{$product->second_conversion_short_name}}" data-id="{{$product->second_conversion_unit_id}}">
																			<input type="hidden" class="fu_default_sell_price" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][fu_default_sell_price]" value="{{$product->fu_default_sell_price}}">			
																			<input type="hidden" class="su_default_sell_price" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][su_default_sell_price]" value="{{$product->su_default_sell_price}}">
																		@endif
																		
																		
																			
																	@else
																		<input type="hidden" class="is_enable_product_multi_unit"  name="stocks[{{$key}}][{{$variation->id}}][__subkey__][is_enable_product_multi_unit]">	
																	@endif

																</td>



																@if ($product->enable_serial_number == "1")

																	<td>
																		@if (!empty($purchase_line_id))
																			<div class="form-group">
																				@php
																					$serial_numbers = App\SerialNumber::where('serial_purchase_code', $var['serial_purchase_code'])->where('stock_status','available')->get();
																				@endphp
																			
																				<div class="form-group">
																						{{-- stocks[{{$key}}][{{$variation->id}}][__subkey__] --}}
																					<button  type="button" data-value="product_serial_novaluesetbox{{$key}}{{$variation->id}}__subkey__" value="quentity_box{{$key}}{{$variation->id}}__subkey__" class="btn btn-info btn-xs btn-modal purchases_serial_numberModelButton" data-toggle="modal" data-target="#purchases_serial_numberModel">
																						Show Serial
																					</button>

																					<div>
																						<input id="product_serial_novaluesetbox{{$key}}{{$variation->id}}__subkey__" type="hidden" value="@php
																							$num_of_items = count($serial_numbers);
																							$num_count = 0;
																							foreach ($serial_numbers as $serial_number) {
																								echo $serial_number->serial_number;
																								$num_count = $num_count + 1;
																								if ($num_count < $num_of_items) {
																								echo ",";
																								}
																							}
																						@endphp" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][product_serial_no]">
																					</div>

																				</div>

																				<input type="hidden" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][serial_purchase_code]" value="{{$var['serial_purchase_code']}}"  class="form-control input-sm input_number">
																			</div>
																		@else
																			<div class="form-group">

																				<button  type="button" data-thisproduct_id="{{ $product->id }}" data-value="product_serial_novaluesetbox{{$key}}{{$variation->id}}__subkey__" value="quentity_box{{$key}}{{$variation->id}}__subkey__" class="btn btn-info btn-xs btn-modal purchases_serial_numberModelButton" data-toggle="modal" data-target="#purchases_serial_numberModel">
																					Add Serial
																				</button>
																				<div>
																					<input id="product_serial_novaluesetbox{{$key}}{{$variation->id}}__subkey__" type="hidden" value="" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][product_serial_no]">
																				</div>

																			</div>
																		@endif
																	</td>

																	<td>
																		<div class="input-group">
																			<div class="quentity_box" id="quentity_box{{$key}}{{$variation->id}}__subkey__">
																				{!! Form::text('stocks['.$key.']['.$variation->id.'][__subkey__][quantity]', @format_quantity($qty) , ['class' => 'form-control input-sm input_number purchase_quantity input_quantity', 'readonly', 'required']); !!}
																			</div>
																			<span class="input-group-addon">
																				{{ $product->unit->short_name }}
																			</span>
																			<input type="hidden" class="base_unit_cost" value="{{$variation->default_purchase_price}}">
																			<input type="hidden" class="base_unit_selling_price" value="{{$variation->sell_price_inc_tax}}">
																			@if(!empty($product->second_unit))
																				{!! Form::hidden('stocks[' . $key . '][' . $variation->id . '][__subkey__][secondary_unit_quantity]', @format_quantity($var['secondary_unit_quantity']) , ['class' => 'form-control input-sm input_number input_quantity']); !!}
																			@endif
																		</div>
																	</td>

																@else
																	<td>
																		No Serial
																	</td>
																	<td>
																		<div class="input-group">
																			{!! Form::text('stocks[' . $key . '][' . $variation->id . '][__subkey__][quantity]', @format_quantity($qty) , ['class' => 'form-control input-sm input_number purchase_quantity input_quantity', 'required']); !!}
																		</div>
																		@if(!empty($sub_units))
																			<input type="hidden" class="base_unit_cost" value="{{$variation->default_purchase_price}}">
																			<input type="hidden" class="base_unit_selling_price" value="{{$variation->sell_price_inc_tax}}">
																			<br>
																			<select name="stocks[{{$key}}][{{$variation->id}}][__subkey__][sub_unit_id]" class="form-control input-sm sub_unit">
																				@foreach($sub_units as $sub_unit_key => $sub_unit_value)
																					<option value="{{$sub_unit_key}}" data-multiplier="{{$sub_unit_value['multiplier']}}" @if($sub_unit_key == $sub_unit_id) selected @endif >
																						{{$sub_unit_value['name']}}
																					</option>
																				@endforeach
																			</select>
																		@else 
																			{{ $product->unit->short_name }}
																		@endif
																		@if(!empty($product->second_unit))
																			<br>
																			<span>
																			@lang('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit->short_name])*:</span><br>
																			{!! Form::text('stocks[' . $key . '][' . $variation->id . '][__subkey__][secondary_unit_quantity]', @format_quantity($var['secondary_unit_quantity']) , ['class' => 'form-control input-sm input_number input_quantity', 'required']); !!}
																		@endif
																	</td>
																@endif





											

																@if($has_warehouses)
																<td>
																	<select name="stocks[{{$key}}][{{$variation->id}}][__subkey__][warehouse_id]" class="form-control input-sm" required>
																		<option value="">@lang('lang_v1.please_select')</option>
																		@foreach($warehouses_list as $warehouse_id => $warehouse_name)
																			<option value="{{$warehouse_id}}" @if(isset($default_warehouse) && $default_warehouse && $default_warehouse->id == $warehouse_id) selected @endif>
																				{{$warehouse_name}}
																			</option>
																		@endforeach
																	</select>
																</td>
																@endif
																<td>
																	<input class="form-control input-sm input_number unit_price" required="" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][purchase_price]" type="text" value="{{@num_format($purcahse_price)}}">
																</td>
	
																@if($enable_expiry == 1 && $product->enable_stock == 1)
																	<td>
																		<input class="form-control input-sm os_exp_date" required="" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][exp_date]" type="text" readonly>
																	</td>
																@endif
	
																@if($enable_lot == 1)
																	<td>
																		<input class="form-control input-sm" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][lot_number]" type="text">
																	</td>
																@endif
																<td>
																	<span class="row_subtotal_before_tax">
																		0.00
																	</span>
																</td>
																<td>
																	<div class="input-group date">
																		<input class="form-control input-sm os_date" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][transaction_date]" type="text" readonly>
																	</div>
																</td>
																<td>
																	<textarea rows="3" class="form-control input-sm" name="stocks[{{$key}}][{{$variation->id}}][__subkey__][purchase_line_note]"></textarea>
																</td>
																<td>&nbsp;</td>
															</tr>'>
															<i class="fa fa-plus"></i>
														</button>
													@else
														&nbsp;
													@endif
												</td>

											</tr>

										@endforeach
									
									@endforeach
								</tbody>
								<tfoot>
									<tr>
										<td colspan="@if($enable_expiry == 1 && $product->enable_stock == 1 && $enable_lot == 1) 5 @elseif(($enable_expiry == 1 && $product->enable_stock == 1) || $enable_lot == 1) @else 3 @endif"></td>
										<td><strong>@lang( 'lang_v1.total_amount_exc_tax' ): </strong> <span id="total_subtotal">{{@num_format($subtotal)}}</span>
										<input type="hidden" id="total_subtotal_hidden" value=0>
										</td>
									</tr>
								</tfoot>
							</table>
												
						</div>
					</div>
				</div>
			</div> <!--box end-->
		@empty
			<h3>@lang( 'lang_v1.product_not_assigned_to_any_location' )</h3>
		@endforelse
	</div>
</div>