@extends('layouts.app')
@section('title', __('lang_v1.add_opening_stock'))
<style>
	.tags {
		margin-bottom: 10px;
	}

	.tags .tag {
		display: inline-block;
		margin-right: 10px;
		padding: 5px 9px;
		font-size: 14px;
		background: #ddd;
		border-radius: 4px;
	}

	.tags .tag span {
		margin-right: 20px;
		display: inline;
	}

	.tags .tag .remove-button {
		display: inline;
		cursor: pointer;
	}
</style>
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('lang_v1.add_opening_stock')</h1>
</section>

<!-- Main content -->
<section class="content">
	{!! Form::open(['url' => action([\App\Http\Controllers\OpeningStockController::class, 'save']), 'method' => 'post', 'id' => 'add_opening_stock_form' ]) !!}
	{!! Form::hidden('product_id', $product->id); !!}
	@include('opening_stock.form-part')
	<div class="row">
		<div class="col-sm-12 text-center">
			<button type="submit" class="btn btn-primary btn-big">@lang('messages.save')</button>
		</div>
	</div>

	{!! Form::close() !!}




	

	<div class="modal fade serial_modal" id="purchases_serial_numberModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog" style="width: 50%;" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel">Edit Serial Number</h5>
				</div>
				<div class="modal-body">
					<div class="tags_list">
						<div id="tags" class="tags">
							<!-- tag list -->
						</div>
					</div>
					<input value="" id="purchases_serial_number" class="purchases_serial_numberclass form-control input-sm" type="text" class="form-control">
				</div>
				<div class="modal-footer">
					<button type="button" id="modelReload" class="btn btn-primary" data-dismiss="modal">Save</button>
				</div>
			</div>
		</div>
	</div>

</section>
@stop


@section('javascript')


	<script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>
	<script type="text/javascript">


		$(document).ready( function(){


			// 
			const selectElement = document.getElementById("purchases_serial_number");
			const tagsContainer = document.getElementById("tags");
			let tags = [];

			// ---------------------------------------------------------------------------------
			$(document).on('click', '.purchases_serial_numberModelButton', function (params) {

				// Set ID For Input Id
				var inputfindid = this.value;
				const key = 'inputfindid';
				localStorage.setItem(key, inputfindid);

				// Set ID For Value Set
				var valueSetId = this.getAttribute('data-value');
				const key1 = 'valueSetId';
				localStorage.setItem(key1, valueSetId);
				// Get Previous value
				var previousValue = document.getElementById(valueSetId).value;
				var previousValueArry = previousValue.split(",");
				var previousValueArryLength = previousValueArry.length;
				if (previousValue === "") {
					// tags = [];
				}else{
					for (var i = 0; i < previousValueArry.length; i++) {
						$("#tags").append(
							"<div class='tag'><span>" + previousValueArry[i] + "</span><div class='remove-button'>x</div></div>"
						);
						tags.push(previousValueArry[i]);
					}
				}

			})


			let lastSelectedValue;


			selectElement.addEventListener("keyup", (event) => {
				if (event.key === "Enter" || event.key === ",") {


					// var getProductSetId = localStorage.getItem('productSetId');
					// var getvariationidSetId = localStorage.getItem('variationidSetId');
					// var location_id = $('select#location_id').find(':selected').val();


					const value = selectElement.value.trim();
					if (value) {

						if (tags.includes(value) || value == "") {
							
						} else {
							// $.ajax({
							// 	url: '/serial/check_serial',
							// 	type: 'POST',
							// 	dataType: 'html',
							// 	data: {
							// 		serial_number: value,
							// 		product_id: getProductSetId,
							// 		location_id: location_id,
							// 		variation_id: getvariationidSetId
							// 	},
							// 	success: function (result) {
							// 		if (result == "0") {
										addTag(value);
										countUpFunction(value);
							// 			} else {
							// 				alert("This Serial Number Already Added");
							// 			}
							// 		},
							// 	});
						}
						selectElement.value = "";
					}
				}
			});



			function renderTags() {
				tagsContainer.innerHTML = "";
				tags.forEach((value) => {
					const tagElement = document.createElement("div");
					tagElement.classList.add("tag");
					tagElement.innerHTML = `<span>${value}</span><div class="remove-button">x</div>`;
					tagElement
					.querySelector(".remove-button")
					.addEventListener("click", function () {
						// removeTag(value);
						// renderTags();
					});
					tagsContainer.appendChild(tagElement);
				});
			}

			function addTag(value) {
				tags.push(value);

				var getValueSetId = localStorage.getItem('valueSetId');

				document.getElementById(getValueSetId).value = tags;

				renderTags();
			}


			function removeTag(value) {
				const index = tags.indexOf(value);
				if (index >= 0) {
					tags.splice(index, 1);
				}

				var getValueSetId = localStorage.getItem('valueSetId');

				document.getElementById(getValueSetId).value = tags;

				renderTags();
			}


			$(document).on("click", '.remove-button', function () {
				if (event.target.className === "remove-button") {
					var tag = event.target.closest(".tag");
					var spanTag = tag.querySelector("span");
					var value = spanTag.innerHTML;
					removeTag(value);
					countDownFunction(value);
				}
			});


			// 
			function countUpFunction(lastSelectedValue) {

				count = 1;

				var getInputFindId = localStorage.getItem('inputfindid');
				var input = $("#" + getInputFindId + "").find('input');
				var qty = __read_number(input);
				if (qty >= 0) {
					__write_number(input, qty + count);
					input.change();
				}

			}
			// Count Up


			// Count Down
			function countDownFunction(unselectedValue) {
				count = 1;
				var getInputFindId = localStorage.getItem('inputfindid');

				var input = $("#" + getInputFindId + "")
					.find('input');
				var qty = __read_number(input);

				if (qty > 0) {
					__write_number(input, qty - count);
					input.change();
				}
			}



			// modelReload
			$(document).on('click', '#modelReload', function () {
				tags = []
				$(".tag").remove();
			});
			$(document).on('hidden.bs.modal', '.serial_modal', function (e) {
                tags = []
				$(".tag").remove();
            });

			$('#product_serial_numberP').select2();

			// ---------------------------------------------------------------------------




			$('.os_date').datetimepicker({
		        format: moment_date_format + ' ' + moment_time_format,
		        ignoreReadonly: true,
		        widgetPositioning: {
		            horizontal: 'right',
		            vertical: 'bottom'
		        }
		    });





		});
	</script>
@endsection
