@extends('layouts.app')
@section('title', __('License Management'))

@section('content')
<section class="content-header">
    <h1>
        <i class="fa fa-key"></i>
        @lang('License Management')
    </h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="row">
                    <div class="col-md-12">
                        <h3>Generate New License</h3>
                        <hr>
                        
                        @if(session('status'))
                            <div class="alert alert-{{ session('status')['success'] ? 'success' : 'danger' }}">
                                {!! session('status')['msg'] !!}
                                @if(isset(session('status')['license_code']))
                                    <br><strong>License Code: {{ session('status')['license_code'] }}</strong>
                                @endif
                            </div>
                        @endif

                        <form action="{{ action([App\Http\Controllers\LicenseManagementController::class, 'generateLicense']) }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="module_name">Module Name:*</label>
                                        <select name="module_name" id="module_name" class="form-control" required>
                                            <option value="businessmanagement">Business Management</option>
                                            <!-- Add more modules as needed -->
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="username">Username:*</label>
                                        <input type="text" name="username" id="username" class="form-control" required 
                                               placeholder="Enter purchase username">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="email">Email:*</label>
                                        <input type="email" name="email" id="email" class="form-control" required 
                                               placeholder="Enter customer email">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="license_type">License Type:*</label>
                                        <select name="license_type" id="license_type" class="form-control" required>
                                            <option value="single">Single Site</option>
                                            <option value="multi">Multi Site</option>
                                            <option value="unlimited">Unlimited</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="expiry_date">Expiry Date (Optional):</label>
                                        <input type="date" name="expiry_date" id="expiry_date" class="form-control" 
                                               placeholder="Leave empty for lifetime license">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-key"></i> Generate License
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            @endcomponent

            @component('components.widget', ['class' => 'box-primary'])
                <div class="row">
                    <div class="col-md-12">
                        <h3>Existing Licenses</h3>
                        <hr>
                        
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover" id="licenses_table">
                                <thead>
                                    <tr>
                                        <th>Module</th>
                                        <th>License Code</th>
                                        <th>Username</th>
                                        <th>Email</th>
                                        <th>Type</th>
                                        <th>Expiry Date</th>
                                        <th>Status</th>
                                        <th>Created At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($licenses as $license)
                                        <tr>
                                            <td>{{ $license->module_name ?? 'N/A' }}</td>
                                            <td><code>{{ $license->license_code ?? 'N/A' }}</code></td>
                                            <td>{{ $license->username ?? 'N/A' }}</td>
                                            <td>{{ $license->email ?? 'N/A' }}</td>
                                            <td>
                                                <span class="label label-info">
                                                    {{ ucfirst($license->license_type ?? 'single') }}
                                                </span>
                                            </td>
                                            <td>
                                                @if($license->expiry_date ?? null)
                                                    {{ \Carbon\Carbon::parse($license->expiry_date)->format('Y-m-d') }}
                                                @else
                                                    <span class="text-success">Lifetime</span>
                                                @endif
                                            </td>
                                            <td>
                                                @php
                                                    $status = $license->status ?? 'active';
                                                    $statusClass = $status == 'active' ? 'success' : ($status == 'expired' ? 'danger' : 'warning');
                                                @endphp
                                                <span class="label label-{{ $statusClass }}">
                                                    {{ ucfirst($status) }}
                                                </span>
                                            </td>
                                            <td>
                                                @if(isset($license->created_at))
                                                    {{ \Carbon\Carbon::parse($license->created_at)->format('Y-m-d H:i') }}
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="8" class="text-center">
                                                <p class="text-muted">No licenses found. Generate a license above.</p>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endcomponent
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script>
    $(document).ready(function() {
        // Initialize DataTable if licenses exist
        @if(count($licenses) > 0)
            $('#licenses_table').DataTable({
                "pageLength": 25,
                "order": [[7, "desc"]]
            });
        @endif
    });
</script>
@endsection

