@php
    $is_mobile = isMobile();
    $common_settings = session()->get('business.common_settings');
@endphp

<style>
    /* Modern Glassmorphism Menu Style */
    .horizontal-scroll {
        height: auto;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px) saturate(180%);
        -webkit-backdrop-filter: blur(20px) saturate(180%);
        display: flex;
        flex-direction: row;
        justify-content: space-between;
        align-items: flex-start;
        position: relative;
        overflow: hidden;
        border-radius: 16px;
        box-shadow: 
            0 8px 32px rgba(0, 0, 0, 0.08),
            0 4px 16px rgba(0, 0, 0, 0.04),
            inset 0 1px 0 rgba(255, 255, 255, 0.9);
        padding: 12px 16px;
        border: 1px solid rgba(255, 255, 255, 0.8);
        margin-bottom: 20px;
    }

    .horizontal-scroll::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%);
        border-radius: 16px;
        pointer-events: none;
        z-index: 0;
    }

    .horizontal-scroll .btn-scroll {
        background: rgba(255, 255, 255, 0.8);
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        color: #6b7280;
        border: 1px solid rgba(229, 231, 235, 0.6);
        border-radius: 10px;
        width: 40px;
        height: 40px;
        margin: 0;
        z-index: 2;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: absolute;
        top: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    }

    .horizontal-scroll .btn-scroll#btn-scroll-left {
        left: 16px;
    }

    .horizontal-scroll .btn-scroll#btn-scroll-right {
        right: 16px;
    }

    .horizontal-scroll .btn-scroll:hover {
        background: rgba(255, 255, 255, 0.95);
        border-color: rgba(37, 99, 235, 0.3);
        box-shadow: 0 4px 12px rgba(37, 99, 235, 0.15);
        transform: translateY(-2px);
    }

    .storys-container {
        display: flex;
        flex-direction: row;
        justify-content: flex-start;
        align-items: flex-end;
        position: relative;
        left: 0;
        transition: 0.3s all ease-out;
        overflow-x: auto;
        white-space: nowrap;
        width: 100%;
        padding: 0 60px;
        gap: 0;
        scrollbar-width: thin;
        scrollbar-color: rgba(209, 213, 219, 0.5) transparent;
        perspective: 1000px;
        z-index: 1;
        transform-style: preserve-3d;
    }

    .storys-container::-webkit-scrollbar {
        height: 6px;
    }

    .storys-container::-webkit-scrollbar-thumb {
        background: linear-gradient(90deg, rgba(37, 99, 235, 0.3) 0%, rgba(59, 130, 246, 0.3) 100%);
        border-radius: 10px;
        backdrop-filter: blur(10px);
    }

    .storys-container::-webkit-scrollbar-thumb:hover {
        background: linear-gradient(90deg, rgba(37, 99, 235, 0.5) 0%, rgba(59, 130, 246, 0.5) 100%);
    }

    .storys-container::-webkit-scrollbar-track {
        background: rgba(243, 244, 246, 0.5);
        border-radius: 10px;
        margin: 0 10px;
    }

    .sub-menu-item {
        padding: 12px 24px;
        color: #6b7280;
        font-weight: 500;
        font-size: 0.875rem;
        line-height: 1.5;
        text-transform: none;
        width: max-content;
        text-decoration: none;
        border-radius: 8px 8px 0 0;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        white-space: nowrap;
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: transparent;
        border: none;
        border-bottom: 3px solid transparent;
        margin-bottom: -2px;
        transform-style: preserve-3d;
        transform: translateZ(0) rotateX(0deg);
        backface-visibility: hidden;
        will-change: transform;
        min-height: 45px;
    }

    .sub-menu-item::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(37, 99, 235, 0.08) 0%, rgba(59, 130, 246, 0.05) 100%);
        border-radius: 8px 8px 0 0;
        opacity: 0;
        transition: opacity 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        z-index: -1;
        transform: translateZ(-10px);
    }

    .sub-menu-item::after {
        content: '';
        position: absolute;
        bottom: -3px;
        left: 50%;
        width: 0;
        height: 3px;
        background: linear-gradient(90deg, #2563eb 0%, #3b82f6 50%, #60a5fa 100%);
        transform: translateX(-50%) translateZ(0);
        transition: width 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        box-shadow: 0 0 20px rgba(37, 99, 235, 0.5);
    }

    .sub-menu-item i {
        font-size: 0.9rem;
        width: 18px;
        text-align: center;
        opacity: 0.7;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        transform: translateZ(0) rotateY(0deg);
        display: inline-block;
    }

    .sub-menu-item:hover {
        color: #2563eb;
        background: transparent;
        border-bottom-color: transparent;
        transform: translateY(-8px) translateZ(20px) rotateX(-5deg) scale(1.05);
        box-shadow: 
            0 20px 40px rgba(37, 99, 235, 0.2),
            0 10px 20px rgba(37, 99, 235, 0.15),
            0 0 0 1px rgba(37, 99, 235, 0.1),
            inset 0 1px 0 rgba(255, 255, 255, 0.6);
        border-radius: 12px 12px 0 0;
        padding-bottom: 16px;
    }

    .sub-menu-item:hover::before {
        opacity: 1;
        transform: translateZ(0);
    }

    .sub-menu-item:hover::after {
        width: 90%;
        box-shadow: 0 0 30px rgba(37, 99, 235, 0.6);
    }

    .sub-menu-item:hover i {
        opacity: 1;
        transform: translateZ(10px) scale(1.2) rotateY(360deg);
        color: #2563eb;
        filter: drop-shadow(0 2px 4px rgba(37, 99, 235, 0.3));
    }

    .sub-menu-item.active {
        color: #2563eb;
        background: linear-gradient(135deg, rgba(37, 99, 235, 0.1) 0%, rgba(59, 130, 246, 0.08) 100%);
        border-bottom: 3px solid #2563eb;
        font-weight: 600;
        transform: translateY(-4px) translateZ(10px) rotateX(-2deg);
        box-shadow: 
            0 15px 30px rgba(37, 99, 235, 0.25),
            0 5px 15px rgba(37, 99, 235, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.5);
        border-radius: 10px 10px 0 0;
    }

    .sub-menu-item.active::before {
        opacity: 1;
    }

    .sub-menu-item.active::after {
        width: 100%;
        background: linear-gradient(90deg, #2563eb 0%, #3b82f6 50%, #60a5fa 100%);
        box-shadow: 0 0 25px rgba(37, 99, 235, 0.7);
    }

    .sub-menu-item.active i {
        opacity: 1;
        color: #2563eb;
        transform: translateZ(5px) scale(1.15);
        filter: drop-shadow(0 2px 4px rgba(37, 99, 235, 0.4));
    }

    .sub-menu-item:active {
        transform: translateY(-6px) translateZ(15px) rotateX(-3deg) scale(1.02);
        transition: all 0.1s ease;
    }

    @keyframes pulse-glow {
        0%, 100% {
            box-shadow: 
                0 15px 30px rgba(37, 99, 235, 0.25),
                0 5px 15px rgba(37, 99, 235, 0.2),
                inset 0 1px 0 rgba(255, 255, 255, 0.5);
        }
        50% {
            box-shadow: 
                0 20px 40px rgba(37, 99, 235, 0.35),
                0 8px 20px rgba(37, 99, 235, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.6);
        }
    }

    .sub-menu-item.active {
        animation: pulse-glow 3s ease-in-out infinite;
    }

    .topbar-sub-menu-wrap {
        position: absolute;
        top: 10%;
        right: 1%;
        width: 250px;
        max-height: 0px;
        overflow: hidden;
        z-index: 11111;
        transition: max-height 0.5s;
    }

    .topbar-sub-menu-wrap.open-menu {
        max-height: 600px;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu {
        background: #ffffff;
        padding: 12px;
        margin: 10px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        border-radius: 8px;
        border: 1px solid #e5e7eb;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu .sub-menu-link {
        display: flex;
        align-items: center;
        text-decoration: none;
        padding: 10px 12px;
        color: #374151;
        font-weight: 500;
        line-height: 130%;
        margin: 4px 0;
        gap: 10px;
        font-size: 0.875rem;
        border-radius: 6px;
        transition: all 0.2s ease;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu .sub-menu-link:hover {
        background: #f3f4f6;
        color: #111827;
    }

    @media (max-width: 768px) {
        .horizontal-scroll {
            margin-bottom: 15px;
        }

        .storys-container {
            padding: 0 45px;
            perspective: 800px;
        }

        .sub-menu-item {
            padding: 10px 18px;
            font-size: 0.8125rem;
        }

        .sub-menu-item:hover {
            transform: translateY(-6px) translateZ(15px) rotateX(-3deg) scale(1.03);
        }
    }
</style>

@if ($is_mobile)
    <button class="btn-scroll" id="btn-scroll-left" onclick="scrollHorizontally(1)">
        <img src="{{ asset('img/icons/scroll-left.svg') }}" alt="">
    </button>
    <button class="btn-scroll" id="btn-scroll-right" onclick="scrollHorizontally(-1)">
        <img src="{{ asset('img/icons/scroll-right.svg') }}" alt="">
    </button>
@endif

<div class="storys-container">
    @if(! empty($common_settings['enable_purchase_requisition']) && (auth()->user()->can('purchase_requisition.view_all') || auth()->user()->can('purchase_requisition.view_own')))
        <a href="{{ action([\App\Http\Controllers\PurchaseRequisitionController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'purchase-requisition' ? 'active' : '' }}">
            <i class="fas fa-clipboard-check"></i>
            @lang('lang_v1.purchase_requisition')
        </a>
    @endif

    @if (
        !empty($common_settings['enable_purchase_order']) &&
            (auth()->user()->can('purchase_order.view_all') || auth()->user()->can('purchase_order.view_own')))
        <a href="{{ action([\App\Http\Controllers\PurchaseOrderController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'purchase-order' ? 'active' : '' }}">
            <i class="fas fa-shopping-bag"></i>
            @lang('lang_v1.purchase_order')
        </a>
    @endif

    @if (auth()->user()->can('purchase.view') || auth()->user()->can('view_own_purchase'))
        <a href="{{ action([\App\Http\Controllers\PurchaseController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'purchases' && request()->segment(2) == null ? 'active' : '' }}">
            <i class="fas fa-list"></i>
            @lang('purchase.list_purchase')
        </a>
    @endif

    @if (auth()->user()->can('purchase.create'))
        <a href="{{ action([\App\Http\Controllers\PurchaseController::class, 'create']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'purchases' && request()->segment(2) == 'create' ? 'active' : '' }}">
            <i class="fas fa-plus-circle"></i>
            @lang('purchase.add_purchase')
        </a>
    @endif

    @if (auth()->user()->can('purchase.update'))
        <a href="{{ action([\App\Http\Controllers\PurchaseReturnController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'purchase-return' ? 'active' : '' }}">
            <i class="fas fa-undo"></i>
            @lang('lang_v1.list_purchase_return')
        </a>
    @endif
</div>
