<style>
    /* Modern Products Menu Styles */
    .horizontal-scroll {
        height: 60px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        flex-direction: row;
        justify-content: space-between;
        align-items: center;
        position: relative;
        overflow: hidden;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        padding: 0 10px;
    }

    .horizontal-scroll .btn-scroll {
        background: rgba(255, 255, 255, 0.2);
        color: white;
        border: none;
        border-radius: 50%;
        width: 36px;
        height: 36px;
        margin: 0 5px;
        z-index: 1;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
    }

    .horizontal-scroll .btn-scroll:hover {
        background: rgba(255, 255, 255, 0.3);
        transform: scale(1.1);
    }

    .storys-container {
        display: flex;
        flex-direction: row;
        justify-content: flex-start;
        align-items: center;
        position: absolute;
        left: 0;
        transition: 0.5s all ease-out;
        overflow-x: auto;
        white-space: nowrap;
        width: 100%;
        padding: 0 10px;
        gap: 8px;
    }

    /* Custom scrollbar styles */
    .storys-container::-webkit-scrollbar {
        height: 6px;
    }

    .storys-container::-webkit-scrollbar-thumb {
        background-color: rgba(255, 255, 255, 0.5);
        border-radius: 10px;
    }

    .storys-container::-webkit-scrollbar-track {
        background: rgba(255, 255, 255, 0.1);
    }

    .sub-menu-item {
        padding: 10px 20px;
        color: rgba(255, 255, 255, 0.9);
        font-weight: 500;
        font-size: 0.9rem;
        line-height: 1.5;
        text-transform: capitalize;
        width: max-content;
        text-decoration: none;
        border-radius: 25px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        white-space: nowrap;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
    }

    .sub-menu-item:hover {
        background: rgba(255, 255, 255, 0.25);
        color: #ffffff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        border-color: rgba(255, 255, 255, 0.4);
    }

    .sub-menu-item.active {
        color: #ffffff;
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        border: 1px solid rgba(255, 255, 255, 0.3);
        box-shadow: 0 4px 15px rgba(245, 87, 108, 0.4);
        font-weight: 600;
        transform: translateY(-2px);
    }

    .sub-menu-item.active::before {
        content: '';
        position: absolute;
        left: 50%;
        bottom: -8px;
        transform: translateX(-50%);
        width: 0;
        height: 0;
        border-left: 6px solid transparent;
        border-right: 6px solid transparent;
        border-top: 6px solid #f5576c;
    }

    /* Alternative Style Option 2: Minimalist Clean */
    .sub-menu-item.style-minimal {
        background: transparent;
        border: none;
        color: rgba(255, 255, 255, 0.8);
        padding: 12px 18px;
    }

    .sub-menu-item.style-minimal:hover {
        background: rgba(255, 255, 255, 0.1);
        color: #ffffff;
        transform: none;
        box-shadow: none;
    }

    .sub-menu-item.style-minimal.active {
        background: rgba(255, 255, 255, 0.2);
        color: #ffffff;
        border-bottom: 3px solid #ffd700;
        border-radius: 0;
        transform: none;
        box-shadow: none;
    }

    .sub-menu-item.style-minimal.active::before {
        display: none;
    }

    /* Alternative Style Option 3: Card Style */
    .sub-menu-item.style-card {
        background: rgba(255, 255, 255, 0.95);
        color: #4a5568;
        border: none;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .sub-menu-item.style-card:hover {
        background: #ffffff;
        color: #2d3748;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .sub-menu-item.style-card.active {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: #ffffff;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    }

    .sub-menu-item.style-card.active::before {
        border-top-color: #667eea;
    }

    .topbar-sub-menu-wrap {
        position: absolute;
        top: 10%;
        right: 1%;
        width: 250px;
        max-height: 0px;
        overflow: hidden;
        z-index: 11111;
        transition: max-height 0.5s;
    }

    .topbar-sub-menu-wrap.open-menu {
        max-height: 600px;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu {
        background: #ffffff;
        padding: 10px;
        margin: 10px;
        box-shadow: 0px 4px 20px rgba(0, 0, 0, 0.1);
        border-radius: 8px;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu .sub-menu-link {
        display: flex;
        align-items: center;
        text-decoration: none;
        padding: 10px 12px;
        color: #374151;
        font-weight: 500;
        line-height: 130%;
        margin: 5px 0;
        gap: 10px;
        font-size: 0.875rem;
        border-radius: 6px;
        transition: all 0.2s ease;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu .sub-menu-link:hover {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: #ffffff;
        transform: translateX(5px);
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .horizontal-scroll {
            height: 55px;
            border-radius: 10px;
        }

        .sub-menu-item {
            padding: 8px 16px;
            font-size: 0.85rem;
        }
    }
</style>
@php
    $common_settings = session()->get('business.common_settings');
    $is_mobile = isMobile();
@endphp



@if ($is_mobile)
    <button class="btn-scroll" id="btn-scroll-left" onclick="scrollHorizontally(1)">
        <img src="{{ asset('img/icons/scroll-left.svg') }}" alt="" style="filter: brightness(0) invert(1);">
    </button>
    <button class="btn-scroll" id="btn-scroll-right" onclick="scrollHorizontally(-1)">
        <img src="{{ asset('img/icons/scroll-right.svg') }}" alt="" style="filter: brightness(0) invert(1);">
    </button>
@endif


<div class="storys-container">

    @can('product.view')
        <a href="{{ action([\App\Http\Controllers\ProductController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'products' && request()->segment(2) == '' ? 'active' : '' }}">
            @lang('lang_v1.list_products')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\ProductController::class, 'create']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'products' && request()->segment(2) == 'create' ? 'active' : '' }}">
            @lang('product.add_product')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\SellingPriceGroupController::class, 'updateProductPrice']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'update-product-price' ? 'active' : '' }}">
            @lang('lang_v1.update_product_price')
        </a>
    @endcan


    @can('product.view')
        <a href="{{ action([\App\Http\Controllers\LabelsController::class, 'show']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'labels' && request()->segment(2) == 'show' && request()->segment(3) == '' ? 'active' : '' }}">
            @lang('barcode.print_labels')
        </a>
    @endcan

    @can('product.view')
        <a href="{{ action([\App\Http\Controllers\LabelsController::class, 'showQrcode']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'labels' && request()->segment(2) == 'show' && request()->segment(3) == 'qrcode' ? 'active' : '' }}">
            @lang('barcode.print_qrcode')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\VariationTemplateController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'variation-templates' ? 'active' : '' }}">
            @lang('product.variations')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\ImportProductsController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'import-products' ? 'active' : '' }}">
            @lang('product.import_products')
        </a>
    @endcan


    @can('product.opening_stock')
        <a href="{{ action([\App\Http\Controllers\ImportOpeningStockController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'import-opening-stock' ? 'active' : '' }}">
            @lang('lang_v1.import_opening_stock')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\SellingPriceGroupController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'selling-price-group' ? 'active' : '' }}">
            @lang('lang_v1.selling_price_group')
        </a>
    @endcan


    @canany(['unit.view', 'unit.create'])
        <a href="{{ action([\App\Http\Controllers\UnitController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'units' ? 'active' : '' }}">
            @lang('unit.units')
        </a>
    @endcanany


    @canany(['category.view', 'category.create'])
        <a href="{{ action([\App\Http\Controllers\TaxonomyController::class, 'index']) . '?type=product' }}"
            class="sub-menu-item {{ request()->segment(1) == 'taxonomies' && request()->get('type') == 'product' ? 'active' : '' }}">
            @lang('category.categories')
        </a>
    @endcanany

    @if (session('business.enable_brand'))
        @canany(['brand.view', 'brand.create'])
            <a href="{{ action([\App\Http\Controllers\BrandController::class, 'index']) }}"
                class="sub-menu-item {{ request()->segment(1) == 'brands' ? 'active' : '' }}">
                @lang('brand.brands')
            </a>
        @endcanany
    @endif

    @if (!empty($common_settings['enable_product_warranty']))
        <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'warranties' ? 'active' : '' }}">
            @lang('warranties')
        </a>
    @endif


    @if (!empty($common_settings['enable_product_warranty']))
        <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'AddwarrantyService']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'add-warranti' ? 'active' : '' }}">
            @lang('Received warranty service')
        </a>

        <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'DeliverywarrantyService']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'delivery-warranti' ? 'active' : '' }}">
            @lang('Delivery warranty service')
        </a>
    @endif


    @canany(['tax_rate.view', 'tax_rate.create'])
        <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'ListWarrantyService']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'list-warranti' ? 'active' : '' }}">
            @lang('All service warranty')
        </a>
    @endcanany




</div>

