<style>
    /* Tab-Style Products Menu - Glassmorphism Design */
    .horizontal-scroll {
        height: auto;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px) saturate(180%);
        -webkit-backdrop-filter: blur(20px) saturate(180%);
        display: flex;
        flex-direction: row;
        justify-content: space-between;
        align-items: flex-start;
        position: relative;
        overflow: hidden;
        border-radius: 16px;
        box-shadow: 
            0 8px 32px rgba(0, 0, 0, 0.08),
            0 4px 16px rgba(0, 0, 0, 0.04),
            inset 0 1px 0 rgba(255, 255, 255, 0.9);
        padding: 12px 16px;
        border: 1px solid rgba(255, 255, 255, 0.8);
        margin-bottom: 20px;
    }

    .horizontal-scroll::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%);
        border-radius: 16px;
        pointer-events: none;
        z-index: 0;
    }

    .horizontal-scroll .btn-scroll {
        background: rgba(255, 255, 255, 0.8);
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        color: #6b7280;
        border: 1px solid rgba(229, 231, 235, 0.6);
        border-radius: 10px;
        width: 40px;
        height: 40px;
        margin: 0;
        z-index: 2;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: absolute;
        top: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    }

    .horizontal-scroll .btn-scroll#btn-scroll-left {
        left: 16px;
    }

    .horizontal-scroll .btn-scroll#btn-scroll-right {
        right: 16px;
    }

    .horizontal-scroll .btn-scroll:hover {
        background: rgba(255, 255, 255, 0.95);
        border-color: rgba(37, 99, 235, 0.3);
        box-shadow: 0 4px 12px rgba(37, 99, 235, 0.15);
        transform: translateY(-2px);
    }

    .storys-container {
        display: flex;
        flex-direction: row;
        justify-content: flex-start;
        align-items: flex-end;
        position: relative;
        left: 0;
        transition: 0.3s all ease-out;
        overflow-x: auto;
        white-space: nowrap;
        width: 100%;
        padding: 0 60px;
        gap: 0;
        scrollbar-width: thin;
        scrollbar-color: rgba(209, 213, 219, 0.5) transparent;
        perspective: 1000px;
        z-index: 1;
    }

    /* Hide scrollbar but keep functionality */
    .storys-container::-webkit-scrollbar {
        height: 6px;
    }

    .storys-container::-webkit-scrollbar-thumb {
        background: linear-gradient(90deg, rgba(37, 99, 235, 0.3) 0%, rgba(59, 130, 246, 0.3) 100%);
        border-radius: 10px;
        backdrop-filter: blur(10px);
    }

    .storys-container::-webkit-scrollbar-thumb:hover {
        background: linear-gradient(90deg, rgba(37, 99, 235, 0.5) 0%, rgba(59, 130, 246, 0.5) 100%);
    }

    .storys-container::-webkit-scrollbar-track {
        background: rgba(243, 244, 246, 0.5);
        border-radius: 10px;
        margin: 0 10px;
    }

    .sub-menu-item {
        padding: 12px 24px;
        color: #6b7280;
        font-weight: 500;
        font-size: 0.875rem;
        line-height: 1.5;
        text-transform: none;
        width: max-content;
        text-decoration: none;
        border-radius: 8px 8px 0 0;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        white-space: nowrap;
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: transparent;
        border: none;
        border-bottom: 3px solid transparent;
        margin-bottom: -2px;
        transform-style: preserve-3d;
        transform: translateZ(0) rotateX(0deg);
        backface-visibility: hidden;
        will-change: transform;
    }

    .sub-menu-item::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(37, 99, 235, 0.08) 0%, rgba(59, 130, 246, 0.05) 100%);
        border-radius: 8px 8px 0 0;
        opacity: 0;
        transition: opacity 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        z-index: -1;
        transform: translateZ(-10px);
    }

    .sub-menu-item::after {
        content: '';
        position: absolute;
        bottom: -3px;
        left: 50%;
        width: 0;
        height: 3px;
        background: linear-gradient(90deg, #2563eb 0%, #3b82f6 50%, #60a5fa 100%);
        transform: translateX(-50%) translateZ(0);
        transition: width 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        box-shadow: 0 0 20px rgba(37, 99, 235, 0.5);
    }

    .sub-menu-item i {
        font-size: 0.9rem;
        width: 18px;
        text-align: center;
        opacity: 0.7;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        transform: translateZ(0) rotateY(0deg);
        display: inline-block;
    }

    .sub-menu-item:hover {
        color: #2563eb;
        background: transparent;
        border-bottom-color: transparent;
        transform: translateY(-8px) translateZ(20px) rotateX(-5deg) scale(1.05);
        box-shadow: 
            0 20px 40px rgba(37, 99, 235, 0.2),
            0 10px 20px rgba(37, 99, 235, 0.15),
            0 0 0 1px rgba(37, 99, 235, 0.1),
            inset 0 1px 0 rgba(255, 255, 255, 0.6);
        border-radius: 12px 12px 0 0;
        padding-bottom: 16px;
    }

    .sub-menu-item:hover::before {
        opacity: 1;
        transform: translateZ(0);
    }

    .sub-menu-item:hover::after {
        width: 90%;
        box-shadow: 0 0 30px rgba(37, 99, 235, 0.6);
    }

    .sub-menu-item:hover i {
        opacity: 1;
        transform: translateZ(10px) scale(1.2) rotateY(360deg);
        color: #2563eb;
        filter: drop-shadow(0 2px 4px rgba(37, 99, 235, 0.3));
    }

    .sub-menu-item.active {
        color: #2563eb;
        background: linear-gradient(135deg, rgba(37, 99, 235, 0.1) 0%, rgba(59, 130, 246, 0.08) 100%);
        border-bottom: 3px solid #2563eb;
        font-weight: 600;
        transform: translateY(-4px) translateZ(10px) rotateX(-2deg);
        box-shadow: 
            0 15px 30px rgba(37, 99, 235, 0.25),
            0 5px 15px rgba(37, 99, 235, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.5);
        border-radius: 10px 10px 0 0;
    }

    .sub-menu-item.active::before {
        opacity: 1;
    }

    .sub-menu-item.active::after {
        width: 100%;
        background: linear-gradient(90deg, #2563eb 0%, #3b82f6 50%, #60a5fa 100%);
        box-shadow: 0 0 25px rgba(37, 99, 235, 0.7);
    }

    .sub-menu-item.active i {
        opacity: 1;
        color: #2563eb;
        transform: translateZ(5px) scale(1.15);
        filter: drop-shadow(0 2px 4px rgba(37, 99, 235, 0.4));
    }

    /* 3D Ripple effect on click */
    .sub-menu-item:active {
        transform: translateY(-6px) translateZ(15px) rotateX(-3deg) scale(1.02);
        transition: all 0.1s ease;
    }

    .sub-menu-item:active::after {
        width: 100%;
        box-shadow: 0 0 40px rgba(37, 99, 235, 0.8);
    }

    .sub-menu-item.active::before {
        display: none;
    }

    /* Alternative: Card/Tile Style */
    .storys-container.style-cards {
        gap: 12px;
        padding: 15px 50px;
        align-items: center;
    }

    .storys-container.style-cards .sub-menu-item {
        padding: 16px 24px;
        background: #ffffff;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        margin-bottom: 0;
        border-bottom: 1px solid #e5e7eb;
    }

    .storys-container.style-cards .sub-menu-item:hover {
        border-color: #3b82f6;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.15);
        transform: translateY(-2px);
        color: #3b82f6;
    }

    .storys-container.style-cards .sub-menu-item.active {
        background: #eff6ff;
        border-color: #3b82f6;
        color: #1d4ed8;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.2);
        border-bottom: 1px solid #3b82f6;
    }

    /* Alternative: Minimalist Line Style */
    .storys-container.style-minimal {
        border-bottom: 1px solid #e5e7eb;
        padding-bottom: 0;
    }

    .storys-container.style-minimal .sub-menu-item {
        padding: 10px 16px;
        color: #6b7280;
        border-bottom: 2px solid transparent;
        margin-bottom: -1px;
    }

    .storys-container.style-minimal .sub-menu-item:hover {
        color: #111827;
    }

    .storys-container.style-minimal .sub-menu-item.active {
        color: #111827;
        border-bottom-color: #111827;
        font-weight: 600;
    }

    /* Alternative: Badge/Chip Style */
    .storys-container.style-badges {
        gap: 8px;
        padding: 12px 50px;
    }

    .storys-container.style-badges .sub-menu-item {
        padding: 8px 16px;
        background: #f3f4f6;
        border: none;
        border-radius: 20px;
        color: #4b5563;
        margin-bottom: 0;
    }

    .storys-container.style-badges .sub-menu-item:hover {
        background: #e5e7eb;
        color: #111827;
    }

    .storys-container.style-badges .sub-menu-item.active {
        background: #2563eb;
        color: #ffffff;
        border-bottom: none;
    }

    .topbar-sub-menu-wrap {
        position: absolute;
        top: 10%;
        right: 1%;
        width: 250px;
        max-height: 0px;
        overflow: hidden;
        z-index: 11111;
        transition: max-height 0.5s;
    }

    .topbar-sub-menu-wrap.open-menu {
        max-height: 600px;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu {
        background: #ffffff;
        padding: 12px;
        margin: 10px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        border-radius: 8px;
        border: 1px solid #e5e7eb;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu .sub-menu-link {
        display: flex;
        align-items: center;
        text-decoration: none;
        padding: 10px 12px;
        color: #374151;
        font-weight: 500;
        line-height: 130%;
        margin: 4px 0;
        gap: 10px;
        font-size: 0.875rem;
        border-radius: 6px;
        transition: all 0.2s ease;
    }

    .topbar-sub-menu-wrap .topbar-sub-menu .sub-menu-link:hover {
        background: #f3f4f6;
        color: #111827;
    }

    /* Enhanced 3D glow effect for active items */
    @keyframes pulse-glow {
        0%, 100% {
            box-shadow: 
                0 15px 30px rgba(37, 99, 235, 0.25),
                0 5px 15px rgba(37, 99, 235, 0.2),
                inset 0 1px 0 rgba(255, 255, 255, 0.5);
        }
        50% {
            box-shadow: 
                0 20px 40px rgba(37, 99, 235, 0.35),
                0 8px 20px rgba(37, 99, 235, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.6);
        }
    }

    .sub-menu-item.active {
        animation: pulse-glow 3s ease-in-out infinite;
    }

    /* Smooth 3D transition for container */
    .storys-container {
        transform-style: preserve-3d;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .horizontal-scroll {
            margin-bottom: 15px;
        }

        .storys-container {
            padding: 0 45px;
            perspective: 800px;
        }

        .sub-menu-item {
            padding: 10px 18px;
            font-size: 0.8125rem;
        }

        .sub-menu-item:hover {
            transform: translateY(-6px) translateZ(15px) rotateX(-3deg) scale(1.03);
        }
    }

    /* Prevent layout shift during 3D transforms */
    .sub-menu-item {
        min-height: 45px;
        display: inline-flex;
        align-items: center;
    }
</style>
@php
    $common_settings = session()->get('business.common_settings');
    $is_mobile = isMobile();
@endphp



@if ($is_mobile)
    <button class="btn-scroll" id="btn-scroll-left" onclick="scrollHorizontally(1)">
        <img src="{{ asset('img/icons/scroll-left.svg') }}" alt="">
    </button>
    <button class="btn-scroll" id="btn-scroll-right" onclick="scrollHorizontally(-1)">
        <img src="{{ asset('img/icons/scroll-right.svg') }}" alt="">
    </button>
@endif


<div class="storys-container">

    @can('product.view')
        <a href="{{ action([\App\Http\Controllers\ProductController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'products' && request()->segment(2) == '' ? 'active' : '' }}">
            <i class="fas fa-list"></i>
            @lang('lang_v1.list_products')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\ProductController::class, 'create']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'products' && request()->segment(2) == 'create' ? 'active' : '' }}">
            <i class="fas fa-plus-circle"></i>
            @lang('product.add_product')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\SellingPriceGroupController::class, 'updateProductPrice']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'update-product-price' ? 'active' : '' }}">
            <i class="fas fa-tags"></i>
            @lang('lang_v1.update_product_price')
        </a>
    @endcan


    @can('product.view')
        <a href="{{ action([\App\Http\Controllers\LabelsController::class, 'show']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'labels' && request()->segment(2) == 'show' && request()->segment(3) == '' ? 'active' : '' }}">
            <i class="fas fa-print"></i>
            @lang('barcode.print_labels')
        </a>
    @endcan

    @can('product.view')
        <a href="{{ action([\App\Http\Controllers\LabelsController::class, 'showQrcode']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'labels' && request()->segment(2) == 'show' && request()->segment(3) == 'qrcode' ? 'active' : '' }}">
            <i class="fas fa-qrcode"></i>
            @lang('barcode.print_qrcode')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\VariationTemplateController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'variation-templates' ? 'active' : '' }}">
            <i class="fas fa-layer-group"></i>
            @lang('product.variations')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\ImportProductsController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'import-products' ? 'active' : '' }}">
            <i class="fas fa-file-import"></i>
            @lang('product.import_products')
        </a>
    @endcan


    @can('product.opening_stock')
        <a href="{{ action([\App\Http\Controllers\ImportOpeningStockController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'import-opening-stock' ? 'active' : '' }}">
            <i class="fas fa-database"></i>
            @lang('lang_v1.import_opening_stock')
        </a>
    @endcan


    @can('product.create')
        <a href="{{ action([\App\Http\Controllers\SellingPriceGroupController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'selling-price-group' ? 'active' : '' }}">
            <i class="fas fa-money-bill-wave"></i>
            @lang('lang_v1.selling_price_group')
        </a>
    @endcan


    @canany(['unit.view', 'unit.create'])
        <a href="{{ action([\App\Http\Controllers\UnitController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'units' ? 'active' : '' }}">
            <i class="fas fa-ruler"></i>
            @lang('unit.units')
        </a>
    @endcanany


    @canany(['category.view', 'category.create'])
        <a href="{{ action([\App\Http\Controllers\TaxonomyController::class, 'index']) . '?type=product' }}"
            class="sub-menu-item {{ request()->segment(1) == 'taxonomies' && request()->get('type') == 'product' ? 'active' : '' }}">
            <i class="fas fa-folder"></i>
            @lang('category.categories')
        </a>
    @endcanany

    @if (session('business.enable_brand'))
        @canany(['brand.view', 'brand.create'])
            <a href="{{ action([\App\Http\Controllers\BrandController::class, 'index']) }}"
                class="sub-menu-item {{ request()->segment(1) == 'brands' ? 'active' : '' }}">
                <i class="fas fa-certificate"></i>
                @lang('brand.brands')
            </a>
        @endcanany
    @endif

    @if (!empty($common_settings['enable_product_warranty']))
        <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'index']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'warranties' ? 'active' : '' }}">
            <i class="fas fa-shield-alt"></i>
            @lang('warranties')
        </a>
    @endif


    @if (!empty($common_settings['enable_product_warranty']))
        <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'AddwarrantyService']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'add-warranti' ? 'active' : '' }}">
            <i class="fas fa-inbox"></i>
            @lang('Received warranty service')
        </a>

        <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'DeliverywarrantyService']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'delivery-warranti' ? 'active' : '' }}">
            <i class="fas fa-truck"></i>
            @lang('Delivery warranty service')
        </a>
    @endif


    @canany(['tax_rate.view', 'tax_rate.create'])
        <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'ListWarrantyService']) }}"
            class="sub-menu-item {{ request()->segment(1) == 'list-warranti' ? 'active' : '' }}">
            <i class="fas fa-list-check"></i>
            @lang('All service warranty')
        </a>
    @endcanany




</div>
