<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{ config('app.name', 'POS') }}</title>
    @laravelPWA
    @include('layouts.partials.css')

    @include('layouts.partials.extracss_auth')
    
    @stack('styles')

    <!--[if lt IE 9]>
    <script src="{{ asset('js/cdn/html5shiv.min.js') }}"></script>
    <script src="{{ asset('js/cdn/respond.min.js') }}"></script>
    <![endif]-->
    <!-- Google reCAPTCHA - requires internet connection. For fully offline, consider removing or using alternative -->
    @if(config('app.recaptcha_enabled', true))
    <script src='https://www.google.com/recaptcha/api.js'></script>
    @endif

</head>

<body class="pace-done modern-login-body" data-new-gr-c-s-check-loaded="14.1172.0" data-gr-ext-installed="" cz-shortcut-listen="true">
    @inject('request', 'Illuminate\Http\Request')
    @if (session('status') && session('status.success'))
        <input type="hidden" id="status_span" data-status="{{ session('status.success') }}"
            data-msg="{{ session('status.msg') }}">
    @endif
    <div class="container-fluid modern-login-container-fluid">
        <div class="row eq-height-row">
            <div class="col-md-12 col-sm-12 col-xs-12 modern-login-main-col">
                <div class="modern-login-header">
                    <div class="modern-header-top">
                        @include('layouts.partials.language_btn')
                    </div>
                </div>
                @yield('content')
            </div>
        </div>
    </div>


    @include('layouts.partials.javascripts')

    <!-- Scripts -->
    <script src="{{ asset('js/login.js?v=' . $asset_v) }}"></script>

    @stack('scripts')
    @yield('javascript')

    <script type="text/javascript">
        $(document).ready(function() {
            $('.select2_register').select2();

            // $('input').iCheck({
            //     checkboxClass: 'icheckbox_square-blue',
            //     radioClass: 'iradio_square-blue',
            //     increaseArea: '20%' // optional
            // });
        });
    </script>
    <style>
        .wizard>.content {
            background-color: white !important;
        }

        /* Modern Login Layout Styles */
        body.modern-login-body {
            background: #0A0E27 !important;
            background-color: #0A0E27 !important;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            overflow-x: hidden;
        }

        .modern-login-container-fluid {
            background: transparent !important;
            padding: 0 !important;
            margin: 0 !important;
            min-height: 100vh;
        }

        .modern-login-main-col {
            padding: 0 !important;
            margin: 0 !important;
            background: transparent !important;
        }

        .modern-login-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            padding: 20px;
            background: transparent;
        }

        .modern-header-top {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            max-width: 1600px;
            margin: 0 auto;
        }

        /* Override Bootstrap container styles */
        .container-fluid.modern-login-container-fluid .row {
            margin: 0 !important;
        }

        .container-fluid.modern-login-container-fluid .col-md-12,
        .container-fluid.modern-login-container-fluid .col-sm-12,
        .container-fluid.modern-login-container-fluid .col-xs-12 {
            padding: 0 !important;
        }

        /* Hide footer and ensure single background color */
        body.modern-login-body footer,
        body.modern-login-body .footer,
        body.modern-login-body [class*="footer"],
        body.modern-login-body [id*="footer"],
        body.modern-login-body [class*="bottom-bar"],
        body.modern-login-body [id*="bottom"] {
            display: none !important;
            background: #0A0E27 !important;
            background-color: #0A0E27 !important;
        }

        /* Ensure body and html have single color */
        html {
            background: #0A0E27 !important;
            background-color: #0A0E27 !important;
        }
    </style>
</body>

</html>
