@extends('layouts.blank')
@section('title', __( 'lang_v1.customer_display'))
@section('content')
<style>
   *{
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      list-style: none;
   }

   .card-wrapper {
    margin-top: 1rem;
    box-shadow: 0px 2px 7px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
    background: #ffffff;
    width: 100%;
    padding: 1.5rem 1.25rem;
}
.box.box-warning {
    border-top-color: #f39c12 !important;
}
   .card-wrapper {
   height: calc(100vh - 80px) !important;
   width: auto !important;
   margin: 20px !important;
   }
   .heading-x {
   flex-direction: column;
   align-items: center;
   text-align: center;
   font-size: 24px;
   font-weight: bold;
   margin-bottom: 20px;
   }
   .table-responsive {
   height: calc(100vh - 300px);
   overflow-y: auto;
   }
   .table {
   margin: 10px !important;
   }
   .table thead {
   position: sticky;
   top: 0px;
   }
   .table th {
   text-align: center; 
   }
   .table tfoot {
   /* z-index: 1000; */
   font-size: 15px;
   font-weight: bold;
   width: 100% !important;
   }
   .table tfoot td {
   border-top: 2px solid #dee2e6;
   }
   @media (max-width: 768px) {
   .card-wrapper {
   padding: 20px;
   height: calc(100vh - 40px);
   width: 90%;
   }
   .table-responsive {
   overflow-x: auto;
   }
   .footer-total-div {
   display: none !important;
   }
   }
   .footer-container {
   position: fixed;
   bottom: 10px;
   left: 0;
   width: 100%;
   z-index: 1000; 
   display: flex;
   flex-direction: column; 
   gap: 10px; 
   padding-left: 1.5%;
    padding-right: 1.5%;
   }
   .footer-total-div {
   font-size: 15px;
   font-weight: bold;
   width: 100%;
   background-color: #f8f9fa;
   padding: 10px 0;
   box-shadow: 0 -2px 5px rgba(0, 0, 0, 0.1);
   display: grid;
   grid-template-columns: 0.8fr 3.2fr 1fr 0.8fr 0.8fr 1fr;
   gap: 10px; 
   }
   .footer-total-div div {
   text-align: center;
   }
   #total_items {
   grid-column: 1;
   }
   #total_discount {
   grid-column: 4;
   }
   #total_quantity {
   grid-column: 5;
   }
   #total_amount {
   grid-column: 6;
   }
   .custom-footer {
   background-color: #f8f9fa;
   padding: 10px 0;
   box-shadow: 0 -2px 5px rgba(0, 0, 0, 0.1);
   display: flex;
   justify-content: space-around; 
   align-items: center;
   flex-wrap: wrap; 
   }
   .footer-item {
   text-align: center;
   padding: 5px 10px;
   font-weight: bold;
   border-left: 1px solid #dee2e6; 
   }
   .footer-item:first-child {
   border-left: none; 
   }
   .table tfoot {
   display: none;   
   }
</style>
@php
$is_mobile = isMobile();
@endphp
<div class="main-container no-print">
   <div class="card-wrapper">
      @component('components.widget', ['class' => 'box-warning'])
      @slot('header')
      <div class="overview-filter">
         <div class="title">
            <h1>@lang('lang_v1.customer_display')</h1>
            <p>@lang('lang_v1.customer_display_caption')</p>
         </div>
         @if(!$is_mobile)
         <div class="filter">
            <button type="button" title="{{ __('lang_v1.full_screen') }}" class="add-user-modal-btn btn-modal pull-right" id="full_screen" data-toggle="tooltip" data-placement="bottom">
            <img src="{{ asset('img/icons/full-screen.svg') }}" style="width: 21px;" alt="">
            </button>
         </div>
         @endif
      </div>
      @endslot
      <div class="content">
         <div class="row">
            <div class="table-responsive " id="customer-display">
               <table class="table table-bordered table-striped ajax_view max-table" id="customer-display-table"  style="width: 100%">
                  <thead >
                     <tr >
                        <th>#</th>
                        <th>@lang('lang_v1.product')</th>
                        <th>@lang('sale.price_inc_tax')</th>
                        <th>@lang('sale.discount')</th>
                        <th>@lang('sale.qty')</th>
                        <th>@lang('sale.total')</th>
                     </tr>
                  </thead>
                  <tbody class=" text-center">
                     <!-- Item rows will be dynamically added here -->
                  </tbody>
               </table>
            </div>
            <div class="footer-container">
               <div class="footer-total-div">
                  <div id="total_items" class="total-item"></div>
                  <div id="total_discount" class="total-item"></div>
                  <div id="total_quantity" class="total-item"></div>
                  <div id="total_amount" class="total-item"></div>
               </div>
               <div class="custom-footer">
                  <div class="footer-item">
                     <strong>@lang('sale.shipping_charges'):</strong>+<span id="shipping_charges"></span>
                  </div>
                  <div class="footer-item">
                     <strong>@lang('sale.order_tax'):</strong>+<span id="order_tax"></span>
                  </div>
                  @if (in_array('types_of_service', $enabled_modules))
                  <div class="footer-item">
                     <strong>@lang('lang_v1.packing_charge'):</strong>+<span id="packing_charge"></span>
                  </div>
                  @endif
                  @if (!empty($pos_settings['amount_rounding_method']) && $pos_settings['amount_rounding_method'] > 0)
                  <div class="footer-item">
                     <strong>@lang('lang_v1.round_off_amount'):</strong> <span id="round_off_amount"></span>
                  </div>
                  @endif
                  <div class="footer-item">
                     <strong>@lang('lang_v1.total_discount'):</strong>-<span id="total_discount_invoice"></span>
                  </div>
                  <div class="footer-item">
                     <strong>@lang('lang_v1.redeemed_amount'):</strong>-<span id="rp_redeemed"></span>
                  </div>
                  <div class="footer-item">
                     <strong>@lang('sale.total_payable'):</strong> <span id="total_payable"></span>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
    @endcomponent

    @stop
    @section('javascript')
      <script>
         function updateCustomerDisplay(data) {
            let tbody = $('#customer-display-table tbody');
            tbody.empty();

            if (data.length === 0) {
                  tbody.append('<tr><td colspan="6" class="heading-x">{{ __('lang_v1.no_items') }}</td></tr>');
            } else {
                  let totalItems = 0;
                  let totalDiscount = 0;
                  let totalQuantity = 0;
                  let totalAmount = 0;

                  data.forEach(function(item, index) {
                     totalItems++;
                     totalDiscount += parseFloat(item.discount);
                     totalQuantity += parseFloat(item.quantity);
                     totalAmount += parseFloat(item.total);

                     let modifierHtml = '';
                     let modifierTotal = 0; 
                     if (item.modifiers && item.modifiers.length > 0) {
                        item.modifiers.forEach(function(modifier) {
                              let modifierItemTotal = modifier.price * modifier.quantity;
                              modifierTotal += modifierItemTotal;
                              modifierHtml += `<div class="modifier-item">${modifier.name}: ${__currency_trans_from_en(modifier.price, true, false, 2)} x ${modifier.quantity} <!--= ${__currency_trans_from_en(modifierItemTotal, true, false, 2)} --></div>`;
                        });
                     }
                     let totalCellContent = `${__currency_trans_from_en(item.total, true, false, 2)}`;
                     if (modifierTotal > 0) {
                        totalCellContent += `<br>${__currency_trans_from_en(modifierTotal, true, false, 2)}`;
                     }
                     let row = $(`
                        <tr id="row_${item.id}">
                              <td>${index + 1}</td>
                              <td>${item.name}<div class="modifier-details">${modifierHtml}</div></td>
                              <td>${__currency_trans_from_en(item.price, true, false, 2)}</td>
                              <td>${__currency_trans_from_en(item.discount, true, false, 2)}</td>
                              <td>${item.quantity}</td>
                              <td>${totalCellContent}</td> 
                        </tr>
                     `);
                     tbody.prepend(row);

                     totalAmount += modifierTotal; 
                  });

                  $('#total_items').text(totalItems);
                  $('#total_discount').text(__currency_trans_from_en(totalDiscount, true, false, 2));
                  $('#total_quantity').text(totalQuantity.toFixed(2));
                  $('#total_amount').text(__currency_trans_from_en(totalAmount, true, false, 2));
               }
            }

            function updateFooterDisplay() {
            let footerData = JSON.parse(localStorage.getItem('footerData')) || {};
            $('#total_discount_invoice').text(__currency_trans_from_en(footerData.discount_amount || 0, true, false, 2));
            $('#rp_redeemed').text(__currency_trans_from_en(footerData.rp_redeemed_amount || 0, true, false, 2));
            $('#packing_charge').text(__currency_trans_from_en(footerData.packing_charge || 0, true, false, 2));
            $('#shipping_charges').text(__currency_trans_from_en(footerData.shipping_charges || 0, true, false, 2));
            $('#order_tax').text(__currency_trans_from_en(footerData.order_tax || 0, true, false, 2));
            $('#round_off_amount').text(__currency_trans_from_en(footerData.round_off_amount || 0, true, false, 2));
            $('#total_payable').text(__currency_trans_from_en(footerData.total_payable || 0, true, false, 2));
         }

      function clearCustomerDisplay() {
         let tbody = $('#customer-display-table tbody');
         tbody.empty();
         tbody.append('<tr><td colspan="6" class="heading-x">{{ __('lang_v1.no_items') }}</td></tr>');
         $('#total_items').text(0);
         $('#total_discount').text('0.00');
         $('#total_quantity').text('0.00');
         $('#total_amount').text('0.00');
         $('#rp_redeemed').text('0.00');
         $('#shipping_charges').text('0.00');
         $('#order_tax').text('0.00');
         $('#round_off_amount').text('0.00');
         $('#total_discount_invoice').text('0.00');
         $('#total_payable').text('0.00');
         $('#packing_charge').text('0.00');
      }

    function fetchPosData() {
        let posData = JSON.parse(localStorage.getItem('posData')) || [];
        updateCustomerDisplay(posData);
        updateFooterDisplay();
    }
   
    window.addEventListener('storage', function(event) {
    if (event.key === 'posDataCleared' && event.newValue === 'true') {
        clearCustomerDisplay();
        localStorage.removeItem('posDataCleared');
    } else if (event.key === 'posDataUpdated') {
        fetchPosData();
    } else if (event.key === 'footerDataUpdated') {
        updateFooterDisplay();
    }
    });

    window.addEventListener('storage', function(event) {
    if (event.key === 'posDataCleared' && event.newValue === 'true') {
        clearCustomerDisplay();
        localStorage.removeItem('posDataCleared');
    } else if (event.key === 'posDataUpdated') {
        fetchPosData();
    } else if (event.key === 'footerDataUpdated') {
        updateFooterDisplay(); 
    }
    });


    $(document).ready(function() {
        fetchPosData();
    });

    </script>
    @endsection