@extends('layouts.app')
@section('title', __('business.business_settings'))

@section('css')
<style>
    /* Ultra-Modern Unique Business Settings Design */
    @import url('{{ asset('fonts/google-fonts/inter-poppins-almarai-local.css') }}');
    
    * {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif !important;
    }
    
    /* Ensure FontAwesome icons display correctly */
    .fa, .fas, .far, .fal, .fad, .fab,
    [class*="fa-"],
    i[class*="fa-"] {
        font-family: "Font Awesome 5 Free", "Font Awesome 5 Pro", "Font Awesome 5 Brands", "FontAwesome" !important;
        font-weight: 900 !important;
        font-style: normal !important;
        font-variant: normal !important;
        text-rendering: auto !important;
        line-height: 1 !important;
        -webkit-font-smoothing: antialiased !important;
        -moz-osx-font-smoothing: grayscale !important;
    }
    
    .far {
        font-weight: 400 !important;
    }
    
    .fab {
        font-family: "Font Awesome 5 Brands" !important;
    }
    
    .modern-settings-wrapper {
        background: linear-gradient(135deg, #f0f4f8 0%, #e8f0f5 50%, #f5f7fa 100%) !important;
        padding: 1rem !important;
        margin: 0 !important;
        position: relative !important;
    }
    
    .modern-settings-wrapper::before {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        left: 0 !important;
        right: 0 !important;
        bottom: 0 !important;
        background: 
            radial-gradient(circle at 20% 50%, rgba(59, 130, 246, 0.08) 0%, transparent 50%),
            radial-gradient(circle at 80% 80%, rgba(139, 92, 246, 0.06) 0%, transparent 50%),
            radial-gradient(circle at 40% 20%, rgba(236, 72, 153, 0.05) 0%, transparent 50%) !important;
        pointer-events: none !important;
        z-index: 0 !important;
    }
    
    .modern-settings-wrapper > * {
        position: relative !important;
        z-index: 1 !important;
    }
    
    .modern-settings-header {
        background: rgba(255, 255, 255, 0.85) !important;
        backdrop-filter: blur(20px) saturate(180%) !important;
        -webkit-backdrop-filter: blur(20px) saturate(180%) !important;
        border: 1px solid rgba(255, 255, 255, 0.3) !important;
        border-bottom: 1px solid rgba(226, 232, 240, 0.5) !important;
        padding: 1.25rem 1.5rem !important;
        margin-bottom: 1rem !important;
        position: relative !important;
        border-radius: 16px !important;
        box-shadow: 
            0 8px 32px rgba(0, 0, 0, 0.06),
            0 2px 8px rgba(0, 0, 0, 0.04),
            inset 0 1px 0 rgba(255, 255, 255, 0.9) !important;
        overflow: hidden !important;
    }
    
    .modern-settings-header::before {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        left: 0 !important;
        right: 0 !important;
        height: 4px !important;
        background: linear-gradient(90deg, 
            #3b82f6 0%, 
            #8b5cf6 25%, 
            #ec4899 50%, 
            #f59e0b 75%, 
            #10b981 100%) !important;
        background-size: 200% 100% !important;
        animation: gradientFlow 3s ease infinite !important;
    }
    
    @keyframes gradientFlow {
        0%, 100% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
    }
    
    .modern-settings-header::after {
        content: '' !important;
        position: absolute !important;
        top: -50% !important;
        right: -10% !important;
        width: 300px !important;
        height: 300px !important;
        background: radial-gradient(circle, rgba(59, 130, 246, 0.1) 0%, transparent 70%) !important;
        border-radius: 50% !important;
        pointer-events: none !important;
    }
    
    .modern-settings-header .header-content-wrapper {
        display: flex !important;
        flex-direction: column !important;
        align-items: flex-start !important;
        width: 100% !important;
    }
    
    .modern-settings-header .header-title-section {
        width: 100% !important;
    }
    
    .modern-settings-header h1 {
        color: #0f172a !important;
        font-size: 1.75rem !important;
        font-weight: 800 !important;
        margin: 0 0 0.5rem 0 !important;
        letter-spacing: -0.4px !important;
        line-height: 1.2 !important;
        display: flex !important;
        align-items: center !important;
        gap: 0.75rem !important;
        position: relative !important;
        z-index: 2 !important;
    }
    
    .modern-settings-header h1 i {
        color: #ffffff !important;
        font-size: 1.25rem !important;
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 50%, #1d4ed8 100%) !important;
        padding: 0.5rem !important;
        border-radius: 12px !important;
        width: 2.75rem !important;
        height: 2.75rem !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        box-shadow: 
            0 8px 16px rgba(59, 130, 246, 0.3),
            0 4px 8px rgba(59, 130, 246, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2) !important;
        position: relative !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        font-family: "Font Awesome 5 Free", "Font Awesome 5 Pro", "FontAwesome" !important;
        font-weight: 900 !important;
        font-style: normal !important;
        -webkit-font-smoothing: antialiased !important;
        -moz-osx-font-smoothing: grayscale !important;
    }
    
    .modern-settings-header h1 i::before {
        content: '' !important;
        position: absolute !important;
        inset: -2px !important;
        border-radius: 16px !important;
        padding: 2px !important;
        background: linear-gradient(135deg, #3b82f6, #8b5cf6, #ec4899) !important;
        -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0) !important;
        -webkit-mask-composite: xor !important;
        mask-composite: exclude !important;
        opacity: 0 !important;
        transition: opacity 0.3s ease !important;
    }
    
    .modern-settings-header h1:hover i {
        transform: translateY(-2px) rotate(5deg) scale(1.05) !important;
        box-shadow: 
            0 12px 24px rgba(59, 130, 246, 0.4),
            0 6px 12px rgba(59, 130, 246, 0.3) !important;
    }
    
    .modern-settings-header h1:hover i::before {
        opacity: 1 !important;
    }
    
    .modern-settings-header .header-subtitle {
        color: #64748b !important;
        font-size: 0.875rem !important;
        margin: 0 !important;
        font-weight: 400 !important;
        line-height: 1.5 !important;
        padding-left: 3.5rem !important;
        position: relative !important;
        z-index: 2 !important;
        max-width: 600px !important;
    }
    
    .modern-settings-header .header-search-section {
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        width: 100% !important;
        margin-top: 1rem !important;
    }
    
    .modern-settings-container {
        background: rgba(255, 255, 255, 0.9) !important;
        backdrop-filter: blur(20px) saturate(180%) !important;
        -webkit-backdrop-filter: blur(20px) saturate(180%) !important;
        border: 1px solid rgba(255, 255, 255, 0.4) !important;
        border-radius: 16px !important;
        padding: 0 !important;
        box-shadow: 
            0 20px 60px rgba(0, 0, 0, 0.08),
            0 8px 24px rgba(0, 0, 0, 0.06),
            inset 0 1px 0 rgba(255, 255, 255, 0.9) !important;
        overflow: hidden !important;
        position: relative !important;
    }
    
    .modern-settings-container::before {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        left: 0 !important;
        right: 0 !important;
        height: 1px !important;
        background: linear-gradient(90deg, 
            transparent, 
            rgba(59, 130, 246, 0.3), 
            rgba(139, 92, 246, 0.3), 
            transparent) !important;
    }
    
    /* Ultra-Modern Sidebar Navigation */
    .modern-sidebar-nav {
        background: linear-gradient(180deg, 
            rgba(255, 255, 255, 0.95) 0%, 
            rgba(248, 250, 252, 0.9) 50%,
            rgba(255, 255, 255, 0.95) 100%) !important;
        backdrop-filter: blur(10px) !important;
        -webkit-backdrop-filter: blur(10px) !important;
        padding: 0.75rem 0 !important;
        min-height: auto !important;
        border-right: 1px solid rgba(226, 232, 240, 0.6) !important;
        position: relative !important;
        overflow-y: auto !important;
        max-height: none !important;
    }
    
    .modern-sidebar-nav::before {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        right: 0 !important;
        width: 2px !important;
        height: 100% !important;
        background: linear-gradient(180deg, 
            transparent 0%, 
            rgba(59, 130, 246, 0.2) 20%,
            rgba(59, 130, 246, 0.3) 50%,
            rgba(59, 130, 246, 0.2) 80%,
            transparent 100%) !important;
    }
    
    .modern-sidebar-nav::after {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        left: 0 !important;
        right: 0 !important;
        height: 60px !important;
        background: linear-gradient(180deg, 
            rgba(59, 130, 246, 0.05) 0%, 
            transparent 100%) !important;
        pointer-events: none !important;
    }
    
    .modern-nav-item {
        display: flex !important;
        align-items: center !important;
        padding: 0.625rem 0.875rem !important;
        margin: 0.125rem 0.5rem !important;
        color: #475569 !important;
        text-decoration: none !important;
        border-radius: 10px !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        position: relative !important;
        font-weight: 500 !important;
        font-size: 0.8125rem !important;
        border: none !important;
        background: transparent !important;
        letter-spacing: 0.01em !important;
        overflow: hidden !important;
    }
    
    .modern-nav-item::before {
        content: '' !important;
        position: absolute !important;
        left: 0 !important;
        top: 50% !important;
        transform: translateY(-50%) scaleY(0) !important;
        height: 50% !important;
        width: 4px !important;
        background: linear-gradient(180deg, #3b82f6 0%, #2563eb 50%, #1d4ed8 100%) !important;
        border-radius: 0 6px 6px 0 !important;
        transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        box-shadow: 0 0 8px rgba(59, 130, 246, 0.4) !important;
    }
    
    .modern-nav-item::after {
        content: '' !important;
        position: absolute !important;
        left: 0 !important;
        right: 0 !important;
        top: 0 !important;
        bottom: 0 !important;
        background: linear-gradient(135deg, 
            rgba(59, 130, 246, 0.1) 0%, 
            rgba(59, 130, 246, 0.05) 50%,
            transparent 100%) !important;
        border-radius: 12px !important;
        opacity: 0 !important;
        transition: opacity 0.3s ease !important;
    }
    
    .modern-nav-item:hover {
        background: rgba(241, 245, 249, 0.8) !important;
        color: #1e293b !important;
        transform: translateX(4px) !important;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08) !important;
    }
    
    .modern-nav-item:hover::after {
        opacity: 1 !important;
    }
    
    .modern-nav-item:hover::before {
        transform: translateY(-50%) scaleY(0.6) !important;
    }
    
    .modern-nav-item.active {
        background: linear-gradient(135deg, 
            rgba(59, 130, 246, 0.15) 0%, 
            rgba(59, 130, 246, 0.08) 50%,
            rgba(59, 130, 246, 0.05) 100%) !important;
        color: #1e40af !important;
        font-weight: 600 !important;
        box-shadow: 
            0 4px 12px rgba(59, 130, 246, 0.15),
            0 2px 4px rgba(59, 130, 246, 0.1),
            inset 0 1px 0 rgba(255, 255, 255, 0.3) !important;
        transform: translateX(4px) !important;
    }
    
    .modern-nav-item.active::before {
        transform: translateY(-50%) scaleY(1) !important;
        box-shadow: 0 0 12px rgba(59, 130, 246, 0.6) !important;
    }
    
    .modern-nav-item.active::after {
        opacity: 1 !important;
    }
    
    .modern-nav-item i {
        font-size: 1rem !important;
        margin-right: 0.625rem !important;
        width: 18px !important;
        text-align: center !important;
        color: inherit !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        flex-shrink: 0 !important;
        position: relative !important;
        z-index: 2 !important;
        display: inline-block !important;
        font-family: "Font Awesome 5 Free", "Font Awesome 5 Pro", "FontAwesome" !important;
        font-weight: 900 !important;
        font-style: normal !important;
        -webkit-font-smoothing: antialiased !important;
        -moz-osx-font-smoothing: grayscale !important;
    }
    
    .modern-nav-item:hover i {
        transform: scale(1.15) rotate(5deg) !important;
        color: #3b82f6 !important;
    }
    
    .modern-nav-item.active i {
        color: #2563eb !important;
        transform: scale(1.1) !important;
        text-shadow: 0 2px 4px rgba(59, 130, 246, 0.2) !important;
    }
    
    .modern-nav-item span {
        flex: 1 !important;
        position: relative !important;
        z-index: 1 !important;
    }
    
    /* Ultra-Modern Content Area */
    .modern-content-area {
        padding: 1.5rem !important;
        background: transparent !important;
        min-height: auto !important;
        position: relative !important;
    }
    
    .modern-content-area::before {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        left: 0 !important;
        right: 0 !important;
        bottom: 0 !important;
        background: 
            radial-gradient(circle at 0% 0%, rgba(59, 130, 246, 0.03) 0%, transparent 50%),
            radial-gradient(circle at 100% 100%, rgba(139, 92, 246, 0.03) 0%, transparent 50%) !important;
        pointer-events: none !important;
        z-index: 0 !important;
    }
    
    .modern-content-area > * {
        position: relative !important;
        z-index: 1 !important;
    }
    
    /* Enhanced Tab Content Animation */
    .pos-tab-content.active {
        animation: slideInFade 0.5s cubic-bezier(0.4, 0, 0.2, 1) !important;
    }
    
    @keyframes slideInFade {
        0% {
            opacity: 0;
            transform: translateY(20px) scale(0.98);
        }
        50% {
            opacity: 0.7;
        }
        100% {
            opacity: 1;
            transform: translateY(0) scale(1);
        }
    }
    
    /* Ultra-Modern Submit Button Section */
    .modern-submit-section {
        background: linear-gradient(135deg, 
            rgba(248, 250, 252, 0.8) 0%, 
            rgba(255, 255, 255, 0.9) 100%) !important;
        backdrop-filter: blur(10px) !important;
        -webkit-backdrop-filter: blur(10px) !important;
        padding: 1.5rem 1.5rem !important;
        margin-top: 0 !important;
        border-top: 1px solid rgba(226, 232, 240, 0.5) !important;
        position: relative !important;
        border-radius: 0 0 16px 16px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
    }
    
    .modern-submit-section > div {
        width: 100% !important;
    }
    
    .modern-submit-section::before {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        left: 50% !important;
        transform: translateX(-50%) !important;
        width: 200px !important;
        height: 1px !important;
        background: linear-gradient(90deg, 
            transparent, 
            rgba(59, 130, 246, 0.4), 
            rgba(139, 92, 246, 0.4), 
            transparent) !important;
    }
    
    .modern-submit-btn {
        background: linear-gradient(135deg, 
            #3b82f6 0%, 
            #2563eb 50%, 
            #1d4ed8 100%) !important;
        color: #ffffff !important;
        border: none !important;
        padding: 0.875rem 2.5rem !important;
        font-size: 0.9375rem !important;
        font-weight: 700 !important;
        border-radius: 12px !important;
        cursor: pointer !important;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
        box-shadow: 
            0 10px 25px rgba(59, 130, 246, 0.35),
            0 5px 10px rgba(59, 130, 246, 0.25),
            inset 0 1px 0 rgba(255, 255, 255, 0.2) !important;
        position: relative !important;
        overflow: hidden !important;
        letter-spacing: 0.5px !important;
        text-transform: uppercase !important;
        display: inline-block !important;
        min-width: 200px !important;
    }
    
    .modern-submit-btn::before {
        content: '' !important;
        position: absolute !important;
        top: 50% !important;
        left: 50% !important;
        width: 0 !important;
        height: 0 !important;
        border-radius: 50% !important;
        background: rgba(255, 255, 255, 0.3) !important;
        transform: translate(-50%, -50%) !important;
        transition: width 0.6s ease, height 0.6s ease !important;
    }
    
    .modern-submit-btn::after {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        left: -100% !important;
        width: 100% !important;
        height: 100% !important;
        background: linear-gradient(90deg, 
            transparent, 
            rgba(255, 255, 255, 0.25), 
            transparent) !important;
        transition: left 0.6s ease !important;
    }
    
    .modern-submit-btn:hover::before {
        width: 400px !important;
        height: 400px !important;
    }
    
    .modern-submit-btn:hover::after {
        left: 100% !important;
    }
    
    .modern-submit-btn:hover {
        background: linear-gradient(135deg, 
            #2563eb 0%, 
            #1d4ed8 50%, 
            #1e40af 100%) !important;
        box-shadow: 
            0 15px 35px rgba(59, 130, 246, 0.45),
            0 8px 15px rgba(59, 130, 246, 0.35),
            inset 0 1px 0 rgba(255, 255, 255, 0.3) !important;
        transform: translateY(-3px) scale(1.02) !important;
    }
    
    .modern-submit-btn:active {
        transform: translateY(-1px) scale(1) !important;
        box-shadow: 
            0 5px 15px rgba(59, 130, 246, 0.3),
            0 2px 5px rgba(59, 130, 246, 0.2) !important;
    }
    
    .modern-submit-btn i {
        margin-right: 0.75rem !important;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
        display: inline-block !important;
        font-family: "Font Awesome 5 Free", "Font Awesome 5 Pro", "FontAwesome" !important;
        font-weight: 900 !important;
        font-style: normal !important;
        -webkit-font-smoothing: antialiased !important;
        -moz-osx-font-smoothing: grayscale !important;
    }
    
    .modern-submit-btn:hover i {
        transform: translateX(4px) rotate(10deg) scale(1.1) !important;
    }
    
    /* Override existing pos-tab styles */
    .pos-tab-container {
        background: transparent !important;
        box-shadow: none !important;
        border: none !important;
    }
    
    .pos-tab-menu {
        display: none !important;
    }
    
    /* Professional Form Elements Enhancement */
    .modern-content-area .form-group label {
        font-weight: 600 !important;
        color: #334155 !important;
        font-size: 0.875rem !important;
        margin-bottom: 0.5rem !important;
    }
    
    .modern-content-area .form-control {
        border: 1px solid #cbd5e1 !important;
        border-radius: 6px !important;
        transition: all 0.2s ease !important;
    }
    
    .modern-content-area .form-control:focus {
        border-color: #3b82f6 !important;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1) !important;
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .modern-settings-wrapper {
            padding: 0.75rem !important;
        }
        
        .modern-settings-header {
            padding: 1rem 1.25rem !important;
            margin-bottom: 0.75rem !important;
        }
        
        .modern-settings-header h1 {
            font-size: 1.5rem !important;
            margin-bottom: 0.375rem !important;
        }
        
        .modern-settings-header h1 i {
            font-size: 1.125rem !important;
            width: 2.25rem !important;
            height: 2.25rem !important;
            padding: 0.4375rem !important;
        }
        
        .modern-settings-header .header-subtitle {
            font-size: 0.8125rem !important;
            padding-left: 3rem !important;
        }
        
        .modern-settings-header .header-search-section {
            margin-top: 0.75rem !important;
        }
        
        .modern-sidebar-nav {
            border-right: none !important;
            border-bottom: 1px solid #e2e8f0 !important;
            max-height: 240px !important;
            margin-bottom: 1rem !important;
            background: #ffffff !important;
            padding: 0.5rem 0 !important;
        }
        
        .modern-content-area {
            padding: 1rem !important;
        }
        
        .modern-nav-item {
            padding: 0.5rem 0.75rem !important;
            font-size: 0.75rem !important;
            margin: 0.125rem 0.375rem !important;
        }
        
        .modern-nav-item i {
            font-size: 0.875rem !important;
            margin-right: 0.5rem !important;
            width: 16px !important;
        }
        
        .modern-submit-section {
            padding: 1rem !important;
            margin-top: 0 !important;
        }
        
        .modern-submit-btn {
            padding: 0.625rem 1.5rem !important;
            font-size: 0.875rem !important;
            width: 100% !important;
            max-width: 300px !important;
        }
    }
    
    /* Professional Scrollbar Styling */
    .modern-sidebar-nav::-webkit-scrollbar {
        width: 6px !important;
    }
    
    .modern-sidebar-nav::-webkit-scrollbar-track {
        background: #f1f5f9 !important;
        border-radius: 3px !important;
    }
    
    .modern-sidebar-nav::-webkit-scrollbar-thumb {
        background: linear-gradient(to bottom, #cbd5e1, #94a3b8) !important;
        border-radius: 3px !important;
    }
    
    .modern-sidebar-nav::-webkit-scrollbar-thumb:hover {
        background: linear-gradient(to bottom, #94a3b8, #64748b) !important;
    }
    
    /* Search Settings Integration */
    .modern-search-wrapper {
        margin: 0 !important;
        width: 100% !important;
        max-width: 500px !important;
    }
    
    .modern-search-wrapper .row {
        margin: 0 !important;
    }
    
    .modern-search-wrapper .col-md-8 {
        width: 100% !important;
        padding: 0 !important;
        margin: 0 auto !important;
        float: none !important;
    }
    
    .modern-search-wrapper .input-group {
        display: flex !important;
        align-items: center !important;
        background: rgba(255, 255, 255, 0.95) !important;
        backdrop-filter: blur(10px) !important;
        -webkit-backdrop-filter: blur(10px) !important;
        border: 2px solid rgba(226, 232, 240, 0.8) !important;
        border-radius: 14px !important;
        padding: 0 !important;
        box-shadow: 
            0 4px 12px rgba(0, 0, 0, 0.06),
            0 2px 4px rgba(0, 0, 0, 0.04),
            inset 0 1px 0 rgba(255, 255, 255, 0.9) !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        position: relative !important;
        overflow: hidden !important;
    }
    
    .modern-search-wrapper .input-group::before {
        content: '' !important;
        position: absolute !important;
        top: 0 !important;
        left: -100% !important;
        width: 100% !important;
        height: 100% !important;
        background: linear-gradient(90deg, 
            transparent, 
            rgba(59, 130, 246, 0.05), 
            transparent) !important;
        transition: left 0.5s ease !important;
    }
    
    .modern-search-wrapper .input-group:hover {
        border-color: rgba(59, 130, 246, 0.4) !important;
        box-shadow: 
            0 6px 20px rgba(0, 0, 0, 0.08),
            0 3px 8px rgba(0, 0, 0, 0.06) !important;
        transform: translateY(-1px) !important;
    }
    
    .modern-search-wrapper .input-group:hover::before {
        left: 100% !important;
    }
    
    .modern-search-wrapper .input-group:focus-within {
        border-color: #3b82f6 !important;
        box-shadow: 
            0 0 0 4px rgba(59, 130, 246, 0.12),
            0 8px 24px rgba(59, 130, 246, 0.15),
            0 4px 12px rgba(0, 0, 0, 0.1) !important;
        transform: translateY(-2px) !important;
    }
    
    .modern-search-wrapper .input-group-addon {
        background: transparent !important;
        border: none !important;
        padding: 0.875rem 1.125rem !important;
        color: #64748b !important;
        font-size: 1.125rem !important;
        transition: all 0.3s ease !important;
        position: relative !important;
        z-index: 2 !important;
    }
    
    .modern-search-wrapper .input-group-addon i {
        color: #64748b !important;
        transition: all 0.3s ease !important;
        font-family: "Font Awesome 5 Free", "Font Awesome 5 Pro", "FontAwesome" !important;
        font-weight: 900 !important;
        font-style: normal !important;
        display: inline-block !important;
        -webkit-font-smoothing: antialiased !important;
        -moz-osx-font-smoothing: grayscale !important;
    }
    
    .modern-search-wrapper .input-group:hover .input-group-addon i {
        color: #3b82f6 !important;
        transform: scale(1.1) !important;
    }
    
    .modern-search-wrapper .input-group:focus-within .input-group-addon i {
        color: #3b82f6 !important;
        transform: scale(1.15) rotate(5deg) !important;
    }
    
    .modern-search-wrapper .form-control,
    .modern-search-wrapper select {
        border: none !important;
        border-radius: 14px !important;
        padding: 0.875rem 1.125rem !important;
        font-size: 0.9375rem !important;
        transition: all 0.3s ease !important;
        background: transparent !important;
        box-shadow: none !important;
        height: auto !important;
        color: #1e293b !important;
        font-weight: 500 !important;
    }
    
    .modern-search-wrapper .form-control:focus,
    .modern-search-wrapper select:focus {
        border: none !important;
        box-shadow: none !important;
        outline: none !important;
    }
    
    .modern-search-wrapper select {
        appearance: none !important;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='14' height='14' viewBox='0 0 14 14'%3E%3Cpath fill='%233b82f6' d='M7 10L2 5h10z'/%3E%3C/svg%3E") !important;
        background-repeat: no-repeat !important;
        background-position: right 1.125rem center !important;
        padding-right: 2.75rem !important;
        cursor: pointer !important;
    }
    
    /* Enhanced Form Fields in Content Area */
    .modern-content-area .form-group {
        margin-bottom: 1rem !important;
    }
    
    .modern-content-area .form-group label {
        font-weight: 600 !important;
        color: #1e293b !important;
        font-size: 0.8125rem !important;
        margin-bottom: 0.5rem !important;
        letter-spacing: 0.01em !important;
    }
    
    .modern-content-area .form-control,
    .modern-content-area select {
        border: 1.5px solid #e2e8f0 !important;
        border-radius: 8px !important;
        padding: 0.625rem 0.875rem !important;
        font-size: 0.875rem !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        background: rgba(255, 255, 255, 0.9) !important;
    }
    
    .modern-content-area .form-control:hover,
    .modern-content-area select:hover {
        border-color: #cbd5e1 !important;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.04) !important;
    }
    
    .modern-content-area .form-control:focus,
    .modern-content-area select:focus {
        border-color: #3b82f6 !important;
        box-shadow: 
            0 0 0 4px rgba(59, 130, 246, 0.1),
            0 4px 12px rgba(59, 130, 246, 0.08) !important;
        outline: none !important;
        background: #ffffff !important;
    }
    
    .modern-content-area .input-group-addon {
        background: rgba(248, 250, 252, 0.8) !important;
        border: 1.5px solid #e2e8f0 !important;
        border-right: none !important;
        color: #64748b !important;
        transition: all 0.3s ease !important;
    }
    
    .modern-content-area .input-group:focus-within .input-group-addon {
        background: rgba(59, 130, 246, 0.05) !important;
        border-color: #3b82f6 !important;
        color: #3b82f6 !important;
    }
    
    /* Responsive Header */
    @media (max-width: 992px) {
        .modern-settings-header .header-search-section {
            margin-top: 0.75rem !important;
        }
        
        .modern-search-wrapper {
            max-width: 100% !important;
        }
        
        .modern-settings-header .header-subtitle {
            padding-left: 0 !important;
            margin-top: 0.375rem !important;
        }
    }
    
    @media (max-width: 768px) {
        .modern-search-wrapper {
            max-width: 100% !important;
        }
        
        .modern-search-wrapper .input-group {
            border-radius: 8px !important;
        }
        
        .modern-search-wrapper .input-group-addon {
            padding: 0.625rem 0.875rem !important;
        }
        
        .modern-search-wrapper .form-control,
        .modern-search-wrapper select {
            padding: 0.625rem 0.875rem !important;
            font-size: 0.875rem !important;
        }
    }
    
    /* Professional Badge/Indicator */
    .modern-nav-item.active span::after {
        content: '' !important;
        position: absolute !important;
        right: -1.5rem !important;
        top: 50% !important;
        transform: translateY(-50%) !important;
        width: 6px !important;
        height: 6px !important;
        background: #3b82f6 !important;
        border-radius: 50% !important;
        box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2) !important;
    }
</style>
@endsection

@section('content')

<div class="modern-settings-wrapper">
    {{-- Modern Header Section --}}
    <div class="container-fluid">
        <div class="modern-settings-header">
            <div class="header-content-wrapper">
                <div class="header-title-section">
                    <h1>
                        <i class="fa fa-cogs"></i>
                        <span>@lang('business.business_settings')</span>
                    </h1>
                    <p class="header-subtitle">
                        @if(Lang::has('lang_v1.manage_your_business_configuration'))
                            @lang('lang_v1.manage_your_business_configuration')
                        @else
                            {{ __('Configure and manage your business settings, preferences, and system options') }}
                        @endif
                    </p>
                </div>
                <div class="header-search-section">
                    <div class="modern-search-wrapper">
                        @include('layouts.partials.search_settings')
                    </div>
                </div>
            </div>
        </div>

        {{-- Main Settings Form --}}
        {!! Form::open([
            'url' => action([\App\Http\Controllers\BusinessController::class, 'postBusinessSettings']), 
            'method' => 'post', 
            'id' => 'bussiness_edit_form',
            'files' => true,
            'class' => 'business-settings-form'
        ]) !!}

        <div class="modern-settings-container">
            <div class="row no-gutters">
                {{-- Modern Sidebar Navigation --}}
                <div class="col-lg-2 col-md-3">
                    <div class="modern-sidebar-nav" role="tablist" aria-label="@lang('business.business_settings')">
                        <a href="#" 
                           class="modern-nav-item active" 
                           role="tab" 
                           aria-selected="true"
                           data-tab-index="0">
                            <i class="fa fa-building"></i>
                            <span>@lang('business.business')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="1">
                            <i class="fa fa-percent"></i>
                            <span>@lang('business.tax')</span>
                            @show_tooltip(__('tooltip.business_tax'))
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="2">
                            <i class="fa fa-cube"></i>
                            <span>@lang('business.product')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="3">
                            <i class="fa fa-address-book"></i>
                            <span>@lang('contact.contact')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="4">
                            <i class="fa fa-shopping-cart"></i>
                            <span>@lang('business.sale')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="5">
                            <i class="fa fa-desktop"></i>
                            <span>@lang('sale.pos_sale')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="6">
                            <i class="fa fa-shopping-bag"></i>
                            <span>@lang('purchase.purchases')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="7">
                            <i class="fa fa-credit-card"></i>
                            <span>@lang('lang_v1.payment')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="8">
                            <i class="fa fa-tachometer-alt"></i>
                            <span>@lang('business.dashboard')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="9">
                            <i class="fa fa-cog"></i>
                            <span>@lang('business.system')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="10">
                            <i class="fa fa-file-alt"></i>
                            <span>@lang('lang_v1.prefixes')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="11">
                            <i class="fa fa-envelope"></i>
                            <span>@lang('lang_v1.email_settings')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="12">
                            <i class="fa fa-sms"></i>
                            <span>@lang('lang_v1.sms_settings')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="13">
                            <i class="fa fa-star"></i>
                            <span>@lang('lang_v1.reward_point_settings')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="14">
                            <i class="fa fa-puzzle-piece"></i>
                            <span>@lang('lang_v1.modules')</span>
                        </a>
                        
                        <a href="#" 
                           class="modern-nav-item" 
                           role="tab" 
                           aria-selected="false"
                           data-tab-index="15">
                            <i class="fa fa-tags"></i>
                            <span>@lang('lang_v1.custom_labels')</span>
                        </a>
                    </div>
                </div>

                {{-- Modern Content Area --}}
                <div class="col-lg-10 col-md-9">
                    <div class="modern-content-area">
                        {{-- Maintain compatibility with existing pos-tab-container system --}}
                        <div class="pos-tab-container" style="background: transparent; box-shadow: none; border: none;">
                            <div class="pos-tab" role="tabpanel">
                                {{-- Tab Contents - Each partial already has pos-tab-content wrapper --}}
                                @include('business.partials.settings_business')
                                @include('business.partials.settings_tax')
                                @include('business.partials.settings_product')
                                @include('business.partials.settings_contact')
                                @include('business.partials.settings_sales')
                                @include('business.partials.settings_pos')
                                @include('business.partials.settings_purchase')
                                @include('business.partials.settings_payment')
                                @include('business.partials.settings_dashboard')
                                @include('business.partials.settings_system')
                                @include('business.partials.settings_prefixes')
                                @include('business.partials.settings_email')
                                @include('business.partials.settings_sms')
                                @include('business.partials.settings_reward_point')
                                @include('business.partials.settings_modules')
                                @include('business.partials.settings_custom_labels')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            {{-- Modern Submit Section --}}
            <div class="modern-submit-section">
                <div class="text-center">
                    <button 
                        type="submit" 
                        class="modern-submit-btn"
                        id="submit_business_settings"
                        aria-label="@lang('business.update_settings')">
                        <i class="fa fa-save"></i>
                        @lang('business.update_settings')
                    </button>
                </div>
            </div>
        </div>
        
        {!! Form::close() !!}
    </div>
</div>

@stop

@section('javascript')
<script type="text/javascript">
    'use strict';
    
    // Initialize page leave confirmation
    __page_leave_confirmation('#bussiness_edit_form');

    /**
     * Modern Navigation Handler
     * Syncs modern navigation with existing tab system
     */
    $(document).ready(function() {
        // Handle modern navigation clicks
        $('.modern-nav-item').on('click', function(e) {
            e.preventDefault();
            
            var $clickedItem = $(this);
            var tabIndex = parseInt($clickedItem.data('tab-index'));
            
            // Update modern nav active state
            $('.modern-nav-item').removeClass('active').attr('aria-selected', 'false');
            $clickedItem.addClass('active').attr('aria-selected', 'true');
            
            // Sync with existing tab system (for compatibility)
            $('.list-group-item').removeClass('active');
            if ($('.list-group-item').length > 0) {
                $('.list-group-item').eq(tabIndex).addClass('active');
            }
            
            // Show corresponding tab content
            $('.pos-tab-content').removeClass('active');
            $('.pos-tab-content').eq(tabIndex).addClass('active');
            
            // Smooth scroll to top of content area
            $('.modern-content-area').animate({ scrollTop: 0 }, 300);
        });
    });

    /**
     * Email Settings Toggle Handler
     */
    $(document).on('ifToggled', '#use_superadmin_settings', function() {
        var isChecked = $('#use_superadmin_settings').is(':checked');
        
        if (isChecked) {
            $('#toggle_visibility').addClass('hide');
            $('.test_email_btn').addClass('hide');
        } else {
            $('#toggle_visibility').removeClass('hide');
            $('.test_email_btn').removeClass('hide');
        }
    });

    /**
     * Document Ready Handler
     */
    $(document).ready(function() {
        
        /**
         * Email Configuration Test Handler
         */
        $('#test_email_btn').on('click', function(e) {
            e.preventDefault();
            
            var $btn = $(this);
            var originalText = $btn.html();
            
            $btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> @lang("lang_v1.testing")...');
            
            var emailData = {
                mail_driver: $('#mail_driver').val(),
                mail_host: $('#mail_host').val(),
                mail_port: $('#mail_port').val(),
                mail_username: $('#mail_username').val(),
                mail_password: $('#mail_password').val(),
                mail_encryption: $('#mail_encryption').val(),
                mail_from_address: $('#mail_from_address').val(),
                mail_from_name: $('#mail_from_name').val(),
            };
            
            $.ajax({
                method: 'POST',
                data: emailData,
                url: "{{ action([\App\Http\Controllers\BusinessController::class, 'testEmailConfiguration']) }}",
                dataType: 'json',
                success: function(result) {
                    if (result.success === true) {
                        swal({
                            text: result.msg,
                            icon: 'success',
                            timer: 3000,
                            buttons: false
                        });
                    } else {
                        swal({
                            text: result.msg,
                            icon: 'error',
                            timer: 5000
                        });
                    }
                },
                error: function(xhr, status, error) {
                    swal({
                        text: '@lang("lang_v1.error_occurred")',
                        icon: 'error'
                    });
                },
                complete: function() {
                    $btn.prop('disabled', false).html(originalText);
                }
            });
        });

        /**
         * SMS Configuration Test Handler
         */
        $('#test_sms_btn').on('click', function(e) {
            e.preventDefault();
            
            var testNumber = $('#test_number').val();
            
            if (!testNumber || testNumber.trim() === '') {
                toastr.error('{{__("lang_v1.test_number_is_required")}}');
                $('#test_number').focus();
                return false;
            }
            
            var $btn = $(this);
            var originalText = $btn.html();
            
            $btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> @lang("lang_v1.testing")...');
            
            var smsData = {
                url: $('#sms_settings_url').val(),
                send_to_param_name: $('#send_to_param_name').val(),
                msg_param_name: $('#msg_param_name').val(),
                request_method: $('#request_method').val(),
                param_1: $('#sms_settings_param_key1').val(),
                param_2: $('#sms_settings_param_key2').val(),
                param_3: $('#sms_settings_param_key3').val(),
                param_4: $('#sms_settings_param_key4').val(),
                param_5: $('#sms_settings_param_key5').val(),
                param_6: $('#sms_settings_param_key6').val(),
                param_7: $('#sms_settings_param_key7').val(),
                param_8: $('#sms_settings_param_key8').val(),
                param_9: $('#sms_settings_param_key9').val(),
                param_10: $('#sms_settings_param_key10').val(),
                param_val_1: $('#sms_settings_param_val1').val(),
                param_val_2: $('#sms_settings_param_val2').val(),
                param_val_3: $('#sms_settings_param_val3').val(),
                param_val_4: $('#sms_settings_param_val4').val(),
                param_val_5: $('#sms_settings_param_val5').val(),
                param_val_6: $('#sms_settings_param_val6').val(),
                param_val_7: $('#sms_settings_param_val7').val(),
                param_val_8: $('#sms_settings_param_val8').val(),
                param_val_9: $('#sms_settings_param_val9').val(),
                param_val_10: $('#sms_settings_param_val10').val(),
                test_number: testNumber
            };
            
            $.ajax({
                method: 'POST',
                data: smsData,
                url: "{{ action([\App\Http\Controllers\BusinessController::class, 'testSmsConfiguration']) }}",
                dataType: 'json',
                success: function(result) {
                    if (result.success === true) {
                        swal({
                            text: result.msg,
                            icon: 'success',
                            timer: 3000,
                            buttons: false
                        });
                    } else {
                        swal({
                            text: result.msg,
                            icon: 'error',
                            timer: 5000
                        });
                    }
                },
                error: function(xhr, status, error) {
                    swal({
                        text: '@lang("lang_v1.error_occurred")',
                        icon: 'error'
                    });
                },
                complete: function() {
                    $btn.prop('disabled', false).html(originalText);
                }
            });
        });

        /**
         * Custom Labels Product Dropdown Handler
         */
        $('select.custom_labels_products').on('change', function() {
            var selectedValue = $(this).val();
            var $parentDiv = $(this).parents('div.custom_label_product_div');
            var $dropdownDiv = $parentDiv.find('div.custom_label_product_dropdown');
            
            if (selectedValue === 'dropdown') {
                $dropdownDiv.removeClass('hide');
            } else {
                $dropdownDiv.addClass('hide');
            }
        });
        
        /**
         * Form Submit Handler
         */
        $('#bussiness_edit_form').on('submit', function() {
            var $submitBtn = $('#submit_business_settings');
            var originalHtml = $submitBtn.html();
            
            $submitBtn.prop('disabled', true)
                      .html('<i class="fa fa-spinner fa-spin"></i> @lang("lang_v1.saving")...')
                      .css('opacity', '0.8');
            
            setTimeout(function() {
                if (!$submitBtn.closest('form')[0].checkValidity()) {
                    $submitBtn.prop('disabled', false)
                              .html(originalHtml)
                              .css('opacity', '1');
                }
            }, 100);
        });
    });
</script>
@endsection
