@extends('layouts.auth2')
@section('title', __('lang_v1.register'))

@section('content')
    <div class="modern-register-wrapper">
        <!-- Animated Mesh Background -->
        <canvas id="mesh-canvas-register" class="mesh-background"></canvas>
        
        <!-- Floating Geometric Shapes -->
        <div class="floating-geometry">
            <div class="geo-shape geo-1"></div>
            <div class="geo-shape geo-2"></div>
            <div class="geo-shape geo-3"></div>
        </div>

        <!-- Main Container -->
        <div class="modern-register-container">
            <!-- Left Side - Branding -->
            <div class="register-visual-panel">
                <div class="visual-content-register">
                    <!-- Posify Logo -->
                    <div class="posify-logo-container">
                        <div class="posify-logo">
                            <svg class="posify-logo-svg" viewBox="0 0 400 120" xmlns="http://www.w3.org/2000/svg">
                                <text x="50" y="80" font-family="'Poppins', sans-serif" font-size="72" font-weight="900" fill="#FFFFFF" class="posify-text">
                                    P
                                    <tspan x="78" y="80">o</tspan>
                                    <tspan x="120" y="80">s</tspan>
                                    <tspan x="150" y="80">i</tspan>
                                    <tspan x="180" y="80">f</tspan>
                                    <tspan x="210" y="80">y</tspan>
                                </text>
                                <g class="pixelated-o">
                                    <rect x="88" y="30" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="100" y="30" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="112" y="30" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="88" y="42" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="100" y="42" width="10" height="10" fill="#8B5CF6" class="pixel-o main-pixel-o" />
                                    <rect x="112" y="42" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="88" y="54" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="100" y="54" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="112" y="54" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                </g>
                            </svg>
                        </div>
                        <div class="posify-tagline">
                            <span class="tagline-word">Sell</span>
                            <span class="tagline-dot">.</span>
                            <span class="tagline-word">Track</span>
                            <span class="tagline-dot">.</span>
                            <span class="tagline-word">Grow</span>
                        </div>
                    </div>
                    
                    <h1 class="register-title">
                        <span class="title-main">Create Your Account</span>
                    </h1>
                    
                    <p class="register-description">
                        Join thousands of businesses using<br>
                        <span class="highlight-text">POSifyme</span> to manage their operations
                    </p>

                    <div class="register-benefits">
                        <div class="benefit-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Free Setup</span>
                        </div>
                        <div class="benefit-item">
                            <i class="fas fa-check-circle"></i>
                            <span>24/7 Support</span>
                        </div>
                        <div class="benefit-item">
                            <i class="fas fa-check-circle"></i>
                            <span>No Credit Card</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Side - Registration Form -->
            <div class="register-form-panel">
                <div class="register-card-modern">
                    <!-- Decorative Top Gradient -->
                    <div class="card-gradient-top"></div>
                    
                    <div class="register-header-modern">
                        <div class="register-icon">
                            <i class="fas fa-user-plus"></i>
                        </div>
                        <h2 class="register-form-title">Get Started</h2>
                        <p class="register-form-subtitle">@lang('business.register_and_get_started_in_minutes')</p>
                    </div>

                    {!! Form::open(['url' => route('business.postRegister'), 'method' => 'post', 'id' => 'business_register_form', 'files' => true, 'class' => 'register-form-modern']) !!}
                        {!! Form::hidden('package_id', $package_id) !!}
                        {!! Form::hidden('language', request()->lang) !!}
                        
                    @include('business.partials.register_form')
                {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <link rel="stylesheet" href="{{ asset('fonts/google-fonts/inter-poppins-almarai-local.css') }}">
    <style>

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: #FFB600;
            --primary-dark: #E6A500;
            --secondary: #6366F1;
            --success: #10B981;
            --text-primary: #0F172A;
            --text-secondary: #475569;
            --text-light: #94A3B8;
            --bg-primary: #FFFFFF;
            --bg-secondary: #F8FAFC;
            --bg-tertiary: #F1F5F9;
            --border: #E2E8F0;
        }

        body.modern-login-body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: #0A0E27 !important;
            background-color: #0A0E27 !important;
            min-height: 100vh;
            max-height: 100vh;
            overflow: hidden !important;
            overflow-x: hidden !important;
            overflow-y: hidden !important;
        }

        html {
            overflow: hidden !important;
            height: 100%;
        }

        /* Ensure page background elements are consistent */
        body.modern-login-body > *:not(.modern-register-wrapper):not(.register-card-modern) {
            background-color: transparent !important;
        }

        /* Hide any footer elements */
        body.modern-login-body footer,
        body.modern-login-body .footer,
        body.modern-login-body [class*="footer"],
        body.modern-login-body [id*="footer"] {
            display: none !important;
            background: #0A0E27 !important;
            background-color: #0A0E27 !important;
        }

        /* Ensure wrapper has consistent background */
        .modern-register-wrapper {
            background: #0A0E27 !important;
            background-color: #0A0E27 !important;
        }

        /* Ensure container has consistent background */
        .modern-register-container {
            background: transparent !important;
            background-color: transparent !important;
        }

        /* Mesh Background Canvas */
        .mesh-background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
            opacity: 0.2;
            display: none; /* Hide mesh background for single color */
        }

        /* Floating Geometric Shapes */
        .floating-geometry {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
            pointer-events: none;
            overflow: hidden;
            display: none; /* Hide geometric shapes for single color */
        }

        .geo-shape {
            position: absolute;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            opacity: 0.05;
            filter: blur(60px);
            animation: geoFloat 30s infinite ease-in-out;
        }

        .geo-1 {
            width: 400px;
            height: 400px;
            border-radius: 50%;
            top: -200px;
            left: -200px;
        }

        .geo-2 {
            width: 300px;
            height: 300px;
            border-radius: 50%;
            bottom: -150px;
            right: -150px;
            animation-delay: -10s;
        }

        .geo-3 {
            width: 250px;
            height: 250px;
            border-radius: 50%;
            top: 50%;
            right: 10%;
            animation-delay: -20s;
        }

        @keyframes geoFloat {
            0%, 100% {
                transform: translate(0, 0) scale(1);
            }
            50% {
                transform: translate(50px, -50px) scale(1.1);
            }
        }

        /* Main Container */
        .modern-register-wrapper {
            height: 100vh;
            max-height: 100vh;
            display: flex;
            align-items: flex-start;
            justify-content: center;
            padding: 20px;
            padding-top: 100px;
            position: relative;
            z-index: 2;
            overflow-y: auto;
            overflow-x: hidden;
        }

        .modern-register-container {
            width: 100%;
            max-width: 1600px;
            display: grid;
            grid-template-columns: 1fr 4fr;
            gap: 40px;
            align-items: start;
        }

        /* Visual Panel */
        .register-visual-panel {
            display: flex;
            flex-direction: column;
            gap: 40px;
            position: sticky;
            top: 100px;
            width: 100%;
        }

        .visual-content-register {
            text-align: center;
        }

        /* Posify Logo */
        .posify-logo-container {
            margin-bottom: 40px;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 20px;
        }

        .posify-logo-svg {
            width: 100%;
            max-width: 280px;
            height: auto;
            filter: drop-shadow(0 8px 16px rgba(99, 102, 241, 0.3));
        }

        .posify-text {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -2px;
        }

        .pixelated-o {
            animation: pixelatedGlow 3s ease-in-out infinite;
        }

        .pixel-o {
            transition: all 0.3s ease;
            animation: pixelPulse 2s ease-in-out infinite;
        }

        .pixel-o.main-pixel-o {
            animation: mainPixelPulse 2s ease-in-out infinite;
        }

        @keyframes pixelatedGlow {
            0%, 100% {
                filter: drop-shadow(0 8px 16px rgba(99, 102, 241, 0.3));
            }
            50% {
                filter: drop-shadow(0 12px 24px rgba(99, 102, 241, 0.5));
            }
        }

        @keyframes pixelPulse {
            0%, 100% {
                opacity: 1;
                transform: scale(1);
            }
            50% {
                opacity: 0.9;
                transform: scale(1.05);
            }
        }

        @keyframes mainPixelPulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.15);
            }
        }

        .posify-tagline {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-family: 'Inter', sans-serif;
            font-size: 18px;
            font-weight: 500;
            color: rgba(255, 255, 255, 0.9);
            letter-spacing: 1px;
            margin-top: 10px;
        }

        .tagline-word {
            transition: all 0.3s ease;
        }

        .tagline-word:hover {
            color: var(--primary);
            transform: translateY(-2px);
        }

        .tagline-dot {
            color: var(--primary);
            font-weight: 700;
            animation: dotPulse 2s ease-in-out infinite;
        }

        @keyframes dotPulse {
            0%, 100% {
                opacity: 0.6;
                transform: scale(1);
            }
            50% {
                opacity: 1;
                transform: scale(1.2);
            }
        }

        .register-title {
            margin-bottom: 20px;
        }

        .title-main {
            font-family: 'Poppins', sans-serif;
            font-size: 36px;
            font-weight: 800;
            background: linear-gradient(135deg, #FFFFFF 0%, var(--primary) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: -1px;
            display: block;
            line-height: 1.2;
        }

        .register-description {
            font-size: 15px;
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 30px;
            line-height: 1.6;
        }

        .highlight-text {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-weight: 700;
        }

        .register-benefits {
            display: flex;
            flex-direction: column;
            gap: 12px;
            margin-top: 30px;
        }

        .benefit-item {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 14px 20px;
            transition: all 0.3s ease;
        }

        .benefit-item:hover {
            background: rgba(255, 255, 255, 0.15);
            transform: translateX(5px);
            border-color: var(--primary);
        }

        .benefit-item i {
            color: var(--primary);
            font-size: 16px;
        }

        .benefit-item span {
            font-size: 13px;
            font-weight: 500;
            color: rgba(255, 255, 255, 0.95);
        }

        /* Form Panel */
        .register-form-panel {
            display: flex;
            justify-content: flex-start;
            align-items: flex-start;
            width: 100%;
        }

        .register-card-modern {
            width: 100%;
            max-width: 100%;
            background: rgba(255, 255, 255, 0.98) !important;
            backdrop-filter: blur(20px);
            border-radius: 24px;
            padding: 24px;
            box-shadow: 
                0 20px 60px -12px rgba(0, 0, 0, 0.25),
                0 0 0 1px rgba(255, 255, 255, 0.1) inset;
            position: relative;
            overflow: hidden;
        }

        .card-gradient-top {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--primary) 0%, var(--secondary) 50%, var(--primary) 100%);
            background-size: 200% 100%;
            animation: gradientFlow 3s ease infinite;
        }

        @keyframes gradientFlow {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }

        .register-header-modern {
            text-align: center;
            margin-bottom: 20px;
            position: relative;
            z-index: 2;
            padding: 0;
        }

        .register-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            box-shadow: 0 8px 24px rgba(255, 182, 0, 0.3);
            transition: all 0.3s ease;
        }

        .register-icon:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 32px rgba(255, 182, 0, 0.4);
        }

        .register-icon i {
            color: white;
            font-size: 22px;
        }

        .register-form-title {
            font-family: 'Poppins', sans-serif;
            font-size: 24px;
            font-weight: 800;
            color: var(--text-primary);
            margin-bottom: 4px;
            letter-spacing: -0.5px;
        }

        .register-form-subtitle {
            font-size: 13px;
            color: var(--text-secondary);
            font-weight: 400;
            margin-bottom: 16px;
        }

        /* Form Styles */
        .register-form-modern {
            margin-top: 8px;
        }

        .register-form-modern fieldset {
            border: none;
            margin-bottom: 16px;
            padding: 0;
        }

        .register-form-modern legend {
            font-family: 'Poppins', sans-serif;
            font-size: 16px;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 12px;
            padding-bottom: 8px;
            border-bottom: 2px solid var(--border);
            width: 100%;
            position: relative;
        }

        .register-form-modern legend::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 60px;
            height: 2px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border-radius: 2px;
        }

        .register-form-modern h3 {
            font-family: 'Poppins', sans-serif;
            font-size: 16px;
            font-weight: 700;
            color: var(--text-primary);
            margin: 16px 0 12px;
            padding-bottom: 8px;
            border-bottom: 2px solid var(--border);
            position: relative;
        }

        .register-form-modern h3::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 60px;
            height: 2px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border-radius: 2px;
        }

        .register-form-modern .form-group {
            margin-bottom: 14px;
        }

        .register-form-modern label {
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 13px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 6px;
        }

        .register-form-modern .input-group {
            position: relative;
            background: var(--bg-secondary);
            border-radius: 12px;
            overflow: hidden;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }

        .register-form-modern .input-group:hover {
            border-color: var(--border);
        }

        .register-form-modern .input-group:focus-within {
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(255, 182, 0, 0.1);
        }

        .register-form-modern .input-group-addon {
            background: transparent;
            border: none;
            padding: 10px 14px;
            color: var(--primary);
            font-size: 14px;
        }

        .register-form-modern .form-control,
        .register-form-modern select.form-control {
            border: none;
            background: transparent;
            padding: 10px 14px;
            font-size: 14px;
            color: var(--text-primary);
            font-weight: 500;
            width: 100%;
            outline: none;
        }

        .register-form-modern .form-control::placeholder {
            color: var(--text-light);
            font-weight: 400;
        }

        /* Select2 Styling */
        .register-form-modern .select2_register {
            width: 100% !important;
        }

        .register-form-modern select.select2-hidden-accessible {
            position: absolute !important;
            width: 1px !important;
            height: 1px !important;
            padding: 0 !important;
            margin: -1px !important;
            overflow: hidden !important;
            clip: rect(0, 0, 0, 0) !important;
            white-space: nowrap !important;
            border: 0 !important;
            opacity: 0 !important;
            visibility: hidden !important;
        }

        .register-form-modern .select2-container {
            width: 100% !important;
            display: block !important;
        }

        .register-form-modern .select2-container--default .select2-selection--single {
            height: auto !important;
            border: none !important;
            background: transparent !important;
            padding: 0 !important;
        }

        .register-form-modern .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: normal !important;
            padding: 10px 14px !important;
            color: var(--text-primary) !important;
            font-size: 14px !important;
            font-weight: 500 !important;
        }

        .register-form-modern .select2-container--default .select2-selection--single .select2-selection__placeholder {
            color: var(--text-light) !important;
            font-weight: 400 !important;
        }

        .register-form-modern .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 100% !important;
            right: 16px !important;
            top: 50% !important;
            transform: translateY(-50%) !important;
        }

        .register-form-modern .select2-container--default .select2-selection--single .select2-selection__arrow b {
            border-color: var(--text-primary) transparent transparent transparent !important;
            border-width: 6px 6px 0 6px !important;
            margin-top: -3px !important;
        }

        .register-form-modern .select2-container--default .select2-results__option {
            padding: 12px 18px !important;
            font-size: 15px !important;
            color: var(--text-primary) !important;
        }

        .register-form-modern .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background: var(--primary) !important;
            color: white !important;
        }

        .register-form-modern .select2-container--default .select2-results__option[aria-selected=true] {
            background: rgba(255, 182, 0, 0.1) !important;
            color: var(--primary) !important;
        }

        .register-form-modern .select2-dropdown {
            border: 2px solid var(--border) !important;
            border-radius: 16px !important;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15) !important;
            background: white !important;
            margin-top: 4px !important;
        }

        .register-form-modern .select2-search--dropdown .select2-search__field {
            border: 2px solid var(--border) !important;
            border-radius: 12px !important;
            padding: 10px 14px !important;
            font-size: 14px !important;
            margin: 8px !important;
        }

        .register-form-modern .select2-search--dropdown .select2-search__field:focus {
            border-color: var(--primary) !important;
            outline: none !important;
            box-shadow: 0 0 0 3px rgba(255, 182, 0, 0.1) !important;
        }

        .register-form-modern .input-group .select2-container {
            width: 100% !important;
            position: relative !important;
            display: block !important;
        }

        .register-form-modern .form-group .select2-container + .select2-container {
            display: none !important;
        }

        .register-form-modern .col-md-12,
        .register-form-modern .col-md-6,
        .register-form-modern .col-md-4,
        .register-form-modern .col-sm-6 {
            padding-left: 12px;
            padding-right: 12px;
        }

        .register-form-modern .clearfix {
            clear: both;
        }

        /* File Input Styling */
        .register-form-modern input[type="file"] {
            padding: 12px;
            background: var(--bg-secondary);
            border: 2px dashed var(--border);
            border-radius: 12px;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .register-form-modern input[type="file"]:hover {
            border-color: var(--primary);
            background: rgba(255, 182, 0, 0.05);
        }

        /* Checkbox Styling */
        .register-form-modern .input-icheck {
            width: 20px;
            height: 20px;
            accent-color: var(--primary);
            cursor: pointer;
        }

        .register-form-modern .terms_condition {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .register-form-modern .terms_condition:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }

        /* Responsive Design */
        @media (max-width: 1400px) {
            .modern-register-container {
                grid-template-columns: 1fr 4fr;
                gap: 30px;
            }
        }

        @media (max-width: 1200px) {
            .modern-register-container {
                grid-template-columns: 1fr;
                max-width: 900px;
                gap: 40px;
            }

            .register-visual-panel {
                position: relative;
                top: 0;
                text-align: center;
            }

            .title-main {
                font-size: 40px;
            }
        }

        @media (max-width: 768px) {
            .modern-register-wrapper {
                padding: 16px;
                padding-top: 80px;
            }

            .register-card-modern {
                padding: 28px 20px;
                border-radius: 20px;
            }

            .register-form-title {
                font-size: 24px;
            }

            .title-main {
                font-size: 32px;
            }

            .posify-logo-svg {
                max-width: 240px;
            }

            .posify-tagline {
                font-size: 16px;
            }

            .register-benefits {
                flex-direction: row;
                flex-wrap: wrap;
                justify-content: center;
            }

            .register-form-modern .col-md-6,
            .register-form-modern .col-md-4 {
                width: 100%;
                float: none;
            }
        }

        @media (max-width: 480px) {
            .register-card-modern {
                padding: 24px 16px;
                border-radius: 20px;
            }

            .posify-logo-svg {
                max-width: 200px;
            }

            .posify-tagline {
                font-size: 14px;
            }

            .title-main {
                font-size: 28px;
            }
        }
    </style>
@endpush

@push('scripts')
    <script>
        // Mesh Background Animation
        const canvasRegister = document.getElementById('mesh-canvas-register');
        if (canvasRegister) {
            const ctx = canvasRegister.getContext('2d');
            canvasRegister.width = window.innerWidth;
            canvasRegister.height = window.innerHeight;

            let time = 0;
            const points = [];
            const pointCount = 40;

            for (let i = 0; i < pointCount; i++) {
                points.push({
                    x: Math.random() * canvasRegister.width,
                    y: Math.random() * canvasRegister.height,
                    vx: (Math.random() - 0.5) * 0.3,
                    vy: (Math.random() - 0.5) * 0.3,
                });
            }

            function animate() {
                time += 0.01;
                ctx.clearRect(0, 0, canvasRegister.width, canvasRegister.height);

                ctx.strokeStyle = `rgba(255, 182, 0, ${0.1 + Math.sin(time) * 0.05})`;
                ctx.lineWidth = 1;

                for (let i = 0; i < points.length; i++) {
                    points[i].x += points[i].vx;
                    points[i].y += points[i].vy;

                    if (points[i].x < 0 || points[i].x > canvasRegister.width) points[i].vx *= -1;
                    if (points[i].y < 0 || points[i].y > canvasRegister.height) points[i].vy *= -1;

                    for (let j = i + 1; j < points.length; j++) {
                        const dx = points[i].x - points[j].x;
                        const dy = points[i].y - points[j].y;
                        const distance = Math.sqrt(dx * dx + dy * dy);

                        if (distance < 120) {
                            ctx.globalAlpha = (120 - distance) / 120 * 0.3;
                            ctx.beginPath();
                            ctx.moveTo(points[i].x, points[i].y);
                            ctx.lineTo(points[j].x, points[j].y);
                            ctx.stroke();
                        }
                    }
                }

                requestAnimationFrame(animate);
            }

            animate();

            window.addEventListener('resize', () => {
                canvasRegister.width = window.innerWidth;
                canvasRegister.height = window.innerHeight;
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Password toggle functionality
            const passwordInputs = document.querySelectorAll('input[type="password"]');
            passwordInputs.forEach(input => {
                const wrapper = input.closest('.input-group');
                if (wrapper) {
                    const toggleBtn = document.createElement('button');
                    toggleBtn.type = 'button';
                    toggleBtn.className = 'password-toggle-btn';
                    toggleBtn.innerHTML = '<i class="fas fa-eye"></i>';
                    toggleBtn.style.cssText = 'position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; color: var(--text-secondary); cursor: pointer; padding: 8px; z-index: 10;';
                    
                    toggleBtn.addEventListener('click', function() {
                        const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
                        input.setAttribute('type', type);
                        const icon = this.querySelector('i');
                        icon.classList.toggle('fa-eye');
                        icon.classList.toggle('fa-eye-slash');
                    });

                    if (input.name === 'password' || input.name === 'confirm_password') {
                        wrapper.style.position = 'relative';
                        wrapper.appendChild(toggleBtn);
                        input.style.paddingRight = '45px';
                    }
                }
            });
        });
    </script>
@endpush

@section('javascript')
    <script type="text/javascript">
        $(document).ready(function() {
            $('.change_lang').click(function() {
                window.location = "{{ route('business.getRegister') }}?lang=" + $(this).attr('value');
            });

            // Initialize Select2 for registration form - ensure no duplicates
            $('.select2_register').each(function() {
                var $select = $(this);
                
                // Destroy existing Select2 instance if any
                if ($select.data('select2')) {
                    $select.select2('destroy');
                }
                
                // Initialize Select2
                $select.select2({
                    theme: 'default',
                    width: '100%',
                    dropdownAutoWidth: false,
                    minimumResultsForSearch: Infinity
                });
            });
        });
    </script>
@endsection
