@extends('layouts.auth2')
@section('title', __('lang_v1.login'))
@inject('request', 'Illuminate\Http\Request')
@section('content')
    @php
        $username = old('username');
        $password = null;
        if (config('app.env') == 'demo') {
            $username = 'admin';
            $password = '12345678';

            $demo_types = [
                'all_in_one' => 'admin',
                'super_market' => 'admin',
                'pharmacy' => 'admin-pharmacy',
                'electronics' => 'admin-electronics',
                'services' => 'admin-services',
                'restaurant' => 'admin-restaurant',
                'superadmin' => 'superadmin',
                'woocommerce' => 'woocommerce_user',
                'essentials' => 'admin-essentials',
                'manufacturing' => 'manufacturer-demo',
            ];

            if (!empty($_GET['demo_type']) && array_key_exists($_GET['demo_type'], $demo_types)) {
                $username = $demo_types[$_GET['demo_type']];
            }
        }
    @endphp

    <div class="modern-login-wrapper">
        <!-- Animated Mesh Background -->
        <canvas id="mesh-canvas" class="mesh-background"></canvas>
        
        <!-- Floating Geometric Shapes -->
        <div class="floating-geometry">
            <div class="geo-shape geo-1"></div>
            <div class="geo-shape geo-2"></div>
            <div class="geo-shape geo-3"></div>
            <div class="geo-shape geo-4"></div>
            <div class="geo-shape geo-5"></div>
        </div>

        <!-- Main Container -->
        <div class="modern-login-container">
            <!-- Left Side - Visual Branding -->
            <div class="login-visual-panel">
                <div class="visual-content">
                    <!-- Posify Logo -->
                    <div class="posify-logo-container">
                        <div class="posify-logo">
                            <svg class="posify-logo-svg" viewBox="0 0 400 120" xmlns="http://www.w3.org/2000/svg">
                                <!-- Posify Text -->
                                <text x="50" y="80" font-family="'Poppins', sans-serif" font-size="72" font-weight="900" fill="#FFFFFF" class="posify-text">
                                    P
                                    <tspan x="78" y="80">o</tspan>
                                    <tspan x="120" y="80">s</tspan>
                                    <tspan x="150" y="80">i</tspan>
                                    <tspan x="180" y="80">f</tspan>
                                    <tspan x="210" y="80">y</tspan>
                                </text>
                                
                                <!-- Pixelated 'o' with network pattern -->
                                <g class="pixelated-o">
                                    <!-- Main 'o' pixels -->
                                    <rect x="88" y="30" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="100" y="30" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="112" y="30" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="88" y="42" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="100" y="42" width="10" height="10" fill="#8B5CF6" class="pixel-o main-pixel-o" />
                                    <rect x="112" y="42" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="88" y="54" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="100" y="54" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    <rect x="112" y="54" width="10" height="10" fill="#6366F1" class="pixel-o" />
                                    
                                    <!-- Scattered pixels breaking away -->
                                    <rect x="125" y="20" width="8" height="8" fill="#60A5FA" class="scattered-pixel" opacity="0.9" />
                                    <rect x="140" y="15" width="8" height="8" fill="#60A5FA" class="scattered-pixel" opacity="0.8" />
                                    <rect x="155" y="25" width="8" height="8" fill="#60A5FA" class="scattered-pixel" opacity="0.7" />
                                    <rect x="130" y="35" width="6" height="6" fill="#93C5FD" class="scattered-pixel" opacity="0.6" />
                                    <rect x="145" y="30" width="6" height="6" fill="#93C5FD" class="scattered-pixel" opacity="0.6" />
                                    <rect x="160" y="20" width="6" height="6" fill="#93C5FD" class="scattered-pixel" opacity="0.5" />
                                    <rect x="135" y="50" width="5" height="5" fill="#DBEAFE" class="scattered-pixel" opacity="0.4" />
                                    <rect x="150" y="45" width="5" height="5" fill="#DBEAFE" class="scattered-pixel" opacity="0.4" />
                                    
                                    <!-- Connection lines -->
                                    <line x1="105" y1="47" x2="129" y2="24" stroke="#60A5FA" stroke-width="1.5" opacity="0.4" class="network-line" />
                                    <line x1="105" y1="47" x2="144" y2="19" stroke="#60A5FA" stroke-width="1.5" opacity="0.3" class="network-line" />
                                    <line x1="105" y1="47" x2="159" y2="24" stroke="#60A5FA" stroke-width="1.5" opacity="0.3" class="network-line" />
                                    <line x1="129" y1="24" x2="144" y2="19" stroke="#93C5FD" stroke-width="1" opacity="0.3" class="network-line" />
                                    <line x1="144" y1="19" x2="159" y2="24" stroke="#93C5FD" stroke-width="1" opacity="0.3" class="network-line" />
                                    <line x1="134" y1="38" x2="149" y2="33" stroke="#DBEAFE" stroke-width="1" opacity="0.2" class="network-line" />
                                </g>
                            </svg>
        </div>
                        
                        <!-- Tagline -->
                        <div class="posify-tagline">
                            <span class="tagline-word">Sell</span>
                            <span class="tagline-dot">.</span>
                            <span class="tagline-word">Track</span>
                            <span class="tagline-dot">.</span>
                            <span class="tagline-word">Grow</span>
                        </div>
                    </div>
                    
                    <p class="visual-description">
                        Experience the future of<br>
                        <span class="highlight-text">Point of Sale</span> management
                    </p>

                    <div class="feature-cards">
                        <div class="feature-card">
                            <div class="feature-icon">
                                <i class="fas fa-bolt"></i>
                            </div>
                            <span>Lightning Fast</span>
                        </div>
                        <div class="feature-card">
                            <div class="feature-icon">
                                <i class="fas fa-shield-alt"></i>
                            </div>
                            <span>Secure & Safe</span>
                        </div>
                        <div class="feature-card">
                            <div class="feature-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <span>Smart Analytics</span>
                        </div>
                    </div>
                </div>

            @if (config('app.env') == 'demo')
                    <div class="demo-panel-modern">
                        <div class="demo-header-modern">
                            <div class="demo-badge">
                                <i class="fas fa-flask"></i>
                                <span>Demo Mode</span>
                    </div>
                        </div>
                        <div class="demo-content-modern">
                            <div class="demo-category">
                                <h4 class="demo-category-title">
                                    <i class="fas fa-store"></i>
                                    Business Types
                                </h4>
                                <div class="demo-grid-modern">
                                    <button class="demo-btn-modern" data-type="all_in_one" data-username="{{ $demo_types['all_in_one'] }}">
                            <i class="fas fa-star"></i>
                            <span>All In One</span>
                                    </button>
                                    <button class="demo-btn-modern" data-type="pharmacy" data-username="{{ $demo_types['pharmacy'] }}">
                            <i class="fas fa-medkit"></i>
                            <span>Pharmacy</span>
                                    </button>
                                    <button class="demo-btn-modern" data-type="electronics" data-username="{{ $demo_types['electronics'] }}">
                            <i class="fas fa-laptop"></i>
                            <span>Electronics</span>
                                    </button>
                                    <button class="demo-btn-modern" data-type="services" data-username="{{ $demo_types['services'] }}">
                            <i class="fas fa-wrench"></i>
                            <span>Services</span>
                                    </button>
                                    <button class="demo-btn-modern" data-type="restaurant" data-username="{{ $demo_types['restaurant'] }}">
                            <i class="fas fa-utensils"></i>
                            <span>Restaurant</span>
                                    </button>
                                    <button class="demo-btn-modern" data-type="super_market" data-username="{{ $demo_types['super_market'] }}">
                            <i class="fas fa-shopping-cart"></i>
                            <span>Super Market</span>
                                    </button>
                    </div>
                    </div>
                            <div class="demo-category premium-section">
                                <h4 class="demo-category-title premium">
                                    <i class="fas fa-gem"></i>
                                    Premium Modules
                                </h4>
                                <div class="demo-grid-modern">
                                    <button class="demo-btn-modern premium" data-type="superadmin" data-username="{{ $demo_types['superadmin'] }}">
                            <i class="fas fa-university"></i>
                                        <span>SaaS</span>
                                    </button>
                                    <button class="demo-btn-modern premium" data-type="woocommerce" data-username="{{ $demo_types['woocommerce'] }}">
                            <i class="fab fa-wordpress"></i>
                            <span>WooCommerce</span>
                                    </button>
                                    <button class="demo-btn-modern premium" data-type="manufacturing" data-username="{{ $demo_types['manufacturing'] }}">
                            <i class="fas fa-industry"></i>
                            <span>Manufacturing</span>
                                    </button>
                                    <button class="demo-btn-modern premium" data-type="essentials" data-username="{{ $demo_types['essentials'] }}">
                            <i class="fas fa-check-circle"></i>
                                        <span>Essentials</span>
                                    </button>
                                </div>
                            </div>
                    </div>
                </div>
            @endif
            </div>

            <!-- Right Side - Login Form -->
            <div class="login-form-panel">
                <div class="form-card-modern">
                    <div class="card-decoration"></div>
                    
                    <div class="form-header-modern">
                        <div class="header-icon">
                            <div class="logo-mark-container">
                                <svg class="logo-mark-svg" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                                    <!-- Pixelated Network Pattern -->
                                    <defs>
                                        <linearGradient id="pixelGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                                            <stop offset="0%" style="stop-color:#6366F1;stop-opacity:1" />
                                            <stop offset="100%" style="stop-color:#8B5CF6;stop-opacity:1" />
                                        </linearGradient>
                                    </defs>
                                    
                                    <!-- Connected Network Pixels -->
                                    <g class="network-pixels">
                                        <!-- Main cluster -->
                                        <rect x="35" y="35" width="8" height="8" fill="#6366F1" class="pixel" />
                                        <rect x="45" y="35" width="8" height="8" fill="#6366F1" class="pixel" />
                                        <rect x="55" y="35" width="8" height="8" fill="#6366F1" class="pixel" />
                                        <rect x="35" y="45" width="8" height="8" fill="#6366F1" class="pixel" />
                                        <rect x="45" y="45" width="8" height="8" fill="url(#pixelGradient)" class="pixel main-pixel" />
                                        <rect x="55" y="45" width="8" height="8" fill="#6366F1" class="pixel" />
                                        <rect x="35" y="55" width="8" height="8" fill="#6366F1" class="pixel" />
                                        <rect x="45" y="55" width="8" height="8" fill="#6366F1" class="pixel" />
                                        <rect x="55" y="55" width="8" height="8" fill="#6366F1" class="pixel" />
                                        
                                        <!-- Scattered pixels -->
                                        <rect x="25" y="25" width="6" height="6" fill="#8B5CF6" class="pixel scattered" opacity="0.8" />
                                        <rect x="65" y="25" width="6" height="6" fill="#8B5CF6" class="pixel scattered" opacity="0.8" />
                                        <rect x="25" y="65" width="6" height="6" fill="#8B5CF6" class="pixel scattered" opacity="0.8" />
                                        <rect x="65" y="65" width="6" height="6" fill="#8B5CF6" class="pixel scattered" opacity="0.8" />
                                        <rect x="20" y="40" width="5" height="5" fill="#8B5CF6" class="pixel scattered" opacity="0.6" />
                                        <rect x="70" y="50" width="5" height="5" fill="#8B5CF6" class="pixel scattered" opacity="0.6" />
                                        <rect x="50" y="20" width="5" height="5" fill="#8B5CF6" class="pixel scattered" opacity="0.6" />
                                        <rect x="40" y="70" width="5" height="5" fill="#8B5CF6" class="pixel scattered" opacity="0.6" />
                                        
                                        <!-- Connection lines -->
                                        <line x1="39" y1="39" x2="25" y2="28" stroke="#6366F1" stroke-width="1.5" opacity="0.4" class="connection-line" />
                                        <line x1="61" y1="39" x2="68" y2="28" stroke="#6366F1" stroke-width="1.5" opacity="0.4" class="connection-line" />
                                        <line x1="39" y1="61" x2="28" y2="68" stroke="#6366F1" stroke-width="1.5" opacity="0.4" class="connection-line" />
                                        <line x1="61" y1="61" x2="68" y2="68" stroke="#6366F1" stroke-width="1.5" opacity="0.4" class="connection-line" />
                                        <line x1="49" y1="49" x2="50" y2="23" stroke="#8B5CF6" stroke-width="1" opacity="0.3" class="connection-line" />
                                        <line x1="49" y1="49" x2="72" y2="52" stroke="#8B5CF6" stroke-width="1" opacity="0.3" class="connection-line" />
                                        <line x1="49" y1="49" x2="22" y2="42" stroke="#8B5CF6" stroke-width="1" opacity="0.3" class="connection-line" />
                                        <line x1="49" y1="49" x2="42" y2="72" stroke="#8B5CF6" stroke-width="1" opacity="0.3" class="connection-line" />
                                    </g>
                            </svg>
                        </div>
                        </div>
                        <h2 class="form-title-modern">Welcome Back</h2>
                        <p class="form-subtitle-modern">Sign in to your account</p>
                    </div>

                    <form method="POST" action="{{ route('login') }}" id="login-form-modern" class="login-form-modern">
                        {{ csrf_field() }}
                        
                        <!-- Username Field -->
                        <div class="input-modern-wrapper">
                            <div class="input-label-modern">
                                <i class="fas fa-user input-label-icon"></i>
                                <span>Username</span>
                            </div>
                            <div class="input-field-modern-container {{ $errors->has('username') ? 'has-error' : '' }}">
                                <div class="input-field-modern-wrapper">
                                    <input 
                                        type="text" 
                                       name="username" 
                                        class="input-modern"
                                        placeholder="Enter username"
                                        value="{{ $username }}"
                                        required
                                        autofocus
                                        autocomplete="username">
                                    <div class="input-line"></div>
                                    <div class="input-glow"></div>
                                    <div class="input-focus-ring"></div>
                                </div>
                            </div>
                            @if ($errors->has('username'))
                                <div class="error-modern">
                                    <i class="fas fa-exclamation-circle"></i>
                                    <span>{{ $errors->first('username') }}</span>
                                </div>
                            @endif
                        </div>

                        <!-- Password Field -->
                        <div class="input-modern-wrapper">
                            <div class="input-label-modern">
                                <i class="fas fa-lock input-label-icon"></i>
                                <span>Password</span>
                            </div>
                            <div class="input-field-modern-container password-modern-container {{ $errors->has('password') ? 'has-error' : '' }}">
                                <div class="input-field-modern-wrapper">
                                    <input 
                                        type="password" 
                                       name="password" 
                                        class="input-modern"
                                        placeholder="Enter password"
                                        value="{{ $password }}"
                                        required
                                        autocomplete="current-password">
                                    <div class="input-line"></div>
                                    <div class="input-glow"></div>
                                    <div class="input-focus-ring"></div>
                                    <button type="button" class="password-toggle-modern" aria-label="Toggle password">
                                    <i class="fas fa-eye"></i>
                                </button>
                                </div>
                            </div>
                            @if ($errors->has('password'))
                                <div class="error-modern">
                                    <i class="fas fa-exclamation-circle"></i>
                                    <span>{{ $errors->first('password') }}</span>
                                </div>
                            @endif
                        </div>

                        <!-- Options -->
                        <div class="form-options-modern">
                            <label class="checkbox-modern-label">
                                <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}>
                                <span class="checkbox-modern-custom">
                                    <i class="fas fa-check"></i>
                                </span>
                                <span class="checkbox-modern-text">Remember me</span>
                            </label>
                            @if(config('app.env') != 'demo')
                                <a href="{{ route('password.request') }}" class="forgot-link-modern">
                                    Forgot Password?
                                </a>
                            @endif
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="submit-btn-modern">
                            <span class="btn-text-modern">Sign In</span>
                            <span class="btn-icon-modern">
                                <i class="fas fa-arrow-right"></i>
                            </span>
                            <div class="btn-loader-modern">
                                <div class="loader-spinner"></div>
                            </div>
                            <div class="btn-shine"></div>
                            <div class="btn-ripple-modern"></div>
                        </button>

                        <!-- Register Link -->
                        @if(config('constants.allow_registration'))
                            <div class="register-modern">
                                <span>New to POSifyme?</span>
                                <a href="{{ route('business.getRegister') }}" class="register-link-modern">
                                    Create Account
                                    <i class="fas fa-arrow-right"></i>
                                </a>
                            </div>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>

    <link rel="stylesheet" href="{{ asset('fonts/google-fonts/inter-poppins-almarai-local.css') }}">
    <style>

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: #FFB600;
            --primary-dark: #E6A500;
            --primary-light: #FFD54F;
            --secondary: #6366F1;
            --secondary-dark: #4F46E5;
            --accent: #8B5CF6;
            --accent-dark: #7C3AED;
            --success: #10B981;
            --error: #EF4444;
            --warning: #F59E0B;
            --text-primary: #0F172A;
            --text-secondary: #475569;
            --text-light: #94A3B8;
            --bg-primary: #FFFFFF;
            --bg-secondary: #F8FAFC;
            --bg-tertiary: #F1F5F9;
            --border: #E2E8F0;
            --shadow-xs: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px -1px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -4px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
            --shadow-2xl: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            --shadow-glow: 0 0 20px rgba(255, 182, 0, 0.3);
        }

        body.modern-login-body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: #0A0E27 !important;
            min-height: 100vh;
            overflow-x: hidden;
            position: relative;
        }

        /* Ensure body background matches */
        body.modern-login-body,
        html {
            background: #0A0E27 !important;
            background-color: #0A0E27 !important;
        }

        /* Mesh Background Canvas */
        .mesh-background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
            opacity: 0.4;
        }

        /* Floating Geometric Shapes */
        .floating-geometry {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
            pointer-events: none;
            overflow: hidden;
        }

        .geo-shape {
            position: absolute;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            opacity: 0.1;
            filter: blur(40px);
            animation: geoFloat 25s infinite ease-in-out;
        }

        .geo-1 {
            width: 400px;
            height: 400px;
            border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            top: -200px;
            left: -200px;
            animation-delay: 0s;
        }

        .geo-2 {
            width: 300px;
            height: 300px;
            border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            bottom: -150px;
            right: -150px;
            animation-delay: -5s;
        }

        .geo-3 {
            width: 250px;
            height: 250px;
            border-radius: 50% 50% 50% 50% / 60% 60% 40% 40%;
            top: 50%;
            right: 10%;
            animation-delay: -10s;
        }

        .geo-4 {
            width: 200px;
            height: 200px;
            border-radius: 40% 60% 60% 40% / 40% 40% 60% 60%;
            bottom: 20%;
            left: 5%;
            animation-delay: -15s;
        }

        .geo-5 {
            width: 350px;
            height: 350px;
            border-radius: 70% 30% 30% 70% / 70% 70% 30% 30%;
            top: 10%;
            left: 50%;
            animation-delay: -20s;
        }

        @keyframes geoFloat {
            0%, 100% { 
                transform: translate(0, 0) rotate(0deg) scale(1);
            }
            25% {
                transform: translate(50px, -50px) rotate(90deg) scale(1.1);
            }
            50% {
                transform: translate(-30px, 30px) rotate(180deg) scale(0.9);
            }
            75% {
                transform: translate(30px, 50px) rotate(270deg) scale(1.05);
            }
        }

        /* Main Container */
        .modern-login-wrapper {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            padding-top: 80px; /* Space for fixed header */
            position: relative;
            z-index: 2;
            background: transparent;
        }

        .modern-login-container {
            width: 100%;
            max-width: 1600px;
            display: grid;
            grid-template-columns: 1.2fr 1fr;
            gap: 60px;
            align-items: center;
        }

        /* Visual Panel */
        .login-visual-panel {
            display: flex;
            flex-direction: column;
            gap: 40px;
        }

        .visual-content {
            text-align: center;
        }

        /* Posify Logo Styles */
        .posify-logo-container {
            margin-bottom: 40px;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 20px;
        }

        .posify-logo {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .posify-logo-svg {
            width: 100%;
            max-width: 320px;
            height: auto;
            filter: drop-shadow(0 8px 16px rgba(99, 102, 241, 0.3));
        }

        .posify-text {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -2px;
        }

        .pixelated-o {
            animation: pixelatedGlow 3s ease-in-out infinite;
        }

        .pixel-o {
            transition: all 0.3s ease;
            animation: pixelPulse 2s ease-in-out infinite;
        }

        .pixel-o.main-pixel-o {
            animation: mainPixelPulse 2s ease-in-out infinite;
            filter: brightness(1.2);
        }

        .scattered-pixel {
            animation: scatteredFloat 4s ease-in-out infinite;
        }

        .scattered-pixel:nth-child(11) { animation-delay: 0s; }
        .scattered-pixel:nth-child(12) { animation-delay: -0.5s; }
        .scattered-pixel:nth-child(13) { animation-delay: -1s; }
        .scattered-pixel:nth-child(14) { animation-delay: -1.5s; }
        .scattered-pixel:nth-child(15) { animation-delay: -2s; }
        .scattered-pixel:nth-child(16) { animation-delay: -2.5s; }
        .scattered-pixel:nth-child(17) { animation-delay: -3s; }
        .scattered-pixel:nth-child(18) { animation-delay: -3.5s; }

        .network-line {
            animation: lineFlow 3s ease-in-out infinite;
            stroke-dasharray: 4, 4;
        }

        @keyframes pixelatedGlow {
            0%, 100% { 
                filter: drop-shadow(0 8px 16px rgba(99, 102, 241, 0.3));
            }
            50% { 
                filter: drop-shadow(0 12px 24px rgba(99, 102, 241, 0.5));
            }
        }

        @keyframes pixelPulse {
            0%, 100% {
                opacity: 1;
                transform: scale(1);
            }
            50% {
                opacity: 0.9;
                transform: scale(1.05);
            }
        }

        @keyframes mainPixelPulse {
            0%, 100% {
                transform: scale(1);
                filter: brightness(1.2);
            }
            50% {
                transform: scale(1.15);
                filter: brightness(1.5);
            }
        }

        @keyframes scatteredFloat {
            0%, 100% {
                transform: translate(0, 0);
                opacity: 0.6;
            }
            25% {
                transform: translate(3px, -3px);
                opacity: 0.9;
            }
            50% {
                transform: translate(-2px, 2px);
                opacity: 0.7;
            }
            75% {
                transform: translate(2px, 3px);
                opacity: 0.8;
            }
        }

        @keyframes lineFlow {
            0%, 100% {
                opacity: 0.3;
                stroke-dashoffset: 0;
            }
            50% {
                opacity: 0.6;
                stroke-dashoffset: 8;
            }
        }

        .posify-tagline {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-family: 'Inter', sans-serif;
            font-size: 18px;
            font-weight: 500;
            color: rgba(255, 255, 255, 0.8);
            letter-spacing: 1px;
            margin-top: 10px;
        }

        .tagline-word {
            transition: all 0.3s ease;
            position: relative;
        }

        .tagline-word:hover {
            color: var(--primary);
            transform: translateY(-2px);
        }

        .tagline-dot {
            color: var(--primary);
            font-weight: 700;
            animation: dotPulse 2s ease-in-out infinite;
        }

        .tagline-dot:nth-child(2) {
            animation-delay: 0s;
        }

        .tagline-dot:nth-child(4) {
            animation-delay: -1s;
        }

        @keyframes dotPulse {
            0%, 100% {
                opacity: 0.6;
                transform: scale(1);
            }
            50% {
                opacity: 1;
                transform: scale(1.2);
            }
        }

        .logo-container-modern {
            position: relative;
            width: 140px;
            height: 140px;
            margin: 0 auto 40px;
        }

        .logo-ring {
            position: absolute;
            top: -20px;
            left: -20px;
            right: -20px;
            bottom: -20px;
            border: 3px solid var(--primary);
            border-radius: 50%;
            opacity: 0.3;
            animation: ringRotate 10s linear infinite;
        }

        .logo-ring::before {
            content: '';
            position: absolute;
            top: -3px;
            left: 50%;
            width: 20px;
            height: 20px;
            background: var(--primary);
            border-radius: 50%;
            transform: translateX(-50%);
            box-shadow: 0 0 20px var(--primary);
        }

        @keyframes ringRotate {
            from {
                transform: rotate(0deg);
            }
            to {
                transform: rotate(360deg);
            }
        }

        .logo-core {
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0.05));
            backdrop-filter: blur(30px);
            border-radius: 35px;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid rgba(255, 255, 255, 0.2);
            box-shadow: 
                0 20px 60px rgba(0, 0, 0, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.3);
            position: relative;
            z-index: 2;
        }

        .logo-image-modern {
            width: 80px;
            height: 80px;
            object-fit: contain;
            filter: drop-shadow(0 8px 16px rgba(0, 0, 0, 0.3));
        }

        .logo-particles {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 1;
        }

        .logo-particles .particle {
            position: absolute;
            width: 6px;
            height: 6px;
            background: var(--primary);
            border-radius: 50%;
            box-shadow: 0 0 10px var(--primary);
            animation: particleOrbit 8s linear infinite;
        }

        .logo-particles .particle:nth-child(1) {
            top: 10%;
            left: 50%;
            animation-delay: 0s;
        }

        .logo-particles .particle:nth-child(2) {
            top: 50%;
            right: 10%;
            animation-delay: -2.67s;
        }

        .logo-particles .particle:nth-child(3) {
            bottom: 10%;
            left: 50%;
            animation-delay: -5.33s;
        }

        @keyframes particleOrbit {
            from {
                transform: rotate(0deg) translateX(80px) rotate(0deg);
            }
            to {
                transform: rotate(360deg) translateX(80px) rotate(-360deg);
            }
        }

        .visual-title {
            position: relative;
            margin-bottom: 20px;
        }

        .title-word {
            font-family: 'Poppins', sans-serif;
            font-size: 64px;
            font-weight: 900;
            background: linear-gradient(135deg, #FFFFFF 0%, var(--primary) 50%, var(--secondary) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: -2px;
            display: block;
            position: relative;
            z-index: 2;
        }

        /* Responsive adjustments for Posify logo */
        @media (max-width: 1400px) {
            .posify-logo-svg {
                max-width: 280px;
            }

            .posify-tagline {
                font-size: 16px;
            }
        }

        @media (max-width: 768px) {
            .posify-logo-svg {
                max-width: 240px;
            }

            .posify-tagline {
                font-size: 14px;
                gap: 6px;
            }
        }

        @media (max-width: 480px) {
            .posify-logo-svg {
                max-width: 200px;
            }

            .posify-tagline {
                font-size: 12px;
            }
        }

        .title-glow {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 200px;
            height: 200px;
            background: radial-gradient(circle, var(--primary) 0%, transparent 70%);
            opacity: 0.3;
            filter: blur(40px);
            animation: titleGlow 3s ease-in-out infinite;
            z-index: 1;
        }

        @keyframes titleGlow {
            0%, 100% {
                opacity: 0.3;
                transform: translate(-50%, -50%) scale(1);
            }
            50% {
                opacity: 0.5;
                transform: translate(-50%, -50%) scale(1.2);
            }
        }

        .visual-description {
            font-size: 18px;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 40px;
            line-height: 1.6;
        }

        .highlight-text {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-weight: 700;
        }

        .feature-cards {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 40px;
        }

        .feature-card {
            background: rgba(255, 255, 255, 0.08);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            padding: 16px 20px;
            display: flex;
            align-items: center;
            gap: 12px;
            transition: all 0.3s ease;
        }

        .feature-card:hover {
            transform: translateY(-4px);
            background: rgba(255, 255, 255, 0.12);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
        }

        .feature-icon {
            width: 36px;
            height: 36px;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 12px rgba(255, 182, 0, 0.3);
        }

        .feature-icon i {
            color: white;
            font-size: 16px;
        }

        .feature-card span {
            font-size: 14px;
            font-weight: 600;
            color: rgba(255, 255, 255, 0.9);
        }

        /* Demo Panel Modern */
        .demo-panel-modern {
            background: rgba(255, 255, 255, 0.06);
            backdrop-filter: blur(30px);
            border-radius: 24px;
            padding: 24px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
        }

        .demo-header-modern {
            margin-bottom: 20px;
        }

        .demo-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
            color: white;
            box-shadow: 0 4px 12px rgba(255, 182, 0, 0.3);
        }

        .demo-badge i {
            font-size: 14px;
        }

        .demo-content-modern {
            display: flex;
            flex-direction: column;
            gap: 24px;
        }

        .demo-category-title {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 14px;
            font-weight: 700;
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .demo-category-title i {
            color: var(--primary);
        }

        .demo-category-title.premium i {
            color: #FFD700;
        }

        .demo-grid-modern {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
        }

        .demo-btn-modern {
            background: rgba(255, 255, 255, 0.08);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 14px;
            padding: 14px;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .demo-btn-modern::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            transition: left 0.5s;
        }

        .demo-btn-modern:hover::before {
            left: 100%;
        }

        .demo-btn-modern:hover {
            transform: translateY(-3px) scale(1.02);
            border-color: var(--primary);
            box-shadow: 0 8px 20px rgba(255, 182, 0, 0.2);
        }

        .demo-btn-modern.premium {
            background: rgba(255, 215, 0, 0.1);
            border-color: rgba(255, 215, 0, 0.3);
        }

        .demo-btn-modern.premium:hover {
            border-color: #FFD700;
            box-shadow: 0 8px 20px rgba(255, 215, 0, 0.3);
        }

        .demo-btn-modern i {
            font-size: 22px;
            color: var(--primary);
            transition: transform 0.3s ease;
        }

        .demo-btn-modern.premium i {
            color: #FFD700;
        }

        .demo-btn-modern:hover i {
            transform: scale(1.2) rotate(5deg);
        }

        .demo-btn-modern span {
            font-size: 11px;
            font-weight: 600;
            color: rgba(255, 255, 255, 0.8);
        }

        /* Form Panel */
        .login-form-panel {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .form-card-modern {
            width: 100%;
            max-width: 520px;
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(40px);
            border-radius: 32px;
            padding: 48px;
            box-shadow: 
                0 25px 50px -12px rgba(0, 0, 0, 0.25),
                0 0 0 1px rgba(255, 255, 255, 0.2) inset;
            position: relative;
            overflow: hidden;
        }

        .card-decoration {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--primary), var(--secondary), var(--accent), var(--primary));
            background-size: 200% 100%;
            animation: decorationFlow 3s linear infinite;
        }

        @keyframes decorationFlow {
            0% {
                background-position: 0% 50%;
            }
            100% {
                background-position: 200% 50%;
            }
        }

        .form-header-modern {
            text-align: center;
            margin-bottom: 40px;
        }

        .header-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.1), rgba(255, 255, 255, 0.05));
            backdrop-filter: blur(20px);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            box-shadow: 
                0 8px 32px rgba(0, 0, 0, 0.1),
                inset 0 1px 0 rgba(255, 255, 255, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.1);
            position: relative;
            overflow: visible;
            animation: iconPulse 3s ease-in-out infinite;
        }

        @keyframes iconPulse {
            0%, 100% {
                transform: scale(1);
                box-shadow: 
                    0 8px 32px rgba(0, 0, 0, 0.1),
                    inset 0 1px 0 rgba(255, 255, 255, 0.2),
                    0 0 20px rgba(99, 102, 241, 0.3);
            }
            50% {
                transform: scale(1.05);
                box-shadow: 
                    0 12px 40px rgba(0, 0, 0, 0.15),
                    inset 0 1px 0 rgba(255, 255, 255, 0.3),
                    0 0 30px rgba(99, 102, 241, 0.5);
            }
        }

        .logo-mark-container {
            width: 100%;
            height: 100%;
            display: flex;
                align-items: center;
            justify-content: center;
            position: relative;
        }

        .logo-mark-svg {
            width: 60px;
            height: 60px;
            filter: drop-shadow(0 4px 8px rgba(99, 102, 241, 0.3));
        }

        .logo-mark-svg .pixel {
            transition: all 0.3s ease;
            animation: pixelGlow 2s ease-in-out infinite;
        }

        .logo-mark-svg .pixel.main-pixel {
            animation: mainPixelPulse 2s ease-in-out infinite;
        }

        .logo-mark-svg .pixel.scattered {
            animation: scatteredFloat 3s ease-in-out infinite;
        }

        .logo-mark-svg .pixel.scattered:nth-child(10) {
            animation-delay: 0s;
        }

        .logo-mark-svg .pixel.scattered:nth-child(11) {
            animation-delay: -0.5s;
        }

        .logo-mark-svg .pixel.scattered:nth-child(12) {
            animation-delay: -1s;
        }

        .logo-mark-svg .pixel.scattered:nth-child(13) {
            animation-delay: -1.5s;
        }

        .logo-mark-svg .pixel.scattered:nth-child(14) {
            animation-delay: -2s;
        }

        .logo-mark-svg .pixel.scattered:nth-child(15) {
            animation-delay: -2.5s;
        }

        .logo-mark-svg .pixel.scattered:nth-child(16) {
            animation-delay: -3s;
        }

        .logo-mark-svg .pixel.scattered:nth-child(17) {
            animation-delay: -3.5s;
        }

        .logo-mark-svg .connection-line {
            animation: linePulse 2s ease-in-out infinite;
            stroke-dasharray: 5, 5;
        }

        @keyframes pixelGlow {
            0%, 100% {
                opacity: 1;
                filter: brightness(1);
            }
            50% {
                opacity: 0.8;
                filter: brightness(1.2);
            }
        }

        @keyframes mainPixelPulse {
            0%, 100% {
                transform: scale(1);
                filter: brightness(1);
            }
            50% {
                transform: scale(1.1);
                filter: brightness(1.4);
            }
        }

        @keyframes scatteredFloat {
            0%, 100% {
                transform: translate(0, 0);
                opacity: 0.6;
            }
            25% {
                transform: translate(2px, -2px);
                opacity: 0.8;
            }
            50% {
                transform: translate(-1px, 1px);
                opacity: 0.7;
            }
            75% {
                transform: translate(1px, 2px);
                opacity: 0.8;
            }
        }

        @keyframes linePulse {
            0%, 100% {
                opacity: 0.3;
                stroke-dashoffset: 0;
            }
            50% {
                opacity: 0.6;
                stroke-dashoffset: 10;
            }
        }

        .header-icon:hover .logo-mark-svg .pixel {
            animation-duration: 1s;
        }

        .header-icon:hover .logo-mark-svg .pixel.main-pixel {
            filter: brightness(1.5);
        }

        .header-icon:hover .logo-mark-svg .connection-line {
            opacity: 0.6;
            stroke-width: 2;
        }

        .form-title-modern {
            font-family: 'Poppins', sans-serif;
            font-size: 32px;
            font-weight: 800;
            color: var(--text-primary);
            margin-bottom: 8px;
            letter-spacing: -0.5px;
        }

        .form-subtitle-modern {
            font-size: 15px;
            color: var(--text-secondary);
            font-weight: 400;
        }

        /* Input Styles Modern */
        .input-modern-wrapper {
            margin-bottom: 28px;
        }

        .input-label-modern {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 10px;
        }

        .input-label-icon {
            color: var(--primary);
            font-size: 14px;
        }

        .input-field-modern-container {
            position: relative;
        }

        .input-field-modern-wrapper {
            position: relative;
            background: var(--bg-secondary);
            border-radius: 18px;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .input-field-modern-wrapper::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            border: 2px solid transparent;
            border-radius: 18px;
            transition: all 0.3s ease;
            pointer-events: none;
            z-index: 1;
        }

        .input-field-modern-container:focus-within .input-field-modern-wrapper::before {
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(255, 182, 0, 0.1);
        }

        .input-field-modern-container.has-error .input-field-modern-wrapper::before {
            border-color: var(--error);
            box-shadow: 0 0 0 4px rgba(239, 68, 68, 0.1);
        }

        .input-modern {
            width: 100%;
            padding: 18px 22px;
            background: transparent;
            border: none;
            font-size: 15px;
            color: var(--text-primary);
            outline: none;
            position: relative;
            z-index: 2;
            font-weight: 500;
        }

        .input-modern::placeholder {
            color: var(--text-light);
            font-weight: 400;
        }

        .input-line {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            transition: width 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 3;
        }

        .input-field-modern-container:focus-within .input-line {
            width: 100%;
        }

        .input-glow {
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 182, 0, 0.1), transparent);
            transition: left 0.6s ease;
            z-index: 1;
        }

        .input-field-modern-container:focus-within .input-glow {
            left: 100%;
        }

        .input-focus-ring {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0);
            width: 100%;
            height: 100%;
            border-radius: 18px;
            background: radial-gradient(circle, rgba(255, 182, 0, 0.1) 0%, transparent 70%);
            transition: transform 0.4s ease;
            pointer-events: none;
            z-index: 0;
        }

        .input-field-modern-container:focus-within .input-focus-ring {
            transform: translate(-50%, -50%) scale(1.2);
        }

        .password-modern-container .input-modern {
            padding-right: 55px;
        }

        .password-toggle-modern {
            position: absolute;
            right: 14px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--text-secondary);
            cursor: pointer;
            padding: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 3;
            transition: all 0.3s ease;
            border-radius: 10px;
        }

        .password-toggle-modern:hover {
            color: var(--primary);
            background: rgba(255, 182, 0, 0.1);
        }

        .error-modern {
            display: flex;
            align-items: center;
            gap: 8px;
            color: var(--error);
            font-size: 13px;
            margin-top: 8px;
            font-weight: 500;
        }

        .error-modern i {
            font-size: 14px;
        }

        /* Form Options */
        .form-options-modern {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 32px;
        }

        .checkbox-modern-label {
            display: flex;
            align-items: center;
            gap: 12px;
            cursor: pointer;
        }

        .checkbox-modern-label input[type="checkbox"] {
            display: none;
        }

        .checkbox-modern-custom {
            width: 22px;
            height: 22px;
            border: 2px solid var(--border);
            border-radius: 7px;
            background: var(--bg-primary);
            position: relative;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .checkbox-modern-custom i {
            color: white;
            font-size: 12px;
            opacity: 0;
            transform: scale(0);
            transition: all 0.2s ease;
        }

        .checkbox-modern-label input[type="checkbox"]:checked + .checkbox-modern-custom {
            background: var(--primary);
            border-color: var(--primary);
        }

        .checkbox-modern-label input[type="checkbox"]:checked + .checkbox-modern-custom i {
            opacity: 1;
            transform: scale(1);
        }

        .checkbox-modern-text {
            font-size: 14px;
            color: var(--text-secondary);
            font-weight: 500;
        }

        .forgot-link-modern {
            font-size: 14px;
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .forgot-link-modern:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }

        /* Submit Button Modern */
        .submit-btn-modern {
            width: 100%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            border: none;
            border-radius: 18px;
            padding: 20px 28px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 8px 24px rgba(255, 182, 0, 0.3);
            margin-bottom: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }

        .submit-btn-modern:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 32px rgba(255, 182, 0, 0.4);
        }

        .submit-btn-modern:active {
            transform: translateY(-1px);
        }

        .btn-text-modern {
            position: relative;
            z-index: 2;
            transition: transform 0.3s ease;
        }

        .btn-icon-modern {
            position: relative;
            z-index: 2;
            transition: transform 0.3s ease;
        }

        .submit-btn-modern:hover .btn-icon-modern {
            transform: translateX(6px);
        }

        .btn-loader-modern {
            display: none;
            align-items: center;
            justify-content: center;
            gap: 10px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 3;
        }

        .loader-spinner {
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        .submit-btn-modern.loading .btn-text-modern,
        .submit-btn-modern.loading .btn-icon-modern {
                opacity: 0;
            transform: translateY(-10px);
        }

        .submit-btn-modern.loading .btn-loader-modern {
            display: flex;
        }

        .btn-shine {
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transform: rotate(45deg);
            transition: left 0.6s ease;
        }

        .submit-btn-modern:hover .btn-shine {
            left: 100%;
        }

        .btn-ripple-modern {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.6);
            transform: scale(0);
            pointer-events: none;
        }

        /* Register */
        .register-modern {
            text-align: center;
            font-size: 14px;
            color: var(--text-secondary);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
        }

        .register-link-modern {
            color: var(--primary);
            text-decoration: none;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 6px;
            transition: all 0.3s ease;
        }

        .register-link-modern:hover {
            color: var(--primary-dark);
            gap: 10px;
        }

        .register-link-modern i {
            font-size: 12px;
            transition: transform 0.3s ease;
        }

        .register-link-modern:hover i {
            transform: translateX(4px);
        }

        /* Responsive Design */
        @media (max-width: 1400px) {
            .modern-login-container {
                grid-template-columns: 1fr;
                max-width: 600px;
                gap: 40px;
            }

            .login-visual-panel {
                text-align: center;
            }

            .title-word {
                font-size: 48px;
            }
        }

        @media (max-width: 768px) {
            .modern-login-wrapper {
                padding: 16px;
            }

            .form-card-modern {
                padding: 36px 28px;
                border-radius: 24px;
            }

            .form-title-modern {
                font-size: 28px;
            }

            .demo-grid-modern {
                grid-template-columns: repeat(2, 1fr);
            }

            .form-options-modern {
                flex-direction: column;
                align-items: flex-start;
                gap: 16px;
            }

            .title-word {
                font-size: 40px;
            }

            .logo-container-modern {
                width: 120px;
                height: 120px;
            }

            .logo-image-modern {
                width: 70px;
                height: 70px;
            }

            .feature-cards {
                flex-direction: column;
                gap: 12px;
            }
        }

        @media (max-width: 480px) {
            .form-card-modern {
                padding: 28px 20px;
                border-radius: 20px;
            }

            .demo-grid-modern {
                grid-template-columns: repeat(2, 1fr);
                gap: 8px;
            }

            .demo-btn-modern {
                padding: 12px;
            }

            .demo-btn-modern i {
                font-size: 20px;
            }

            .demo-btn-modern span {
                font-size: 10px;
            }
        }
    </style>

    <script>
        // Mesh Background Animation
        const canvas = document.getElementById('mesh-canvas');
        if (canvas) {
            const ctx = canvas.getContext('2d');
            canvas.width = window.innerWidth;
            canvas.height = window.innerHeight;

            let time = 0;
            const points = [];
            const pointCount = 50;

            for (let i = 0; i < pointCount; i++) {
                points.push({
                    x: Math.random() * canvas.width,
                    y: Math.random() * canvas.height,
                    vx: (Math.random() - 0.5) * 0.5,
                    vy: (Math.random() - 0.5) * 0.5,
                });
            }

            function animate() {
                time += 0.01;
                ctx.clearRect(0, 0, canvas.width, canvas.height);

                ctx.strokeStyle = `rgba(255, 182, 0, ${0.1 + Math.sin(time) * 0.05})`;
                ctx.lineWidth = 1;

                for (let i = 0; i < points.length; i++) {
                    points[i].x += points[i].vx;
                    points[i].y += points[i].vy;

                    if (points[i].x < 0 || points[i].x > canvas.width) points[i].vx *= -1;
                    if (points[i].y < 0 || points[i].y > canvas.height) points[i].vy *= -1;

                    for (let j = i + 1; j < points.length; j++) {
                        const dx = points[i].x - points[j].x;
                        const dy = points[i].y - points[j].y;
                        const distance = Math.sqrt(dx * dx + dy * dy);

                        if (distance < 150) {
                            ctx.globalAlpha = (150 - distance) / 150 * 0.3;
                            ctx.beginPath();
                            ctx.moveTo(points[i].x, points[i].y);
                            ctx.lineTo(points[j].x, points[j].y);
                            ctx.stroke();
                        }
                    }
                }

                requestAnimationFrame(animate);
            }

            animate();

            window.addEventListener('resize', () => {
                canvas.width = window.innerWidth;
                canvas.height = window.innerHeight;
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Password toggle
            const passwordToggle = document.querySelector('.password-toggle-modern');
            const passwordInput = document.querySelector('input[name="password"]');

            if (passwordToggle && passwordInput) {
                passwordToggle.addEventListener('click', function() {
                    const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                    passwordInput.setAttribute('type', type);
                    
                    const icon = this.querySelector('i');
                    icon.classList.toggle('fa-eye');
                    icon.classList.toggle('fa-eye-slash');
                });
            }

            // Demo buttons
            const demoButtons = document.querySelectorAll('.demo-btn-modern');
            const loginForm = document.getElementById('login-form-modern');
            const usernameInput = document.querySelector('input[name="username"]');
            const passwordInput = document.querySelector('input[name="password"]');

            demoButtons.forEach(btn => {
                btn.addEventListener('click', function() {
                    const username = this.getAttribute('data-username');
                    if (username && usernameInput) {
                        usernameInput.value = username;
                        if (passwordInput && '{{ $password }}') {
                            passwordInput.value = '{{ $password }}';
                        }
                        loginForm.submit();
                    }
                });
            });

            // Form submission
            const submitBtn = document.querySelector('.submit-btn-modern');

            if (loginForm && submitBtn) {
                loginForm.addEventListener('submit', function(e) {
                    submitBtn.classList.add('loading');
                    
                    // Ripple effect
            submitBtn.addEventListener('click', function(e) {
                const rect = this.getBoundingClientRect();
                const x = e.clientX - rect.left;
                const y = e.clientY - rect.top;
                
                        const ripple = document.createElement('div');
                        ripple.className = 'btn-ripple-modern';
                        ripple.style.width = ripple.style.height = Math.max(rect.width, rect.height) + 'px';
                        ripple.style.left = x + 'px';
                        ripple.style.top = y + 'px';
                        ripple.style.transform = 'translate(-50%, -50%) scale(0)';
                        ripple.style.animation = 'rippleAnimation 0.6s ease-out';
                
                this.appendChild(ripple);
                
                setTimeout(() => {
                    ripple.remove();
                }, 600);
            });
                });
            }

            // Input focus effects
            const inputs = document.querySelectorAll('.input-modern');
            inputs.forEach(input => {
                input.addEventListener('focus', function() {
                    this.closest('.input-field-modern-container').classList.add('focused');
                });
                
                input.addEventListener('blur', function() {
                    this.closest('.input-field-modern-container').classList.remove('focused');
                });
            });
        });

        // Add ripple animation
        const style = document.createElement('style');
        style.textContent = `
            @keyframes rippleAnimation {
                to {
                    transform: translate(-50%, -50%) scale(4);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);
    </script>
@endsection
