//This file contains all functions used products tab

$(document).ready(function() {
    $(document).on('ifChecked', 'input#enable_stock', function() {
        $('div#alert_quantity_div').show();
        $('div#quick_product_opening_stock_div').show();


        $('input#pre_made').iCheck('uncheck'); // Uncheck pre_made


        //Enable expiry selection
        if ($('#expiry_period_type').length) {
            $('#expiry_period_type').removeAttr('disabled');
        }

        if ($('#opening_stock_button').length) {
            $('#opening_stock_button').removeAttr('disabled');
        }
    });
    $(document).on('ifUnchecked', 'input#enable_stock', function() {
        $('div#alert_quantity_div').hide();
        $('div#quick_product_opening_stock_div').hide();
        $('input#alert_quantity').val(0);

        //Disable expiry selection
        if ($('#expiry_period_type').length) {
            $('#expiry_period_type').val('').change();
            $('#expiry_period_type').attr('disabled', true);
        }
        if ($('#opening_stock_button').length) {
            $('#opening_stock_button').attr('disabled', true);
        }
    });

    $(document).on('ifToggled', 'input#use_multi_unit', function() {
        if ($('#use_multi_unit').is(':checked')) {
            
            $('.multi_unit').removeClass('hide');
            $('.sub_units').addClass('hide');
            $('.secondary_unit').addClass('hide');
            $('.enable_serial_number_div').addClass('hide');
            
        } else {
            $('.sub_units').removeClass('hide');
            $('.secondary_unit').removeClass('hide');
            $('.enable_serial_number_div').removeClass('hide');
            $('.multi_unit').addClass('hide');
        }
    });  



    // pre_made product
    $(document).on('ifToggled', 'input#pre_made', function() {

        if ($('#pre_made').is(':checked')) {
            $('#pre_made_div').removeClass('hide');
            $('input#enable_stock').iCheck('uncheck'); // Uncheck enable_stock
        } else {
            $('#pre_made_div').addClass('hide');
            $('input#enable_stock').iCheck('check'); // Check enable_stock
        }

    });   
    






    $(document).on('ifToggled', 'input#enable_serial_number', function() {
        if ($('#enable_serial_number').is(':checked')) {



            if ($('#quick_product_opening_stock_div')) {

                $('table#quick_product_opening_stock_table tbody tr').each(function() {
                    var row_key = $(this).find('input.row_key').val();
                    var serial_row_box = $(this).find('.serial_row_box');
                    var purchase_quantity = $(this).find('input.purchase_quantity');
                    purchase_quantity.attr('readonly', true);

                    var serial_html = `<div class="form-group">
                        <button  type="button" data-value="product_serial_novaluesetbox`+row_key+`" value="opening_stock_quentity_box`+row_key+`" class="btn btn-info btn-xs btn-modal purchases_serial_numberModelButton" data-toggle="modal" data-target="#purchases_serial_numberModel">
                            Add Serial
                        </button>
                        
                    </div>`

                    serial_row_box.html(serial_html);

       
                });
                // serial_row_box
                
            }








            $('.multi_unit_box').addClass('hide');
        } else {


            if ($('#quick_product_opening_stock_div')) {

                $('table#quick_product_opening_stock_table tbody tr').each(function() {
                    var serial_row_box = $(this).find('.serial_row_box');
                    var purchase_quantity = $(this).find('input.purchase_quantity');
                    purchase_quantity.attr('readonly', false);
                    var serial_html = `<span>No Serial</span>`
                    serial_row_box.html(serial_html);
                });
                // serial_row_box
                
            }







            $('.multi_unit_box').removeClass('hide');
        }
    });  








    $(document).on('change', 'select#first_conversion_unit_id, select#second_conversion_unit_id', function() {
        var first_conversion_unit_id = ($('select#first_conversion_unit_id').find(':selected').val() || '').trim();
        var second_conversion_unit_id = ($('select#second_conversion_unit_id').find(':selected').val() || '').trim();
        if (first_conversion_unit_id) {
            $('.fu_variation_value_row').removeClass('hide');
            $('.su_variation_value_row').addClass('hide');
        }else{
            $('.fu_variation_value_row').addClass('hide');
            $('.su_variation_value_row').removeClass('hide');
        }
        if (second_conversion_unit_id) {
            $('.su_variation_value_row').removeClass('hide');
        }else{
            $('.su_variation_value_row').addClass('hide');
        }
    })


    //Start For product type single

       //Start For product type single
    //If purchase price exc tax is changed
    $(document).on('change', 'input#single_dpp', function(e) {
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
        __write_number($('input#single_dpp_inc_tax'), purchase_inc_tax);

        var profit_percent = __read_number($('#profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number($('input#single_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);

        
        var firstConversionUnitId = $('#first_conversion_unit_id').val();
        var firstConversionUnitRate = 1;
        if(firstConversionUnitId) {
            firstConversionUnitRate = $('#first_conversion_unit_rate').val();
            var first_unit_price = purchase_exc_tax*firstConversionUnitRate;
            var fu_single_dpp_element = $('input#fu_single_dpp');
            __write_number(fu_single_dpp_element, first_unit_price);
            fu_single_dpp_element.change();
        }
        
        
        var secondConversionUnitId = $('#second_conversion_unit_id').val();
        var secondConversionUnitRate = 1;
        
        if(secondConversionUnitId) {
            secondConversionUnitRate = $('#second_conversion_unit_rate').val();
            var second_unit_price = (purchase_exc_tax*(firstConversionUnitRate*secondConversionUnitRate));
            var su_single_dpp_element = $('input#su_single_dpp');
            __write_number(su_single_dpp_element, second_unit_price);
            su_single_dpp_element.change();
        }


    });



    //If tax rate is changed
    $(document).on('change', 'select#tax', function() {
        if ($('select#type').val() == 'single') {
            var purchase_exc_tax = __read_number($('input#single_dpp'));
            purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;
            var tax_rate = $('select#tax').find(':selected').data('rate');
            tax_rate = tax_rate == undefined ? 0 : tax_rate;

            var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
            __write_number($('input#single_dpp_inc_tax'), purchase_inc_tax);

            var selling_price = __read_number($('input#single_dsp'));
            var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
            __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);




            var firstConversionUnitId = $('#first_conversion_unit_id').val();
            var firstConversionUnitRate = 1;
            if(firstConversionUnitId) {
                firstConversionUnitRate = $('#first_conversion_unit_rate').val();
                var first_unit_price = purchase_exc_tax*firstConversionUnitRate;
                var fu_single_dpp_element = $('input#fu_single_dpp');
                __write_number(fu_single_dpp_element, first_unit_price);
                fu_single_dpp_element.change();
            }
            
            
            var secondConversionUnitId = $('#second_conversion_unit_id').val();
            var secondConversionUnitRate = 1;
            
            if(secondConversionUnitId) {
                secondConversionUnitRate = $('#second_conversion_unit_rate').val();
                var second_unit_price = (purchase_exc_tax*(firstConversionUnitRate*secondConversionUnitRate));
                var su_single_dpp_element = $('input#su_single_dpp');
                __write_number(su_single_dpp_element, second_unit_price);
                su_single_dpp_element.change();
            }
    



        }
    });


    //If purchase price inc tax is changed
    $(document).on('change', 'input#single_dpp_inc_tax', function(e) {
        var purchase_inc_tax = __read_number($('input#single_dpp_inc_tax'));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_exc_tax = __get_principle(purchase_inc_tax, tax_rate);
        __write_number($('input#single_dpp'), purchase_exc_tax);
        $('input#single_dpp').change();

        var profit_percent = __read_number($('#profit_percent'));
        profit_percent = profit_percent == undefined ? 0 : profit_percent;
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number($('input#single_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);




        var firstConversionUnitId = $('#first_conversion_unit_id').val();
        var firstConversionUnitRate = 1;
        if(firstConversionUnitId) {
            firstConversionUnitRate = $('#first_conversion_unit_rate').val();
            var first_unit_price = purchase_inc_tax*firstConversionUnitRate;
            var fu_single_dpp_inc_tax_element = $('input#fu_single_dpp_inc_tax');
            __write_number(fu_single_dpp_inc_tax_element, first_unit_price);
            fu_single_dpp_inc_tax_element.change();
        }
        
        var secondConversionUnitId = $('#second_conversion_unit_id').val();
        var secondConversionUnitRate = 1;
        
        if(secondConversionUnitId) {
            secondConversionUnitRate = $('#second_conversion_unit_rate').val();
            var second_unit_price = (purchase_inc_tax*(firstConversionUnitRate*secondConversionUnitRate));
            var su_single_dpp_inc_tax_element = $('input#su_single_dpp_inc_tax');
            __write_number(su_single_dpp_inc_tax_element, second_unit_price);
            su_single_dpp_inc_tax_element.change();
        }



    });

    $(document).on('change', 'input#profit_percent', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_inc_tax = __read_number($('input#single_dpp_inc_tax'));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var purchase_exc_tax = __read_number($('input#single_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var profit_percent = __read_number($('input#profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number($('input#single_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);


        var firstConversionUnitId = $('#first_conversion_unit_id').val();
        if(firstConversionUnitId) {
            var fu_profit_percent_element = $('input#fu_profit_percent');
            __write_number(fu_profit_percent_element, profit_percent);
            fu_profit_percent_element.change();
        }
        
        var secondConversionUnitId = $('#second_conversion_unit_id').val();
        
        if(secondConversionUnitId) {
            var su_profit_percent_element = $('input#su_profit_percent');
            __write_number(su_profit_percent_element, profit_percent);
            su_profit_percent_element.change();
        }

    });

    $(document).on('change', 'input#single_dsp', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var selling_price = __read_number($('input#single_dsp'));
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        var profit_percent = __read_number($('input#profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number($('input#profit_percent'), profit_percent);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);




        
        var firstConversionUnitId = $('#first_conversion_unit_id').val();
        var firstConversionUnitRate = 1;
        if(firstConversionUnitId) {
            firstConversionUnitRate = $('#first_conversion_unit_rate').val();
            var first_unit_price = selling_price*firstConversionUnitRate;
            var fu_single_dsp_element = $('input#fu_single_dsp');
            __write_number(fu_single_dsp_element, first_unit_price);
            fu_single_dsp_element.change();
        }
        
        var secondConversionUnitId = $('#second_conversion_unit_id').val();
        var secondConversionUnitRate = 1;
        
        if(secondConversionUnitId) {
            secondConversionUnitRate = $('#second_conversion_unit_rate').val();
            var second_unit_price = (selling_price*(firstConversionUnitRate*secondConversionUnitRate));
            var su_single_dsp_element = $('input#su_single_dsp');
            __write_number(su_single_dsp_element, second_unit_price);
            su_single_dsp_element.change();
        }



    });

    $(document).on('change', 'input#single_dsp_inc_tax', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;
        var selling_price_inc_tax = __read_number($('input#single_dsp_inc_tax'));

        var selling_price = __get_principle(selling_price_inc_tax, tax_rate);
        __write_number($('input#single_dsp'), selling_price);
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        var profit_percent = __read_number($('input#profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number($('input#profit_percent'), profit_percent);




              
        var firstConversionUnitId = $('#first_conversion_unit_id').val();
        var firstConversionUnitRate = 1;
        if(firstConversionUnitId) {
            firstConversionUnitRate = $('#first_conversion_unit_rate').val();
            var first_unit_price = selling_price_inc_tax*firstConversionUnitRate;
            var fu_single_dsp_inc_tax_element = $('input#fu_single_dsp_inc_tax');
            __write_number(fu_single_dsp_inc_tax_element, first_unit_price);
            fu_single_dsp_inc_tax_element.change();
        }
        
        var secondConversionUnitId = $('#second_conversion_unit_id').val();
        var secondConversionUnitRate = 1;
        
        if(secondConversionUnitId) {
            secondConversionUnitRate = $('#second_conversion_unit_rate').val();
            var second_unit_price = (selling_price_inc_tax*(firstConversionUnitRate*secondConversionUnitRate));
            var su_single_dsp_inc_tax_element = $('input#su_single_dsp_inc_tax');
            __write_number(su_single_dsp_inc_tax_element, second_unit_price);
            su_single_dsp_inc_tax_element.change();
        }


    });

    if ($('#product_add_form').length) {
        $('form#product_add_form').validate({
            rules: {
                sku: {
                    remote: {
                        url: '/products/check_product_sku',
                        type: 'post',
                        data: {
                            sku: function() {
                                return $('#sku').val();
                            },
                            product_id: function() {
                                if ($('#product_id').length > 0) {
                                    return $('#product_id').val();
                                } else {
                                    return '';
                                }
                            },
                        },
                    },
                },
                expiry_period: {
                    required: {
                        depends: function(element) {
                            return (
                                $('#expiry_period_type')
                                    .val()
                                    .trim() != ''
                            );
                        },
                    },
                },
            },
            messages: {
                sku: {
                    remote: LANG.sku_already_exists,
                },
            },
        });
    }

    $(document).on('click', '.submit_product_form', function(e) {
        e.preventDefault();

        var firstConversionUnitId = $('#first_conversion_unit_id').val();
        var firstConversionUnitRate = $('#first_conversion_unit_rate');
        
        if(firstConversionUnitId) {
            firstConversionUnitRate.attr('required', true);
            
            
            var fu_dpp = $('.fu_dpp');
            var fu_dpp_inc_tax = $('.fu_dpp_inc_tax');
            var fu_profit_percent = $('.fu_profit_percent');
            var fu_single_dsp = $('.fu_single_dsp');
            var fu_single_dsp_inc_tax = $('.fu_single_dsp_inc_tax');
            
            fu_dpp.attr('required', true);
            fu_dpp_inc_tax.attr('required', true);
            fu_profit_percent.attr('required', true);
            fu_single_dsp.attr('required', true);
            fu_single_dsp_inc_tax.attr('required', true);
  


        }else {
            firstConversionUnitRate.removeAttr('required');

            var fu_dpp = $('.fu_dpp');
            var fu_dpp_inc_tax = $('.fu_dpp_inc_tax');
            var fu_profit_percent = $('.fu_profit_percent');
            var fu_single_dsp = $('.fu_single_dsp');
            var fu_single_dsp_inc_tax = $('.fu_single_dsp_inc_tax');
            
            fu_dpp.removeAttr('required');
            fu_dpp_inc_tax.removeAttr('required');
            fu_profit_percent.removeAttr('required');
            fu_single_dsp.removeAttr('required');
            fu_single_dsp_inc_tax.removeAttr('required');


        }
        var secondConversionUnitId = $('#second_conversion_unit_id').val();
        var secondConversionUnitRate = $('#second_conversion_unit_rate');

        if(secondConversionUnitId) {
            secondConversionUnitRate.attr('required', true);

            var su_dpp = $('.su_dpp');
            var su_dpp_inc_tax = $('.su_dpp_inc_tax');
            var su_profit_percent = $('.su_profit_percent');
            var su_single_dsp = $('.su_single_dsp');
            var su_single_dsp_inc_tax = $('.su_single_dsp_inc_tax');
            
            su_dpp.attr('required', true);
            su_dpp_inc_tax.attr('required', true);
            su_profit_percent.attr('required', true);
            su_single_dsp.attr('required', true);
            su_single_dsp_inc_tax.attr('required', true);


        }else {
            secondConversionUnitRate.removeAttr('required');

            var su_dpp = $('.su_dpp');
            var su_dpp_inc_tax = $('.su_dpp_inc_tax');
            var su_profit_percent = $('.su_profit_percent');
            var su_single_dsp = $('.su_single_dsp');
            var su_single_dsp_inc_tax = $('.su_single_dsp_inc_tax');

            su_dpp.removeAttr('required');
            su_dpp_inc_tax.removeAttr('required');
            su_profit_percent.removeAttr('required');
            su_single_dsp.removeAttr('required');
            su_single_dsp_inc_tax.removeAttr('required');

        }

        var variation_skus = [];

        $('#product_form_part').find('.input_sub_sku').each( function(){
            var element = $(this);
            var row_variation_id = '';
            if ($(this).closest('tr').find('.row_variation_id')) {
                row_variation_id = $(this).closest('tr').find('.row_variation_id').val();
            }
            variation_skus.push({
                sku: element.val(), 
                variation_id: row_variation_id
            });
            
        });

        if (variation_skus.length > 0) {
            $.ajax({
                method: 'post',
                url: '/products/validate_variation_skus',
                data: { skus: variation_skus},
                success: function(result) {
                    if (result.success == true) {
                        var submit_type = $(this).attr('value');
                        $('#submit_type').val(submit_type);
                        if ($('form#product_add_form').valid()) {
                            $('form#product_add_form').submit();
                        }
                    } else {
                        toastr.error(__translate('skus_already_exists', {sku: result.sku}));
                        return false;
                    }
                },
            });
        } else {
            var submit_type = $(this).attr('value');
            $('#submit_type').val(submit_type);
            if ($('form#product_add_form').valid()) {
                $('form#product_add_form').submit();
            }
        }
        
    });
    //End for product type single
    
    //Start for product type single for first unit
    $(document).on('change', 'input#fu_single_dpp', function(e) {
        var fu_purchase_exc_tax = __read_number($('input#fu_single_dpp'));
        fu_purchase_exc_tax = fu_purchase_exc_tax == undefined ? 0 : fu_purchase_exc_tax;

        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var fu_purchase_inc_tax = __add_percent(fu_purchase_exc_tax, tax_rate);
        __write_number($('input#fu_single_dpp_inc_tax'), fu_purchase_inc_tax);

        var fu_profit_percent = __read_number($('#fu_profit_percent'));
        var fu_selling_price = __add_percent(fu_purchase_exc_tax, fu_profit_percent);
        __write_number($('input#fu_single_dsp'), fu_selling_price);

        var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
        __write_number($('input#fu_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    });
    // //If tax rate is changed
    // $(document).on('change', 'select#tax', function() {
    //     if ($('select#type').val() == 'single') {
    //         var fu_purchase_exc_tax = __read_number($('input#fu_single_dpp'));
    //         fu_purchase_exc_tax = fu_purchase_exc_tax == undefined ? 0 : fu_purchase_exc_tax;
    //         var tax_rate = $('select#tax').find(':selected').data('rate');
    //         tax_rate = tax_rate == undefined ? 0 : tax_rate;

    //         var fu_purchase_inc_tax = __add_percent(fu_purchase_exc_tax, tax_rate);
    //         __write_number($('input#fu_single_dpp_inc_tax'), fu_purchase_inc_tax);

    //         var fu_selling_price = __read_number($('input#fu_single_dsp'));
    //         var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
    //         __write_number($('input#fu_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    //     }
    // });
    //If purchase price inc tax is changed
    $(document).on('change', 'input#fu_single_dpp_inc_tax', function(e) {
        var fu_purchase_inc_tax = __read_number($('input#fu_single_dpp_inc_tax'));
        fu_purchase_inc_tax = fu_purchase_inc_tax == undefined ? 0 : fu_purchase_inc_tax;

        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var fu_purchase_exc_tax = __get_principle(fu_purchase_inc_tax, tax_rate);
        __write_number($('input#fu_single_dpp'), fu_purchase_exc_tax);
        $('input#fu_single_dpp').change();

        var fu_profit_percent = __read_number($('#fu_profit_percent'));
        fu_profit_percent = fu_profit_percent == undefined ? 0 : fu_profit_percent;
        var fu_selling_price = __add_percent(fu_purchase_exc_tax, fu_profit_percent);
        __write_number($('input#fu_single_dsp'), fu_selling_price);

        var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
        __write_number($('input#fu_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    });
    $(document).on('change', 'input#fu_profit_percent', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var fu_purchase_inc_tax = __read_number($('input#fu_single_dpp_inc_tax'));
        fu_purchase_inc_tax = fu_purchase_inc_tax == undefined ? 0 : fu_purchase_inc_tax;

        var fu_purchase_exc_tax = __read_number($('input#fu_single_dpp'));
        fu_purchase_exc_tax = fu_purchase_exc_tax == undefined ? 0 : fu_purchase_exc_tax;

        var fu_profit_percent = __read_number($('input#fu_profit_percent'));
        var fu_selling_price = __add_percent(fu_purchase_exc_tax, fu_profit_percent);
        __write_number($('input#fu_single_dsp'), fu_selling_price);

        var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
        __write_number($('input#fu_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    });
    $(document).on('change', 'input#fu_single_dsp', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var fu_selling_price = __read_number($('input#fu_single_dsp'));
        var fu_purchase_exc_tax = __read_number($('input#fu_single_dpp'));
        var fu_profit_percent = __read_number($('input#fu_profit_percent'));

        //if purchase price not set
        if (fu_purchase_exc_tax == 0) {
            fu_profit_percent = 0;
        } else {
            fu_profit_percent = __get_rate(fu_purchase_exc_tax, fu_selling_price);
        }
        __write_number($('input#fu_profit_percent'), fu_profit_percent);

        var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
        __write_number($('input#fu_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    });
    $(document).on('change', 'input#fu_single_dsp_inc_tax', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;
        var fu_selling_price_inc_tax = __read_number($('input#fu_single_dsp_inc_tax'));

        var fu_selling_price = __get_principle(fu_selling_price_inc_tax, tax_rate);
        __write_number($('input#fu_single_dsp'), fu_selling_price);
        var fu_purchase_exc_tax = __read_number($('input#fu_single_dpp'));
        var fu_profit_percent = __read_number($('input#fu_profit_percent'));

        //if purchase price not set
        if (fu_purchase_exc_tax == 0) {
            fu_profit_percent = 0;
        } else {
            fu_profit_percent = __get_rate(fu_purchase_exc_tax, selling_price);
        }
        __write_number($('input#fu_profit_percent'), fu_profit_percent);
    });
    //End for product type single for first unit


    //Start for product type single for second unit
    $(document).on('change', 'input#su_single_dpp', function(e) {
        var fu_purchase_exc_tax = __read_number($('input#su_single_dpp'));
        fu_purchase_exc_tax = fu_purchase_exc_tax == undefined ? 0 : fu_purchase_exc_tax;

        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var fu_purchase_inc_tax = __add_percent(fu_purchase_exc_tax, tax_rate);
        __write_number($('input#su_single_dpp_inc_tax'), fu_purchase_inc_tax);

        var fu_profit_percent = __read_number($('#su_profit_percent'));
        var fu_selling_price = __add_percent(fu_purchase_exc_tax, fu_profit_percent);
        __write_number($('input#su_single_dsp'), fu_selling_price);

        var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
        __write_number($('input#su_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    });
    //If tax rate is changed
    $(document).on('change', 'select#tax', function() {
        if ($('select#type').val() == 'single') {
            var fu_purchase_exc_tax = __read_number($('input#su_single_dpp'));
            fu_purchase_exc_tax = fu_purchase_exc_tax == undefined ? 0 : fu_purchase_exc_tax;
            var tax_rate = $('select#tax').find(':selected').data('rate');
            tax_rate = tax_rate == undefined ? 0 : tax_rate;

            var fu_purchase_inc_tax = __add_percent(fu_purchase_exc_tax, tax_rate);
            __write_number($('input#su_single_dpp_inc_tax'), fu_purchase_inc_tax);

            var fu_selling_price = __read_number($('input#su_single_dsp'));
            var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
            __write_number($('input#su_single_dsp_inc_tax'), fu_selling_price_inc_tax);
        }
    });
    //If purchase price inc tax is changed
    $(document).on('change', 'input#su_single_dpp_inc_tax', function(e) {
        var fu_purchase_inc_tax = __read_number($('input#su_single_dpp_inc_tax'));
        fu_purchase_inc_tax = fu_purchase_inc_tax == undefined ? 0 : fu_purchase_inc_tax;

        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var fu_purchase_exc_tax = __get_principle(fu_purchase_inc_tax, tax_rate);
        __write_number($('input#su_single_dpp'), fu_purchase_exc_tax);
        $('input#su_single_dpp').change();

        var fu_profit_percent = __read_number($('#su_profit_percent'));
        fu_profit_percent = fu_profit_percent == undefined ? 0 : fu_profit_percent;
        var fu_selling_price = __add_percent(fu_purchase_exc_tax, fu_profit_percent);
        __write_number($('input#su_single_dsp'), fu_selling_price);

        var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
        __write_number($('input#su_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    });
    $(document).on('change', 'input#su_profit_percent', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var fu_purchase_inc_tax = __read_number($('input#su_single_dpp_inc_tax'));
        fu_purchase_inc_tax = fu_purchase_inc_tax == undefined ? 0 : fu_purchase_inc_tax;

        var fu_purchase_exc_tax = __read_number($('input#su_single_dpp'));
        fu_purchase_exc_tax = fu_purchase_exc_tax == undefined ? 0 : fu_purchase_exc_tax;

        var fu_profit_percent = __read_number($('input#su_profit_percent'));
        var fu_selling_price = __add_percent(fu_purchase_exc_tax, fu_profit_percent);
        __write_number($('input#su_single_dsp'), fu_selling_price);

        var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
        __write_number($('input#su_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    });
    $(document).on('change', 'input#su_single_dsp', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var fu_selling_price = __read_number($('input#su_single_dsp'));
        var fu_purchase_exc_tax = __read_number($('input#su_single_dpp'));
        var fu_profit_percent = __read_number($('input#su_profit_percent'));

        //if purchase price not set
        if (fu_purchase_exc_tax == 0) {
            fu_profit_percent = 0;
        } else {
            fu_profit_percent = __get_rate(fu_purchase_exc_tax, fu_selling_price);
        }
        __write_number($('input#su_profit_percent'), fu_profit_percent);

        var fu_selling_price_inc_tax = __add_percent(fu_selling_price, tax_rate);
        __write_number($('input#su_single_dsp_inc_tax'), fu_selling_price_inc_tax);
    });
    $(document).on('change', 'input#su_single_dsp_inc_tax', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;
        var fu_selling_price_inc_tax = __read_number($('input#su_single_dsp_inc_tax'));

        var fu_selling_price = __get_principle(fu_selling_price_inc_tax, tax_rate);
        __write_number($('input#su_single_dsp'), fu_selling_price);
        var fu_purchase_exc_tax = __read_number($('input#su_single_dpp'));
        var fu_profit_percent = __read_number($('input#su_profit_percent'));

        //if purchase price not set
        if (fu_purchase_exc_tax == 0) {
            fu_profit_percent = 0;
        } else {
            fu_profit_percent = __get_rate(fu_purchase_exc_tax, selling_price);
        }
        __write_number($('input#su_profit_percent'), fu_profit_percent);
    });
    //End for product type single for second unit

    //Start for product type Variable
    //If purchase price exc tax is changed
    $(document).on('change', 'input.variable_dpp', function(e) {
        var tr_obj = $(this).closest('tr');

        var purchase_exc_tax = __read_number($(this));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dpp_inc_tax'), purchase_inc_tax);

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);

        if (tr_obj.hasClass('main_v')) {
            var firstConversionUnitId = $('#first_conversion_unit_id').val();
            var firstConversionUnitRate = 1;
        
            if (firstConversionUnitId) {
                var first_unit_tr = $('.fu_variation_value_row');
                firstConversionUnitRate = $('#first_conversion_unit_rate').val();
                var first_unit_price = purchase_exc_tax * firstConversionUnitRate;
        
                var fu_variable_dpp_element = first_unit_tr.find('input.variable_dpp');
                var current_fu_variable_dpp_value = __read_number(fu_variable_dpp_element);
        
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (first_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(fu_variable_dpp_element, first_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitPrices(first_unit_tr, first_unit_price);
                }
            }
            
            
            var secondConversionUnitId = $('#second_conversion_unit_id').val();
            var secondConversionUnitRate = 1;
            
            if(secondConversionUnitId) {
                var second_unit_tr = $('.su_variation_value_row');
                secondConversionUnitRate = $('#second_conversion_unit_rate').val();
                var second_unit_price = (purchase_exc_tax*(firstConversionUnitRate*secondConversionUnitRate));
                var su_variable_dpp_element = second_unit_tr.find('input.variable_dpp');
                var current_fu_variable_dpp_value = __read_number(su_variable_dpp_element);
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (second_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(su_variable_dpp_element, second_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitPrices(second_unit_tr, second_unit_price);
                }
    
            }
    
        }

    });
    //If purchase price inc tax is changed
    $(document).on('change', 'input.variable_dpp_inc_tax', function(e) {
        var tr_obj = $(this).closest('tr');

        var purchase_inc_tax = __read_number($(this));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_exc_tax = __get_principle(purchase_inc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dpp'), purchase_exc_tax);

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);


        if (tr_obj.hasClass('main_v')) {

            var firstConversionUnitId = $('#first_conversion_unit_id').val();
            var firstConversionUnitRate = 1;
        
            if (firstConversionUnitId) {
                var first_unit_tr = $('.fu_variation_value_row');
                firstConversionUnitRate = $('#first_conversion_unit_rate').val();
                var first_unit_price = purchase_exc_tax * firstConversionUnitRate;
        
                var fu_variable_dpp_element = first_unit_tr.find('input.variable_dpp_inc_tax');
                var current_fu_variable_dpp_value = __read_number(fu_variable_dpp_element);
        
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (first_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(fu_variable_dpp_element, first_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitvariable_dpp_inc_tax(first_unit_tr, first_unit_price);
                }
            }
            
            
            var secondConversionUnitId = $('#second_conversion_unit_id').val();
            var secondConversionUnitRate = 1;
            
            if(secondConversionUnitId) {
                var second_unit_tr = $('.su_variation_value_row');
                secondConversionUnitRate = $('#second_conversion_unit_rate').val();
                var second_unit_price = (purchase_exc_tax*(firstConversionUnitRate*secondConversionUnitRate));

                var su_variable_dpp_element = second_unit_tr.find('input.variable_dpp_inc_tax');
                var current_fu_variable_dpp_value = __read_number(su_variable_dpp_element);
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (second_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(su_variable_dpp_element, second_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitvariable_dpp_inc_tax(second_unit_tr, second_unit_price);
                }

            }
        }

    });

    $(document).on('change', 'input.variable_profit_percent', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var tr_obj = $(this).closest('tr');
        var profit_percent = __read_number($(this));

        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);

        if (tr_obj.hasClass('main_v')) {
            var firstConversionUnitId = $('#first_conversion_unit_id').val();
            if (firstConversionUnitId) {
                var first_unit_tr = $('.fu_variation_value_row');
                var first_unit_price = profit_percent;
        
                var fu_variable_dpp_element = first_unit_tr.find('input.variable_profit_percent');
                var current_fu_variable_dpp_value = __read_number(fu_variable_dpp_element);
        
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (first_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(fu_variable_dpp_element, first_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitvariable_profit_percent(first_unit_tr, first_unit_price);
                }
            }
            



            var secondConversionUnitId = $('#second_conversion_unit_id').val();
            if(secondConversionUnitId) {
                var second_unit_tr = $('.su_variation_value_row');
                var second_unit_price = profit_percent;

                var su_variable_dpp_element = second_unit_tr.find('input.variable_profit_percent');
                var current_fu_variable_dpp_value = __read_number(su_variable_dpp_element);
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (second_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(su_variable_dpp_element, second_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitvariable_profit_percent(second_unit_tr, second_unit_price);
                }
            }
        }

    });

    $(document).on('change', 'input.variable_dsp', function(e) {
        var tax_rate = $('select#tax').find(':selected').data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var tr_obj = $(this).closest('tr');
        var selling_price = __read_number($(this));
        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number(tr_obj.find('input.variable_profit_percent'), profit_percent);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);

        if (tr_obj.hasClass('main_v')) {

            var firstConversionUnitId = $('#first_conversion_unit_id').val();
            var firstConversionUnitRate = 1;
        
            if (firstConversionUnitId) {
                var first_unit_tr = $('.fu_variation_value_row');
                firstConversionUnitRate = $('#first_conversion_unit_rate').val();
                var first_unit_price = selling_price * firstConversionUnitRate;
        
                var fu_variable_dpp_element = first_unit_tr.find('input.variable_dsp');
                var current_fu_variable_dpp_value = __read_number(fu_variable_dpp_element);
        
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (first_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(fu_variable_dpp_element, first_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitvariable_dsp(first_unit_tr, first_unit_price);
                }
            }
            
            var secondConversionUnitId = $('#second_conversion_unit_id').val();
            var secondConversionUnitRate = 1;
            
            if(secondConversionUnitId) {
                var second_unit_tr = $('.su_variation_value_row');
                secondConversionUnitRate = $('#second_conversion_unit_rate').val();
                var second_unit_price = (selling_price*(firstConversionUnitRate*secondConversionUnitRate));
                var su_variable_dpp_element = second_unit_tr.find('input.variable_dsp');
                var current_fu_variable_dpp_value = __read_number(su_variable_dpp_element);
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (second_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(su_variable_dpp_element, second_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitvariable_dsp(second_unit_tr, second_unit_price);
                }
            }
        }

    });

    $(document).on('change', 'input.variable_dsp_inc_tax', function(e) {
        var tr_obj = $(this).closest('tr');
        var selling_price_inc_tax = __read_number($(this));

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var selling_price = __get_principle(selling_price_inc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));
        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number(tr_obj.find('input.variable_profit_percent'), profit_percent);

        if (tr_obj.hasClass('main_v')) {

            var firstConversionUnitId = $('#first_conversion_unit_id').val();
            var firstConversionUnitRate = 1;
        
            if (firstConversionUnitId) {
                var first_unit_tr = $('.fu_variation_value_row');
                firstConversionUnitRate = $('#first_conversion_unit_rate').val();
                var first_unit_price = selling_price_inc_tax * firstConversionUnitRate;
        
                var fu_variable_dpp_element = first_unit_tr.find('input.variable_dsp_inc_tax');
                var current_fu_variable_dpp_value = __read_number(fu_variable_dpp_element);
        
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (first_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(fu_variable_dpp_element, first_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitselling_price_inc_tax(first_unit_tr, first_unit_price);
                }
            }
            
            var secondConversionUnitId = $('#second_conversion_unit_id').val();
            var secondConversionUnitRate = 1;
            if(secondConversionUnitId) {
                var second_unit_tr = $('.su_variation_value_row');
                secondConversionUnitRate = $('#second_conversion_unit_rate').val();
                var second_unit_price = (selling_price_inc_tax*(firstConversionUnitRate*secondConversionUnitRate));
                var su_variable_dpp_element = second_unit_tr.find('input.variable_dsp_inc_tax');
                var current_fu_variable_dpp_value = __read_number(su_variable_dpp_element);
                // Only update the value if it has changed, avoiding re-triggering the change event
                if (second_unit_price !== current_fu_variable_dpp_value) {
                    __write_number(su_variable_dpp_element, second_unit_price);
                    // Manually update values here instead of triggering .change()
                    updateFirstUnitselling_price_inc_tax(second_unit_tr, second_unit_price);
                }

            }
        }

    });






    $(document).on('click', '.add_variation_value_row', function() {
        var variation_row_index = $(this).closest('.variation_row').find('.row_index').val();
        var variation_value_row_index = $(this).closest('table').find('tr:last .variation_row_index').val();
        if ($(this).closest('.variation_row').find('.row_edit').length >= 1) {
            var row_type = 'edit';
        } else {
            var row_type = 'add';
        }

        var table = $(this).closest('table');


        var first_conversion_unit_id = null;
        if ($('select#first_conversion_unit_id').length) {
            var selectedFirstUnit = $('select#first_conversion_unit_id').find(':selected').val();
            first_conversion_unit_id = selectedFirstUnit ? selectedFirstUnit.trim() : null;
        }
        
        var second_conversion_unit_id = null;
        if ($('select#second_conversion_unit_id').length) {
            var selectedSecondUnit = $('select#second_conversion_unit_id').find(':selected').val();
            second_conversion_unit_id = selectedSecondUnit ? selectedSecondUnit.trim() : null;
        }
    


        if ($('#use_multi_unit').is(':checked')) {
            var use_multi_unit = 1;
        } else {
            var use_multi_unit = 0;
        }


        $.ajax({
            method: 'GET',
            url: '/products/get_variation_value_row',
            data: {

                variation_row_index: variation_row_index,
                value_index: variation_value_row_index,
                row_type: row_type,
                use_multi_unit: use_multi_unit,
                first_conversion_unit_id: first_conversion_unit_id,
                second_conversion_unit_id: second_conversion_unit_id,

            },
            dataType: 'html',
            success: function(result) {
                if (result) {
                    table.append(result);
                    toggle_dsp_input();
                }
            },
        });
    });
    $(document).on('change', '.variation_template_values', function() {
        var tr_obj = $(this).closest('tr');
        var val = $(this).val();
        tr_obj.find('.variation_value_row').each(function(){
            if(val.includes($(this).attr('data-variation_value_id'))) {
                $(this).removeClass('hide');
                $(this).find('.is_variation_value_hidden').val(0);
            } else {
                $(this).addClass('hide');
                $(this).find('.is_variation_value_hidden').val(1);
            }
        })
    });
    $(document).on('change', '.variation_template', function() {
        tr_obj = $(this).closest('tr');

        if ($(this).val() !== '') {
            tr_obj.find('input.variation_name').val(
                $(this).find('option:selected').text()
            );

            var template_id = $(this).val();
            
            
            var first_conversion_unit_id = null;
            if ($('select#first_conversion_unit_id').length) {
                var selectedFirstUnit = $('select#first_conversion_unit_id').find(':selected').val();
                first_conversion_unit_id = selectedFirstUnit ? selectedFirstUnit.trim() : null;
            }
            
            var second_conversion_unit_id = null;
            if ($('select#second_conversion_unit_id').length) {
                var selectedSecondUnit = $('select#second_conversion_unit_id').find(':selected').val();
                second_conversion_unit_id = selectedSecondUnit ? selectedSecondUnit.trim() : null;
            }
        
            if ($('#use_multi_unit').is(':checked')) {
                var use_multi_unit = 1;
            } else {
                var use_multi_unit = 0;
            }

    
            var row_index = $(this).closest('tr').find('.row_index').val();
            $.ajax({
                method: 'POST',
                url: '/products/get_variation_template',
                dataType: 'json',
                data: { 
                    template_id: template_id, 
                    row_index: row_index,

                    use_multi_unit: use_multi_unit,
                    first_conversion_unit_id: first_conversion_unit_id,
                    second_conversion_unit_id: second_conversion_unit_id,
                },
                success: function(result) {
                    if (result) {
                        if(result.values.length > 0) {
                            tr_obj.find('.variation_template_values').select2();
                            tr_obj.find('.variation_template_values').empty();
                            tr_obj.find('.variation_template_values').select2({data: result.values, closeOnSelect: false});
                            tr_obj.find('.variation_template_values_div').removeClass('hide');
                            tr_obj.find('.variation_template_values').select2('open');
                        } else {
                            tr_obj.find('.variation_template_values_div').addClass('hide');
                        }
                        tr_obj
                            .find('table.variation_value_table')
                            .find('tbody')
                            .html(result.html);

                        toggle_dsp_input();
                    }
                },
            });
        }
    });

    $(document).on('click','.delete_complete_row', function(){
        swal({
            title: LANG.sure,
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then(willDelete => {
            if (willDelete) {
                $(this)
                .closest('.variation_row')
                .remove();
            }
        });
    });

    $(document).on('click', '.remove_variation_value_row', function() {
        swal({
            title: LANG.sure,
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then(willDelete => {
            if (willDelete) {
                var count = $(this).closest('table').find('.remove_variation_value_row').length;
                if (count === 1) {
                    $(this).closest('.variation_row').remove();
                } else {
                    $(this).closest('tr').remove();
                }
            }
        });
    });

    //If tax rate is changed
    $(document).on('change', 'select#tax', function() {
        if ($('select#type').val() == 'variable') {
            var tax_rate = $('select#tax').find(':selected').data('rate');
            tax_rate = tax_rate == undefined ? 0 : tax_rate;

            $('table.variation_value_table > tbody').each(function() {
                $(this).find('tr').each(function() {
                    var purchase_exc_tax = __read_number($(this).find('input.variable_dpp'));
                    purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

                    var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
                    __write_number(
                        $(this).find('input.variable_dpp_inc_tax'),
                        purchase_inc_tax
                    );

                    var selling_price = __read_number($(this).find('input.variable_dsp'));
                    var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
                    __write_number(
                        $(this).find('input.variable_dsp_inc_tax'),
                        selling_price_inc_tax
                    );
                });
            });

        }
    });
    //End for product type Variable
    $(document).on('change', '#tax_type', function(e) {
        toggle_dsp_input();
    });
    toggle_dsp_input();

    $(document).on('change', '#expiry_period_type', function(e) {
        if ($(this).val()) {
            $('input#expiry_period').prop('disabled', false);
        } else {
            $('input#expiry_period').val('');
            $('input#expiry_period').prop('disabled', true);
        }
    });

    $(document).on('click', 'a.view-product', function(e) {
        e.preventDefault();
        $.ajax({
            url: $(this).attr('href'),
            dataType: 'html',
            success: function(result) {
                $('#view_product_modal')
                    .html(result)
                    .modal('show');
                __currency_convert_recursively($('#view_product_modal'));
            },
        });
    });
    var img_fileinput_setting = {
        showUpload: false,
        showPreview: true,
        browseLabel: LANG.file_browse_label,
        removeLabel: LANG.remove,
        previewSettings: {
            image: { width: 'auto', height: 'auto', 'max-width': '100%', 'max-height': '100%' },
        },
    };
    $('#upload_image').fileinput(img_fileinput_setting);

    if ($('textarea#product_description').length > 0) {
        tinymce.init({
            selector: 'textarea#product_description',
            height:250
        });
    }









    // search_pre_made_product
    //Add products
    if ($('#search_pre_made_product').length > 0) {

        $('#search_pre_made_product').autocomplete({
            delay: 1000,
            source: function(request, response) {
                var price_group = '';
                var search_fields = [];
                $('.search_fields:checked').each(function(i){
                    search_fields[i] = $(this).val();
                });

                if ($('#price_group').length > 0) {
                    price_group = $('#price_group').val();
                }
                $.getJSON('/products/list',{
                        price_group: price_group,
                        location_id: $('input#location_id').val(),
                        term: request.term,
                        not_for_selling: 1,
                        search_fields: search_fields
                    },
                    response
                );
            },
            minLength: 2,
            response: function(event, ui) {
                if (ui.content.length == 1) {

                    ui.item = ui.content[0];

                    var is_overselling_allowed = false;
                    if($('input#is_overselling_allowed').length) {
                        is_overselling_allowed = true;
                    }
                    var for_so = false;
                    if ($('#sale_type').length && $('#sale_type').val() == 'sales_order') {
                        for_so = true;
                    }

                } else if (ui.content.length == 0) {
                    toastr.error(LANG.no_products_found);
                    $('input#search_pre_made_product').select();
                }
            },
            focus: function(event, ui) {
                if (ui.item.qty_available <= 0) {
                    return false;
                }
            },
            select: function(event, ui) {
                var searched_term = $(this).val();
                $(this).val(null);
                //Pre select Serial number only if the searched term is same as the serial number
                var selected_serial_number = searched_term == ui.item.serial_number ? ui.item.serial_number : null;
                //Pre select lot number only if the searched term is same as the lot number
                var purchase_line_id = ui.item.purchase_line_id && searched_term == ui.item.lot_number ? ui.item.purchase_line_id : null;
                pre_made_product_row(ui.item.variation_id, purchase_line_id, null, 1, selected_serial_number);
            }
        }).autocomplete('instance')._renderItem = function(ul, item) {

            var listItem;
            var string = '<div class="ui-menu-item-wrapper">' + item.name;
            if (item.type == 'variable') {
                string += '-' + item.variation;
            }
            var selling_price = item.selling_price;
            if (item.variation_group_price) {
                selling_price = item.variation_group_price;
            }
            string += ' (' + item.sub_sku + ')' + '<br> Price: ' + selling_price;
            if (item.enable_stock == 1) {
                var qty_available = __currency_trans_from_en(item.qty_available, false, false, __currency_precision, true);
                string += ' - ' + qty_available + item.unit;
            }
            string += '<br>Last Sell Price: ' + (item.unit_price_before_discount ?? item.selling_price);
            string += ' Last Purchase Price: ' + (item.pp_without_discount ?? item.default_purchase_price);
            string += '</div>';
            listItem = $('<li class="ui-menu-item">').append(string).appendTo(ul);
            // Store the item data in the list item
            listItem.data('item.autocomplete', item);

            return listItem;

        };
        
    }

    //Remove row on click on remove row
    $('table#premade_entry_table tbody').on('click', 'i.premade_remove_row', function() {
        $(this).parents('tr').remove();
        premade_total_row();
    });





});






//variation_id is null when weighing_scale_barcode is used.
function pre_made_product_row(variation_id = null, purchase_line_id = null, weighing_scale_barcode = null, quantity = 1, selected_serial_number = null) {

    
    //Get item addition method
    var item_addtn_method = 0;
    var add_via_ajax = true;

    if (variation_id != null && $('#item_addition_method').length) {
        item_addtn_method = $('#item_addition_method').val();
    }

    if (item_addtn_method == 0) {
        add_via_ajax = true;
    } else {
        var is_added = false;

        //Search for variation id in each row of pos table
        $('#premade_entry_table tbody').find('tr').each(function() {

            var row_v_id = $(this).find('.row_variation_id').val();
            var modifiers_exist = false;
            if ($(this).find('input.modifiers_exist').length > 0) {
                modifiers_exist = true;
            }
            // Increment product quantity
            var qty_element = $(this).find('.premade_quantity');

            if (row_v_id == variation_id && !modifiers_exist && !is_added){

                add_via_ajax = false;
                is_added = true;

                // let selectedValues = $(this).find('select.productserialnumber').val(); // Gets an array of selected values
                if ($(this).find('select.productserialnumber').length > 0) {
                    var selectedValues = $(this).find('select.productserialnumber').val();

                    if (selected_serial_number !== null) {

                        if (selectedValues.includes(selected_serial_number)) {
                            alert('Already Add this');
                        }else{
                            // Add the new serial number to the existing selections
                            selectedValues.push(selected_serial_number);
                            $(this).find('select.productserialnumber').val(selectedValues).trigger('change');
                            var qty = __read_number(qty_element);
                            __write_number(qty_element, qty + 1);
                            qty_element.change();

                            $('input#search_pre_made_product').focus().select();
                        }
            
                    }else{
                        alert('Please Select Serial Number');
                    }
                    

                }else{

                    // Increment product quantity
                    var qty = __read_number(qty_element);
                    __write_number(qty_element, qty + 1);
                    qty_element.change();

                    $('input#search_pre_made_product').focus().select();
                }
            }

        });
    }

    if (add_via_ajax) {
        var product_row = $('input#product_row_count').val();
  
        $.ajax({
            method: 'GET',
            url: '/products/premade/get_product_row/' + variation_id,
            async: false,
            data: {
                product_row: product_row,
                purchase_line_id: purchase_line_id,
                quantity: quantity,
            },
            dataType: 'json',
            success: function(result) {

                if (result.success) {
                    $('table#premade_entry_table tbody').append(result.html_content).find('input.premade_quantity');
                    //increment row count
                    $('input#product_row_count').val(parseInt(product_row) + 1);
                    var this_row = $('table#premade_entry_table tbody').find('tr').last();

                    if (this_row.find('select.productserialnumber').length > 0) {
                        var selectedValues = this_row.find('select.productserialnumber').val(); // Gets an array of selected values
                        if (selected_serial_number !== null) {
                            if (selectedValues.includes(selected_serial_number)) {
                                alert('Already Add this');
                            }else{
                                // Add the new serial number to the existing selections
                                selectedValues.push(selected_serial_number);
                                this_row.find('select.productserialnumber').val(selectedValues).trigger('change');
                            }
                        }
                    }


                    //For initial discount if present
                    var line_total = __read_number(this_row.find('input.premade_line_total'));
                    var is_enable_product_multi_unit = this_row.find('input.is_enable_product_multi_unit').val();
                    if (is_enable_product_multi_unit) {

                        var quantity = __read_number(this_row.find('input.premade_quantity'));

                        var select_unit_id = this_row.find('select.sub_unit').find(':selected').val();
                        var main_unit_rate = this_row.find('input.main_unit').val();
                        var first_unit_id = this_row.find('input.first_unit').data('id');
                        var first_unit_rate = this_row.find('input.first_unit').val();
                        var second_unit_id = this_row.find('input.second_unit').data('id');
                        var second_unit_rate = this_row.find('input.second_unit').val();
                        var final_first_unit_rate = first_unit_rate;
                        var final_second_unit_rate = second_unit_rate;

                        var base_unit_quantity = (quantity*main_unit_rate).toFixed(2);

                        var base_unit_quantity = (quantity*main_unit_rate).toFixed(2);
                        if (select_unit_id == first_unit_id) {
                            final_first_unit_rate = main_unit_rate*first_unit_rate;
                            final_second_unit_rate = main_unit_rate/second_unit_rate;
                            base_unit_quantity = (quantity*final_first_unit_rate).toFixed(2);
                        }
                        if (select_unit_id == second_unit_id) {
                            final_first_unit_rate = (main_unit_rate*first_unit_rate)*second_unit_rate;
                            final_second_unit_rate = main_unit_rate*second_unit_rate;
                            base_unit_quantity = (quantity*final_first_unit_rate).toFixed(2);
                        }   

                        var unit_price_inc_tax = __read_number(this_row.find('input.premade_unit_price_inc_tax'));

                        line_total = unit_price_inc_tax*base_unit_quantity;
                    }
            
                    this_row.find('span.premade_line_total_text').text(line_total);

                    premade_total_row();


                    //Check if multipler is present then multiply it when a new row is added.
                    if(__getUnitMultiplier(this_row) > 1){
                        this_row.find('select.sub_unit').trigger('change');
                    }

                    __currency_convert_recursively(this_row);

                    $('input#search_pre_made_product').focus().select();

                    //scroll bottom of items list
                    $(".pos_product_div").animate({ scrollTop: $('.pos_product_div').prop("scrollHeight")}, 1000);

                } else {
                    toastr.error(result.msg);
                    $('input#search_pre_made_product').focus().select();
                }

            },
        });
    }


}
function premade_total_row() {
    var total_quantity = 0;
    var price_total = get_premade_subtotal();
    $('table#premade_entry_table tbody tr').each(function() {
        total_quantity = total_quantity + __read_number($(this).find('input.premade_quantity'));
    });

    $('span#total_quantity').html(__number_f(total_quantity));

    //$('span.unit_price_total').html(unit_price_total);
    $('span#total_subtotal').html(__currency_trans_from_en(price_total, false));


}
function get_premade_subtotal() {
    var price_total = 0;
    $('table#premade_entry_table tbody tr').each(function() {
        price_total = price_total + __read_number($(this).find('input.premade_line_total'));
    });
    return price_total;
}
// premade_line_total_text
//Update values for each row
function premade_each_row(row_obj) {
    var unit_price = __read_number(row_obj.find('input.premade_unit_price'));
    var unit_price_inc_tax = __read_number(row_obj.find('input.premade_unit_price_inc_tax'));
    var item_tax = __read_number(row_obj.find('input.item_tax'));
}

//Update line total and check for quantity not greater than max quantity
$('table#premade_entry_table tbody').on('change', 'input.premade_quantity', function() {

    // var max_qty = parseFloat($(this).data('rule-max'));
    var entered_qty = __read_number($(this));
    var tr = $(this).parents('tr');
    var selected_option = tr.find('select.sub_unit').find(':selected');
    var unit_price_inc_tax = __read_number(tr.find('input.premade_unit_price_inc_tax'));
    var item_tax = __read_number(tr.find('input.item_tax'));
    var line_total = entered_qty * unit_price_inc_tax;

    var is_enable_product_multi_unit = tr.find('input.is_enable_product_multi_unit').val();
    if (is_enable_product_multi_unit) {

        var select_unit_id = selected_option.val();
        var quantity = entered_qty;

        var main_unit_id = tr.find('input.main_unit').data('id');
        var main_unit_rate = tr.find('input.main_unit').val();
        var main_unit_name = tr.find('input.main_unit').data('name');

        var first_unit_id = tr.find('input.first_unit').data('id');
        var first_unit_rate = tr.find('input.first_unit').val();
        var first_unit_name = tr.find('input.first_unit').data('name');

        var second_unit_id = tr.find('input.second_unit').data('id');
        var second_unit_rate = tr.find('input.second_unit').val();          
        var second_unit_name = tr.find('input.second_unit').data('name');

        var final_first_unit_rate = first_unit_rate;
        var final_second_unit_rate = second_unit_rate;


        var base_unit_quantity_element = tr.find('input.base_unit_quantity');
        var base_unit_quantity = (quantity*main_unit_rate).toFixed(2);

        if (select_unit_id == first_unit_id) {
            first_unit_name = main_unit_name;
            final_first_unit_rate = main_unit_rate*first_unit_rate;
            final_second_unit_rate = main_unit_rate/second_unit_rate;
            base_unit_quantity = (quantity*final_first_unit_rate).toFixed(2);
        }
        if (select_unit_id == second_unit_id) {
            second_unit_name = first_unit_name;
            first_unit_name = main_unit_name;
            final_first_unit_rate = (main_unit_rate*first_unit_rate)*second_unit_rate;
            final_second_unit_rate = main_unit_rate*second_unit_rate;
            base_unit_quantity = (quantity*final_first_unit_rate).toFixed(2);
        }   

        __write_number(base_unit_quantity_element, base_unit_quantity);

        //--------------------------------------
        var first_unit_rate_for_this_quantity = final_first_unit_rate*quantity;
        var second_unit_rate_for_this_quantity = final_second_unit_rate*quantity;

        var first_conversion_unit_rate = tr.find('.first_conversion_unit_rate span');
        var second_conversion_unit_rate = tr.find('.second_conversion_unit_rate span');

        first_conversion_unit_rate.text(__number_f(first_unit_rate_for_this_quantity, false)+" "+first_unit_name);
        second_conversion_unit_rate.text(__number_f(second_unit_rate_for_this_quantity, false)+" "+second_unit_name);

        line_total = unit_price_inc_tax*base_unit_quantity;

    }

    __write_number(tr.find('input.premade_line_total'), line_total, false, 2);
    tr.find('span.premade_line_total_text').text(__currency_trans_from_en(line_total, true));


    premade_total_row();

});













function toggle_dsp_input() {
    var tax_type = $('#tax_type').val();
    if (tax_type == 'inclusive') {
        $('.dsp_label').each(function() {
            $(this).text(LANG.inc_tax);
        });
        $('#single_dsp').addClass('hide');
        $('#single_dsp_inc_tax').removeClass('hide');

        $('.add-product-price-table')
            .find('.variable_dsp_inc_tax')
            .each(function() {
                $(this).removeClass('hide');
            });
        $('.add-product-price-table')
            .find('.variable_dsp')
            .each(function() {
                $(this).addClass('hide');
            });
    } else if (tax_type == 'exclusive') {
        $('.dsp_label').each(function() {
            $(this).text(LANG.exc_tax);
        });
        $('#single_dsp').removeClass('hide');
        $('#single_dsp_inc_tax').addClass('hide');

        $('.add-product-price-table')
            .find('.variable_dsp_inc_tax')
            .each(function() {
                $(this).addClass('hide');
            });
        $('.add-product-price-table')
            .find('.variable_dsp')
            .each(function() {
                $(this).removeClass('hide');
            });
    }
}

function get_product_details(rowData) {
    var div = $('<div/>')
        .addClass('loading')
        .text('Loading...');

    $.ajax({
        url: '/products/' + rowData.id,
        dataType: 'html',
        success: function(data) {
            div.html(data).removeClass('loading');
        },
    });

    return div;
}

//Quick add unit
$(document).on('submit', 'form#quick_add_unit_form', function(e) {
    e.preventDefault();
    var form = $(this);
    var data = form.serialize();

    $.ajax({
        method: 'POST',
        url: $(this).attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function(xhr) {
            __disable_submit_button(form.find('button[type="submit"]'));
        },
        success: function(result) {
            if (result.success == true) {
                var newOption = new Option(result.data.short_name, result.data.id, true, true);

                var  first_unit = $('#first_unit').val(); 
                var  second_unit = $('#second_unit').val(); 

                if (first_unit) {
                    // Append it to the select
                    $('#first_conversion_unit_id').append(newOption).trigger('change');
                }
                if (second_unit) {
                    // Append it to the select
                    $('#second_conversion_unit_id').append(newOption).trigger('change');
                }
                if (!first_unit && !second_unit) {
                    $('#unit_id').append(newOption).trigger('change');
                    $('#first_conversion_unit_id').append('').trigger('change');
                }
                $('div.view_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
});

//Quick add brand
$(document).on('submit', 'form#quick_add_brand_form', function(e) {
    e.preventDefault();
    var form = $(this);
    var data = form.serialize();

    $.ajax({
        method: 'POST',
        url: $(this).attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function(xhr) {
            __disable_submit_button(form.find('button[type="submit"]'));
        },
        success: function(result) {
            if (result.success == true) {
                var newOption = new Option(result.data.name, result.data.id, true, true);
                // Append it to the select
                $('#brand_id')
                    .append(newOption)
                    .trigger('change');
                $('div.view_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
});

//Quick add category
$(document).on('submit', 'form#category_add_form', function(e) {
    e.preventDefault();
    e.stopImmediatePropagation();
    
    var form = $(this);
    var data = form.serialize();

    $.ajax({
        method: 'POST',
        url: form.attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function(xhr) {
            __disable_submit_button(form.find('button[type="submit"]'));
        },
        success: function(result) {
            if (result.success == true) {
                var newOption = new Option(result.data.name, result.data.id, true, true);
                
                // Check if it's a sub-category (has parent_id > 0) or main category
                if (result.data.parent_id && result.data.parent_id != 0 && result.data.parent_id != '0') {
                    // This is a sub-category - append and select
                    var $subCategorySelect = $('#sub_category_id');
                    $subCategorySelect.append(newOption);
                    $subCategorySelect.val(result.data.id).trigger('change');
                } else {
                    // This is a main category - append and select
                    var $categorySelect = $('#category_id');
                    $categorySelect.append(newOption);
                    $categorySelect.val(result.data.id).trigger('change');
                }
                
                $('div.view_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
        error: function(xhr, status, error) {
            console.error('Category add error:', error);
            toastr.error('An error occurred while adding the category');
            form.find('button[type="submit"]').removeAttr('disabled');
        }
    });
    
    return false;
});

$(document).on('click', 'button.apply-all', function(){
    var val = $(this).closest('.input-group').find('input').val();
    var target_class = $(this).data('target-class');
    $(this).closest('tbody').find('tr').each( function(){
        element =  $(this).find(target_class);
        element.val(val);
        element.change();
    });
});
