function initializeSocket() {
    socket = new WebSocket('ws://127.0.0.1:6441');

    socket.onopen = function() {
        console.log('WebSocket connection established');
    };

    socket.onmessage = function(msg) {
        console.log('Message from server:', msg.data);
    };

    socket.onclose = function(event) {
        console.log('WebSocket connection closed:', event);
        socket = null; // Reset socket to null on close
    };

    socket.onerror = function(error) {
        console.error('WebSocket error:', error);
    };
}


initializeSocket();