$(document).ready(function() {
    if ($('#dashboard_date_filter').length == 1) {
        dateRangeSettings.startDate = moment();
        dateRangeSettings.endDate = moment();
        $('#dashboard_date_filter').daterangepicker(dateRangeSettings, function(start, end) {
            $('#dashboard_date_filter span').html(
                start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
            );
            // Update badge captions and statistics
            update_statistics(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
            if ($('#quotation_table').length && $('#dashboard_location').length) {
                quotation_datatable.ajax.reload();
            }
            $('.dashboard_date_filter_value').empty().prepend(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            
            // Trigger custom event for top customers/products
            $(document).trigger('daterangepicker-change', [start, end]);
        });

        // Initialize with today's date and update badges
        update_statistics(moment().format('YYYY-MM-DD'), moment().format('YYYY-MM-DD'));
    }

    $('#dashboard_location').change( function(e) {
        var start = $('#dashboard_date_filter')
                    .data('daterangepicker')
                    .startDate.format('YYYY-MM-DD');

        var end = $('#dashboard_date_filter')
                    .data('daterangepicker')
                    .endDate.format('YYYY-MM-DD');

        // Update badge captions and statistics
        update_statistics(start, end);
        
        // Trigger custom event for top customers/products
        $(document).trigger('daterangepicker-change', [
            $('#dashboard_date_filter').data('daterangepicker').startDate,
            $('#dashboard_date_filter').data('daterangepicker').endDate
        ]);
    });

    //atock alert datatables
    var stock_alert_table = $('#stock_alert_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Bfrtip',
        buttons: {
            dom: {
                button: {
                    tag: 'button',
                    className: 'btn btn-sm btn-outline-secondary me-2',
                    active: 'active',
                    disabled: 'disabled'
                }
            },
            buttons: [
                {
                    extend: 'copy',
                    text: '<i class="fas fa-copy"></i> Copy',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="fas fa-file-csv"></i> CSV',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="fas fa-file-excel"></i> Excel',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="fas fa-file-pdf"></i> PDF',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="fas fa-print"></i> Print',
                    exportOptions: {
                        columns: ':visible'
                    }
                }
            ]
        },
        ajax: {
            "url": '/home/product-stock-alert',
            "data": function ( d ) {
                if ($('#stock_alert_location').length > 0) {
                    d.location_id = $('#stock_alert_location').val();
                }
            }
        },
        fnDrawCallback: function(oSettings) {
            __currency_convert_recursively($('#stock_alert_table'));
        },
    });

    $('#stock_alert_location').change( function(){
        stock_alert_table.ajax.reload();
    });
    //payment dues datatables
    purchase_payment_dues_table = $('#purchase_payment_dues_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Bfrtip',
        buttons: {
            dom: {
                button: {
                    tag: 'button',
                    className: 'btn btn-sm btn-outline-secondary me-2',
                    active: 'active',
                    disabled: 'disabled'
                }
            },
            buttons: [
                {
                    extend: 'copy',
                    text: '<i class="fas fa-copy"></i> Copy',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="fas fa-file-csv"></i> CSV',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="fas fa-file-excel"></i> Excel',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="fas fa-file-pdf"></i> PDF',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="fas fa-print"></i> Print',
                    exportOptions: {
                        columns: ':visible'
                    }
                }
            ]
        },
        ajax: {
            "url": '/home/purchase-payment-dues',
            "data": function ( d ) {
                if ($('#purchase_payment_dues_location').length > 0) {
                    d.location_id = $('#purchase_payment_dues_location').val();
                }
            }
        },
        fnDrawCallback: function(oSettings) {
            __currency_convert_recursively($('#purchase_payment_dues_table'));
        },
    });

    $('#purchase_payment_dues_location').change( function(){
        purchase_payment_dues_table.ajax.reload();
    });

    //Sales dues datatables
    sales_payment_dues_table = $('#sales_payment_dues_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Bfrtip',
        buttons: {
            dom: {
                button: {
                    tag: 'button',
                    className: 'btn btn-sm btn-outline-secondary me-2',
                    active: 'active',
                    disabled: 'disabled'
                }
            },
            buttons: [
                {
                    extend: 'copy',
                    text: '<i class="fas fa-copy"></i> Copy',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="fas fa-file-csv"></i> CSV',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="fas fa-file-excel"></i> Excel',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="fas fa-file-pdf"></i> PDF',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="fas fa-print"></i> Print',
                    exportOptions: {
                        columns: ':visible'
                    }
                }
            ]
        },
        columns: [
            { data: 'customer', name: 'customer' },
            { data: 'invoice_no', name: 'invoice_no' },
            { data: 'due', name: 'due', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        ajax: {
            "url": '/home/sales-payment-dues',
            "data": function ( d ) {
                if ($('#sales_payment_dues_location').length > 0) {
                    d.location_id = $('#sales_payment_dues_location').val();
                }
            },
            "error": function(xhr, error, thrown) {
                console.error('DataTables Ajax error:', error);
                console.error('Response:', xhr.responseText);
            }
        },
        fnDrawCallback: function(oSettings) {
            __currency_convert_recursively($('#sales_payment_dues_table'));
        },
    });

    $('#sales_payment_dues_location').change( function(){
        sales_payment_dues_table.ajax.reload();
    });

    //Stock expiry report table
    stock_expiry_alert_table = $('#stock_expiry_alert_table').DataTable({
        processing: true,
        serverSide: true,
        searching: false,
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Bfrtip',
        buttons: {
            dom: {
                button: {
                    tag: 'button',
                    className: 'btn btn-sm btn-outline-secondary me-2',
                    active: 'active',
                    disabled: 'disabled'
                }
            },
            buttons: [
                {
                    extend: 'copy',
                    text: '<i class="fas fa-copy"></i> Copy',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="fas fa-file-csv"></i> CSV',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="fas fa-file-excel"></i> Excel',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="fas fa-file-pdf"></i> PDF',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="fas fa-print"></i> Print',
                    exportOptions: {
                        columns: ':visible'
                    }
                }
            ]
        },
        ajax: {
            url: '/reports/stock-expiry',
            data: function(d) {
                d.exp_date_filter = $('#stock_expiry_alert_days').val();
            },
        },
        order: [[3, 'asc']],
        columns: [
            { data: 'product', name: 'p.name' },
            { data: 'location', name: 'l.name' },
            { data: 'stock_left', name: 'stock_left' },
            { data: 'exp_date', name: 'exp_date' },
        ],
        fnDrawCallback: function(oSettings) {
            __show_date_diff_for_human($('#stock_expiry_alert_table'));
            __currency_convert_recursively($('#stock_expiry_alert_table'));
        },
    });

    if ($('#quotation_table').length) {
        quotation_datatable = $('#quotation_table').DataTable({
            processing: true,
            serverSide: true,
            fixedHeader:false,
            aaSorting: [[0, 'desc']],
            "ajax": {
                "url": '/sells/draft-dt?is_quotation=1',
                "data": function ( d ) {
                    if ($('#dashboard_location').length > 0) {
                        d.location_id = $('#dashboard_location').val();
                    }
                }
            },
            columnDefs: [ {
                "targets": 4,
                "orderable": false,
                "searchable": false
            } ],
            columns: [
                { data: 'transaction_date', name: 'transaction_date'  },
                { data: 'invoice_no', name: 'invoice_no'},
                { data: 'name', name: 'contacts.name'},
                { data: 'business_location', name: 'bl.name'},
                { data: 'action', name: 'action'}
            ]            
        });
    }

    // Load Top Customers and Products - Make it global
    window.loadTopCustomersAndProducts = function() {
        // Check if tables exist
        if ($('#top_customers_table').length === 0 || $('#top_products_table').length === 0) {
            console.log('Top customers/products tables not found');
            return;
        }

        var location_id = '';
        // Default to last 365 days to ensure we get data
        var start = moment().subtract(365, 'days').format('YYYY-MM-DD');
        var end = moment().format('YYYY-MM-DD');
        
        // Get location - prioritize Top Customers specific filter, then dashboard filter
        if ($('#top_customers_location').length > 0 && $('#top_customers_location').val()) {
            location_id = $('#top_customers_location').val();
        } else if ($('#dashboard_location').length > 0) {
            location_id = $('#dashboard_location').val();
        }
        
        // Get date range from daterangepicker - try multiple ways
        if ($('#dashboard_date_filter').length > 0) {
            try {
                var dateRange = $('#dashboard_date_filter').data('daterangepicker');
                if (dateRange && dateRange.startDate && dateRange.endDate) {
                    start = dateRange.startDate.format('YYYY-MM-DD');
                    end = dateRange.endDate.format('YYYY-MM-DD');
                } else {
                    // Try to get from the span text as fallback
                    var dateText = $('#dashboard_date_filter span').text();
                    if (dateText && dateText.includes('~')) {
                        var dates = dateText.split('~');
                        if (dates.length === 2 && typeof moment_date_format !== 'undefined') {
                            start = moment(dates[0].trim(), moment_date_format).format('YYYY-MM-DD');
                            end = moment(dates[1].trim(), moment_date_format).format('YYYY-MM-DD');
                        }
                    }
                }
            } catch(e) {
                console.warn('Could not get date range from daterangepicker:', e);
                // Keep default dates (last 365 days)
            }
        }

        console.log('Loading top customers/products with:', { location_id, start, end });

        // Load Top Customers
        $.ajax({
            url: '/home/top-customers',
            method: 'GET',
            data: {
                location_id: location_id || null,
                start: start,
                end: end
            },
            dataType: 'json',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                console.log('Top customers response:', response);
                var tbody = $('#top_customers_table tbody');
                if (tbody.length === 0) {
                    console.error('Top customers table tbody not found');
                    return;
                }
                
                tbody.empty();
                
                if (response && response.data && Array.isArray(response.data) && response.data.length > 0) {
                    $.each(response.data, function(index, customer) {
                        var rank = customer.rank || (index + 1);
                        var row = '<tr>' +
                            '<td>' + rank + '</td>' +
                            '<td>' + (customer.customer_name || 'N/A') + '</td>' +
                            '<td><span class="display_currency" data-currency_symbol="true">' + (customer.amount || 0) + '</span></td>' +
                            '</tr>';
                        tbody.append(row);
                    });
                    
                    if (typeof __currency_convert_recursively === 'function') {
                        __currency_convert_recursively($('#top_customers_table'));
                    }
                    console.log('Top customers loaded successfully:', response.data.length, 'records');
                } else {
                    tbody.append('<tr><td colspan="3" class="text-center">No data available</td></tr>');
                    console.log('No customer data in response');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error loading top customers:', {
                    status: status,
                    error: error,
                    responseText: xhr.responseText,
                    statusCode: xhr.status
                });
                var tbody = $('#top_customers_table tbody');
                if (tbody.length > 0) {
                    tbody.html('<tr><td colspan="3" class="text-center text-danger">Error loading data. Check console.</td></tr>');
                }
            }
        });

        // Load Top Products
        $.ajax({
            url: '/home/top-products',
            method: 'GET',
            data: {
                location_id: location_id || null,
                start: start,
                end: end
            },
            dataType: 'json',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                console.log('Top products response:', response);
                var tbody = $('#top_products_table tbody');
                if (tbody.length === 0) {
                    console.error('Top products table tbody not found');
                    return;
                }
                
                tbody.empty();
                
                if (response && response.data && Array.isArray(response.data) && response.data.length > 0) {
                    $.each(response.data, function(index, product) {
                        var rank = product.rank || (index + 1);
                        var row = '<tr>' +
                            '<td>' + rank + '</td>' +
                            '<td>' + (product.product_name || 'N/A') + '</td>' +
                            '<td><strong>' + parseFloat(product.quantity || 0).toFixed(2) + '</strong></td>' +
                            '</tr>';
                        tbody.append(row);
                    });
                    console.log('Top products loaded successfully:', response.data.length, 'records');
                } else {
                    tbody.append('<tr><td colspan="3" class="text-center">No data available</td></tr>');
                    console.log('No product data in response');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error loading top products:', {
                    status: status,
                    error: error,
                    responseText: xhr.responseText,
                    statusCode: xhr.status
                });
                var tbody = $('#top_products_table tbody');
                if (tbody.length > 0) {
                    tbody.html('<tr><td colspan="3" class="text-center text-danger">Error loading data. Check console.</td></tr>');
                }
            }
        });
    }

    // Load on page load - wait for everything to be ready
    setTimeout(function() {
        if (typeof loadTopCustomersAndProducts === 'function') {
            loadTopCustomersAndProducts();
        }
    }, 2500);

    // Reload when date or location changes
    $(document).on('daterangepicker-change', function(e, start, end) {
        setTimeout(function() {
            if (typeof loadTopCustomersAndProducts === 'function') {
                loadTopCustomersAndProducts();
            }
        }, 500);
    });

    // Also listen for location change
    $(document).on('change', '#dashboard_location', function() {
        setTimeout(function() {
            if (typeof loadTopCustomersAndProducts === 'function') {
                loadTopCustomersAndProducts();
            }
        }, 500);
    });

    // Listen for Top Customers specific location filter
    $(document).on('change', '#top_customers_location', function() {
        setTimeout(function() {
            if (typeof loadTopCustomersAndProducts === 'function') {
                loadTopCustomersAndProducts();
            }
        }, 300);
    });
});

// Function to update badge captions based on date range
function updateBadgeCaptions(start, end) {
    var startMoment = moment(start, 'YYYY-MM-DD');
    var endMoment = moment(end, 'YYYY-MM-DD');
    var today = moment();
    var yesterday = moment().subtract(1, 'day');
    
    var badgeText = '';
    
    // Get translations from LANG object if available, otherwise use English defaults
    var transToday = (typeof LANG !== 'undefined' && LANG['lang_v1.today']) ? LANG['lang_v1.today'] : 'Today';
    var transYesterday = (typeof LANG !== 'undefined' && LANG['lang_v1.yesterday']) ? LANG['lang_v1.yesterday'] : 'Yesterday';
    var transThisWeek = (typeof LANG !== 'undefined' && LANG['lang_v1.this_week']) ? LANG['lang_v1.this_week'] : 'This Week';
    var transLastWeek = (typeof LANG !== 'undefined' && LANG['lang_v1.last_week']) ? LANG['lang_v1.last_week'] : 'Last Week';
    var transThisMonth = (typeof LANG !== 'undefined' && LANG['lang_v1.this_month']) ? LANG['lang_v1.this_month'] : 'This Month';
    var transLastMonth = (typeof LANG !== 'undefined' && LANG['lang_v1.last_month']) ? LANG['lang_v1.last_month'] : 'Last Month';
    var transThisYear = (typeof LANG !== 'undefined' && LANG['lang_v1.this_year']) ? LANG['lang_v1.this_year'] : 'This Year';
    var transLastYear = (typeof LANG !== 'undefined' && LANG['lang_v1.last_year']) ? LANG['lang_v1.last_year'] : 'Last Year';
    
    // Check if it's today
    if (startMoment.isSame(today, 'day') && endMoment.isSame(today, 'day')) {
        badgeText = transToday;
    }
    // Check if it's yesterday
    else if (startMoment.isSame(yesterday, 'day') && endMoment.isSame(yesterday, 'day')) {
        badgeText = transYesterday;
    }
    // Check if it's a single day (not today or yesterday)
    else if (startMoment.isSame(endMoment, 'day')) {
        badgeText = startMoment.format('MMM DD, YYYY');
    }
    // Check if it's this week
    else if (startMoment.isSame(today.clone().startOf('week'), 'day') && 
             endMoment.isSame(today, 'day')) {
        badgeText = transThisWeek;
    }
    // Check if it's last week
    else if (startMoment.isSame(today.clone().subtract(1, 'week').startOf('week'), 'day') && 
             endMoment.isSame(today.clone().subtract(1, 'week').endOf('week'), 'day')) {
        badgeText = transLastWeek;
    }
    // Check if it's this month
    else if (startMoment.isSame(today.clone().startOf('month'), 'day') && 
             endMoment.isSame(today, 'day')) {
        badgeText = transThisMonth;
    }
    // Check if it's last month
    else if (startMoment.isSame(today.clone().subtract(1, 'month').startOf('month'), 'day') && 
             endMoment.isSame(today.clone().subtract(1, 'month').endOf('month'), 'day')) {
        badgeText = transLastMonth;
    }
    // Check if it's this year
    else if (startMoment.isSame(today.clone().startOf('year'), 'day') && 
             endMoment.isSame(today, 'day')) {
        badgeText = transThisYear;
    }
    // Default: show date range
    else {
        if (startMoment.format('YYYY') === endMoment.format('YYYY')) {
            // Same year, show shorter format
            badgeText = startMoment.format('MMM DD') + ' - ' + endMoment.format('MMM DD, YYYY');
        } else {
            // Different years, show full format
            badgeText = startMoment.format('MMM DD, YYYY') + ' - ' + endMoment.format('MMM DD, YYYY');
        }
    }
    
    // Update all metric badges that have data-update-date="true" attribute
    // This ensures we only update badges that should change with date filter
    $('.metric-badge[data-update-date="true"]').each(function() {
        var $badge = $(this);
        $badge.text(badgeText);
    });
    
    // Also update badges without the attribute but exclude static ones
    $('.metric-badge:not([data-update-date])').each(function() {
        var currentText = $(this).text().trim();
        var $badge = $(this);
        
        // Skip badges that should not be updated (static labels)
        if (currentText === 'vs Yesterday' || currentText === 'Total' || 
            currentText === 'vs Last Period' || currentText === 'All Time') {
            return; // Skip this badge
        }
        
        // Update all other badges (including date ranges that might have been set previously)
        // Check if it looks like a date range (contains " - " or month names)
        if (currentText.includes(' - ') || 
            currentText.match(/^(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)/i) ||
            currentText === 'Today' || currentText === 'Yesterday' ||
            currentText === 'This Week' || currentText === 'Last Week' ||
            currentText === 'This Month' || currentText === 'Last Month' ||
            currentText === 'This Year' || currentText === 'Last Year') {
            $badge.text(badgeText);
        }
    });
}

function update_statistics(start, end) {
    var location_id = '';
    if ($('#dashboard_location').length > 0) {
        location_id = $('#dashboard_location').val();
    }
    var data = { start: start, end: end, location_id: location_id };
    
    // Update badge captions first
    updateBadgeCaptions(start, end);
    
    //get purchase details
    var loader = '<i class="fas fa-sync fa-spin fa-fw margin-bottom"></i>';
    $('.total_purchase').html(loader);
    $('.purchase_due').html(loader);
    $('.total_sell').html(loader);
    $('.invoice_due').html(loader);
    $('.total_expense').html(loader);
    $('.total_purchase_return').html(loader);
    $('.total_sell_return').html(loader);
    $('.net').html(loader);
    $.ajax({
        method: 'get',
        url: '/home/get-totals',
        dataType: 'json',
        data: data,
        success: function(data) {
            //purchase details
            $('.total_purchase').html(__currency_trans_from_en(data.total_purchase, true));
            $('.purchase_due').html(__currency_trans_from_en(data.purchase_due, true));

            //sell details
            $('.total_sell').html(__currency_trans_from_en(data.total_sell, true));
            $('.invoice_due').html(__currency_trans_from_en(data.invoice_due, true));
            //expense details
            $('.total_expense').html(__currency_trans_from_en(data.total_expense, true));
            var total_purchase_return = data.total_purchase_return - data.total_purchase_return_paid;
            $('.total_purchase_return').html(__currency_trans_from_en(total_purchase_return, true));
            var total_sell_return_due = data.total_sell_return - data.total_sell_return_paid;
            $('.total_sell_return').html(__currency_trans_from_en(total_sell_return_due, true));
            $('.total_sr').html(__currency_trans_from_en(data.total_sell_return, true));
            $('.total_srp').html(__currency_trans_from_en(data.total_sell_return_paid, true));
            $('.total_pr').html(__currency_trans_from_en(data.total_purchase_return, true));
            $('.total_prp').html(__currency_trans_from_en(data.total_purchase_return_paid, true));
            $('.net').html(__currency_trans_from_en(data.net, true));

            // assign tooltip total_sell_return 
            var lang = $('#total_srp').data('value');
            var splitlang = lang.split('-');
            
            var newContent = "<p class='mb-0 text-muted fs-10 mt-5'>" + splitlang[0] + ": <span class=''>" + __currency_trans_from_en(data.total_sell_return, true) + "</span><br>" + splitlang[1] + ": <span class=''>" + __currency_trans_from_en(data.total_sell_return_paid, true) + "</span></p>";
            $('#total_srp').attr('data-content', newContent)
            // assign tooltip total_purchase_return 
            var lang = $('#total_prp').data('value');
            var splitlang = lang.split('-');
            
            var newContent = "<p class='mb-0 text-muted fs-10 mt-5'>" + splitlang[0] + ": <span class=''>" + __currency_trans_from_en(data.total_purchase_return, true) + "</span><br>" + splitlang[1] + ": <span class=''>" + __currency_trans_from_en(data.total_purchase_return_paid, true) + "</span></p>";
            
            $('#total_prp').attr('data-content', newContent);

        },
    });
}
