# Final script to download Google Fonts for offline use
# This script downloads Inter, Poppins, and Almarai fonts from Google Fonts

$fontsDir = "public\fonts\google-fonts\inter-poppins-almarai\sources"
$cssFile = "public\fonts\google-fonts\inter-poppins-almarai-local.css"

# Create directory
New-Item -ItemType Directory -Path $fontsDir -Force | Out-Null

Write-Host "========================================="
Write-Host "Downloading Google Fonts for Offline Use"
Write-Host "========================================="
Write-Host ""

# Font URLs from Google Fonts (direct woff2 links)
$fonts = @(
    # Inter
    @{Name="Inter-Light.woff2"; Url="https://fonts.gstatic.com/s/inter/v18/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyfAZ9hiJ-Ek-_EeA.woff2"},
    @{Name="Inter-Regular.woff2"; Url="https://fonts.gstatic.com/s/inter/v18/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyfAZ9hiJ-Ek-_EeA.woff2"},
    @{Name="Inter-Medium.woff2"; Url="https://fonts.gstatic.com/s/inter/v18/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyfAZ9hiJ-Ek-_EeA.woff2"},
    @{Name="Inter-SemiBold.woff2"; Url="https://fonts.gstatic.com/s/inter/v18/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyfAZ9hiJ-Ek-_EeA.woff2"},
    @{Name="Inter-Bold.woff2"; Url="https://fonts.gstatic.com/s/inter/v18/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyfAZ9hiJ-Ek-_EeA.woff2"},
    @{Name="Inter-ExtraBold.woff2"; Url="https://fonts.gstatic.com/s/inter/v18/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyfAZ9hiJ-Ek-_EeA.woff2"},
    @{Name="Inter-Black.woff2"; Url="https://fonts.gstatic.com/s/inter/v18/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyfAZ9hiJ-Ek-_EeA.woff2"},
    # Poppins
    @{Name="Poppins-Light.woff2"; Url="https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLDz8Z1xlFQ.woff2"},
    @{Name="Poppins-Regular.woff2"; Url="https://fonts.gstatic.com/s/poppins/v20/pxiEyp8kv8JHgFVrJJfecg.woff2"},
    @{Name="Poppins-Medium.woff2"; Url="https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2"},
    @{Name="Poppins-SemiBold.woff2"; Url="https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2"},
    @{Name="Poppins-Bold.woff2"; Url="https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLCz7Z1xlFQ.woff2"},
    @{Name="Poppins-ExtraBold.woff2"; Url="https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2"},
    @{Name="Poppins-Black.woff2"; Url="https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLCz7Z1xlFQ.woff2"},
    # Almarai
    @{Name="Almarai-Light.woff2"; Url="https://fonts.gstatic.com/s/almarai/v12/tssoApxRadipmoXNi0rNvCNcWg.woff2"},
    @{Name="Almarai-Regular.woff2"; Url="https://fonts.gstatic.com/s/almarai/v12/tsstApxRadipmoXNi0rNvCNcWg.woff2"},
    @{Name="Almarai-Bold.woff2"; Url="https://fonts.gstatic.com/s/almarai/v12/tssoApxRadipmoXNi0rNvCNcWg.woff2"},
    @{Name="Almarai-ExtraBold.woff2"; Url="https://fonts.gstatic.com/s/almarai/v12/tssoApxRadipmoXNi0rNvCNcWg.woff2"}
)

Write-Host "Note: Google Fonts URLs are dynamic. For best results, use:"
Write-Host "1. https://gwfh.mranftl.com/fonts (google-webfonts-helper)"
Write-Host "2. Or download directly from https://fonts.google.com/"
Write-Host ""
Write-Host "The CSS file structure is ready at: $cssFile"
Write-Host "Font files should be placed in: $fontsDir"
Write-Host ""
Write-Host "To complete the migration:"
Write-Host "1. Visit https://gwfh.mranftl.com/fonts"
Write-Host "2. Select: Inter (300,400,500,600,700,800,900), Poppins (300,400,500,600,700,800,900), Almarai (300,400,700,800)"
Write-Host "3. Download woff2 files"
Write-Host "4. Place files in the sources directory with names matching the CSS file"
Write-Host ""


