<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stock_movements', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            $table->integer('product_id')->unsigned();
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->integer('variation_id')->unsigned();
            $table->foreign('variation_id')->references('id')->on('variations')->onDelete('cascade');
            $table->integer('warehouse_id')->unsigned();
            $table->foreign('warehouse_id')->references('id')->on('warehouses')->onDelete('cascade');
            $table->enum('type', [
                'purchase',
                'sale',
                'opening_stock',
                'adjustment',
                'transfer_in',
                'transfer_out',
                'return',
                'production',
                'expiry',
                'damage',
                'other'
            ]);
            $table->decimal('quantity', 22, 4)->comment('Positive for increase, negative for decrease');
            $table->decimal('qty_before', 22, 4)->default(0);
            $table->decimal('qty_after', 22, 4)->default(0);
            $table->string('reference_type')->nullable()->comment('Model class name (Transaction, StockAdjustment, etc.)');
            $table->integer('reference_id')->nullable()->comment('ID of the reference model');
            $table->string('reference_no')->nullable()->comment('Human-readable reference (invoice_no, etc.)');
            $table->text('notes')->nullable();
            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->timestamp('movement_date');
            $table->timestamps();

            //Indexing
            $table->index('business_id');
            $table->index('product_id');
            $table->index('variation_id');
            $table->index('warehouse_id');
            $table->index('type');
            $table->index('reference_type');
            $table->index(['reference_type', 'reference_id']);
            $table->index('movement_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_movements');
    }
};

