<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(){

        Schema::table('purchase_lines', function (Blueprint $table) {
            $table->enum('line_discount_type', ['fixed', 'percentage'])->nullable()->after('tax_id');
            $table->decimal('line_discount_amount', 22, 4)->default(0)->after('line_discount_type');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('purchase_lines', function (Blueprint $table) {
            //
        });
    }
};
