<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(){

        Schema::create('serial_numbers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('business_id')->nullable();
            $table->integer('location_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->integer('variation_id')->unsigned();
            $table->string('serial_number');
            $table->string('purchase_status')->default('received');
            $table->string('stock_status')->default('available');
            $table->bigInteger('transaction_id')->nullable();
            $table->string('serial_purchase_code')->nullable();
            $table->integer('is_return')->nullable();
            $table->integer('is_p_return')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(){

        Schema::dropIfExists('serial_numbers');

    }

};
