<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateModuleLicensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('module_licenses')) {
            Schema::create('module_licenses', function (Blueprint $table) {
                $table->increments('id');
                $table->string('module_name', 100)->index();
                $table->string('license_code', 100)->unique();
                $table->string('username', 100);
                $table->string('email', 100)->nullable();
                $table->enum('license_type', ['single', 'multi', 'unlimited'])->default('single');
                $table->date('expiry_date')->nullable();
                $table->enum('status', ['active', 'inactive', 'expired', 'revoked'])->default('active');
                $table->text('notes')->nullable();
                $table->timestamps();

                $table->index(['module_name', 'license_code']);
                $table->index(['module_name', 'username']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('module_licenses');
    }
}

