<?php

namespace App\Utils;

class ColorUtil
{
    /**
     * Convert hex color to RGB string
     *
     * @param string $hex Hex color code (with or without #)
     * @return string RGB string format: "r, g, b"
     */
    public static function hex2rgb($hex)
    {
        $hex = str_replace('#', '', $hex);
        
        if (strlen($hex) == 3) {
            $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
            $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
            $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
        } else {
            $r = hexdec(substr($hex, 0, 2));
            $g = hexdec(substr($hex, 2, 2));
            $b = hexdec(substr($hex, 4, 2));
        }
        
        return "$r, $g, $b";
    }

    /**
     * Adjust brightness of hex color
     *
     * @param string $hex Hex color code (with or without #)
     * @param int $steps Steps to adjust (-255 to 255, negative = darker, positive = lighter)
     * @return string Hex color code with #
     */
    public static function adjustBrightness($hex, $steps)
    {
        $hex = str_replace('#', '', $hex);
        
        if (strlen($hex) == 3) {
            $hex = substr($hex, 0, 1) . substr($hex, 0, 1) . 
                   substr($hex, 1, 1) . substr($hex, 1, 1) . 
                   substr($hex, 2, 1) . substr($hex, 2, 1);
        }
        
        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));
        
        $r = max(0, min(255, $r + $steps));
        $g = max(0, min(255, $g + $steps));
        $b = max(0, min(255, $b + $steps));
        
        return sprintf("#%02x%02x%02x", $r, $g, $b);
    }
}



