<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreatePosSaleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $business_id = $this->session()->get('user.business_id');
        $moduleUtil = app(\App\Utils\ModuleUtil::class);

        return auth()->user()->can('superadmin') ||
               auth()->user()->can('sell.create') ||
               auth()->user()->can('direct_sell.access') ||
               auth()->user()->can('so.create') ||
               ($moduleUtil->hasThePermissionInSubscription($business_id, 'repair_module') &&
                auth()->user()->can('repair.create'));
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'sub_type' => 'nullable|string|max:255',
            'job_sheet_id' => 'nullable|integer|exists:repair_job_sheets,id',
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'job_sheet_id.exists' => 'The selected job sheet does not exist.',
        ];
    }
}

