<?php

namespace App\Http;

use Nwidart\Menus\Presenters\Presenter;

class AdminlteCustomPresenter extends Presenter
{
    /**
     * {@inheritdoc}.
     */
    public function getOpenTagWrapper()
    {
        return '<nav role="navigation" aria-label="Main navigation" class="tw-flex-1 tw-p-3 tw-space-y-1 tw-overflow-y-auto tw-overflow-x-hidden" id="side-bar">' . PHP_EOL;
    }

    /**
     * {@inheritdoc}.
     */
    public function getCloseTagWrapper()
    {
        return '</nav>' . PHP_EOL;
    }

    /**
     * {@inheritdoc}.
     */
    public function getMenuWithoutDropdownWrapper($item)
    
    {
        $activeClass = $item->isActive() ? ' active-menu-item' : '';
        $ariaLabel = $item->title . ($item->isActive() ? ' (Current Page)' : '');
        return '<a style="height:2.75rem; font-size: 15px;'. $this->getActiveStateStyle($item) .'" href="' . $item->getUrl() . '" title="' . htmlspecialchars($item->title) . '" aria-label="' . htmlspecialchars($ariaLabel) . '" role="menuitem" ' . ($item->isActive() ? 'aria-current="page"' : '') . ' class="tw-flex tw-items-center tw-gap-3 tw-px-3 tw-py-2 tw-font-medium tw-tracking-tight tw-transition-all tw-duration-300 tw-rounded-lg tw-whitespace-nowrap custom-hover menu-item-parent' . $activeClass . '" ' . $item->getAttributes() . '>' .
        '<span class="tw-flex-shrink-0 tw-w-5 tw-h-5 tw-flex tw-items-center tw-justify-center" aria-hidden="true">' . $this->formatIcon($item->icon) . '</span>' .
        '<span class="tw-flex-1 tw-min-w-0 tw-overflow-hidden tw-text-ellipsis tw-font-medium">' . htmlspecialchars($item->title) . '</span>' .
            '</a>' . PHP_EOL;
    }

    /**
     * {@inheritdoc}.
     */
    public function getActiveState($item, $state = ' ')
    {
        return $item->isActive() ? $state : null;
    }

    public function getActiveStateStyle($item, $state = '')
    {
        return $item->isActive() ? $state : null;
    }

    /**
     * Get active state on child items.
     *
     * @param $item
     * @param  string  $state
     * @return null|string
     */
    public function getActiveStateOnChild($item, $state = 'tw-pb-1 tw-rounded-md tw-text-primary-700')
    {
        return $item->hasActiveOnChild() ? $state : null;
    }

    /**
     * {@inheritdoc}.
     */
    public function getDividerWrapper()
    {
        // Assuming a divider is just a visual space in this design
        return '<div class="tw-my-2"></div>';
    }

    /**
     * {@inheritdoc}.
     */
    public function getHeaderWrapper($item)
    {
        return '<div class="tw-px-3 tw-py-2 tw-text-xs tw-font-semibold tw-uppercase tw-tracking-wider">' . $item->title . '</div>';
    }

    /**
     * {@inheritdoc}.
     */
    public function getMenuWithDropDownWrapper($item)
    {
        $activeClass = $item->hasActiveOnChild() ? ' active-menu-item' : '';
        $isExpanded = $item->hasActiveOnChild() ? 'true' : 'false';
        $ariaLabel = $item->title . ' menu' . ($item->hasActiveOnChild() ? ' (expanded)' : ' (collapsed)');
        $dropdownToggle = '<a href="#" title="' . htmlspecialchars($item->title) . '" aria-label="' . htmlspecialchars($ariaLabel) . '" aria-expanded="' . $isExpanded . '" aria-haspopup="true" role="menuitem" style="height:2.75rem; font-size: 15px;" class="drop_down tw-flex tw-items-center tw-gap-3 tw-px-3 tw-py-2 tw-font-medium tw-tracking-tight tw-transition-all tw-duration-300 tw-rounded-lg tw-whitespace-nowrap custom-hover menu-item-parent' . $activeClass . '" ' . $item->getAttributes() . '>' .
        '<span class="tw-flex-shrink-0 tw-w-5 tw-h-5 tw-flex tw-items-center tw-justify-center" aria-hidden="true">' . $this->formatIcon($item->icon) . '</span>' .
        '<span class="tw-flex-1 tw-min-w-0 tw-overflow-hidden tw-text-ellipsis tw-font-medium">' . htmlspecialchars($item->title) . '</span>' .
        '<svg aria-hidden="true" class="svg tw-flex-shrink-0 tw-ml-auto tw-w-4 tw-h-4 tw-transition-transform tw-duration-300" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">' . $this->getArray($item) .
            '</svg>' .
            '</a>';

        $childItemsContainerStart = '';

        $childItemsContainerEnd = '';

        // Compile child menu items
        $childItems = $this->getChildMenuItems($item);

        return '<div class="menu-dropdown-wrapper tw-relative tw-mb-1' . ($item->hasActiveOnChild() ? ' menu-parent-active' : '') . '">' . $dropdownToggle . $childItemsContainerStart . $childItems . $childItemsContainerEnd . '</div>' . PHP_EOL;
    }

    /**
     * Get multi-level dropdown wrapper.
     *
     * Note: This example doesn't directly implement a multi-level dropdown, as it wasn't specified, but you could extend
     * the functionality similarly to `getMenuWithDropDownWrapper`, adjusting for deeper nesting.
     *
     * @param  \Nwidart\Menus\MenuItem  $item
     * @return string
     */
    public function getMultiLevelDropdownWrapper($item)
    {
        // Placeholder for multi-level dropdown functionality if needed
        return '';
    }

    /**
     * Get child menu items.
     *
     * @param  \Nwidart\Menus\MenuItem  $item
     * @return string
     */
    public function getChildMenuItems($item)
    {

        $children = '';
        $displayStyle = $item->hasActiveOnChild() ? 'block' : 'none';

        


        if (count($item->getChilds()) > 0) {
            
            $children .= '<div class="chiled tw-relative tw-mt-2 tw-mb-3" style="display:' . $displayStyle . '; padding-left: 2.5rem;">
            <!-- Professional Tree Line: Vertical line connecting all submenu items -->
            <div class="tree-line-vertical tw-absolute tw-inset-y-0 tw-w-0.5 tw-h-full tw-left-6" style="background: linear-gradient(to bottom, rgba(99, 102, 241, 0.35) 0%, rgba(99, 102, 241, 0.28) 20%, rgba(99, 102, 241, 0.25) 50%, rgba(99, 102, 241, 0.28) 80%, rgba(99, 102, 241, 0.35) 100%);"></div>
            <!-- Professional Tree Line: Horizontal connector from main menu -->
            <div class="tree-line-horizontal tw-absolute tw-top-0 tw-left-6 tw-w-5 tw-h-0.5" style="background: linear-gradient(to right, rgba(99, 102, 241, 0.35) 0%, rgba(99, 102, 241, 0.3) 50%, rgba(99, 102, 241, 0.25) 100%);"></div>
            <div class="tw-space-y-1.5">';

            foreach ($item->getChilds() as $child) {
                // Skip empty child menu items to prevent blank spaces with active indicators
                if (empty(trim($child->title))) {
                    continue;
                }

                $isActive = $child->isActive() ? 'child-menu-active' : '';
                $activeClass = $child->isActive() ? ' active-child-item' : '';

                $childAriaLabel = $child->title . ($child->isActive() ? ' (Current Page)' : '');
                $children .= '<a href="' . $child->getUrl() . '" title="' . htmlspecialchars($child->title) . '" aria-label="' . htmlspecialchars($childAriaLabel) . '" role="menuitem" ' . ($child->isActive() ? 'aria-current="page"' : '') . ' style="font-size: 14px; padding-left: 10px !important;" class="tw-flex tw-items-center tw-gap-2 tw-font-medium tw-tracking-tight tw-transition-all tw-duration-300 tw-whitespace-nowrap menu-item-child ' . $isActive . $activeClass . '" ' . $child->getAttributes() . '>' .
                '<span class="tw-flex-shrink-0 tw-w-5 tw-h-5 tw-flex tw-items-center tw-justify-center" aria-hidden="true">' . $this->formatIcon($child->icon) . '</span>' .
                '<span class="tw-flex-1 tw-min-w-0 tw-overflow-hidden tw-text-ellipsis tw-font-normal">' . htmlspecialchars($child->title) . '</span>' .
                    '</a>' . PHP_EOL;
            }

            $children .= '</div></div>';
        }

        return $children;
    }

    /**
     * Returns the icon HTML. If the icon is SVG, it returns directly; otherwise, it assumes it's a FontAwesome class and wraps it in an <i> tag.
     *
     * @param string $icon
     * @return string
     */
    protected function formatIcon($icon)
    {
        if (empty($icon)) {
            return '<span class="tw-w-5 tw-h-5"></span>'; // Return empty spacer if no icon
        }
        // Check if the icon string contains "<svg", indicating it's an SVG icon
        if (strpos($icon, '<svg') !== false) {
            return $icon; // Return the SVG icon directly
        } else {
            // Assume it's a FontAwesome icon and return it wrapped in an <i> tag
            return '<i class="' . $icon . '"></i>';
        }
    }

    public function getArray($item)
    {
        if ($item->hasActiveOnChild()) {
            return '<path stroke="none" d="M0 0h24v24H0z" fill="none" /><path d="M6 9l6 6l6 -6" />';
        } else {
            return '<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
            <path d="M15 6l-6 6l6 6" />';
        }
    }
}


