# Server Configuration Checklist for dev.posifyme.com

## ✅ Required PHP Extensions

### 1. **PDO (PHP Data Objects)**
- **Status:** ❌ **NOT INSTALLED** (causing current error)
- **Required for:** Database connections
- **Install:** `php8.2-pdo` or `php-pdo`

### 2. **PDO MySQL**
- **Status:** ❌ **NOT INSTALLED** (needed for MySQL)
- **Required for:** MySQL/MariaDB connections
- **Install:** `php8.2-mysql` or `php-mysql`

### 3. **Other Required Extensions** (Verify these are installed)
- ✅ `curl` - For HTTP requests
- ✅ `json` - For JSON encoding/decoding
- ✅ `mbstring` - For string manipulation
- ✅ `openssl` - For SSL/TLS
- ✅ `xml` - For XML parsing
- ✅ `zip` - For file compression

## 🔧 Installation Commands

### Ubuntu/Debian:
```bash
sudo apt-get update
sudo apt-get install php8.2-pdo php8.2-mysql php8.2-curl php8.2-json php8.2-mbstring php8.2-openssl php8.2-xml php8.2-zip
```

### CentOS/RHEL:
```bash
sudo yum install php-pdo php-mysql php-curl php-json php-mbstring php-openssl php-xml php-zip
```

## ✅ Verification Script

Create `check_php_extensions.php` on server:

```php
<?php
$required = [
    'pdo' => 'PDO (PHP Data Objects)',
    'pdo_mysql' => 'PDO MySQL',
    'curl' => 'cURL',
    'json' => 'JSON',
    'mbstring' => 'mbstring',
    'openssl' => 'OpenSSL',
    'xml' => 'XML',
    'zip' => 'ZIP'
];

echo "=== PHP Extensions Check ===\n";
echo "PHP Version: " . phpversion() . "\n\n";

foreach ($required as $ext => $name) {
    $status = extension_loaded($ext) ? '✓' : '✗';
    echo "{$status} {$name} (" . ($status === '✓' ? 'INSTALLED' : 'MISSING') . ")\n";
}

echo "\n=== Database Connection Test ===\n";
if (extension_loaded('pdo') && extension_loaded('pdo_mysql')) {
    try {
        // Test connection (update credentials)
        $pdo = new PDO('mysql:host=localhost', 'root', '');
        echo "✓ PDO Connection: Working\n";
    } catch (Exception $e) {
        echo "✗ PDO Connection: " . $e->getMessage() . "\n";
    }
} else {
    echo "✗ PDO extensions not loaded\n";
}
```

**Run:**
```bash
php check_php_extensions.php
```

## 🚀 After Installation

1. **Restart Web Server:**
   ```bash
   # Apache
   sudo systemctl restart apache2
   
   # Nginx + PHP-FPM
   sudo systemctl restart php8.2-fpm
   sudo systemctl restart nginx
   ```

2. **Clear Laravel Caches:**
   ```bash
   cd /var/www/html
   php artisan config:clear
   php artisan cache:clear
   php artisan route:clear
   ```

3. **Test API Endpoint:**
   ```bash
   curl https://dev.posifyme.com/api/license/validate
   ```

## 📝 Current Error

**Error:** `Class 'PDO' not found`
**Location:** `AppServiceProvider:137 boot`
**Cause:** PDO extension not installed/enabled
**Fix:** Install and enable PDO extension (see above)

## ✅ Success Criteria

After fixing:
- ✅ No "Class 'PDO' not found" error
- ✅ API endpoint returns JSON responses
- ✅ Database connections work
- ✅ Module installation works

**This is a server configuration issue that must be fixed by the server administrator.**

