<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your module. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['setData', 'auth', 'SetSessionData', 'language', 'timezone', 'AdminSidebarMenu', 'CheckUserLogin'])->prefix('stock-recalculation')->name('stock-recalculation.')->group(callback: function () {


    // Main interface
    Route::get('/', 'StockRecalculationController@index')->name('index');

    // AJAX endpoints
    Route::post('/verify', 'StockRecalculationController@verify')->name('verify');
    Route::post('/backup', 'StockRecalculationController@backup')->name('backup');
    Route::post('/start-recalculation', 'StockRecalculationController@startRecalculation')->name('start-recalculation');
    Route::post('/process-batch', 'StockRecalculationController@processBatch')->name('process-batch');
    Route::get('/progress', 'StockRecalculationController@getProgress')->name('progress');
    Route::post('/cancel-recalculation', 'StockRecalculationController@cancelRecalculation')->name('cancel-recalculation');
    Route::get('/summary', 'StockRecalculationController@getSummary')->name('summary');
    Route::get('/debug-calculation', 'StockRecalculationController@debugCalculation')->name('debug-calculation');
    Route::get('/test-calculation', 'StockRecalculationController@testCalculationMethods')->name('test-calculation');
    Route::get('/test-new-calculation', 'StockRecalculationController@testCalculation')->name('test-new-calculation');
    Route::get('/sample-variations', 'StockRecalculationController@getSampleVariations')->name('sample-variations');
    Route::get('/check-statuses', 'StockRecalculationController@checkTransactionStatuses')->name('check-statuses');

    // Utility endpoints
    Route::get('/locations/{business_id}', 'StockRecalculationController@getLocations')->name('locations');
});

// Installation routes
Route::middleware(['web', 'auth'])->prefix('stock-recalculation/install')->name('stock-recalculation.install.')->group(function () {
    Route::get('/', 'InstallController@index')->name('index');
    Route::get('/update', 'InstallController@update')->name('update');
    Route::get('/uninstall', 'InstallController@uninstall')->name('uninstall');
});