<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your module. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->prefix('stock-recalculation')->name('api.stock-recalculation.')->group(function() {
    Route::get('/summary', 'StockRecalculationController@getSummary')->name('summary');
    Route::post('/verify', 'StockRecalculationController@verify')->name('verify');
    Route::post('/backup', 'StockRecalculationController@backup')->name('backup');
    Route::post('/recalculate', 'StockRecalculationController@recalculate')->name('recalculate');
});