@if($type === 'verification')
@if(count($data) > 0)
<div class="alert alert-warning">
    <strong><i class="fa fa-exclamation-triangle"></i> {{ __('stockrecalculation::lang.discrepancies_found', ['count' =>
        count($data)]) }}</strong>
</div>

<div class="table-responsive">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>{{ __('stockrecalculation::lang.business_id') }}</th>
                <th>{{ __('stockrecalculation::lang.location_name') }}</th>
                <th>{{ __('stockrecalculation::lang.product_name') }}</th>
                <th>{{ __('stockrecalculation::lang.variation_name') }}</th>
                <th>{{ __('stockrecalculation::lang.current_qty') }}</th>
                <th>{{ __('stockrecalculation::lang.calculated_qty') }}</th>
                <th>{{ __('stockrecalculation::lang.difference') }}</th>
                <th>{{ __('stockrecalculation::lang.status') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($data as $row)
            <tr class="{{ abs($row->difference) > 10 ? 'danger' : (abs($row->difference) > 1 ? 'warning' : 'info') }}">
                <td>{{ $row->business_id }}</td>
                <td>{{ $row->location_name }}</td>
                <td>{{ $row->product_name }}</td>
                <td>{{ $row->variation_name ?: '--' }}</td>
                <td>{{ number_format($row->current_qty, session('business.quantity_precision', 2)) }}</td>
                <td>{{ number_format($row->calculated_qty, session('business.quantity_precision', 2)) }}</td>
                <td class="{{ $row->difference > 0 ? 'text-red' : 'text-green' }}">
                    {{ number_format($row->difference, session('business.quantity_precision', 2)) }}
                </td>
                <td>
                    @if(abs($row->difference) > 10)
                    <span class="label label-danger">{{ __('stockrecalculation::lang.critical') }}</span>
                    @elseif(abs($row->difference) > 1)
                    <span class="label label-warning">{{ __('stockrecalculation::lang.high') }}</span>
                    @else
                    <span class="label label-info">{{ __('stockrecalculation::lang.low') }}</span>
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="callout callout-info">
            <h4 class="text-white">{{ __('brand.note') }}:</h4>
            <ul>
                <li><strong>{{ __('stockrecalculation::lang.current_qty') }}:</strong> {{
                    __('stockrecalculation::lang.current_qty_note') }}</li>
                <li><strong>{{ __('stockrecalculation::lang.calculated_qty') }}:</strong> {{
                    __('stockrecalculation::lang.calculated_qty_note') }}</li>
                <li><strong>{{ __('stockrecalculation::lang.difference') }}:</strong> {{
                    __('stockrecalculation::lang.difference_note') }}</li>
                <li><strong>{{ __('stockrecalculation::lang.critical') }}:</strong> {{
                    __('stockrecalculation::lang.critical_note') }}</li>
                <li><strong>{{ __('stockrecalculation::lang.high') }}:</strong> {{
                    __('stockrecalculation::lang.high_note') }}</li>
                <li><strong>{{ __('stockrecalculation::lang.low') }}:</strong> {{
                    __('stockrecalculation::lang.low_note') }}</li>
            </ul>
        </div>
    </div>
</div>

@if(!empty($filters))
<div class="alert alert-info">
    <strong>{{ __('stockrecalculation::lang.applied_filters') }}:</strong>
    @if(!empty($filters['business_id']))
    {{ __('stockrecalculation::lang.business_id') }}: {{ $filters['business_id'] }}
    @endif
    @if(!empty($filters['location_id']))
    | {{ __('lang_v1.location_id') }}: {{ $filters['location_id'] }}
    @endif
    @if(!empty($filters['product_id']))
    | {{ __('stockrecalculation::lang.product_id') }}: {{ $filters['product_id'] }}
    @endif
</div>
@endif

@else
<div class="alert alert-success">
    <i class="fa fa-check"></i> <strong>{{ __('stockrecalculation::lang.no_discrepancies') }}</strong>
</div>

@if(!empty($filters))
<div class="alert alert-info">
    <strong>{{ __('stockrecalculation::lang.checked_with_filters') }}:</strong>
    @if(!empty($filters['business_id']))
    {{ __('stockrecalculation::lang.business_id') }}: {{ $filters['business_id'] }}
    @endif
    @if(!empty($filters['location_id']))
    | {{ __('lang_v1.location_id') }}: {{ $filters['location_id'] }} |
    @endif
    @if(!empty($filters['product_id']))
    | {{ __('stockrecalculation::lang.product_id') }}: {{ $filters['product_id'] }}
    @endif
</div>
@endif
@endif
@endif

@if($type === 'recalculation_result')
<div class="alert alert-success">
    <i class="fa fa-check"></i> <strong>{{ __('stockrecalculation::lang.recalculation_complete', ['count' =>
        $data['updated_count']]) }}</strong>
</div>
@endif

<div class="row">
    <div class="col-md-12">
        <button type="button" class="tw-dw-btn tw-dw-btn-neutral tw-text-white" onclick="$('#results-box').hide();">
            <i class="fa fa-times"></i> {{ __('stockrecalculation::lang.close_results') }}
        </button>

        @if($type === 'verification' && count($data) > 0)
        <button type="button" class="tw-dw-btn tw-dw-btn-primary tw-text-white pull-right" onclick="window.print();">
            <i class="fa fa-print"></i> {{ __('stockrecalculation::lang.print_report') }}
        </button>
        @endif
    </div>
</div>