<?php

return [
    // Module Info
    'stock_recalculation_module' => 'Stock Recalculation Module',
    'stock_recalculation' => 'Stock Recalculation',
    'stock_integrity' => 'Stock Integrity',
    'module_description' => 'Professional stock integrity management with automated recalculation, verification, and backup functionality',

    // Permissions
    'view_stock_recalculation' => 'View Stock Recalculation',
    'manage_stock_recalculation' => 'Manage Stock Recalculation',
    'backup_stock_data' => 'Backup Stock Data',
    'recalculate_stock' => 'Recalculate Stock Quantities',
    'audit_stock_integrity' => 'Audit Stock Integrity',
    'export_reports' => 'Export Reports',

    // Interface
    'dashboard' => 'Dashboard',
    'integrity_audit' => 'Integrity Audit',
    'filters' => 'Filters',
    'actions' => 'Actions',
    'results' => 'Results',
    'progress' => 'Progress',
    'total_products' => 'Total Products',
    'discrepancies' => 'Discrepancies',
    'critical_issues' => 'Critical Issues',
    'avg_difference' => 'Avg Difference',

    // Status Messages
    'installation_success' => 'Stock Recalculation module installed successfully!',
    'update_success' => 'Stock Recalculation module updated successfully!',
    'uninstall_success' => 'Stock Recalculation module uninstalled successfully!',

    // Warnings
    'backup_warning' => 'Stock recalculation will modify your database. Always create a backup before proceeding!',
    'unauthorized' => 'Unauthorized access to Stock Recalculation',

    // Results
    'no_discrepancies' => 'Excellent! No stock discrepancies found. All stock quantities are accurate.',
    'discrepancies_found' => 'Found :count stock discrepancies that need fixing. These records have differences between stored and calculated quantities.',
    'recalculation_complete' => 'Recalculation Complete! :count stock records have been updated.',

    // Filters
    'all_businesses' => 'All Businesses',
    'all_locations' => 'All Locations',
    'business' => 'Business',
    'location' => 'Location',
    'product_id' => 'Product ID',
    'enter_product_id' => 'Enter Product ID',

    // Table Headers
    'business_id' => 'Business ID',
    'location_name' => 'Location',
    'product_name' => 'Product',
    'variation_name' => 'Variation',
    'current_qty' => 'Current Qty',
    'calculated_qty' => 'Calculated Qty',
    'difference' => 'Difference',
    'status' => 'Status',

    // Status Labels
    'critical' => 'Critical',
    'high' => 'High',
    'low' => 'Low',

    // Steps
    'step_1' => '1. Verify Discrepancies',
    'step_2' => '2. Create Backup',
    'step_3' => '3. Recalculate',
    'step_4' => '4. Verify Again',

    'step_1_desc' => 'Check which records need fixing',
    'step_2_desc' => 'Backup current stock data',
    'step_3_desc' => 'Fix the stock quantities',
    'step_4_desc' => 'Confirm fixes worked',

    // Messages
    'processing' => 'Processing...',
    'backup_created' => 'Backup created successfully',
    'close_results' => 'Close Results',
    'print_report' => 'Print Report',

    // Errors
    'error' => 'Error',
    'backup_required' => 'Backup Required',
    'backup_required_info' => 'Please create a backup first before running recalculation.',
    'backup_failed' => 'Backup creation failed',
    'recalculation_failed' => 'Stock recalculation failed',
    'batch_failed' => 'Batch processing failed',

    // Note
    'applied_filters' => 'Applied Filters',
    'checked_with_filters' => 'Checked with filters',
    'current_qty_note' => 'Quantity stored in database',
    'calculated_qty_note' => 'Quantity calculated from transactions',
    'difference_note' => 'Current minus Calculated (positive = overstocked, negative = understocked)',
    'critical_note' => 'Difference > 10 units',
    'high_note' => 'Difference > 1 unit',
    'low_note' => 'Difference ≤ 1 unit',

    // Alert
    'checking_for_discrepancies' => 'Checking for stock discrepancies...',
    'create_backup' => 'Create backup',
    'create_backup_info' => 'Create backup of current stock data? This will create a backup table and process data in batches to prevent timeouts. Recommended before any recalculation.',
    'creating_backup' => 'Creating backup...',
    'start_batch_recalculation' => 'Start Batch Recalculation',
    'start_batch_recalculation_info' => 'This will recalculate stock quantities in batches (100 records at a time), show real-time progress and allow cancellation if needed. This process may take several minutes for large datasets.',
    'batch_processing' => 'Batch Processing',
    'recalculation_completed_successfully' => 'Recalculation completed successfully!',
    'cancel_recalculation' => 'Cancel Recalculation',
    'cancel_recalculation_info' => 'Are you sure you want to cancel? The recalculation process will be stopped immediately. Partial progress will be saved.',
    'recalculation_cancelled' => 'Recalculation has been cancelled successfully.',
];