<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        try{ DB::statement('CREATE INDEX IF NOT EXISTS idx_pl_variation ON purchase_lines (variation_id)'); }catch(\Throwable $e){}
        try{ DB::statement('CREATE INDEX IF NOT EXISTS idx_t_business_type_loc ON transactions (business_id, type, location_id)'); }catch(\Throwable $e){}
        try{ DB::statement('CREATE INDEX IF NOT EXISTS idx_tsl_variation ON transaction_sell_lines (variation_id)'); }catch(\Throwable $e){}
        try{ DB::statement('CREATE INDEX IF NOT EXISTS idx_sal_variation ON stock_adjustment_lines (variation_id)'); }catch(\Throwable $e){}
        try{ DB::statement('CREATE INDEX IF NOT EXISTS idx_vld_vl ON variation_location_details (variation_id, location_id)'); }catch(\Throwable $e){}

        DB::statement('DROP VIEW IF EXISTS vw_vld_vs_calculated');
        DB::statement(<<<SQL
CREATE VIEW vw_vld_vs_calculated AS
SELECT
    bl.business_id,
    vld.location_id,
    vld.variation_id,
    vld.qty_available AS vld_qty,
    ROUND(
        COALESCE((
            SELECT SUM((pl.quantity - IFNULL(pl.quantity_returned,0)))
            FROM purchase_lines pl
            JOIN transactions t ON t.id = pl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND pl.variation_id = vld.variation_id
              AND t.type IN ('purchase','opening_stock')
        ),0)
        + COALESCE((
            SELECT SUM(IFNULL(tsl.quantity,0))
            FROM transaction_sell_lines tsl
            JOIN transactions t ON t.id = tsl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND tsl.variation_id = vld.variation_id
              AND t.type = 'sell_return'
        ),0)
        + COALESCE((
            SELECT SUM(IFNULL(sal.quantity,0))
            FROM stock_adjustment_lines sal
            JOIN transactions t ON t.id = sal.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND sal.variation_id = vld.variation_id
        ),0)
        - COALESCE((
            SELECT SUM(IFNULL(tsl.quantity,0))
            FROM transaction_sell_lines tsl
            JOIN transactions t ON t.id = tsl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND tsl.variation_id = vld.variation_id
              AND t.type = 'sell'
              AND t.status IN ('final')
        ),0)
    ,4) AS calculated_qty
FROM variation_location_details vld
JOIN business_locations bl ON bl.id = vld.location_id;
SQL);

        DB::statement('DROP VIEW IF EXISTS vw_stock_integrity_audit');
        DB::statement(<<<SQL
CREATE VIEW vw_stock_integrity_audit AS
SELECT
    bl.business_id,
    vld.location_id,
    vld.variation_id,
    bl.name as location_name,
    p.name as product_name,
    v.name as variation_name,
    vld.qty_available AS stored_qty,
    ROUND(
        COALESCE((
            SELECT SUM((pl.quantity - IFNULL(pl.quantity_returned,0)))
            FROM purchase_lines pl
            JOIN transactions t ON t.id = pl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND pl.variation_id = vld.variation_id
              AND t.type IN ('purchase','opening_stock')
        ),0)
        + COALESCE((
            SELECT SUM(IFNULL(tsl.quantity,0))
            FROM transaction_sell_lines tsl
            JOIN transactions t ON t.id = tsl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND tsl.variation_id = vld.variation_id
              AND t.type = 'sell_return'
        ),0)
        + COALESCE((
            SELECT SUM(IFNULL(sal.quantity,0))
            FROM stock_adjustment_lines sal
            JOIN transactions t ON t.id = sal.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND sal.variation_id = vld.variation_id
        ),0)
        - COALESCE((
            SELECT SUM(IFNULL(tsl.quantity,0))
            FROM transaction_sell_lines tsl
            JOIN transactions t ON t.id = tsl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND tsl.variation_id = vld.variation_id
              AND t.type = 'sell'
              AND t.status IN ('final')
        ),0)
    ,4) AS calculated_qty,
    ROUND(vld.qty_available - (
        COALESCE((
            SELECT SUM((pl.quantity - IFNULL(pl.quantity_returned,0)))
            FROM purchase_lines pl
            JOIN transactions t ON t.id = pl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND pl.variation_id = vld.variation_id
              AND t.type IN ('purchase','opening_stock')
        ),0)
        + COALESCE((
            SELECT SUM(IFNULL(tsl.quantity,0))
            FROM transaction_sell_lines tsl
            JOIN transactions t ON t.id = tsl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND tsl.variation_id = vld.variation_id
              AND t.type = 'sell_return'
        ),0)
        + COALESCE((
            SELECT SUM(IFNULL(sal.quantity,0))
            FROM stock_adjustment_lines sal
            JOIN transactions t ON t.id = sal.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND sal.variation_id = vld.variation_id
        ),0)
        - COALESCE((
            SELECT SUM(IFNULL(tsl.quantity,0))
            FROM transaction_sell_lines tsl
            JOIN transactions t ON t.id = tsl.transaction_id
            WHERE t.business_id = bl.business_id
              AND t.location_id = vld.location_id
              AND tsl.variation_id = vld.variation_id
              AND t.type = 'sell'
              AND t.status IN ('final')
        ),0)
    ), 4) AS difference
FROM variation_location_details vld
JOIN business_locations bl ON bl.id = vld.location_id
JOIN variations v ON v.id = vld.variation_id
JOIN products p ON p.id = v.product_id;
SQL);
    }

    public function down(): void
    {
        DB::statement('DROP VIEW IF EXISTS vw_stock_integrity_audit');
        DB::statement('DROP VIEW IF EXISTS vw_vld_vs_calculated');
    }
};